package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLiveStreamMonitor invokes the live.UpdateLiveStreamMonitor API synchronously
func (client *Client) UpdateLiveStreamMonitor(request *UpdateLiveStreamMonitorRequest) (response *UpdateLiveStreamMonitorResponse, err error) {
	response = CreateUpdateLiveStreamMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLiveStreamMonitorWithChan invokes the live.UpdateLiveStreamMonitor API asynchronously
func (client *Client) UpdateLiveStreamMonitorWithChan(request *UpdateLiveStreamMonitorRequest) (<-chan *UpdateLiveStreamMonitorResponse, <-chan error) {
	responseChan := make(chan *UpdateLiveStreamMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLiveStreamMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLiveStreamMonitorWithCallback invokes the live.UpdateLiveStreamMonitor API asynchronously
func (client *Client) UpdateLiveStreamMonitorWithCallback(request *UpdateLiveStreamMonitorRequest, callback func(response *UpdateLiveStreamMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLiveStreamMonitorResponse
		var err error
		defer close(result)
		response, err = client.UpdateLiveStreamMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLiveStreamMonitorRequest is the request struct for api UpdateLiveStreamMonitor
type UpdateLiveStreamMonitorRequest struct {
	*requests.RpcRequest
	MonitorId      string           `position:"Query" name:"MonitorId"`
	MonitorConfig  string           `position:"Query" name:"MonitorConfig"`
	MonitorName    string           `position:"Query" name:"MonitorName"`
	Stream         string           `position:"Query" name:"Stream"`
	OutputTemplate string           `position:"Query" name:"OutputTemplate"`
	App            string           `position:"Query" name:"App"`
	InputList      string           `position:"Query" name:"InputList"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	Domain         string           `position:"Query" name:"Domain"`
}

// UpdateLiveStreamMonitorResponse is the response struct for api UpdateLiveStreamMonitor
type UpdateLiveStreamMonitorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateLiveStreamMonitorRequest creates a request to invoke UpdateLiveStreamMonitor API
func CreateUpdateLiveStreamMonitorRequest() (request *UpdateLiveStreamMonitorRequest) {
	request = &UpdateLiveStreamMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "UpdateLiveStreamMonitor", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateLiveStreamMonitorResponse creates a response to parse from UpdateLiveStreamMonitor response
func CreateUpdateLiveStreamMonitorResponse() (response *UpdateLiveStreamMonitorResponse) {
	response = &UpdateLiveStreamMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
