package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMasCrowd invokes the mpaas.CreateMasCrowd API synchronously
func (client *Client) CreateMasCrowd(request *CreateMasCrowdRequest) (response *CreateMasCrowdResponse, err error) {
	response = CreateCreateMasCrowdResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMasCrowdWithChan invokes the mpaas.CreateMasCrowd API asynchronously
func (client *Client) CreateMasCrowdWithChan(request *CreateMasCrowdRequest) (<-chan *CreateMasCrowdResponse, <-chan error) {
	responseChan := make(chan *CreateMasCrowdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMasCrowd(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMasCrowdWithCallback invokes the mpaas.CreateMasCrowd API asynchronously
func (client *Client) CreateMasCrowdWithCallback(request *CreateMasCrowdRequest, callback func(response *CreateMasCrowdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMasCrowdResponse
		var err error
		defer close(result)
		response, err = client.CreateMasCrowd(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMasCrowdRequest is the request struct for api CreateMasCrowd
type CreateMasCrowdRequest struct {
	*requests.RpcRequest
	TenantId                                 string `position:"Body" name:"TenantId"`
	MpaasMappcenterMcdpMasCrowdCreateJsonStr string `position:"Body" name:"MpaasMappcenterMcdpMasCrowdCreateJsonStr"`
	AppId                                    string `position:"Body" name:"AppId"`
	WorkspaceId                              string `position:"Body" name:"WorkspaceId"`
}

// CreateMasCrowdResponse is the response struct for api CreateMasCrowd
type CreateMasCrowdResponse struct {
	*responses.BaseResponse
	ResultMessage string                        `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                        `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                        `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInCreateMasCrowd `json:"ResultContent" xml:"ResultContent"`
}

// CreateCreateMasCrowdRequest creates a request to invoke CreateMasCrowd API
func CreateCreateMasCrowdRequest() (request *CreateMasCrowdRequest) {
	request = &CreateMasCrowdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CreateMasCrowd", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMasCrowdResponse creates a response to parse from CreateMasCrowd response
func CreateCreateMasCrowdResponse() (response *CreateMasCrowdResponse) {
	response = &CreateMasCrowdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
