package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMcubeWhitelist invokes the mpaas.DeleteMcubeWhitelist API synchronously
func (client *Client) DeleteMcubeWhitelist(request *DeleteMcubeWhitelistRequest) (response *DeleteMcubeWhitelistResponse, err error) {
	response = CreateDeleteMcubeWhitelistResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMcubeWhitelistWithChan invokes the mpaas.DeleteMcubeWhitelist API asynchronously
func (client *Client) DeleteMcubeWhitelistWithChan(request *DeleteMcubeWhitelistRequest) (<-chan *DeleteMcubeWhitelistResponse, <-chan error) {
	responseChan := make(chan *DeleteMcubeWhitelistResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMcubeWhitelist(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMcubeWhitelistWithCallback invokes the mpaas.DeleteMcubeWhitelist API asynchronously
func (client *Client) DeleteMcubeWhitelistWithCallback(request *DeleteMcubeWhitelistRequest, callback func(response *DeleteMcubeWhitelistResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMcubeWhitelistResponse
		var err error
		defer close(result)
		response, err = client.DeleteMcubeWhitelist(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMcubeWhitelistRequest is the request struct for api DeleteMcubeWhitelist
type DeleteMcubeWhitelistRequest struct {
	*requests.RpcRequest
	TenantId    string           `position:"Body" name:"TenantId"`
	Id          requests.Integer `position:"Body" name:"Id"`
	AppId       string           `position:"Body" name:"AppId"`
	WorkspaceId string           `position:"Body" name:"WorkspaceId"`
}

// DeleteMcubeWhitelistResponse is the response struct for api DeleteMcubeWhitelist
type DeleteMcubeWhitelistResponse struct {
	*responses.BaseResponse
	ResultMessage         string                `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode            string                `json:"ResultCode" xml:"ResultCode"`
	RequestId             string                `json:"RequestId" xml:"RequestId"`
	DeleteWhitelistResult DeleteWhitelistResult `json:"DeleteWhitelistResult" xml:"DeleteWhitelistResult"`
}

// CreateDeleteMcubeWhitelistRequest creates a request to invoke DeleteMcubeWhitelist API
func CreateDeleteMcubeWhitelistRequest() (request *DeleteMcubeWhitelistRequest) {
	request = &DeleteMcubeWhitelistRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "DeleteMcubeWhitelist", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteMcubeWhitelistResponse creates a response to parse from DeleteMcubeWhitelist response
func CreateDeleteMcubeWhitelistResponse() (response *DeleteMcubeWhitelistResponse) {
	response = &DeleteMcubeWhitelistResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
