package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryUploadInfo invokes the mpaas.QueryUploadInfo API synchronously
func (client *Client) QueryUploadInfo(request *QueryUploadInfoRequest) (response *QueryUploadInfoResponse, err error) {
	response = CreateQueryUploadInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryUploadInfoWithChan invokes the mpaas.QueryUploadInfo API asynchronously
func (client *Client) QueryUploadInfoWithChan(request *QueryUploadInfoRequest) (<-chan *QueryUploadInfoResponse, <-chan error) {
	responseChan := make(chan *QueryUploadInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryUploadInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryUploadInfoWithCallback invokes the mpaas.QueryUploadInfo API asynchronously
func (client *Client) QueryUploadInfoWithCallback(request *QueryUploadInfoRequest, callback func(response *QueryUploadInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryUploadInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryUploadInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryUploadInfoRequest is the request struct for api QueryUploadInfo
type QueryUploadInfoRequest struct {
	*requests.RpcRequest
	MpaasMappcenterMsacCreateAppInstanceJsonStr string `position:"Body" name:"MpaasMappcenterMsacCreateAppInstanceJsonStr"`
	AppId                                       string `position:"Query" name:"appId"`
	TenantId                                    string `position:"Query" name:"tenantId"`
	WorkspaceId                                 string `position:"Query" name:"workspaceId"`
}

// QueryUploadInfoResponse is the response struct for api QueryUploadInfo
type QueryUploadInfoResponse struct {
	*responses.BaseResponse
}

// CreateQueryUploadInfoRequest creates a request to invoke QueryUploadInfo API
func CreateQueryUploadInfoRequest() (request *QueryUploadInfoRequest) {
	request = &QueryUploadInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "QueryUploadInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryUploadInfoResponse creates a response to parse from QueryUploadInfo response
func CreateQueryUploadInfoResponse() (response *QueryUploadInfoResponse) {
	response = &QueryUploadInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
