package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadMcubeMiniPackage invokes the mpaas.UploadMcubeMiniPackage API synchronously
func (client *Client) UploadMcubeMiniPackage(request *UploadMcubeMiniPackageRequest) (response *UploadMcubeMiniPackageResponse, err error) {
	response = CreateUploadMcubeMiniPackageResponse()
	err = client.DoAction(request, response)
	return
}

// UploadMcubeMiniPackageWithChan invokes the mpaas.UploadMcubeMiniPackage API asynchronously
func (client *Client) UploadMcubeMiniPackageWithChan(request *UploadMcubeMiniPackageRequest) (<-chan *UploadMcubeMiniPackageResponse, <-chan error) {
	responseChan := make(chan *UploadMcubeMiniPackageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadMcubeMiniPackage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadMcubeMiniPackageWithCallback invokes the mpaas.UploadMcubeMiniPackage API asynchronously
func (client *Client) UploadMcubeMiniPackageWithCallback(request *UploadMcubeMiniPackageRequest, callback func(response *UploadMcubeMiniPackageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadMcubeMiniPackageResponse
		var err error
		defer close(result)
		response, err = client.UploadMcubeMiniPackage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadMcubeMiniPackageRequest is the request struct for api UploadMcubeMiniPackage
type UploadMcubeMiniPackageRequest struct {
	*requests.RpcRequest
	AutoInstall      requests.Integer `position:"Body" name:"AutoInstall"`
	InstallType      requests.Integer `position:"Body" name:"InstallType"`
	OnexFlag         requests.Boolean `position:"Body" name:"OnexFlag"`
	EnableOptionMenu string           `position:"Body" name:"EnableOptionMenu"`
	H5Version        string           `position:"Body" name:"H5Version"`
	EnableTabBar     requests.Integer `position:"Body" name:"EnableTabBar"`
	UserId           string           `position:"Body" name:"UserId"`
	Uuid             string           `position:"Body" name:"Uuid"`
	ResourceFileUrl  string           `position:"Body" name:"ResourceFileUrl"`
	H5Id             string           `position:"Body" name:"H5Id"`
	ExtendInfo       string           `position:"Body" name:"ExtendInfo"`
	MainUrl          string           `position:"Body" name:"MainUrl"`
	ClientVersionMin string           `position:"Body" name:"ClientVersionMin"`
	EnableKeepAlive  string           `position:"Body" name:"EnableKeepAlive"`
	Vhost            string           `position:"Body" name:"Vhost"`
	ClientVersionMax string           `position:"Body" name:"ClientVersionMax"`
	PackageType      requests.Integer `position:"Body" name:"PackageType"`
	WorkspaceId      string           `position:"Body" name:"WorkspaceId"`
	H5Name           string           `position:"Body" name:"H5Name"`
	Platform         string           `position:"Body" name:"Platform"`
	TenantId         string           `position:"Body" name:"TenantId"`
	ResourceType     requests.Integer `position:"Body" name:"ResourceType"`
	IconFileUrl      string           `position:"Body" name:"IconFileUrl"`
	AppId            string           `position:"Body" name:"AppId"`
	IconUrl          string           `position:"Body" name:"IconUrl"`
}

// UploadMcubeMiniPackageResponse is the response struct for api UploadMcubeMiniPackage
type UploadMcubeMiniPackageResponse struct {
	*responses.BaseResponse
	ResultMessage           string                  `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode              string                  `json:"ResultCode" xml:"ResultCode"`
	RequestId               string                  `json:"RequestId" xml:"RequestId"`
	UploadMiniPackageResult UploadMiniPackageResult `json:"UploadMiniPackageResult" xml:"UploadMiniPackageResult"`
}

// CreateUploadMcubeMiniPackageRequest creates a request to invoke UploadMcubeMiniPackage API
func CreateUploadMcubeMiniPackageRequest() (request *UploadMcubeMiniPackageRequest) {
	request = &UploadMcubeMiniPackageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "UploadMcubeMiniPackage", "", "")
	request.Method = requests.POST
	return
}

// CreateUploadMcubeMiniPackageResponse creates a response to parse from UploadMcubeMiniPackage response
func CreateUploadMcubeMiniPackageResponse() (response *UploadMcubeMiniPackageResponse) {
	response = &UploadMcubeMiniPackageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
