package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImportServices invokes the mse.ImportServices API synchronously
func (client *Client) ImportServices(request *ImportServicesRequest) (response *ImportServicesResponse, err error) {
	response = CreateImportServicesResponse()
	err = client.DoAction(request, response)
	return
}

// ImportServicesWithChan invokes the mse.ImportServices API asynchronously
func (client *Client) ImportServicesWithChan(request *ImportServicesRequest) (<-chan *ImportServicesResponse, <-chan error) {
	responseChan := make(chan *ImportServicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImportServices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImportServicesWithCallback invokes the mse.ImportServices API asynchronously
func (client *Client) ImportServicesWithCallback(request *ImportServicesRequest, callback func(response *ImportServicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImportServicesResponse
		var err error
		defer close(result)
		response, err = client.ImportServices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImportServicesRequest is the request struct for api ImportServices
type ImportServicesRequest struct {
	*requests.RpcRequest
	MseSessionId    string                       `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string                       `position:"Query" name:"GatewayUniqueId"`
	ServiceList     *[]ImportServicesServiceList `position:"Query" name:"ServiceList"  type:"Json"`
	TlsSetting      string                       `position:"Query" name:"TlsSetting"`
	SourceType      string                       `position:"Query" name:"SourceType"`
	AcceptLanguage  string                       `position:"Query" name:"AcceptLanguage"`
}

// ImportServicesServiceList is a repeated param struct in ImportServicesRequest
type ImportServicesServiceList struct {
	ServiceProtocol string    `name:"ServiceProtocol"`
	Name            string    `name:"Name"`
	Namespace       string    `name:"Namespace"`
	GroupName       string    `name:"GroupName"`
	Ips             *[]string `name:"Ips" type:"Repeated"`
	ServicePort     string    `name:"ServicePort"`
}

// ImportServicesResponse is the response struct for api ImportServices
type ImportServicesResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           bool   `json:"Data" xml:"Data"`
}

// CreateImportServicesRequest creates a request to invoke ImportServices API
func CreateImportServicesRequest() (request *ImportServicesRequest) {
	request = &ImportServicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ImportServices", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateImportServicesResponse creates a response to parse from ImportServices response
func CreateImportServicesResponse() (response *ImportServicesResponse) {
	response = &ImportServicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
