package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAnsInstances invokes the mse.ListAnsInstances API synchronously
func (client *Client) ListAnsInstances(request *ListAnsInstancesRequest) (response *ListAnsInstancesResponse, err error) {
	response = CreateListAnsInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// ListAnsInstancesWithChan invokes the mse.ListAnsInstances API asynchronously
func (client *Client) ListAnsInstancesWithChan(request *ListAnsInstancesRequest) (<-chan *ListAnsInstancesResponse, <-chan error) {
	responseChan := make(chan *ListAnsInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAnsInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAnsInstancesWithCallback invokes the mse.ListAnsInstances API asynchronously
func (client *Client) ListAnsInstancesWithCallback(request *ListAnsInstancesRequest, callback func(response *ListAnsInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAnsInstancesResponse
		var err error
		defer close(result)
		response, err = client.ListAnsInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAnsInstancesRequest is the request struct for api ListAnsInstances
type ListAnsInstancesRequest struct {
	*requests.RpcRequest
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	ClusterName    string           `position:"Query" name:"ClusterName"`
	PageNum        requests.Integer `position:"Query" name:"PageNum"`
	NamespaceId    string           `position:"Query" name:"NamespaceId"`
	RequestPars    string           `position:"Query" name:"RequestPars"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	ServiceName    string           `position:"Query" name:"ServiceName"`
	ClusterId      string           `position:"Query" name:"ClusterId"`
	GroupName      string           `position:"Query" name:"GroupName"`
	InstanceId     string           `position:"Query" name:"InstanceId"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
}

// ListAnsInstancesResponse is the response struct for api ListAnsInstances
type ListAnsInstancesResponse struct {
	*responses.BaseResponse
	HttpCode   string             `json:"HttpCode" xml:"HttpCode"`
	TotalCount int                `json:"TotalCount" xml:"TotalCount"`
	RequestId  string             `json:"RequestId" xml:"RequestId"`
	Message    string             `json:"Message" xml:"Message"`
	PageSize   int                `json:"PageSize" xml:"PageSize"`
	PageNumber int                `json:"PageNumber" xml:"PageNumber"`
	ErrorCode  string             `json:"ErrorCode" xml:"ErrorCode"`
	Success    bool               `json:"Success" xml:"Success"`
	Data       []NacosAnsInstance `json:"Data" xml:"Data"`
}

// CreateListAnsInstancesRequest creates a request to invoke ListAnsInstances API
func CreateListAnsInstancesRequest() (request *ListAnsInstancesRequest) {
	request = &ListAnsInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ListAnsInstances", "mse", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListAnsInstancesResponse creates a response to parse from ListAnsInstances response
func CreateListAnsInstancesResponse() (response *ListAnsInstancesResponse) {
	response = &ListAnsInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
