package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReleaseOmsOpenAPIProject invokes the oceanbasepro.ReleaseOmsOpenAPIProject API synchronously
func (client *Client) ReleaseOmsOpenAPIProject(request *ReleaseOmsOpenAPIProjectRequest) (response *ReleaseOmsOpenAPIProjectResponse, err error) {
	response = CreateReleaseOmsOpenAPIProjectResponse()
	err = client.DoAction(request, response)
	return
}

// ReleaseOmsOpenAPIProjectWithChan invokes the oceanbasepro.ReleaseOmsOpenAPIProject API asynchronously
func (client *Client) ReleaseOmsOpenAPIProjectWithChan(request *ReleaseOmsOpenAPIProjectRequest) (<-chan *ReleaseOmsOpenAPIProjectResponse, <-chan error) {
	responseChan := make(chan *ReleaseOmsOpenAPIProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReleaseOmsOpenAPIProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReleaseOmsOpenAPIProjectWithCallback invokes the oceanbasepro.ReleaseOmsOpenAPIProject API asynchronously
func (client *Client) ReleaseOmsOpenAPIProjectWithCallback(request *ReleaseOmsOpenAPIProjectRequest, callback func(response *ReleaseOmsOpenAPIProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReleaseOmsOpenAPIProjectResponse
		var err error
		defer close(result)
		response, err = client.ReleaseOmsOpenAPIProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReleaseOmsOpenAPIProjectRequest is the request struct for api ReleaseOmsOpenAPIProject
type ReleaseOmsOpenAPIProjectRequest struct {
	*requests.RpcRequest
	PageNumber    requests.Integer `position:"Body" name:"PageNumber"`
	PageSize      requests.Integer `position:"Body" name:"PageSize"`
	WorkerGradeId string           `position:"Body" name:"WorkerGradeId"`
	ProjectId     string           `position:"Body" name:"ProjectId"`
}

// ReleaseOmsOpenAPIProjectResponse is the response struct for api ReleaseOmsOpenAPIProject
type ReleaseOmsOpenAPIProjectResponse struct {
	*responses.BaseResponse
	Success     bool        `json:"Success" xml:"Success"`
	Code        string      `json:"Code" xml:"Code"`
	Message     string      `json:"Message" xml:"Message"`
	Advice      string      `json:"Advice" xml:"Advice"`
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	PageNumber  int         `json:"PageNumber" xml:"PageNumber"`
	PageSize    int         `json:"PageSize" xml:"PageSize"`
	TotalCount  int64       `json:"TotalCount" xml:"TotalCount"`
	Cost        string      `json:"Cost" xml:"Cost"`
	Data        bool        `json:"Data" xml:"Data"`
	ErrorDetail ErrorDetail `json:"ErrorDetail" xml:"ErrorDetail"`
}

// CreateReleaseOmsOpenAPIProjectRequest creates a request to invoke ReleaseOmsOpenAPIProject API
func CreateReleaseOmsOpenAPIProjectRequest() (request *ReleaseOmsOpenAPIProjectRequest) {
	request = &ReleaseOmsOpenAPIProjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "ReleaseOmsOpenAPIProject", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReleaseOmsOpenAPIProjectResponse creates a response to parse from ReleaseOmsOpenAPIProject response
func CreateReleaseOmsOpenAPIProjectResponse() (response *ReleaseOmsOpenAPIProjectResponse) {
	response = &ReleaseOmsOpenAPIProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
