package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResetOmsOpenAPIProject invokes the oceanbasepro.ResetOmsOpenAPIProject API synchronously
func (client *Client) ResetOmsOpenAPIProject(request *ResetOmsOpenAPIProjectRequest) (response *ResetOmsOpenAPIProjectResponse, err error) {
	response = CreateResetOmsOpenAPIProjectResponse()
	err = client.DoAction(request, response)
	return
}

// ResetOmsOpenAPIProjectWithChan invokes the oceanbasepro.ResetOmsOpenAPIProject API asynchronously
func (client *Client) ResetOmsOpenAPIProjectWithChan(request *ResetOmsOpenAPIProjectRequest) (<-chan *ResetOmsOpenAPIProjectResponse, <-chan error) {
	responseChan := make(chan *ResetOmsOpenAPIProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResetOmsOpenAPIProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResetOmsOpenAPIProjectWithCallback invokes the oceanbasepro.ResetOmsOpenAPIProject API asynchronously
func (client *Client) ResetOmsOpenAPIProjectWithCallback(request *ResetOmsOpenAPIProjectRequest, callback func(response *ResetOmsOpenAPIProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResetOmsOpenAPIProjectResponse
		var err error
		defer close(result)
		response, err = client.ResetOmsOpenAPIProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResetOmsOpenAPIProjectRequest is the request struct for api ResetOmsOpenAPIProject
type ResetOmsOpenAPIProjectRequest struct {
	*requests.RpcRequest
	PageNumber    requests.Integer `position:"Body" name:"PageNumber"`
	PageSize      requests.Integer `position:"Body" name:"PageSize"`
	WorkerGradeId string           `position:"Body" name:"WorkerGradeId"`
	ProjectId     string           `position:"Body" name:"ProjectId"`
}

// ResetOmsOpenAPIProjectResponse is the response struct for api ResetOmsOpenAPIProject
type ResetOmsOpenAPIProjectResponse struct {
	*responses.BaseResponse
	Success     bool        `json:"Success" xml:"Success"`
	Code        string      `json:"Code" xml:"Code"`
	Message     string      `json:"Message" xml:"Message"`
	Advice      string      `json:"Advice" xml:"Advice"`
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	PageNumber  int         `json:"PageNumber" xml:"PageNumber"`
	PageSize    int         `json:"PageSize" xml:"PageSize"`
	TotalCount  int64       `json:"TotalCount" xml:"TotalCount"`
	Cost        string      `json:"Cost" xml:"Cost"`
	Data        bool        `json:"Data" xml:"Data"`
	ErrorDetail ErrorDetail `json:"ErrorDetail" xml:"ErrorDetail"`
}

// CreateResetOmsOpenAPIProjectRequest creates a request to invoke ResetOmsOpenAPIProject API
func CreateResetOmsOpenAPIProjectRequest() (request *ResetOmsOpenAPIProjectRequest) {
	request = &ResetOmsOpenAPIProjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "ResetOmsOpenAPIProject", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateResetOmsOpenAPIProjectResponse creates a response to parse from ResetOmsOpenAPIProject response
func CreateResetOmsOpenAPIProjectResponse() (response *ResetOmsOpenAPIProjectResponse) {
	response = &ResetOmsOpenAPIProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
