package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeployApplicationGroup invokes the oos.DeployApplicationGroup API synchronously
func (client *Client) DeployApplicationGroup(request *DeployApplicationGroupRequest) (response *DeployApplicationGroupResponse, err error) {
	response = CreateDeployApplicationGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeployApplicationGroupWithChan invokes the oos.DeployApplicationGroup API asynchronously
func (client *Client) DeployApplicationGroupWithChan(request *DeployApplicationGroupRequest) (<-chan *DeployApplicationGroupResponse, <-chan error) {
	responseChan := make(chan *DeployApplicationGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeployApplicationGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeployApplicationGroupWithCallback invokes the oos.DeployApplicationGroup API asynchronously
func (client *Client) DeployApplicationGroupWithCallback(request *DeployApplicationGroupRequest, callback func(response *DeployApplicationGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeployApplicationGroupResponse
		var err error
		defer close(result)
		response, err = client.DeployApplicationGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeployApplicationGroupRequest is the request struct for api DeployApplicationGroup
type DeployApplicationGroupRequest struct {
	*requests.RpcRequest
	DeployParameters string `position:"Query" name:"DeployParameters"`
	ApplicationName  string `position:"Query" name:"ApplicationName"`
	Name             string `position:"Query" name:"Name"`
}

// DeployApplicationGroupResponse is the response struct for api DeployApplicationGroup
type DeployApplicationGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeployApplicationGroupRequest creates a request to invoke DeployApplicationGroup API
func CreateDeployApplicationGroupRequest() (request *DeployApplicationGroupRequest) {
	request = &DeployApplicationGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "DeployApplicationGroup", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeployApplicationGroupResponse creates a response to parse from DeployApplicationGroup response
func CreateDeployApplicationGroupResponse() (response *DeployApplicationGroupResponse) {
	response = &DeployApplicationGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
