package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSecretParameter invokes the oos.GetSecretParameter API synchronously
func (client *Client) GetSecretParameter(request *GetSecretParameterRequest) (response *GetSecretParameterResponse, err error) {
	response = CreateGetSecretParameterResponse()
	err = client.DoAction(request, response)
	return
}

// GetSecretParameterWithChan invokes the oos.GetSecretParameter API asynchronously
func (client *Client) GetSecretParameterWithChan(request *GetSecretParameterRequest) (<-chan *GetSecretParameterResponse, <-chan error) {
	responseChan := make(chan *GetSecretParameterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSecretParameter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSecretParameterWithCallback invokes the oos.GetSecretParameter API asynchronously
func (client *Client) GetSecretParameterWithCallback(request *GetSecretParameterRequest, callback func(response *GetSecretParameterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSecretParameterResponse
		var err error
		defer close(result)
		response, err = client.GetSecretParameter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSecretParameterRequest is the request struct for api GetSecretParameter
type GetSecretParameterRequest struct {
	*requests.RpcRequest
	WithDecryption   requests.Boolean `position:"Query" name:"WithDecryption"`
	ParameterVersion requests.Integer `position:"Query" name:"ParameterVersion"`
	Name             string           `position:"Query" name:"Name"`
}

// GetSecretParameterResponse is the response struct for api GetSecretParameter
type GetSecretParameterResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Parameter Parameter `json:"Parameter" xml:"Parameter"`
}

// CreateGetSecretParameterRequest creates a request to invoke GetSecretParameter API
func CreateGetSecretParameterRequest() (request *GetSecretParameterRequest) {
	request = &GetSecretParameterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "GetSecretParameter", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetSecretParameterResponse creates a response to parse from GetSecretParameter response
func CreateGetSecretParameterResponse() (response *GetSecretParameterResponse) {
	response = &GetSecretParameterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
