package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAppStatistics invokes the opensearch.DescribeAppStatistics API synchronously
func (client *Client) DescribeAppStatistics(request *DescribeAppStatisticsRequest) (response *DescribeAppStatisticsResponse, err error) {
	response = CreateDescribeAppStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAppStatisticsWithChan invokes the opensearch.DescribeAppStatistics API asynchronously
func (client *Client) DescribeAppStatisticsWithChan(request *DescribeAppStatisticsRequest) (<-chan *DescribeAppStatisticsResponse, <-chan error) {
	responseChan := make(chan *DescribeAppStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAppStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAppStatisticsWithCallback invokes the opensearch.DescribeAppStatistics API asynchronously
func (client *Client) DescribeAppStatisticsWithCallback(request *DescribeAppStatisticsRequest, callback func(response *DescribeAppStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAppStatisticsResponse
		var err error
		defer close(result)
		response, err = client.DescribeAppStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAppStatisticsRequest is the request struct for api DescribeAppStatistics
type DescribeAppStatisticsRequest struct {
	*requests.RoaRequest
	AppId            string `position:"Path" name:"appId"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// DescribeAppStatisticsResponse is the response struct for api DescribeAppStatistics
type DescribeAppStatisticsResponse struct {
	*responses.BaseResponse
	Result    map[string]interface{} `json:"result" xml:"result"`
	RequestId string                 `json:"requestId" xml:"requestId"`
}

// CreateDescribeAppStatisticsRequest creates a request to invoke DescribeAppStatistics API
func CreateDescribeAppStatisticsRequest() (request *DescribeAppStatisticsRequest) {
	request = &DescribeAppStatisticsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "DescribeAppStatistics", "/v4/openapi/app-groups/[appGroupIdentity]/apps/[appId]/statistics", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeAppStatisticsResponse creates a response to parse from DescribeAppStatistics response
func CreateDescribeAppStatisticsResponse() (response *DescribeAppStatisticsResponse) {
	response = &DescribeAppStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
