package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFunctionVersion invokes the opensearch.GetFunctionVersion API synchronously
func (client *Client) GetFunctionVersion(request *GetFunctionVersionRequest) (response *GetFunctionVersionResponse, err error) {
	response = CreateGetFunctionVersionResponse()
	err = client.DoAction(request, response)
	return
}

// GetFunctionVersionWithChan invokes the opensearch.GetFunctionVersion API asynchronously
func (client *Client) GetFunctionVersionWithChan(request *GetFunctionVersionRequest) (<-chan *GetFunctionVersionResponse, <-chan error) {
	responseChan := make(chan *GetFunctionVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFunctionVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFunctionVersionWithCallback invokes the opensearch.GetFunctionVersion API asynchronously
func (client *Client) GetFunctionVersionWithCallback(request *GetFunctionVersionRequest, callback func(response *GetFunctionVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFunctionVersionResponse
		var err error
		defer close(result)
		response, err = client.GetFunctionVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFunctionVersionRequest is the request struct for api GetFunctionVersion
type GetFunctionVersionRequest struct {
	*requests.RoaRequest
	VersionId    requests.Integer `position:"Path" name:"versionId"`
	FunctionName string           `position:"Path" name:"functionName"`
}

// GetFunctionVersionResponse is the response struct for api GetFunctionVersion
type GetFunctionVersionResponse struct {
	*responses.BaseResponse
	Status    string `json:"Status" xml:"Status"`
	HttpCode  int64  `json:"HttpCode" xml:"HttpCode"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Latency   int64  `json:"Latency" xml:"Latency"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateGetFunctionVersionRequest creates a request to invoke GetFunctionVersion API
func CreateGetFunctionVersionRequest() (request *GetFunctionVersionRequest) {
	request = &GetFunctionVersionRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "GetFunctionVersion", "/v4/openapi/functions/[functionName]/versions/[versionId]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetFunctionVersionResponse creates a response to parse from GetFunctionVersion response
func CreateGetFunctionVersionResponse() (response *GetFunctionVersionResponse) {
	response = &GetFunctionVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
