package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateABTestFixedFlowDividers invokes the opensearch.UpdateABTestFixedFlowDividers API synchronously
func (client *Client) UpdateABTestFixedFlowDividers(request *UpdateABTestFixedFlowDividersRequest) (response *UpdateABTestFixedFlowDividersResponse, err error) {
	response = CreateUpdateABTestFixedFlowDividersResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateABTestFixedFlowDividersWithChan invokes the opensearch.UpdateABTestFixedFlowDividers API asynchronously
func (client *Client) UpdateABTestFixedFlowDividersWithChan(request *UpdateABTestFixedFlowDividersRequest) (<-chan *UpdateABTestFixedFlowDividersResponse, <-chan error) {
	responseChan := make(chan *UpdateABTestFixedFlowDividersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateABTestFixedFlowDividers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateABTestFixedFlowDividersWithCallback invokes the opensearch.UpdateABTestFixedFlowDividers API asynchronously
func (client *Client) UpdateABTestFixedFlowDividersWithCallback(request *UpdateABTestFixedFlowDividersRequest, callback func(response *UpdateABTestFixedFlowDividersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateABTestFixedFlowDividersResponse
		var err error
		defer close(result)
		response, err = client.UpdateABTestFixedFlowDividers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateABTestFixedFlowDividersRequest is the request struct for api UpdateABTestFixedFlowDividers
type UpdateABTestFixedFlowDividersRequest struct {
	*requests.RoaRequest
	GroupId          requests.Integer `position:"Path" name:"groupId"`
	SceneId          requests.Integer `position:"Path" name:"sceneId"`
	ExperimentId     requests.Integer `position:"Path" name:"experimentId"`
	AppGroupIdentity string           `position:"Path" name:"appGroupIdentity"`
}

// UpdateABTestFixedFlowDividersResponse is the response struct for api UpdateABTestFixedFlowDividers
type UpdateABTestFixedFlowDividersResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"requestId" xml:"requestId"`
	Result    []string `json:"result" xml:"result"`
}

// CreateUpdateABTestFixedFlowDividersRequest creates a request to invoke UpdateABTestFixedFlowDividers API
func CreateUpdateABTestFixedFlowDividersRequest() (request *UpdateABTestFixedFlowDividersRequest) {
	request = &UpdateABTestFixedFlowDividersRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "UpdateABTestFixedFlowDividers", "/v4/openapi/app-groups/[appGroupIdentity]/scenes/[sceneId]/groups/[groupId]/experiments/[experimentId]/fixed-flow-dividers", "", "")
	request.Method = requests.PUT
	return
}

// CreateUpdateABTestFixedFlowDividersResponse creates a response to parse from UpdateABTestFixedFlowDividers response
func CreateUpdateABTestFixedFlowDividersResponse() (response *UpdateABTestFixedFlowDividersResponse) {
	response = &UpdateABTestFixedFlowDividersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
