package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateQualityCheckData invokes the qualitycheck.UpdateQualityCheckData API synchronously
func (client *Client) UpdateQualityCheckData(request *UpdateQualityCheckDataRequest) (response *UpdateQualityCheckDataResponse, err error) {
	response = CreateUpdateQualityCheckDataResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateQualityCheckDataWithChan invokes the qualitycheck.UpdateQualityCheckData API asynchronously
func (client *Client) UpdateQualityCheckDataWithChan(request *UpdateQualityCheckDataRequest) (<-chan *UpdateQualityCheckDataResponse, <-chan error) {
	responseChan := make(chan *UpdateQualityCheckDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateQualityCheckData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateQualityCheckDataWithCallback invokes the qualitycheck.UpdateQualityCheckData API asynchronously
func (client *Client) UpdateQualityCheckDataWithCallback(request *UpdateQualityCheckDataRequest, callback func(response *UpdateQualityCheckDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateQualityCheckDataResponse
		var err error
		defer close(result)
		response, err = client.UpdateQualityCheckData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateQualityCheckDataRequest is the request struct for api UpdateQualityCheckData
type UpdateQualityCheckDataRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// UpdateQualityCheckDataResponse is the response struct for api UpdateQualityCheckData
type UpdateQualityCheckDataResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUpdateQualityCheckDataRequest creates a request to invoke UpdateQualityCheckData API
func CreateUpdateQualityCheckDataRequest() (request *UpdateQualityCheckDataRequest) {
	request = &UpdateQualityCheckDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "UpdateQualityCheckData", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateQualityCheckDataResponse creates a response to parse from UpdateQualityCheckData response
func CreateUpdateQualityCheckDataResponse() (response *UpdateQualityCheckDataResponse) {
	response = &UpdateQualityCheckDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
