package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddUserTagMeta invokes the quickbi_public.AddUserTagMeta API synchronously
func (client *Client) AddUserTagMeta(request *AddUserTagMetaRequest) (response *AddUserTagMetaResponse, err error) {
	response = CreateAddUserTagMetaResponse()
	err = client.DoAction(request, response)
	return
}

// AddUserTagMetaWithChan invokes the quickbi_public.AddUserTagMeta API asynchronously
func (client *Client) AddUserTagMetaWithChan(request *AddUserTagMetaRequest) (<-chan *AddUserTagMetaResponse, <-chan error) {
	responseChan := make(chan *AddUserTagMetaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddUserTagMeta(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddUserTagMetaWithCallback invokes the quickbi_public.AddUserTagMeta API asynchronously
func (client *Client) AddUserTagMetaWithCallback(request *AddUserTagMetaRequest, callback func(response *AddUserTagMetaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddUserTagMetaResponse
		var err error
		defer close(result)
		response, err = client.AddUserTagMeta(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddUserTagMetaRequest is the request struct for api AddUserTagMeta
type AddUserTagMetaRequest struct {
	*requests.RpcRequest
	TagDescription string `position:"Query" name:"TagDescription"`
	TagName        string `position:"Query" name:"TagName"`
	TagId          string `position:"Query" name:"TagId"`
	ClientToken    string `position:"Query" name:"ClientToken"`
	AccessPoint    string `position:"Query" name:"AccessPoint"`
	SignType       string `position:"Query" name:"SignType"`
}

// AddUserTagMetaResponse is the response struct for api AddUserTagMeta
type AddUserTagMetaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateAddUserTagMetaRequest creates a request to invoke AddUserTagMeta API
func CreateAddUserTagMetaRequest() (request *AddUserTagMetaRequest) {
	request = &AddUserTagMetaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "AddUserTagMeta", "quickbi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddUserTagMetaResponse creates a response to parse from AddUserTagMeta response
func CreateAddUserTagMetaResponse() (response *AddUserTagMetaResponse) {
	response = &AddUserTagMetaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
