package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteUserTagMeta invokes the quickbi_public.DeleteUserTagMeta API synchronously
func (client *Client) DeleteUserTagMeta(request *DeleteUserTagMetaRequest) (response *DeleteUserTagMetaResponse, err error) {
	response = CreateDeleteUserTagMetaResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteUserTagMetaWithChan invokes the quickbi_public.DeleteUserTagMeta API asynchronously
func (client *Client) DeleteUserTagMetaWithChan(request *DeleteUserTagMetaRequest) (<-chan *DeleteUserTagMetaResponse, <-chan error) {
	responseChan := make(chan *DeleteUserTagMetaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteUserTagMeta(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteUserTagMetaWithCallback invokes the quickbi_public.DeleteUserTagMeta API asynchronously
func (client *Client) DeleteUserTagMetaWithCallback(request *DeleteUserTagMetaRequest, callback func(response *DeleteUserTagMetaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteUserTagMetaResponse
		var err error
		defer close(result)
		response, err = client.DeleteUserTagMeta(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteUserTagMetaRequest is the request struct for api DeleteUserTagMeta
type DeleteUserTagMetaRequest struct {
	*requests.RpcRequest
	TagId       string `position:"Query" name:"TagId"`
	AccessPoint string `position:"Query" name:"AccessPoint"`
	SignType    string `position:"Query" name:"SignType"`
}

// DeleteUserTagMetaResponse is the response struct for api DeleteUserTagMeta
type DeleteUserTagMetaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteUserTagMetaRequest creates a request to invoke DeleteUserTagMeta API
func CreateDeleteUserTagMetaRequest() (request *DeleteUserTagMetaRequest) {
	request = &DeleteUserTagMetaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "DeleteUserTagMeta", "quickbi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteUserTagMetaResponse creates a response to parse from DeleteUserTagMeta response
func CreateDeleteUserTagMetaResponse() (response *DeleteUserTagMetaResponse) {
	response = &DeleteUserTagMetaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
