package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetScaleAppMetric invokes the sae.GetScaleAppMetric API synchronously
func (client *Client) GetScaleAppMetric(request *GetScaleAppMetricRequest) (response *GetScaleAppMetricResponse, err error) {
	response = CreateGetScaleAppMetricResponse()
	err = client.DoAction(request, response)
	return
}

// GetScaleAppMetricWithChan invokes the sae.GetScaleAppMetric API asynchronously
func (client *Client) GetScaleAppMetricWithChan(request *GetScaleAppMetricRequest) (<-chan *GetScaleAppMetricResponse, <-chan error) {
	responseChan := make(chan *GetScaleAppMetricResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetScaleAppMetric(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetScaleAppMetricWithCallback invokes the sae.GetScaleAppMetric API asynchronously
func (client *Client) GetScaleAppMetricWithCallback(request *GetScaleAppMetricRequest, callback func(response *GetScaleAppMetricResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetScaleAppMetricResponse
		var err error
		defer close(result)
		response, err = client.GetScaleAppMetric(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetScaleAppMetricRequest is the request struct for api GetScaleAppMetric
type GetScaleAppMetricRequest struct {
	*requests.RoaRequest
	Limit requests.Integer `position:"Path" name:"Limit"`
}

// GetScaleAppMetricResponse is the response struct for api GetScaleAppMetric
type GetScaleAppMetricResponse struct {
	*responses.BaseResponse
	Message   string              `json:"Message" xml:"Message"`
	RequestId string              `json:"RequestId" xml:"RequestId"`
	Code      string              `json:"Code" xml:"Code"`
	Success   bool                `json:"Success" xml:"Success"`
	Data      []ScaleAppMetricDto `json:"Data" xml:"Data"`
}

// CreateGetScaleAppMetricRequest creates a request to invoke GetScaleAppMetric API
func CreateGetScaleAppMetricRequest() (request *GetScaleAppMetricRequest) {
	request = &GetScaleAppMetricRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "GetScaleAppMetric", "/pop/v1/sam/getScaleAppMetric", "serverless", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetScaleAppMetricResponse creates a response to parse from GetScaleAppMetric response
func CreateGetScaleAppMetricResponse() (response *GetScaleAppMetricResponse) {
	response = &GetScaleAppMetricResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
