package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddInstallCode invokes the sas.AddInstallCode API synchronously
func (client *Client) AddInstallCode(request *AddInstallCodeRequest) (response *AddInstallCodeResponse, err error) {
	response = CreateAddInstallCodeResponse()
	err = client.DoAction(request, response)
	return
}

// AddInstallCodeWithChan invokes the sas.AddInstallCode API asynchronously
func (client *Client) AddInstallCodeWithChan(request *AddInstallCodeRequest) (<-chan *AddInstallCodeResponse, <-chan error) {
	responseChan := make(chan *AddInstallCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddInstallCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddInstallCodeWithCallback invokes the sas.AddInstallCode API asynchronously
func (client *Client) AddInstallCodeWithCallback(request *AddInstallCodeRequest, callback func(response *AddInstallCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddInstallCodeResponse
		var err error
		defer close(result)
		response, err = client.AddInstallCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddInstallCodeRequest is the request struct for api AddInstallCode
type AddInstallCodeRequest struct {
	*requests.RpcRequest
	ExpiredDate requests.Integer `position:"Query" name:"ExpiredDate"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	Os          string           `position:"Query" name:"Os"`
	GroupId     requests.Integer `position:"Query" name:"GroupId"`
	OnlyImage   requests.Boolean `position:"Query" name:"OnlyImage"`
	VendorName  string           `position:"Query" name:"VendorName"`
}

// AddInstallCodeResponse is the response struct for api AddInstallCode
type AddInstallCodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddInstallCodeRequest creates a request to invoke AddInstallCode API
func CreateAddInstallCodeRequest() (request *AddInstallCodeRequest) {
	request = &AddInstallCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "AddInstallCode", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddInstallCodeResponse creates a response to parse from AddInstallCode response
func CreateAddInstallCodeResponse() (response *AddInstallCodeResponse) {
	response = &AddInstallCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
