package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SasInstallCode invokes the sas.SasInstallCode API synchronously
func (client *Client) SasInstallCode(request *SasInstallCodeRequest) (response *SasInstallCodeResponse, err error) {
	response = CreateSasInstallCodeResponse()
	err = client.DoAction(request, response)
	return
}

// SasInstallCodeWithChan invokes the sas.SasInstallCode API asynchronously
func (client *Client) SasInstallCodeWithChan(request *SasInstallCodeRequest) (<-chan *SasInstallCodeResponse, <-chan error) {
	responseChan := make(chan *SasInstallCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SasInstallCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SasInstallCodeWithCallback invokes the sas.SasInstallCode API asynchronously
func (client *Client) SasInstallCodeWithCallback(request *SasInstallCodeRequest, callback func(response *SasInstallCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SasInstallCodeResponse
		var err error
		defer close(result)
		response, err = client.SasInstallCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SasInstallCodeRequest is the request struct for api SasInstallCode
type SasInstallCodeRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// SasInstallCodeResponse is the response struct for api SasInstallCode
type SasInstallCodeResponse struct {
	*responses.BaseResponse
	Data      string `json:"data" xml:"data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSasInstallCodeRequest creates a request to invoke SasInstallCode API
func CreateSasInstallCodeRequest() (request *SasInstallCodeRequest) {
	request = &SasInstallCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "SasInstallCode", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSasInstallCodeResponse creates a response to parse from SasInstallCode response
func CreateSasInstallCodeResponse() (response *SasInstallCodeResponse) {
	response = &SasInstallCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
