package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLoadBalancerUDPListenerAttribute invokes the slb.DescribeLoadBalancerUDPListenerAttribute API synchronously
func (client *Client) DescribeLoadBalancerUDPListenerAttribute(request *DescribeLoadBalancerUDPListenerAttributeRequest) (response *DescribeLoadBalancerUDPListenerAttributeResponse, err error) {
	response = CreateDescribeLoadBalancerUDPListenerAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLoadBalancerUDPListenerAttributeWithChan invokes the slb.DescribeLoadBalancerUDPListenerAttribute API asynchronously
func (client *Client) DescribeLoadBalancerUDPListenerAttributeWithChan(request *DescribeLoadBalancerUDPListenerAttributeRequest) (<-chan *DescribeLoadBalancerUDPListenerAttributeResponse, <-chan error) {
	responseChan := make(chan *DescribeLoadBalancerUDPListenerAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLoadBalancerUDPListenerAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLoadBalancerUDPListenerAttributeWithCallback invokes the slb.DescribeLoadBalancerUDPListenerAttribute API asynchronously
func (client *Client) DescribeLoadBalancerUDPListenerAttributeWithCallback(request *DescribeLoadBalancerUDPListenerAttributeRequest, callback func(response *DescribeLoadBalancerUDPListenerAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLoadBalancerUDPListenerAttributeResponse
		var err error
		defer close(result)
		response, err = client.DescribeLoadBalancerUDPListenerAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLoadBalancerUDPListenerAttributeRequest is the request struct for api DescribeLoadBalancerUDPListenerAttribute
type DescribeLoadBalancerUDPListenerAttributeRequest struct {
	*requests.RpcRequest
	AccessKeyId          string           `position:"Query" name:"access_key_id"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ListenerPort         requests.Integer `position:"Query" name:"ListenerPort"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Tags                 string           `position:"Query" name:"Tags"`
	LoadBalancerId       string           `position:"Query" name:"LoadBalancerId"`
}

// DescribeLoadBalancerUDPListenerAttributeResponse is the response struct for api DescribeLoadBalancerUDPListenerAttribute
type DescribeLoadBalancerUDPListenerAttributeResponse struct {
	*responses.BaseResponse
	VServerGroupId            string                                               `json:"VServerGroupId" xml:"VServerGroupId"`
	Status                    string                                               `json:"Status" xml:"Status"`
	AclType                   string                                               `json:"AclType" xml:"AclType"`
	ConnectionDrainTimeout    int                                                  `json:"ConnectionDrainTimeout" xml:"ConnectionDrainTimeout"`
	FailoverStrategy          string                                               `json:"FailoverStrategy" xml:"FailoverStrategy"`
	WorkingServerGroupId      string                                               `json:"WorkingServerGroupId" xml:"WorkingServerGroupId"`
	HealthCheckSwitch         string                                               `json:"HealthCheckSwitch" xml:"HealthCheckSwitch"`
	FullNatEnabled            bool                                                 `json:"FullNatEnabled" xml:"FullNatEnabled"`
	ServiceManagedMode        string                                               `json:"ServiceManagedMode" xml:"ServiceManagedMode"`
	QuicVersion               string                                               `json:"QuicVersion" xml:"QuicVersion"`
	RequestId                 string                                               `json:"RequestId" xml:"RequestId"`
	HealthCheckConnectPort    int                                                  `json:"HealthCheckConnectPort" xml:"HealthCheckConnectPort"`
	Description               string                                               `json:"Description" xml:"Description"`
	Bandwidth                 int                                                  `json:"Bandwidth" xml:"Bandwidth"`
	HealthCheckType           string                                               `json:"HealthCheckType" xml:"HealthCheckType"`
	MasterSlaveServerGroupId  string                                               `json:"MasterSlaveServerGroupId" xml:"MasterSlaveServerGroupId"`
	BackendServerPort         int                                                  `json:"BackendServerPort" xml:"BackendServerPort"`
	AclStatus                 string                                               `json:"AclStatus" xml:"AclStatus"`
	HealthCheckDomain         string                                               `json:"HealthCheckDomain" xml:"HealthCheckDomain"`
	UnhealthyThreshold        int                                                  `json:"UnhealthyThreshold" xml:"UnhealthyThreshold"`
	MasterServerGroupId       string                                               `json:"MasterServerGroupId" xml:"MasterServerGroupId"`
	HealthCheckHttpCode       string                                               `json:"HealthCheckHttpCode" xml:"HealthCheckHttpCode"`
	MaxConnection             int                                                  `json:"MaxConnection" xml:"MaxConnection"`
	ProxyProtocolV2Enabled    bool                                                 `json:"ProxyProtocolV2Enabled" xml:"ProxyProtocolV2Enabled"`
	SlaveServerGroupId        string                                               `json:"SlaveServerGroupId" xml:"SlaveServerGroupId"`
	PersistenceTimeout        int                                                  `json:"PersistenceTimeout" xml:"PersistenceTimeout"`
	ListenerPort              int                                                  `json:"ListenerPort" xml:"ListenerPort"`
	HealthCheckInterval       int                                                  `json:"HealthCheckInterval" xml:"HealthCheckInterval"`
	HealthCheckExp            string                                               `json:"HealthCheckExp" xml:"HealthCheckExp"`
	HealthCheckURI            string                                               `json:"HealthCheckURI" xml:"HealthCheckURI"`
	FailoverThreshold         int                                                  `json:"FailoverThreshold" xml:"FailoverThreshold"`
	AclId                     string                                               `json:"AclId" xml:"AclId"`
	Scheduler                 string                                               `json:"Scheduler" xml:"Scheduler"`
	VpcIds                    string                                               `json:"VpcIds" xml:"VpcIds"`
	HealthCheckConnectTimeout int                                                  `json:"HealthCheckConnectTimeout" xml:"HealthCheckConnectTimeout"`
	MasterSlaveModeEnabled    bool                                                 `json:"MasterSlaveModeEnabled" xml:"MasterSlaveModeEnabled"`
	HealthyThreshold          int                                                  `json:"HealthyThreshold" xml:"HealthyThreshold"`
	ConnectionDrain           string                                               `json:"ConnectionDrain" xml:"ConnectionDrain"`
	HealthCheckReq            string                                               `json:"HealthCheckReq" xml:"HealthCheckReq"`
	HealthCheckMethod         string                                               `json:"HealthCheckMethod" xml:"HealthCheckMethod"`
	HealthCheck               string                                               `json:"HealthCheck" xml:"HealthCheck"`
	AclIds                    AclIdsInDescribeLoadBalancerUDPListenerAttribute     `json:"AclIds" xml:"AclIds"`
	PortRanges                PortRangesInDescribeLoadBalancerUDPListenerAttribute `json:"PortRanges" xml:"PortRanges"`
}

// CreateDescribeLoadBalancerUDPListenerAttributeRequest creates a request to invoke DescribeLoadBalancerUDPListenerAttribute API
func CreateDescribeLoadBalancerUDPListenerAttributeRequest() (request *DescribeLoadBalancerUDPListenerAttributeRequest) {
	request = &DescribeLoadBalancerUDPListenerAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "DescribeLoadBalancerUDPListenerAttribute", "slb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLoadBalancerUDPListenerAttributeResponse creates a response to parse from DescribeLoadBalancerUDPListenerAttribute response
func CreateDescribeLoadBalancerUDPListenerAttributeResponse() (response *DescribeLoadBalancerUDPListenerAttributeResponse) {
	response = &DescribeLoadBalancerUDPListenerAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
