package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveVServerGroupBackendServers invokes the slb.RemoveVServerGroupBackendServers API synchronously
func (client *Client) RemoveVServerGroupBackendServers(request *RemoveVServerGroupBackendServersRequest) (response *RemoveVServerGroupBackendServersResponse, err error) {
	response = CreateRemoveVServerGroupBackendServersResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveVServerGroupBackendServersWithChan invokes the slb.RemoveVServerGroupBackendServers API asynchronously
func (client *Client) RemoveVServerGroupBackendServersWithChan(request *RemoveVServerGroupBackendServersRequest) (<-chan *RemoveVServerGroupBackendServersResponse, <-chan error) {
	responseChan := make(chan *RemoveVServerGroupBackendServersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveVServerGroupBackendServers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveVServerGroupBackendServersWithCallback invokes the slb.RemoveVServerGroupBackendServers API asynchronously
func (client *Client) RemoveVServerGroupBackendServersWithCallback(request *RemoveVServerGroupBackendServersRequest, callback func(response *RemoveVServerGroupBackendServersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveVServerGroupBackendServersResponse
		var err error
		defer close(result)
		response, err = client.RemoveVServerGroupBackendServers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveVServerGroupBackendServersRequest is the request struct for api RemoveVServerGroupBackendServers
type RemoveVServerGroupBackendServersRequest struct {
	*requests.RpcRequest
	AccessKeyId          string           `position:"Query" name:"access_key_id"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	BackendServers       string           `position:"Query" name:"BackendServers"`
	VServerGroupId       string           `position:"Query" name:"VServerGroupId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Tags                 string           `position:"Query" name:"Tags"`
}

// RemoveVServerGroupBackendServersResponse is the response struct for api RemoveVServerGroupBackendServers
type RemoveVServerGroupBackendServersResponse struct {
	*responses.BaseResponse
	VServerGroupId string                                           `json:"VServerGroupId" xml:"VServerGroupId"`
	RequestId      string                                           `json:"RequestId" xml:"RequestId"`
	BackendServers BackendServersInRemoveVServerGroupBackendServers `json:"BackendServers" xml:"BackendServers"`
}

// CreateRemoveVServerGroupBackendServersRequest creates a request to invoke RemoveVServerGroupBackendServers API
func CreateRemoveVServerGroupBackendServersRequest() (request *RemoveVServerGroupBackendServersRequest) {
	request = &RemoveVServerGroupBackendServersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "RemoveVServerGroupBackendServers", "slb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveVServerGroupBackendServersResponse creates a response to parse from RemoveVServerGroupBackendServers response
func CreateRemoveVServerGroupBackendServersResponse() (response *RemoveVServerGroupBackendServersResponse) {
	response = &RemoveVServerGroupBackendServersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
