package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetAccessControlListAttribute invokes the slb.SetAccessControlListAttribute API synchronously
func (client *Client) SetAccessControlListAttribute(request *SetAccessControlListAttributeRequest) (response *SetAccessControlListAttributeResponse, err error) {
	response = CreateSetAccessControlListAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// SetAccessControlListAttributeWithChan invokes the slb.SetAccessControlListAttribute API asynchronously
func (client *Client) SetAccessControlListAttributeWithChan(request *SetAccessControlListAttributeRequest) (<-chan *SetAccessControlListAttributeResponse, <-chan error) {
	responseChan := make(chan *SetAccessControlListAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetAccessControlListAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetAccessControlListAttributeWithCallback invokes the slb.SetAccessControlListAttribute API asynchronously
func (client *Client) SetAccessControlListAttributeWithCallback(request *SetAccessControlListAttributeRequest, callback func(response *SetAccessControlListAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetAccessControlListAttributeResponse
		var err error
		defer close(result)
		response, err = client.SetAccessControlListAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetAccessControlListAttributeRequest is the request struct for api SetAccessControlListAttribute
type SetAccessControlListAttributeRequest struct {
	*requests.RpcRequest
	AccessKeyId          string           `position:"Query" name:"access_key_id"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	AclName              string           `position:"Query" name:"AclName"`
	AclId                string           `position:"Query" name:"AclId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Tags                 string           `position:"Query" name:"Tags"`
}

// SetAccessControlListAttributeResponse is the response struct for api SetAccessControlListAttribute
type SetAccessControlListAttributeResponse struct {
	*responses.BaseResponse
	AclId     string `json:"AclId" xml:"AclId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetAccessControlListAttributeRequest creates a request to invoke SetAccessControlListAttribute API
func CreateSetAccessControlListAttributeRequest() (request *SetAccessControlListAttributeRequest) {
	request = &SetAccessControlListAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "SetAccessControlListAttribute", "slb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetAccessControlListAttributeResponse creates a response to parse from SetAccessControlListAttribute response
func CreateSetAccessControlListAttributeResponse() (response *SetAccessControlListAttributeResponse) {
	response = &SetAccessControlListAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
