package tag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetConfigRuleReport invokes the tag.GetConfigRuleReport API synchronously
func (client *Client) GetConfigRuleReport(request *GetConfigRuleReportRequest) (response *GetConfigRuleReportResponse, err error) {
	response = CreateGetConfigRuleReportResponse()
	err = client.DoAction(request, response)
	return
}

// GetConfigRuleReportWithChan invokes the tag.GetConfigRuleReport API asynchronously
func (client *Client) GetConfigRuleReportWithChan(request *GetConfigRuleReportRequest) (<-chan *GetConfigRuleReportResponse, <-chan error) {
	responseChan := make(chan *GetConfigRuleReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetConfigRuleReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetConfigRuleReportWithCallback invokes the tag.GetConfigRuleReport API asynchronously
func (client *Client) GetConfigRuleReportWithCallback(request *GetConfigRuleReportRequest, callback func(response *GetConfigRuleReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetConfigRuleReportResponse
		var err error
		defer close(result)
		response, err = client.GetConfigRuleReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetConfigRuleReportRequest is the request struct for api GetConfigRuleReport
type GetConfigRuleReportRequest struct {
	*requests.RpcRequest
	TargetId             string           `position:"Query" name:"TargetId"`
	TargetType           string           `position:"Query" name:"TargetType"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	UserType             string           `position:"Query" name:"UserType"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// GetConfigRuleReportResponse is the response struct for api GetConfigRuleReport
type GetConfigRuleReportResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetConfigRuleReportRequest creates a request to invoke GetConfigRuleReport API
func CreateGetConfigRuleReportRequest() (request *GetConfigRuleReportRequest) {
	request = &GetConfigRuleReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Tag", "2018-08-28", "GetConfigRuleReport", "tag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetConfigRuleReportResponse creates a response to parse from GetConfigRuleReport response
func CreateGetConfigRuleReportResponse() (response *GetConfigRuleReportResponse) {
	response = &GetConfigRuleReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
