package tag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListConfigRulesForTarget invokes the tag.ListConfigRulesForTarget API synchronously
func (client *Client) ListConfigRulesForTarget(request *ListConfigRulesForTargetRequest) (response *ListConfigRulesForTargetResponse, err error) {
	response = CreateListConfigRulesForTargetResponse()
	err = client.DoAction(request, response)
	return
}

// ListConfigRulesForTargetWithChan invokes the tag.ListConfigRulesForTarget API asynchronously
func (client *Client) ListConfigRulesForTargetWithChan(request *ListConfigRulesForTargetRequest) (<-chan *ListConfigRulesForTargetResponse, <-chan error) {
	responseChan := make(chan *ListConfigRulesForTargetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListConfigRulesForTarget(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListConfigRulesForTargetWithCallback invokes the tag.ListConfigRulesForTarget API asynchronously
func (client *Client) ListConfigRulesForTargetWithCallback(request *ListConfigRulesForTargetRequest, callback func(response *ListConfigRulesForTargetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListConfigRulesForTargetResponse
		var err error
		defer close(result)
		response, err = client.ListConfigRulesForTarget(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListConfigRulesForTargetRequest is the request struct for api ListConfigRulesForTarget
type ListConfigRulesForTargetRequest struct {
	*requests.RpcRequest
	TargetId             string           `position:"Query" name:"TargetId"`
	TargetType           string           `position:"Query" name:"TargetType"`
	NextToken            string           `position:"Query" name:"NextToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	PolicyType           string           `position:"Query" name:"PolicyType"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	UserType             string           `position:"Query" name:"UserType"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	MaxResult            requests.Integer `position:"Query" name:"MaxResult"`
	TagKey               string           `position:"Query" name:"TagKey"`
}

// ListConfigRulesForTargetResponse is the response struct for api ListConfigRulesForTarget
type ListConfigRulesForTargetResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	NextToken string     `json:"NextToken" xml:"NextToken"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateListConfigRulesForTargetRequest creates a request to invoke ListConfigRulesForTarget API
func CreateListConfigRulesForTargetRequest() (request *ListConfigRulesForTargetRequest) {
	request = &ListConfigRulesForTargetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Tag", "2018-08-28", "ListConfigRulesForTarget", "tag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListConfigRulesForTargetResponse creates a response to parse from ListConfigRulesForTarget response
func CreateListConfigRulesForTargetResponse() (response *ListConfigRulesForTargetResponse) {
	response = &ListConfigRulesForTargetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
