package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindMaterial invokes the trademark.BindMaterial API synchronously
// api document: https://help.aliyun.com/api/trademark/bindmaterial.html
func (client *Client) BindMaterial(request *BindMaterialRequest) (response *BindMaterialResponse, err error) {
	response = CreateBindMaterialResponse()
	err = client.DoAction(request, response)
	return
}

// BindMaterialWithChan invokes the trademark.BindMaterial API asynchronously
// api document: https://help.aliyun.com/api/trademark/bindmaterial.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindMaterialWithChan(request *BindMaterialRequest) (<-chan *BindMaterialResponse, <-chan error) {
	responseChan := make(chan *BindMaterialResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindMaterial(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindMaterialWithCallback invokes the trademark.BindMaterial API asynchronously
// api document: https://help.aliyun.com/api/trademark/bindmaterial.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindMaterialWithCallback(request *BindMaterialRequest, callback func(response *BindMaterialResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindMaterialResponse
		var err error
		defer close(result)
		response, err = client.BindMaterial(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindMaterialRequest is the request struct for api BindMaterial
type BindMaterialRequest struct {
	*requests.RpcRequest
	BizId      string `position:"Query" name:"BizId"`
	MaterialId string `position:"Query" name:"MaterialId"`
	LoaOssKey  string `position:"Query" name:"LoaOssKey"`
}

// BindMaterialResponse is the response struct for api BindMaterial
type BindMaterialResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBindMaterialRequest creates a request to invoke BindMaterial API
func CreateBindMaterialRequest() (request *BindMaterialRequest) {
	request = &BindMaterialRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "BindMaterial", "trademark", "openAPI")
	return
}

// CreateBindMaterialResponse creates a response to parse from BindMaterial response
func CreateBindMaterialResponse() (response *BindMaterialResponse) {
	response = &BindMaterialResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
