package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryUnionTaskList invokes the unimkt.QueryUnionTaskList API synchronously
func (client *Client) QueryUnionTaskList(request *QueryUnionTaskListRequest) (response *QueryUnionTaskListResponse, err error) {
	response = CreateQueryUnionTaskListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryUnionTaskListWithChan invokes the unimkt.QueryUnionTaskList API asynchronously
func (client *Client) QueryUnionTaskListWithChan(request *QueryUnionTaskListRequest) (<-chan *QueryUnionTaskListResponse, <-chan error) {
	responseChan := make(chan *QueryUnionTaskListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryUnionTaskList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryUnionTaskListWithCallback invokes the unimkt.QueryUnionTaskList API asynchronously
func (client *Client) QueryUnionTaskListWithCallback(request *QueryUnionTaskListRequest, callback func(response *QueryUnionTaskListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryUnionTaskListResponse
		var err error
		defer close(result)
		response, err = client.QueryUnionTaskList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryUnionTaskListRequest is the request struct for api QueryUnionTaskList
type QueryUnionTaskListRequest struct {
	*requests.RpcRequest
	BrandUserId requests.Integer `position:"Query" name:"BrandUserId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	PageIndex   requests.Integer `position:"Query" name:"PageIndex"`
	ProxyUserId requests.Integer `position:"Query" name:"ProxyUserId"`
	ChannelId   string           `position:"Query" name:"ChannelId"`
}

// QueryUnionTaskListResponse is the response struct for api QueryUnionTaskList
type QueryUnionTaskListResponse struct {
	*responses.BaseResponse
	Code      int                      `json:"Code" xml:"Code"`
	Success   bool                     `json:"Success" xml:"Success"`
	ErrorMsg  string                   `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Data      []map[string]interface{} `json:"Data" xml:"Data"`
}

// CreateQueryUnionTaskListRequest creates a request to invoke QueryUnionTaskList API
func CreateQueryUnionTaskListRequest() (request *QueryUnionTaskListRequest) {
	request = &QueryUnionTaskListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "QueryUnionTaskList", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryUnionTaskListResponse creates a response to parse from QueryUnionTaskList response
func CreateQueryUnionTaskListResponse() (response *QueryUnionTaskListResponse) {
	response = &QueryUnionTaskListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
