package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExecuteSqlScript invokes the ververica.ExecuteSqlScript API synchronously
func (client *Client) ExecuteSqlScript(request *ExecuteSqlScriptRequest) (response *ExecuteSqlScriptResponse, err error) {
	response = CreateExecuteSqlScriptResponse()
	err = client.DoAction(request, response)
	return
}

// ExecuteSqlScriptWithChan invokes the ververica.ExecuteSqlScript API asynchronously
func (client *Client) ExecuteSqlScriptWithChan(request *ExecuteSqlScriptRequest) (<-chan *ExecuteSqlScriptResponse, <-chan error) {
	responseChan := make(chan *ExecuteSqlScriptResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExecuteSqlScript(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExecuteSqlScriptWithCallback invokes the ververica.ExecuteSqlScript API asynchronously
func (client *Client) ExecuteSqlScriptWithCallback(request *ExecuteSqlScriptRequest, callback func(response *ExecuteSqlScriptResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExecuteSqlScriptResponse
		var err error
		defer close(result)
		response, err = client.ExecuteSqlScript(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExecuteSqlScriptRequest is the request struct for api ExecuteSqlScript
type ExecuteSqlScriptRequest struct {
	*requests.RoaRequest
	Workspace  string `position:"Path" name:"workspace"`
	ParamsJson string `position:"Body" name:"paramsJson"`
	Namespace  string `position:"Path" name:"namespace"`
}

// ExecuteSqlScriptResponse is the response struct for api ExecuteSqlScript
type ExecuteSqlScriptResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	RequestId string `json:"requestId" xml:"requestId"`
	Data      string `json:"data" xml:"data"`
}

// CreateExecuteSqlScriptRequest creates a request to invoke ExecuteSqlScript API
func CreateExecuteSqlScriptRequest() (request *ExecuteSqlScriptRequest) {
	request = &ExecuteSqlScriptRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "ExecuteSqlScript", "/pop/workspaces/[workspace]/sql/v1beta1/namespaces/[namespace]/sqlscripts:execute", "", "")
	request.Method = requests.POST
	return
}

// CreateExecuteSqlScriptResponse creates a response to parse from ExecuteSqlScript response
func CreateExecuteSqlScriptResponse() (response *ExecuteSqlScriptResponse) {
	response = &ExecuteSqlScriptResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
