package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFormats invokes the ververica.ListFormats API synchronously
func (client *Client) ListFormats(request *ListFormatsRequest) (response *ListFormatsResponse, err error) {
	response = CreateListFormatsResponse()
	err = client.DoAction(request, response)
	return
}

// ListFormatsWithChan invokes the ververica.ListFormats API asynchronously
func (client *Client) ListFormatsWithChan(request *ListFormatsRequest) (<-chan *ListFormatsResponse, <-chan error) {
	responseChan := make(chan *ListFormatsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFormats(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFormatsWithCallback invokes the ververica.ListFormats API asynchronously
func (client *Client) ListFormatsWithCallback(request *ListFormatsRequest, callback func(response *ListFormatsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFormatsResponse
		var err error
		defer close(result)
		response, err = client.ListFormats(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFormatsRequest is the request struct for api ListFormats
type ListFormatsRequest struct {
	*requests.RoaRequest
	Workspace string `position:"Path" name:"workspace"`
	Namespace string `position:"Path" name:"namespace"`
}

// ListFormatsResponse is the response struct for api ListFormats
type ListFormatsResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	Data      string `json:"data" xml:"data"`
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateListFormatsRequest creates a request to invoke ListFormats API
func CreateListFormatsRequest() (request *ListFormatsRequest) {
	request = &ListFormatsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "ListFormats", "/pop/workspaces/[workspace]/sql/v1beta1/namespaces/[namespace]/formats", "", "")
	request.Method = requests.GET
	return
}

// CreateListFormatsResponse creates a response to parse from ListFormats response
func CreateListFormatsResponse() (response *ListFormatsResponse) {
	response = &ListFormatsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
