package yundun_dbaudit

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAuditLogs invokes the yundun_dbaudit.DescribeAuditLogs API synchronously
// api document: https://help.aliyun.com/api/yundun-dbaudit/describeauditlogs.html
func (client *Client) DescribeAuditLogs(request *DescribeAuditLogsRequest) (response *DescribeAuditLogsResponse, err error) {
	response = CreateDescribeAuditLogsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAuditLogsWithChan invokes the yundun_dbaudit.DescribeAuditLogs API asynchronously
// api document: https://help.aliyun.com/api/yundun-dbaudit/describeauditlogs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAuditLogsWithChan(request *DescribeAuditLogsRequest) (<-chan *DescribeAuditLogsResponse, <-chan error) {
	responseChan := make(chan *DescribeAuditLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAuditLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAuditLogsWithCallback invokes the yundun_dbaudit.DescribeAuditLogs API asynchronously
// api document: https://help.aliyun.com/api/yundun-dbaudit/describeauditlogs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAuditLogsWithCallback(request *DescribeAuditLogsRequest, callback func(response *DescribeAuditLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAuditLogsResponse
		var err error
		defer close(result)
		response, err = client.DescribeAuditLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAuditLogsRequest is the request struct for api DescribeAuditLogs
type DescribeAuditLogsRequest struct {
	*requests.RpcRequest
	Dip         string           `position:"Query" name:"Dip"`
	StartTime   string           `position:"Query" name:"StartTime"`
	Sessionid   string           `position:"Query" name:"Sessionid"`
	Dir         string           `position:"Query" name:"Dir"`
	HostName    string           `position:"Query" name:"HostName"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	Payload     string           `position:"Query" name:"Payload"`
	LoginUser   string           `position:"Query" name:"LoginUser"`
	QueryString string           `position:"Query" name:"QueryString"`
	Sort        string           `position:"Query" name:"Sort"`
	SqlLen      string           `position:"Query" name:"SqlLen"`
	InstanceId  string           `position:"Query" name:"InstanceId"`
	DbName      string           `position:"Query" name:"DbName"`
	DbId        string           `position:"Query" name:"DbId"`
	AlarmName   string           `position:"Query" name:"AlarmName"`
	Dmac        string           `position:"Query" name:"Dmac"`
	Smac        string           `position:"Query" name:"Smac"`
	Result      string           `position:"Query" name:"Result"`
	Dport       string           `position:"Query" name:"Dport"`
	OpType      string           `position:"Query" name:"OpType"`
	ClientUser  string           `position:"Query" name:"ClientUser"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	Sip         string           `position:"Query" name:"Sip"`
	EffectRow   string           `position:"Query" name:"EffectRow"`
	ResultDesc  string           `position:"Query" name:"ResultDesc"`
	Sqlid       string           `position:"Query" name:"Sqlid"`
	Cost        string           `position:"Query" name:"Cost"`
	EndTime     string           `position:"Query" name:"EndTime"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Accessid    string           `position:"Query" name:"Accessid"`
	DbType      string           `position:"Query" name:"DbType"`
	ClientPrg   string           `position:"Query" name:"ClientPrg"`
	Sport       string           `position:"Query" name:"Sport"`
	DataSet     string           `position:"Query" name:"DataSet"`
	AlarmLevel  string           `position:"Query" name:"AlarmLevel"`
}

// DescribeAuditLogsResponse is the response struct for api DescribeAuditLogs
type DescribeAuditLogsResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	AuditLogs  []Item `json:"AuditLogs" xml:"AuditLogs"`
}

// CreateDescribeAuditLogsRequest creates a request to invoke DescribeAuditLogs API
func CreateDescribeAuditLogsRequest() (request *DescribeAuditLogsRequest) {
	request = &DescribeAuditLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Yundun-dbaudit", "2018-10-29", "DescribeAuditLogs", "dbaudit", "openAPI")
	return
}

// CreateDescribeAuditLogsResponse creates a response to parse from DescribeAuditLogs response
func CreateDescribeAuditLogsResponse() (response *DescribeAuditLogsResponse) {
	response = &DescribeAuditLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
