/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.psi.j2se.rms;

import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import javax.microedition.midlet.ApplicationManager;
import javax.swing.JOptionPane;
import org.me4se.Initializer;
import org.me4se.impl.rms.AbstractRecordStore;
import org.me4se.psi.j2se.rms.RecordStoreImpl;

public class RecordStoreInitializer
implements Initializer {
    public void initialize(ApplicationManager am) {
        if (RecordStoreImpl.rmsDir != null) {
            return;
        }
        if (am.applet != null) {
            RecordStoreImpl.rmsDir = null;
        } else {
            boolean hasRms;
            RecordStoreImpl.rmsDir = new File(ApplicationManager.getProperty("rms.home", ".rms"));
            try {
                hasRms = RecordStoreImpl.rmsDir.exists();
            }
            catch (Throwable th) {
                hasRms = false;
            }
            if (hasRms) {
                try {
                    final File lockFile = new File(RecordStoreImpl.rmsDir, "in.use");
                    if (lockFile.exists()) {
                        int result;
                        System.err.println("[RecordStoreInitializer] in.use file found! " + lockFile);
                        if (System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0 && (result = JOptionPane.showConfirmDialog(null, "ME4SE may already be running, are you sure you want to run anyway?", "Question?", 0)) == 1) {
                            System.exit(0);
                        }
                        lockFile.delete();
                    }
                    FileOutputStream lockFileOS = new FileOutputStream(lockFile);
                    lockFileOS.close();
                    final FileChannel lockChannel = new RandomAccessFile(lockFile, "rw").getChannel();
                    final FileLock lock = lockChannel.tryLock();
                    if (lock == null) {
                        throw new Exception("Unable to obtain lock");
                    }
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        public void run() {
                            try {
                                lock.release();
                                lockChannel.close();
                                lockFile.delete();
                            }
                            catch (Throwable th) {
                                th.printStackTrace();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "An instance of ME4SE is already running.", "Warning", 2);
                    System.exit(0);
                }
                String[] files = RecordStoreImpl.rmsDir.list();
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        String fileName = files[i];
                        if (!fileName.endsWith(".rms")) continue;
                        String name = RecordStoreImpl.decode(fileName.substring(0, fileName.length() - 4));
                        AbstractRecordStore.recordStores.put(name, new RecordStoreImpl());
                    }
                }
            }
        }
    }
}

