/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.ant;

import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Echo;
import org.dita.dost.ant.ExtensibleAntInvoker;
import org.dita.dost.log.DITAOTAntLogger;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageBean;
import org.dita.dost.log.MessageUtils;

public final class DITAOTEchoTask
extends Echo {
    private String id = null;
    private final ArrayList<ExtensibleAntInvoker.ParamElem> params = new ArrayList();
    private DITAOTLogger logger;

    public void setId(String identifier) {
        this.id = identifier;
    }

    public ExtensibleAntInvoker.ParamElem createParam() {
        ExtensibleAntInvoker.ParamElem p = new ExtensibleAntInvoker.ParamElem();
        this.params.add(p);
        return p;
    }

    public void execute() throws BuildException {
        this.logger = new DITAOTAntLogger(this.getProject());
        MessageBean msgBean = MessageUtils.getMessage(this.id, this.readParamValues());
        if (msgBean != null) {
            String type = msgBean.getType();
            if (MessageBean.ERROR.equals(type)) {
                this.logger.error(msgBean.toString());
            } else if (MessageBean.WARN.equals(type)) {
                this.logger.warn(msgBean.toString());
            } else if (MessageBean.INFO.equals(type)) {
                this.logger.info(msgBean.toString());
            } else if (MessageBean.DEBUG.equals(type)) {
                this.logger.debug(msgBean.toString());
            }
        }
    }

    private String[] readParamValues() throws BuildException {
        ArrayList<String> prop = new ArrayList<String>();
        for (ExtensibleAntInvoker.ParamElem p : this.params) {
            if (!p.isValid()) {
                throw new BuildException("Incomplete parameter");
            }
            if (!ExtensibleAntInvoker.isValid(this.getProject(), this.getLocation(), p.getIf(), p.getUnless())) continue;
            int idx = Integer.parseInt(p.getName()) - 1;
            if (idx >= prop.size()) {
                prop.ensureCapacity(idx + 1);
                while (prop.size() < idx + 1) {
                    prop.add(null);
                }
            }
            prop.set(idx, p.getValue());
        }
        return prop.toArray(new String[0]);
    }
}

