/*
Copyright 2014 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package registrytest

import (
	"reflect"
	"testing"

	"k8s.io/apiserver/pkg/registry/rest"
)

func AssertShortNames(t *testing.T, storage rest.ShortNamesProvider, expected []string) {
	actual := storage.ShortNames()
	ok := reflect.DeepEqual(actual, expected)
	if !ok {
		t.Errorf("short names not equal. expected = %v actual = %v", expected, actual)
	}
}
