/*
Copyright 2023 The KEDA Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package util

import (
	"testing"
	"time"

	"github.com/stretchr/testify/assert"
)

func TestCreateHTTPClientWhenNegativeTimeout(t *testing.T) {
	client := CreateHTTPClient(-1*time.Minute, false)

	assert.Equal(t, 300*time.Millisecond, client.Timeout)
}

func TestCreateHTTPClientWhenValidTimeout(t *testing.T) {
	client := CreateHTTPClient(1*time.Minute, false)

	assert.Equal(t, 1*time.Minute, client.Timeout)
}
