// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// LINT: LEGACY_NAMES

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/sql/v1beta4/cloud_sql_resources.proto

package sql

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type SqlFileType int32

const (
	// Unknown file type.
	SqlFileType_SQL_FILE_TYPE_UNSPECIFIED SqlFileType = 0
	// File containing SQL statements.
	SqlFileType_SQL SqlFileType = 1
	// File in CSV format.
	SqlFileType_CSV SqlFileType = 2
	SqlFileType_BAK SqlFileType = 4
)

// Enum value maps for SqlFileType.
var (
	SqlFileType_name = map[int32]string{
		0: "SQL_FILE_TYPE_UNSPECIFIED",
		1: "SQL",
		2: "CSV",
		4: "BAK",
	}
	SqlFileType_value = map[string]int32{
		"SQL_FILE_TYPE_UNSPECIFIED": 0,
		"SQL":                       1,
		"CSV":                       2,
		"BAK":                       4,
	}
)

func (x SqlFileType) Enum() *SqlFileType {
	p := new(SqlFileType)
	*p = x
	return p
}

func (x SqlFileType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlFileType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[0].Descriptor()
}

func (SqlFileType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[0]
}

func (x SqlFileType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlFileType.Descriptor instead.
func (SqlFileType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{0}
}

// The status of a backup run.
type SqlBackupRunStatus int32

const (
	// The status of the run is unknown.
	SqlBackupRunStatus_SQL_BACKUP_RUN_STATUS_UNSPECIFIED SqlBackupRunStatus = 0
	// The backup operation was enqueued.
	SqlBackupRunStatus_ENQUEUED SqlBackupRunStatus = 1
	// The backup is overdue across a given backup window. Indicates a
	// problem. Example: Long-running operation in progress during
	// the whole window.
	SqlBackupRunStatus_OVERDUE SqlBackupRunStatus = 2
	// The backup is in progress.
	SqlBackupRunStatus_RUNNING SqlBackupRunStatus = 3
	// The backup failed.
	SqlBackupRunStatus_FAILED SqlBackupRunStatus = 4
	// The backup was successful.
	SqlBackupRunStatus_SUCCESSFUL SqlBackupRunStatus = 5
	// The backup was skipped (without problems) for a given backup
	// window. Example: Instance was idle.
	SqlBackupRunStatus_SKIPPED SqlBackupRunStatus = 6
	// The backup is about to be deleted.
	SqlBackupRunStatus_DELETION_PENDING SqlBackupRunStatus = 7
	// The backup deletion failed.
	SqlBackupRunStatus_DELETION_FAILED SqlBackupRunStatus = 8
	// The backup has been deleted.
	SqlBackupRunStatus_DELETED SqlBackupRunStatus = 9
)

// Enum value maps for SqlBackupRunStatus.
var (
	SqlBackupRunStatus_name = map[int32]string{
		0: "SQL_BACKUP_RUN_STATUS_UNSPECIFIED",
		1: "ENQUEUED",
		2: "OVERDUE",
		3: "RUNNING",
		4: "FAILED",
		5: "SUCCESSFUL",
		6: "SKIPPED",
		7: "DELETION_PENDING",
		8: "DELETION_FAILED",
		9: "DELETED",
	}
	SqlBackupRunStatus_value = map[string]int32{
		"SQL_BACKUP_RUN_STATUS_UNSPECIFIED": 0,
		"ENQUEUED":                          1,
		"OVERDUE":                           2,
		"RUNNING":                           3,
		"FAILED":                            4,
		"SUCCESSFUL":                        5,
		"SKIPPED":                           6,
		"DELETION_PENDING":                  7,
		"DELETION_FAILED":                   8,
		"DELETED":                           9,
	}
)

func (x SqlBackupRunStatus) Enum() *SqlBackupRunStatus {
	p := new(SqlBackupRunStatus)
	*p = x
	return p
}

func (x SqlBackupRunStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlBackupRunStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[1].Descriptor()
}

func (SqlBackupRunStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[1]
}

func (x SqlBackupRunStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlBackupRunStatus.Descriptor instead.
func (SqlBackupRunStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{1}
}

type SqlBackupRunType int32

const (
	// This is an unknown BackupRun type.
	SqlBackupRunType_SQL_BACKUP_RUN_TYPE_UNSPECIFIED SqlBackupRunType = 0
	// The backup schedule automatically triggers a backup.
	SqlBackupRunType_AUTOMATED SqlBackupRunType = 1
	// The user manually triggers a backup.
	SqlBackupRunType_ON_DEMAND SqlBackupRunType = 2
)

// Enum value maps for SqlBackupRunType.
var (
	SqlBackupRunType_name = map[int32]string{
		0: "SQL_BACKUP_RUN_TYPE_UNSPECIFIED",
		1: "AUTOMATED",
		2: "ON_DEMAND",
	}
	SqlBackupRunType_value = map[string]int32{
		"SQL_BACKUP_RUN_TYPE_UNSPECIFIED": 0,
		"AUTOMATED":                       1,
		"ON_DEMAND":                       2,
	}
)

func (x SqlBackupRunType) Enum() *SqlBackupRunType {
	p := new(SqlBackupRunType)
	*p = x
	return p
}

func (x SqlBackupRunType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlBackupRunType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[2].Descriptor()
}

func (SqlBackupRunType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[2]
}

func (x SqlBackupRunType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlBackupRunType.Descriptor instead.
func (SqlBackupRunType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{2}
}

// Defines the supported backup kinds
type SqlBackupKind int32

const (
	// This is an unknown BackupKind.
	SqlBackupKind_SQL_BACKUP_KIND_UNSPECIFIED SqlBackupKind = 0
	// The snapshot based backups
	SqlBackupKind_SNAPSHOT SqlBackupKind = 1
	// Physical backups
	SqlBackupKind_PHYSICAL SqlBackupKind = 2
)

// Enum value maps for SqlBackupKind.
var (
	SqlBackupKind_name = map[int32]string{
		0: "SQL_BACKUP_KIND_UNSPECIFIED",
		1: "SNAPSHOT",
		2: "PHYSICAL",
	}
	SqlBackupKind_value = map[string]int32{
		"SQL_BACKUP_KIND_UNSPECIFIED": 0,
		"SNAPSHOT":                    1,
		"PHYSICAL":                    2,
	}
)

func (x SqlBackupKind) Enum() *SqlBackupKind {
	p := new(SqlBackupKind)
	*p = x
	return p
}

func (x SqlBackupKind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlBackupKind) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[3].Descriptor()
}

func (SqlBackupKind) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[3]
}

func (x SqlBackupKind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlBackupKind.Descriptor instead.
func (SqlBackupKind) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{3}
}

type SqlBackendType int32

const (
	// This is an unknown backend type for instance.
	SqlBackendType_SQL_BACKEND_TYPE_UNSPECIFIED SqlBackendType = 0
	// V1 speckle instance.
	//
	// Deprecated: Do not use.
	SqlBackendType_FIRST_GEN SqlBackendType = 1
	// V2 speckle instance.
	SqlBackendType_SECOND_GEN SqlBackendType = 2
	// On premises instance.
	SqlBackendType_EXTERNAL SqlBackendType = 3
)

// Enum value maps for SqlBackendType.
var (
	SqlBackendType_name = map[int32]string{
		0: "SQL_BACKEND_TYPE_UNSPECIFIED",
		1: "FIRST_GEN",
		2: "SECOND_GEN",
		3: "EXTERNAL",
	}
	SqlBackendType_value = map[string]int32{
		"SQL_BACKEND_TYPE_UNSPECIFIED": 0,
		"FIRST_GEN":                    1,
		"SECOND_GEN":                   2,
		"EXTERNAL":                     3,
	}
)

func (x SqlBackendType) Enum() *SqlBackendType {
	p := new(SqlBackendType)
	*p = x
	return p
}

func (x SqlBackendType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlBackendType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[4].Descriptor()
}

func (SqlBackendType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[4]
}

func (x SqlBackendType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlBackendType.Descriptor instead.
func (SqlBackendType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{4}
}

type SqlIpAddressType int32

const (
	// This is an unknown IP address type.
	SqlIpAddressType_SQL_IP_ADDRESS_TYPE_UNSPECIFIED SqlIpAddressType = 0
	// IP address the customer is supposed to connect to. Usually this is the
	// load balancer's IP address
	SqlIpAddressType_PRIMARY SqlIpAddressType = 1
	// Source IP address of the connection a read replica establishes to its
	// external primary instance. This IP address can be allowlisted by the
	// customer in case it has a firewall that filters incoming connection to its
	// on premises primary instance.
	SqlIpAddressType_OUTGOING SqlIpAddressType = 2
	// Private IP used when using private IPs and network peering.
	SqlIpAddressType_PRIVATE SqlIpAddressType = 3
	// V1 IP of a migrated instance. We want the user to
	// decommission this IP as soon as the migration is complete.
	// Note: V1 instances with V1 ip addresses will be counted as PRIMARY.
	SqlIpAddressType_MIGRATED_1ST_GEN SqlIpAddressType = 4
)

// Enum value maps for SqlIpAddressType.
var (
	SqlIpAddressType_name = map[int32]string{
		0: "SQL_IP_ADDRESS_TYPE_UNSPECIFIED",
		1: "PRIMARY",
		2: "OUTGOING",
		3: "PRIVATE",
		4: "MIGRATED_1ST_GEN",
	}
	SqlIpAddressType_value = map[string]int32{
		"SQL_IP_ADDRESS_TYPE_UNSPECIFIED": 0,
		"PRIMARY":                         1,
		"OUTGOING":                        2,
		"PRIVATE":                         3,
		"MIGRATED_1ST_GEN":                4,
	}
)

func (x SqlIpAddressType) Enum() *SqlIpAddressType {
	p := new(SqlIpAddressType)
	*p = x
	return p
}

func (x SqlIpAddressType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlIpAddressType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[5].Descriptor()
}

func (SqlIpAddressType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[5]
}

func (x SqlIpAddressType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlIpAddressType.Descriptor instead.
func (SqlIpAddressType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{5}
}

type SqlInstanceType int32

const (
	// This is an unknown Cloud SQL instance type.
	SqlInstanceType_SQL_INSTANCE_TYPE_UNSPECIFIED SqlInstanceType = 0
	// A regular Cloud SQL instance that is not replicating from a primary
	// instance.
	SqlInstanceType_CLOUD_SQL_INSTANCE SqlInstanceType = 1
	// An instance running on the customer's premises that is not managed by
	// Cloud SQL.
	SqlInstanceType_ON_PREMISES_INSTANCE SqlInstanceType = 2
	// A Cloud SQL instance acting as a read-replica.
	SqlInstanceType_READ_REPLICA_INSTANCE SqlInstanceType = 3
)

// Enum value maps for SqlInstanceType.
var (
	SqlInstanceType_name = map[int32]string{
		0: "SQL_INSTANCE_TYPE_UNSPECIFIED",
		1: "CLOUD_SQL_INSTANCE",
		2: "ON_PREMISES_INSTANCE",
		3: "READ_REPLICA_INSTANCE",
	}
	SqlInstanceType_value = map[string]int32{
		"SQL_INSTANCE_TYPE_UNSPECIFIED": 0,
		"CLOUD_SQL_INSTANCE":            1,
		"ON_PREMISES_INSTANCE":          2,
		"READ_REPLICA_INSTANCE":         3,
	}
)

func (x SqlInstanceType) Enum() *SqlInstanceType {
	p := new(SqlInstanceType)
	*p = x
	return p
}

func (x SqlInstanceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlInstanceType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[6].Descriptor()
}

func (SqlInstanceType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[6]
}

func (x SqlInstanceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlInstanceType.Descriptor instead.
func (SqlInstanceType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{6}
}

// The database engine type and version.
type SqlDatabaseVersion int32

const (
	// This is an unknown database version.
	SqlDatabaseVersion_SQL_DATABASE_VERSION_UNSPECIFIED SqlDatabaseVersion = 0
	// The database version is MySQL 5.1.
	//
	// Deprecated: Do not use.
	SqlDatabaseVersion_MYSQL_5_1 SqlDatabaseVersion = 2
	// The database version is MySQL 5.5.
	//
	// Deprecated: Do not use.
	SqlDatabaseVersion_MYSQL_5_5 SqlDatabaseVersion = 3
	// The database version is MySQL 5.6.
	SqlDatabaseVersion_MYSQL_5_6 SqlDatabaseVersion = 5
	// The database version is MySQL 5.7.
	SqlDatabaseVersion_MYSQL_5_7 SqlDatabaseVersion = 6
	// The database version is PostgreSQL 9.6.
	SqlDatabaseVersion_POSTGRES_9_6 SqlDatabaseVersion = 9
	// The database version is PostgreSQL 11.
	SqlDatabaseVersion_POSTGRES_11 SqlDatabaseVersion = 10
	// The database version is SQL Server 2017 Standard.
	SqlDatabaseVersion_SQLSERVER_2017_STANDARD SqlDatabaseVersion = 11
	// The database version is SQL Server 2017 Enterprise.
	SqlDatabaseVersion_SQLSERVER_2017_ENTERPRISE SqlDatabaseVersion = 14
	// The database version is SQL Server 2017 Express.
	SqlDatabaseVersion_SQLSERVER_2017_EXPRESS SqlDatabaseVersion = 15
	// The database version is SQL Server 2017 Web.
	SqlDatabaseVersion_SQLSERVER_2017_WEB SqlDatabaseVersion = 16
	// The database version is PostgreSQL 10.
	SqlDatabaseVersion_POSTGRES_10 SqlDatabaseVersion = 18
	// The database version is PostgreSQL 12.
	SqlDatabaseVersion_POSTGRES_12 SqlDatabaseVersion = 19
	// The database version is MySQL 8.
	SqlDatabaseVersion_MYSQL_8_0 SqlDatabaseVersion = 20
	// The database major version is MySQL 8.0 and the minor version is 18.
	SqlDatabaseVersion_MYSQL_8_0_18 SqlDatabaseVersion = 41
	// The database major version is MySQL 8.0 and the minor version is 26.
	SqlDatabaseVersion_MYSQL_8_0_26 SqlDatabaseVersion = 85
	// The database major version is MySQL 8.0 and the minor version is 27.
	SqlDatabaseVersion_MYSQL_8_0_27 SqlDatabaseVersion = 111
	// The database major version is MySQL 8.0 and the minor version is 28.
	SqlDatabaseVersion_MYSQL_8_0_28 SqlDatabaseVersion = 132
	// The database version is PostgreSQL 13.
	SqlDatabaseVersion_POSTGRES_13 SqlDatabaseVersion = 23
	// The database version is PostgreSQL 14.
	SqlDatabaseVersion_POSTGRES_14 SqlDatabaseVersion = 110
	// The database version is SQL Server 2019 Standard.
	SqlDatabaseVersion_SQLSERVER_2019_STANDARD SqlDatabaseVersion = 26
	// The database version is SQL Server 2019 Enterprise.
	SqlDatabaseVersion_SQLSERVER_2019_ENTERPRISE SqlDatabaseVersion = 27
	// The database version is SQL Server 2019 Express.
	SqlDatabaseVersion_SQLSERVER_2019_EXPRESS SqlDatabaseVersion = 28
	// The database version is SQL Server 2019 Web.
	SqlDatabaseVersion_SQLSERVER_2019_WEB SqlDatabaseVersion = 29
)

// Enum value maps for SqlDatabaseVersion.
var (
	SqlDatabaseVersion_name = map[int32]string{
		0:   "SQL_DATABASE_VERSION_UNSPECIFIED",
		2:   "MYSQL_5_1",
		3:   "MYSQL_5_5",
		5:   "MYSQL_5_6",
		6:   "MYSQL_5_7",
		9:   "POSTGRES_9_6",
		10:  "POSTGRES_11",
		11:  "SQLSERVER_2017_STANDARD",
		14:  "SQLSERVER_2017_ENTERPRISE",
		15:  "SQLSERVER_2017_EXPRESS",
		16:  "SQLSERVER_2017_WEB",
		18:  "POSTGRES_10",
		19:  "POSTGRES_12",
		20:  "MYSQL_8_0",
		41:  "MYSQL_8_0_18",
		85:  "MYSQL_8_0_26",
		111: "MYSQL_8_0_27",
		132: "MYSQL_8_0_28",
		23:  "POSTGRES_13",
		110: "POSTGRES_14",
		26:  "SQLSERVER_2019_STANDARD",
		27:  "SQLSERVER_2019_ENTERPRISE",
		28:  "SQLSERVER_2019_EXPRESS",
		29:  "SQLSERVER_2019_WEB",
	}
	SqlDatabaseVersion_value = map[string]int32{
		"SQL_DATABASE_VERSION_UNSPECIFIED": 0,
		"MYSQL_5_1":                        2,
		"MYSQL_5_5":                        3,
		"MYSQL_5_6":                        5,
		"MYSQL_5_7":                        6,
		"POSTGRES_9_6":                     9,
		"POSTGRES_11":                      10,
		"SQLSERVER_2017_STANDARD":          11,
		"SQLSERVER_2017_ENTERPRISE":        14,
		"SQLSERVER_2017_EXPRESS":           15,
		"SQLSERVER_2017_WEB":               16,
		"POSTGRES_10":                      18,
		"POSTGRES_12":                      19,
		"MYSQL_8_0":                        20,
		"MYSQL_8_0_18":                     41,
		"MYSQL_8_0_26":                     85,
		"MYSQL_8_0_27":                     111,
		"MYSQL_8_0_28":                     132,
		"POSTGRES_13":                      23,
		"POSTGRES_14":                      110,
		"SQLSERVER_2019_STANDARD":          26,
		"SQLSERVER_2019_ENTERPRISE":        27,
		"SQLSERVER_2019_EXPRESS":           28,
		"SQLSERVER_2019_WEB":               29,
	}
)

func (x SqlDatabaseVersion) Enum() *SqlDatabaseVersion {
	p := new(SqlDatabaseVersion)
	*p = x
	return p
}

func (x SqlDatabaseVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlDatabaseVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[7].Descriptor()
}

func (SqlDatabaseVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[7]
}

func (x SqlDatabaseVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlDatabaseVersion.Descriptor instead.
func (SqlDatabaseVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{7}
}

// The suspension reason of the database instance if the state is SUSPENDED.
type SqlSuspensionReason int32

const (
	// This is an unknown suspension reason.
	SqlSuspensionReason_SQL_SUSPENSION_REASON_UNSPECIFIED SqlSuspensionReason = 0
	// The instance is suspended due to billing issues (for example:, GCP account
	// issue)
	SqlSuspensionReason_BILLING_ISSUE SqlSuspensionReason = 2
	// The instance is suspended due to illegal content (for example:, child
	// pornography, copyrighted material, etc.).
	SqlSuspensionReason_LEGAL_ISSUE SqlSuspensionReason = 3
	// The instance is causing operational issues (for example:, causing the
	// database to crash).
	SqlSuspensionReason_OPERATIONAL_ISSUE SqlSuspensionReason = 4
	// The KMS key used by the instance is either revoked or denied access to
	SqlSuspensionReason_KMS_KEY_ISSUE SqlSuspensionReason = 5
)

// Enum value maps for SqlSuspensionReason.
var (
	SqlSuspensionReason_name = map[int32]string{
		0: "SQL_SUSPENSION_REASON_UNSPECIFIED",
		2: "BILLING_ISSUE",
		3: "LEGAL_ISSUE",
		4: "OPERATIONAL_ISSUE",
		5: "KMS_KEY_ISSUE",
	}
	SqlSuspensionReason_value = map[string]int32{
		"SQL_SUSPENSION_REASON_UNSPECIFIED": 0,
		"BILLING_ISSUE":                     2,
		"LEGAL_ISSUE":                       3,
		"OPERATIONAL_ISSUE":                 4,
		"KMS_KEY_ISSUE":                     5,
	}
)

func (x SqlSuspensionReason) Enum() *SqlSuspensionReason {
	p := new(SqlSuspensionReason)
	*p = x
	return p
}

func (x SqlSuspensionReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlSuspensionReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[8].Descriptor()
}

func (SqlSuspensionReason) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[8]
}

func (x SqlSuspensionReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlSuspensionReason.Descriptor instead.
func (SqlSuspensionReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{8}
}

// The pricing plan for this instance.
type SqlPricingPlan int32

const (
	// This is an unknown pricing plan for this instance.
	SqlPricingPlan_SQL_PRICING_PLAN_UNSPECIFIED SqlPricingPlan = 0
	// The instance is billed at a monthly flat rate.
	SqlPricingPlan_PACKAGE SqlPricingPlan = 1
	// The instance is billed per usage.
	SqlPricingPlan_PER_USE SqlPricingPlan = 2
)

// Enum value maps for SqlPricingPlan.
var (
	SqlPricingPlan_name = map[int32]string{
		0: "SQL_PRICING_PLAN_UNSPECIFIED",
		1: "PACKAGE",
		2: "PER_USE",
	}
	SqlPricingPlan_value = map[string]int32{
		"SQL_PRICING_PLAN_UNSPECIFIED": 0,
		"PACKAGE":                      1,
		"PER_USE":                      2,
	}
)

func (x SqlPricingPlan) Enum() *SqlPricingPlan {
	p := new(SqlPricingPlan)
	*p = x
	return p
}

func (x SqlPricingPlan) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlPricingPlan) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[9].Descriptor()
}

func (SqlPricingPlan) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[9]
}

func (x SqlPricingPlan) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlPricingPlan.Descriptor instead.
func (SqlPricingPlan) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{9}
}

type SqlReplicationType int32

const (
	// This is an unknown replication type for a Cloud SQL instance.
	SqlReplicationType_SQL_REPLICATION_TYPE_UNSPECIFIED SqlReplicationType = 0
	// The synchronous replication mode for First Generation instances. It is the
	// default value.
	SqlReplicationType_SYNCHRONOUS SqlReplicationType = 1
	// The asynchronous replication mode for First Generation instances. It
	// provides a slight performance gain, but if an outage occurs while this
	// option is set to asynchronous, you can lose up to a few seconds of updates
	// to your data.
	SqlReplicationType_ASYNCHRONOUS SqlReplicationType = 2
)

// Enum value maps for SqlReplicationType.
var (
	SqlReplicationType_name = map[int32]string{
		0: "SQL_REPLICATION_TYPE_UNSPECIFIED",
		1: "SYNCHRONOUS",
		2: "ASYNCHRONOUS",
	}
	SqlReplicationType_value = map[string]int32{
		"SQL_REPLICATION_TYPE_UNSPECIFIED": 0,
		"SYNCHRONOUS":                      1,
		"ASYNCHRONOUS":                     2,
	}
)

func (x SqlReplicationType) Enum() *SqlReplicationType {
	p := new(SqlReplicationType)
	*p = x
	return p
}

func (x SqlReplicationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlReplicationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[10].Descriptor()
}

func (SqlReplicationType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[10]
}

func (x SqlReplicationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlReplicationType.Descriptor instead.
func (SqlReplicationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{10}
}

// The type of disk that is used for a v2 instance to use.
type SqlDataDiskType int32

const (
	// This is an unknown data disk type.
	SqlDataDiskType_SQL_DATA_DISK_TYPE_UNSPECIFIED SqlDataDiskType = 0
	// An SSD data disk.
	SqlDataDiskType_PD_SSD SqlDataDiskType = 1
	// An HDD data disk.
	SqlDataDiskType_PD_HDD SqlDataDiskType = 2
	// This field is deprecated and will be removed from a future version of the
	// API.
	//
	// Deprecated: Do not use.
	SqlDataDiskType_OBSOLETE_LOCAL_SSD SqlDataDiskType = 3
)

// Enum value maps for SqlDataDiskType.
var (
	SqlDataDiskType_name = map[int32]string{
		0: "SQL_DATA_DISK_TYPE_UNSPECIFIED",
		1: "PD_SSD",
		2: "PD_HDD",
		3: "OBSOLETE_LOCAL_SSD",
	}
	SqlDataDiskType_value = map[string]int32{
		"SQL_DATA_DISK_TYPE_UNSPECIFIED": 0,
		"PD_SSD":                         1,
		"PD_HDD":                         2,
		"OBSOLETE_LOCAL_SSD":             3,
	}
)

func (x SqlDataDiskType) Enum() *SqlDataDiskType {
	p := new(SqlDataDiskType)
	*p = x
	return p
}

func (x SqlDataDiskType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlDataDiskType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[11].Descriptor()
}

func (SqlDataDiskType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[11]
}

func (x SqlDataDiskType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlDataDiskType.Descriptor instead.
func (SqlDataDiskType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{11}
}

// The availability type of the given Cloud SQL instance.
type SqlAvailabilityType int32

const (
	// This is an unknown Availability type.
	SqlAvailabilityType_SQL_AVAILABILITY_TYPE_UNSPECIFIED SqlAvailabilityType = 0
	// Zonal available instance.
	SqlAvailabilityType_ZONAL SqlAvailabilityType = 1
	// Regional available instance.
	SqlAvailabilityType_REGIONAL SqlAvailabilityType = 2
)

// Enum value maps for SqlAvailabilityType.
var (
	SqlAvailabilityType_name = map[int32]string{
		0: "SQL_AVAILABILITY_TYPE_UNSPECIFIED",
		1: "ZONAL",
		2: "REGIONAL",
	}
	SqlAvailabilityType_value = map[string]int32{
		"SQL_AVAILABILITY_TYPE_UNSPECIFIED": 0,
		"ZONAL":                             1,
		"REGIONAL":                          2,
	}
)

func (x SqlAvailabilityType) Enum() *SqlAvailabilityType {
	p := new(SqlAvailabilityType)
	*p = x
	return p
}

func (x SqlAvailabilityType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlAvailabilityType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[12].Descriptor()
}

func (SqlAvailabilityType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[12]
}

func (x SqlAvailabilityType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlAvailabilityType.Descriptor instead.
func (SqlAvailabilityType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{12}
}

type SqlUpdateTrack int32

const (
	// This is an unknown maintenance timing preference.
	SqlUpdateTrack_SQL_UPDATE_TRACK_UNSPECIFIED SqlUpdateTrack = 0
	// For instance update that requires a restart, this update track indicates
	// your instance prefer to restart for new version early in maintenance
	// window.
	SqlUpdateTrack_canary SqlUpdateTrack = 1
	// For instance update that requires a restart, this update track indicates
	// your instance prefer to let Cloud SQL choose the timing of restart (within
	// its Maintenance window, if applicable).
	SqlUpdateTrack_stable SqlUpdateTrack = 2
)

// Enum value maps for SqlUpdateTrack.
var (
	SqlUpdateTrack_name = map[int32]string{
		0: "SQL_UPDATE_TRACK_UNSPECIFIED",
		1: "canary",
		2: "stable",
	}
	SqlUpdateTrack_value = map[string]int32{
		"SQL_UPDATE_TRACK_UNSPECIFIED": 0,
		"canary":                       1,
		"stable":                       2,
	}
)

func (x SqlUpdateTrack) Enum() *SqlUpdateTrack {
	p := new(SqlUpdateTrack)
	*p = x
	return p
}

func (x SqlUpdateTrack) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlUpdateTrack) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[13].Descriptor()
}

func (SqlUpdateTrack) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[13]
}

func (x SqlUpdateTrack) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlUpdateTrack.Descriptor instead.
func (SqlUpdateTrack) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{13}
}

type SqlFlagType int32

const (
	// This is an unknown flag type.
	SqlFlagType_SQL_FLAG_TYPE_UNSPECIFIED SqlFlagType = 0
	// Boolean type flag.
	SqlFlagType_BOOLEAN SqlFlagType = 1
	// String type flag.
	SqlFlagType_STRING SqlFlagType = 2
	// Integer type flag.
	SqlFlagType_INTEGER SqlFlagType = 3
	// Flag type used for a server startup option.
	SqlFlagType_NONE SqlFlagType = 4
	// Type introduced specially for MySQL TimeZone offset. Accept a string value
	// with the format [-12:59, 13:00].
	SqlFlagType_MYSQL_TIMEZONE_OFFSET SqlFlagType = 5
	// Float type flag.
	SqlFlagType_FLOAT SqlFlagType = 6
	// Comma-separated list of the strings in a SqlFlagType enum.
	SqlFlagType_REPEATED_STRING SqlFlagType = 7
)

// Enum value maps for SqlFlagType.
var (
	SqlFlagType_name = map[int32]string{
		0: "SQL_FLAG_TYPE_UNSPECIFIED",
		1: "BOOLEAN",
		2: "STRING",
		3: "INTEGER",
		4: "NONE",
		5: "MYSQL_TIMEZONE_OFFSET",
		6: "FLOAT",
		7: "REPEATED_STRING",
	}
	SqlFlagType_value = map[string]int32{
		"SQL_FLAG_TYPE_UNSPECIFIED": 0,
		"BOOLEAN":                   1,
		"STRING":                    2,
		"INTEGER":                   3,
		"NONE":                      4,
		"MYSQL_TIMEZONE_OFFSET":     5,
		"FLOAT":                     6,
		"REPEATED_STRING":           7,
	}
)

func (x SqlFlagType) Enum() *SqlFlagType {
	p := new(SqlFlagType)
	*p = x
	return p
}

func (x SqlFlagType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlFlagType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[14].Descriptor()
}

func (SqlFlagType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[14]
}

func (x SqlFlagType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlFlagType.Descriptor instead.
func (SqlFlagType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{14}
}

type ApiWarning_SqlApiWarningCode int32

const (
	// An unknown or unset warning type from Cloud SQL API.
	ApiWarning_SQL_API_WARNING_CODE_UNSPECIFIED ApiWarning_SqlApiWarningCode = 0
	// Warning when one or more regions are not reachable.  The returned result
	// set may be incomplete.
	ApiWarning_REGION_UNREACHABLE ApiWarning_SqlApiWarningCode = 1
)

// Enum value maps for ApiWarning_SqlApiWarningCode.
var (
	ApiWarning_SqlApiWarningCode_name = map[int32]string{
		0: "SQL_API_WARNING_CODE_UNSPECIFIED",
		1: "REGION_UNREACHABLE",
	}
	ApiWarning_SqlApiWarningCode_value = map[string]int32{
		"SQL_API_WARNING_CODE_UNSPECIFIED": 0,
		"REGION_UNREACHABLE":               1,
	}
)

func (x ApiWarning_SqlApiWarningCode) Enum() *ApiWarning_SqlApiWarningCode {
	p := new(ApiWarning_SqlApiWarningCode)
	*p = x
	return p
}

func (x ApiWarning_SqlApiWarningCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ApiWarning_SqlApiWarningCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[15].Descriptor()
}

func (ApiWarning_SqlApiWarningCode) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[15]
}

func (x ApiWarning_SqlApiWarningCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ApiWarning_SqlApiWarningCode.Descriptor instead.
func (ApiWarning_SqlApiWarningCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{1, 0}
}

// The units that retained_backups specifies, we only support COUNT.
type BackupRetentionSettings_RetentionUnit int32

const (
	// Backup retention unit is unspecified, will be treated as COUNT.
	BackupRetentionSettings_RETENTION_UNIT_UNSPECIFIED BackupRetentionSettings_RetentionUnit = 0
	// Retention will be by count, eg. "retain the most recent 7 backups".
	BackupRetentionSettings_COUNT BackupRetentionSettings_RetentionUnit = 1
)

// Enum value maps for BackupRetentionSettings_RetentionUnit.
var (
	BackupRetentionSettings_RetentionUnit_name = map[int32]string{
		0: "RETENTION_UNIT_UNSPECIFIED",
		1: "COUNT",
	}
	BackupRetentionSettings_RetentionUnit_value = map[string]int32{
		"RETENTION_UNIT_UNSPECIFIED": 0,
		"COUNT":                      1,
	}
)

func (x BackupRetentionSettings_RetentionUnit) Enum() *BackupRetentionSettings_RetentionUnit {
	p := new(BackupRetentionSettings_RetentionUnit)
	*p = x
	return p
}

func (x BackupRetentionSettings_RetentionUnit) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackupRetentionSettings_RetentionUnit) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[16].Descriptor()
}

func (BackupRetentionSettings_RetentionUnit) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[16]
}

func (x BackupRetentionSettings_RetentionUnit) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackupRetentionSettings_RetentionUnit.Descriptor instead.
func (BackupRetentionSettings_RetentionUnit) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{2, 0}
}

// The current serving state of the database instance.
type DatabaseInstance_SqlInstanceState int32

const (
	// The state of the instance is unknown.
	DatabaseInstance_SQL_INSTANCE_STATE_UNSPECIFIED DatabaseInstance_SqlInstanceState = 0
	// The instance is running, or has been stopped by owner.
	DatabaseInstance_RUNNABLE DatabaseInstance_SqlInstanceState = 1
	// The instance is not available, for example due to problems with billing.
	DatabaseInstance_SUSPENDED DatabaseInstance_SqlInstanceState = 2
	// The instance is being deleted.
	DatabaseInstance_PENDING_DELETE DatabaseInstance_SqlInstanceState = 3
	// The instance is being created.
	DatabaseInstance_PENDING_CREATE DatabaseInstance_SqlInstanceState = 4
	// The instance is down for maintenance.
	DatabaseInstance_MAINTENANCE DatabaseInstance_SqlInstanceState = 5
	// The creation of the instance failed or a fatal error occurred during
	// maintenance.
	DatabaseInstance_FAILED DatabaseInstance_SqlInstanceState = 6
	// Deprecated
	//
	// Deprecated: Do not use.
	DatabaseInstance_ONLINE_MAINTENANCE DatabaseInstance_SqlInstanceState = 7
)

// Enum value maps for DatabaseInstance_SqlInstanceState.
var (
	DatabaseInstance_SqlInstanceState_name = map[int32]string{
		0: "SQL_INSTANCE_STATE_UNSPECIFIED",
		1: "RUNNABLE",
		2: "SUSPENDED",
		3: "PENDING_DELETE",
		4: "PENDING_CREATE",
		5: "MAINTENANCE",
		6: "FAILED",
		7: "ONLINE_MAINTENANCE",
	}
	DatabaseInstance_SqlInstanceState_value = map[string]int32{
		"SQL_INSTANCE_STATE_UNSPECIFIED": 0,
		"RUNNABLE":                       1,
		"SUSPENDED":                      2,
		"PENDING_DELETE":                 3,
		"PENDING_CREATE":                 4,
		"MAINTENANCE":                    5,
		"FAILED":                         6,
		"ONLINE_MAINTENANCE":             7,
	}
)

func (x DatabaseInstance_SqlInstanceState) Enum() *DatabaseInstance_SqlInstanceState {
	p := new(DatabaseInstance_SqlInstanceState)
	*p = x
	return p
}

func (x DatabaseInstance_SqlInstanceState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseInstance_SqlInstanceState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[17].Descriptor()
}

func (DatabaseInstance_SqlInstanceState) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[17]
}

func (x DatabaseInstance_SqlInstanceState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseInstance_SqlInstanceState.Descriptor instead.
func (DatabaseInstance_SqlInstanceState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{14, 0}
}

// This enum lists all possible states regarding out-of-disk issues.
type DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState int32

const (
	// Unspecified state
	DatabaseInstance_SqlOutOfDiskReport_SQL_OUT_OF_DISK_STATE_UNSPECIFIED DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState = 0
	// The instance has plenty space on data disk
	DatabaseInstance_SqlOutOfDiskReport_NORMAL DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState = 1
	// Data disk is almost used up. It is shutdown to prevent data
	// corruption.
	DatabaseInstance_SqlOutOfDiskReport_SOFT_SHUTDOWN DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState = 2
)

// Enum value maps for DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState.
var (
	DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState_name = map[int32]string{
		0: "SQL_OUT_OF_DISK_STATE_UNSPECIFIED",
		1: "NORMAL",
		2: "SOFT_SHUTDOWN",
	}
	DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState_value = map[string]int32{
		"SQL_OUT_OF_DISK_STATE_UNSPECIFIED": 0,
		"NORMAL":                            1,
		"SOFT_SHUTDOWN":                     2,
	}
)

func (x DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState) Enum() *DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState {
	p := new(DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState)
	*p = x
	return p
}

func (x DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[18].Descriptor()
}

func (DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[18]
}

func (x DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState.Descriptor instead.
func (DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{14, 2, 0}
}

type SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType int32

const (
	SqlExternalSyncSettingError_SQL_EXTERNAL_SYNC_SETTING_ERROR_TYPE_UNSPECIFIED SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 0
	SqlExternalSyncSettingError_CONNECTION_FAILURE                               SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 1
	SqlExternalSyncSettingError_BINLOG_NOT_ENABLED                               SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 2
	SqlExternalSyncSettingError_INCOMPATIBLE_DATABASE_VERSION                    SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 3
	SqlExternalSyncSettingError_REPLICA_ALREADY_SETUP                            SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 4
	SqlExternalSyncSettingError_INSUFFICIENT_PRIVILEGE                           SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 5
	// Unsupported migration type.
	SqlExternalSyncSettingError_UNSUPPORTED_MIGRATION_TYPE SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 6
	// No pglogical extension installed on databases, applicable for postgres.
	SqlExternalSyncSettingError_NO_PGLOGICAL_INSTALLED SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 7
	// pglogical node already exists on databases, applicable for postgres.
	SqlExternalSyncSettingError_PGLOGICAL_NODE_ALREADY_EXISTS SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 8
	// The value of parameter wal_level is not set to logical.
	SqlExternalSyncSettingError_INVALID_WAL_LEVEL SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 9
	// The value of parameter shared_preload_libraries does not include
	// pglogical.
	SqlExternalSyncSettingError_INVALID_SHARED_PRELOAD_LIBRARY SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 10
	// The value of parameter max_replication_slots is not sufficient.
	SqlExternalSyncSettingError_INSUFFICIENT_MAX_REPLICATION_SLOTS SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 11
	// The value of parameter max_wal_senders is not sufficient.
	SqlExternalSyncSettingError_INSUFFICIENT_MAX_WAL_SENDERS SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 12
	// The value of parameter max_worker_processes is not sufficient.
	SqlExternalSyncSettingError_INSUFFICIENT_MAX_WORKER_PROCESSES SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 13
	// Extensions installed are either not supported or having unsupported
	// versions
	SqlExternalSyncSettingError_UNSUPPORTED_EXTENSIONS SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 14
	// The value of parameter rds.logical_replication is not set to 1.
	SqlExternalSyncSettingError_INVALID_RDS_LOGICAL_REPLICATION SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 15
	// The primary instance logging setup doesn't allow EM sync.
	SqlExternalSyncSettingError_INVALID_LOGGING_SETUP SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 16
	// The primary instance database parameter setup doesn't allow EM sync.
	SqlExternalSyncSettingError_INVALID_DB_PARAM SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 17
	// The gtid_mode is not supported, applicable for MySQL.
	SqlExternalSyncSettingError_UNSUPPORTED_GTID_MODE SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 18
	// SQL Server Agent is not running.
	SqlExternalSyncSettingError_SQLSERVER_AGENT_NOT_RUNNING SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 19
	// The table definition is not support due to missing primary key or replica
	// identity, applicable for postgres.
	SqlExternalSyncSettingError_UNSUPPORTED_TABLE_DEFINITION SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 20
	// The customer has a definer that will break EM setup.
	SqlExternalSyncSettingError_UNSUPPORTED_DEFINER SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 21
	// SQL Server @@SERVERNAME does not match actual host name
	SqlExternalSyncSettingError_SQLSERVER_SERVERNAME_MISMATCH SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 22
	// The primary instance has been setup and will fail the setup.
	SqlExternalSyncSettingError_PRIMARY_ALREADY_SETUP SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 23
	// The primary instance has unsupported binary log format.
	SqlExternalSyncSettingError_UNSUPPORTED_BINLOG_FORMAT SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 24
	// The primary instance's binary log retention setting.
	SqlExternalSyncSettingError_BINLOG_RETENTION_SETTING SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 25
	// The primary instance has tables with unsupported storage engine.
	SqlExternalSyncSettingError_UNSUPPORTED_STORAGE_ENGINE SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType = 26
)

// Enum value maps for SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType.
var (
	SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType_name = map[int32]string{
		0:  "SQL_EXTERNAL_SYNC_SETTING_ERROR_TYPE_UNSPECIFIED",
		1:  "CONNECTION_FAILURE",
		2:  "BINLOG_NOT_ENABLED",
		3:  "INCOMPATIBLE_DATABASE_VERSION",
		4:  "REPLICA_ALREADY_SETUP",
		5:  "INSUFFICIENT_PRIVILEGE",
		6:  "UNSUPPORTED_MIGRATION_TYPE",
		7:  "NO_PGLOGICAL_INSTALLED",
		8:  "PGLOGICAL_NODE_ALREADY_EXISTS",
		9:  "INVALID_WAL_LEVEL",
		10: "INVALID_SHARED_PRELOAD_LIBRARY",
		11: "INSUFFICIENT_MAX_REPLICATION_SLOTS",
		12: "INSUFFICIENT_MAX_WAL_SENDERS",
		13: "INSUFFICIENT_MAX_WORKER_PROCESSES",
		14: "UNSUPPORTED_EXTENSIONS",
		15: "INVALID_RDS_LOGICAL_REPLICATION",
		16: "INVALID_LOGGING_SETUP",
		17: "INVALID_DB_PARAM",
		18: "UNSUPPORTED_GTID_MODE",
		19: "SQLSERVER_AGENT_NOT_RUNNING",
		20: "UNSUPPORTED_TABLE_DEFINITION",
		21: "UNSUPPORTED_DEFINER",
		22: "SQLSERVER_SERVERNAME_MISMATCH",
		23: "PRIMARY_ALREADY_SETUP",
		24: "UNSUPPORTED_BINLOG_FORMAT",
		25: "BINLOG_RETENTION_SETTING",
		26: "UNSUPPORTED_STORAGE_ENGINE",
	}
	SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType_value = map[string]int32{
		"SQL_EXTERNAL_SYNC_SETTING_ERROR_TYPE_UNSPECIFIED": 0,
		"CONNECTION_FAILURE":                               1,
		"BINLOG_NOT_ENABLED":                               2,
		"INCOMPATIBLE_DATABASE_VERSION":                    3,
		"REPLICA_ALREADY_SETUP":                            4,
		"INSUFFICIENT_PRIVILEGE":                           5,
		"UNSUPPORTED_MIGRATION_TYPE":                       6,
		"NO_PGLOGICAL_INSTALLED":                           7,
		"PGLOGICAL_NODE_ALREADY_EXISTS":                    8,
		"INVALID_WAL_LEVEL":                                9,
		"INVALID_SHARED_PRELOAD_LIBRARY":                   10,
		"INSUFFICIENT_MAX_REPLICATION_SLOTS":               11,
		"INSUFFICIENT_MAX_WAL_SENDERS":                     12,
		"INSUFFICIENT_MAX_WORKER_PROCESSES":                13,
		"UNSUPPORTED_EXTENSIONS":                           14,
		"INVALID_RDS_LOGICAL_REPLICATION":                  15,
		"INVALID_LOGGING_SETUP":                            16,
		"INVALID_DB_PARAM":                                 17,
		"UNSUPPORTED_GTID_MODE":                            18,
		"SQLSERVER_AGENT_NOT_RUNNING":                      19,
		"UNSUPPORTED_TABLE_DEFINITION":                     20,
		"UNSUPPORTED_DEFINER":                              21,
		"SQLSERVER_SERVERNAME_MISMATCH":                    22,
		"PRIMARY_ALREADY_SETUP":                            23,
		"UNSUPPORTED_BINLOG_FORMAT":                        24,
		"BINLOG_RETENTION_SETTING":                         25,
		"UNSUPPORTED_STORAGE_ENGINE":                       26,
	}
)

func (x SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType) Enum() *SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType {
	p := new(SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType)
	*p = x
	return p
}

func (x SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[19].Descriptor()
}

func (SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[19]
}

func (x SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType.Descriptor instead.
func (SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{36, 0}
}

// The type of Cloud SQL operation.
type Operation_SqlOperationType int32

const (
	// Unknown operation type.
	Operation_SQL_OPERATION_TYPE_UNSPECIFIED Operation_SqlOperationType = 0
	// Imports data into a Cloud SQL instance.
	Operation_IMPORT Operation_SqlOperationType = 1
	// Exports data from a Cloud SQL instance to a Cloud Storage
	// bucket.
	Operation_EXPORT Operation_SqlOperationType = 2
	// Creates a new Cloud SQL instance.
	Operation_CREATE Operation_SqlOperationType = 3
	// Updates the settings of a Cloud SQL instance.
	Operation_UPDATE Operation_SqlOperationType = 4
	// Deletes a Cloud SQL instance.
	Operation_DELETE Operation_SqlOperationType = 5
	// Restarts the Cloud SQL instance.
	Operation_RESTART Operation_SqlOperationType = 6
	// Deprecated: Do not use.
	Operation_BACKUP Operation_SqlOperationType = 7
	// Deprecated: Do not use.
	Operation_SNAPSHOT Operation_SqlOperationType = 8
	// Performs instance backup.
	Operation_BACKUP_VOLUME Operation_SqlOperationType = 9
	// Deletes an instance backup.
	Operation_DELETE_VOLUME Operation_SqlOperationType = 10
	// Restores an instance backup.
	Operation_RESTORE_VOLUME Operation_SqlOperationType = 11
	// Injects a privileged user in mysql for MOB instances.
	Operation_INJECT_USER Operation_SqlOperationType = 12
	// Clones a Cloud SQL instance.
	Operation_CLONE Operation_SqlOperationType = 14
	// Stops replication on a Cloud SQL read replica instance.
	Operation_STOP_REPLICA Operation_SqlOperationType = 15
	// Starts replication on a Cloud SQL read replica instance.
	Operation_START_REPLICA Operation_SqlOperationType = 16
	// Promotes a Cloud SQL replica instance.
	Operation_PROMOTE_REPLICA Operation_SqlOperationType = 17
	// Creates a Cloud SQL replica instance.
	Operation_CREATE_REPLICA Operation_SqlOperationType = 18
	// Creates a new user in a Cloud SQL instance.
	Operation_CREATE_USER Operation_SqlOperationType = 19
	// Deletes a user from a Cloud SQL instance.
	Operation_DELETE_USER Operation_SqlOperationType = 20
	// Updates an existing user in a Cloud SQL instance.
	Operation_UPDATE_USER Operation_SqlOperationType = 21
	// Creates a database in the Cloud SQL instance.
	Operation_CREATE_DATABASE Operation_SqlOperationType = 22
	// Deletes a database in the Cloud SQL instance.
	Operation_DELETE_DATABASE Operation_SqlOperationType = 23
	// Updates a database in the Cloud SQL instance.
	Operation_UPDATE_DATABASE Operation_SqlOperationType = 24
	// Performs failover of an HA-enabled Cloud SQL
	// failover replica.
	Operation_FAILOVER Operation_SqlOperationType = 25
	// Deletes the backup taken by a backup run.
	Operation_DELETE_BACKUP    Operation_SqlOperationType = 26
	Operation_RECREATE_REPLICA Operation_SqlOperationType = 27
	// Truncates a general or slow log table in MySQL.
	Operation_TRUNCATE_LOG Operation_SqlOperationType = 28
	// Demotes the stand-alone instance to be a Cloud SQL
	// read replica for an external database server.
	Operation_DEMOTE_MASTER Operation_SqlOperationType = 29
	// Indicates that the instance is currently in maintenance. Maintenance
	// typically causes the instance to be unavailable for 1-3 minutes.
	Operation_MAINTENANCE Operation_SqlOperationType = 30
	// This field is deprecated, and will be removed in future version of API.
	//
	// Deprecated: Do not use.
	Operation_ENABLE_PRIVATE_IP Operation_SqlOperationType = 31
	// Deprecated: Do not use.
	Operation_DEFER_MAINTENANCE Operation_SqlOperationType = 32
	// Creates clone instance.
	//
	// Deprecated: Do not use.
	Operation_CREATE_CLONE Operation_SqlOperationType = 33
	// Reschedule maintenance to another time.
	Operation_RESCHEDULE_MAINTENANCE Operation_SqlOperationType = 34
	// Starts external sync of a Cloud SQL EM replica to an external primary
	// instance.
	Operation_START_EXTERNAL_SYNC Operation_SqlOperationType = 35
)

// Enum value maps for Operation_SqlOperationType.
var (
	Operation_SqlOperationType_name = map[int32]string{
		0:  "SQL_OPERATION_TYPE_UNSPECIFIED",
		1:  "IMPORT",
		2:  "EXPORT",
		3:  "CREATE",
		4:  "UPDATE",
		5:  "DELETE",
		6:  "RESTART",
		7:  "BACKUP",
		8:  "SNAPSHOT",
		9:  "BACKUP_VOLUME",
		10: "DELETE_VOLUME",
		11: "RESTORE_VOLUME",
		12: "INJECT_USER",
		14: "CLONE",
		15: "STOP_REPLICA",
		16: "START_REPLICA",
		17: "PROMOTE_REPLICA",
		18: "CREATE_REPLICA",
		19: "CREATE_USER",
		20: "DELETE_USER",
		21: "UPDATE_USER",
		22: "CREATE_DATABASE",
		23: "DELETE_DATABASE",
		24: "UPDATE_DATABASE",
		25: "FAILOVER",
		26: "DELETE_BACKUP",
		27: "RECREATE_REPLICA",
		28: "TRUNCATE_LOG",
		29: "DEMOTE_MASTER",
		30: "MAINTENANCE",
		31: "ENABLE_PRIVATE_IP",
		32: "DEFER_MAINTENANCE",
		33: "CREATE_CLONE",
		34: "RESCHEDULE_MAINTENANCE",
		35: "START_EXTERNAL_SYNC",
	}
	Operation_SqlOperationType_value = map[string]int32{
		"SQL_OPERATION_TYPE_UNSPECIFIED": 0,
		"IMPORT":                         1,
		"EXPORT":                         2,
		"CREATE":                         3,
		"UPDATE":                         4,
		"DELETE":                         5,
		"RESTART":                        6,
		"BACKUP":                         7,
		"SNAPSHOT":                       8,
		"BACKUP_VOLUME":                  9,
		"DELETE_VOLUME":                  10,
		"RESTORE_VOLUME":                 11,
		"INJECT_USER":                    12,
		"CLONE":                          14,
		"STOP_REPLICA":                   15,
		"START_REPLICA":                  16,
		"PROMOTE_REPLICA":                17,
		"CREATE_REPLICA":                 18,
		"CREATE_USER":                    19,
		"DELETE_USER":                    20,
		"UPDATE_USER":                    21,
		"CREATE_DATABASE":                22,
		"DELETE_DATABASE":                23,
		"UPDATE_DATABASE":                24,
		"FAILOVER":                       25,
		"DELETE_BACKUP":                  26,
		"RECREATE_REPLICA":               27,
		"TRUNCATE_LOG":                   28,
		"DEMOTE_MASTER":                  29,
		"MAINTENANCE":                    30,
		"ENABLE_PRIVATE_IP":              31,
		"DEFER_MAINTENANCE":              32,
		"CREATE_CLONE":                   33,
		"RESCHEDULE_MAINTENANCE":         34,
		"START_EXTERNAL_SYNC":            35,
	}
)

func (x Operation_SqlOperationType) Enum() *Operation_SqlOperationType {
	p := new(Operation_SqlOperationType)
	*p = x
	return p
}

func (x Operation_SqlOperationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Operation_SqlOperationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[20].Descriptor()
}

func (Operation_SqlOperationType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[20]
}

func (x Operation_SqlOperationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Operation_SqlOperationType.Descriptor instead.
func (Operation_SqlOperationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{47, 0}
}

// The status of an operation.
type Operation_SqlOperationStatus int32

const (
	// The state of the operation is unknown.
	Operation_SQL_OPERATION_STATUS_UNSPECIFIED Operation_SqlOperationStatus = 0
	// The operation has been queued, but has not started yet.
	Operation_PENDING Operation_SqlOperationStatus = 1
	// The operation is running.
	Operation_RUNNING Operation_SqlOperationStatus = 2
	// The operation completed.
	Operation_DONE Operation_SqlOperationStatus = 3
)

// Enum value maps for Operation_SqlOperationStatus.
var (
	Operation_SqlOperationStatus_name = map[int32]string{
		0: "SQL_OPERATION_STATUS_UNSPECIFIED",
		1: "PENDING",
		2: "RUNNING",
		3: "DONE",
	}
	Operation_SqlOperationStatus_value = map[string]int32{
		"SQL_OPERATION_STATUS_UNSPECIFIED": 0,
		"PENDING":                          1,
		"RUNNING":                          2,
		"DONE":                             3,
	}
)

func (x Operation_SqlOperationStatus) Enum() *Operation_SqlOperationStatus {
	p := new(Operation_SqlOperationStatus)
	*p = x
	return p
}

func (x Operation_SqlOperationStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Operation_SqlOperationStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[21].Descriptor()
}

func (Operation_SqlOperationStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[21]
}

func (x Operation_SqlOperationStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Operation_SqlOperationStatus.Descriptor instead.
func (Operation_SqlOperationStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{47, 1}
}

// The complexity choices of the password.
type PasswordValidationPolicy_Complexity int32

const (
	// Complexity check is not specified.
	PasswordValidationPolicy_COMPLEXITY_UNSPECIFIED PasswordValidationPolicy_Complexity = 0
	// A combination of lowercase, uppercase, numeric, and non-alphanumeric
	// characters.
	PasswordValidationPolicy_COMPLEXITY_DEFAULT PasswordValidationPolicy_Complexity = 1
)

// Enum value maps for PasswordValidationPolicy_Complexity.
var (
	PasswordValidationPolicy_Complexity_name = map[int32]string{
		0: "COMPLEXITY_UNSPECIFIED",
		1: "COMPLEXITY_DEFAULT",
	}
	PasswordValidationPolicy_Complexity_value = map[string]int32{
		"COMPLEXITY_UNSPECIFIED": 0,
		"COMPLEXITY_DEFAULT":     1,
	}
)

func (x PasswordValidationPolicy_Complexity) Enum() *PasswordValidationPolicy_Complexity {
	p := new(PasswordValidationPolicy_Complexity)
	*p = x
	return p
}

func (x PasswordValidationPolicy_Complexity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PasswordValidationPolicy_Complexity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[22].Descriptor()
}

func (PasswordValidationPolicy_Complexity) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[22]
}

func (x PasswordValidationPolicy_Complexity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PasswordValidationPolicy_Complexity.Descriptor instead.
func (PasswordValidationPolicy_Complexity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{50, 0}
}

// Specifies when the instance is activated.
type Settings_SqlActivationPolicy int32

const (
	// Unknown activation plan.
	Settings_SQL_ACTIVATION_POLICY_UNSPECIFIED Settings_SqlActivationPolicy = 0
	// The instance is always up and running.
	Settings_ALWAYS Settings_SqlActivationPolicy = 1
	// The instance never starts.
	Settings_NEVER Settings_SqlActivationPolicy = 2
	// The instance starts upon receiving requests.
	//
	// Deprecated: Do not use.
	Settings_ON_DEMAND Settings_SqlActivationPolicy = 3
)

// Enum value maps for Settings_SqlActivationPolicy.
var (
	Settings_SqlActivationPolicy_name = map[int32]string{
		0: "SQL_ACTIVATION_POLICY_UNSPECIFIED",
		1: "ALWAYS",
		2: "NEVER",
		3: "ON_DEMAND",
	}
	Settings_SqlActivationPolicy_value = map[string]int32{
		"SQL_ACTIVATION_POLICY_UNSPECIFIED": 0,
		"ALWAYS":                            1,
		"NEVER":                             2,
		"ON_DEMAND":                         3,
	}
)

func (x Settings_SqlActivationPolicy) Enum() *Settings_SqlActivationPolicy {
	p := new(Settings_SqlActivationPolicy)
	*p = x
	return p
}

func (x Settings_SqlActivationPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Settings_SqlActivationPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[23].Descriptor()
}

func (Settings_SqlActivationPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[23]
}

func (x Settings_SqlActivationPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Settings_SqlActivationPolicy.Descriptor instead.
func (Settings_SqlActivationPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{55, 0}
}

type SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType int32

const (
	SqlInstancesRescheduleMaintenanceRequestBody_RESCHEDULE_TYPE_UNSPECIFIED SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType = 0
	// Reschedules maintenance to happen now (within 5 minutes).
	SqlInstancesRescheduleMaintenanceRequestBody_IMMEDIATE SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType = 1
	// Reschedules maintenance to occur within one week from the originally
	// scheduled day and time.
	SqlInstancesRescheduleMaintenanceRequestBody_NEXT_AVAILABLE_WINDOW SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType = 2
	// Reschedules maintenance to a specific time and day.
	SqlInstancesRescheduleMaintenanceRequestBody_SPECIFIC_TIME SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType = 3
)

// Enum value maps for SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType.
var (
	SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType_name = map[int32]string{
		0: "RESCHEDULE_TYPE_UNSPECIFIED",
		1: "IMMEDIATE",
		2: "NEXT_AVAILABLE_WINDOW",
		3: "SPECIFIC_TIME",
	}
	SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType_value = map[string]int32{
		"RESCHEDULE_TYPE_UNSPECIFIED": 0,
		"IMMEDIATE":                   1,
		"NEXT_AVAILABLE_WINDOW":       2,
		"SPECIFIC_TIME":               3,
	}
)

func (x SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType) Enum() *SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType {
	p := new(SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType)
	*p = x
	return p
}

func (x SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[24].Descriptor()
}

func (SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType) Type() protoreflect.EnumType {
	return &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes[24]
}

func (x SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType.Descriptor instead.
func (SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{60, 0}
}

// An entry for an Access Control list.
type AclEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The allowlisted value for the access control list.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// The time when this access control entry expires in
	// [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	ExpirationTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
	// Optional. A label to identify this entry.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// This is always `sql#aclEntry`.
	Kind string `protobuf:"bytes,4,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *AclEntry) Reset() {
	*x = AclEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AclEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AclEntry) ProtoMessage() {}

func (x *AclEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AclEntry.ProtoReflect.Descriptor instead.
func (*AclEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{0}
}

func (x *AclEntry) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *AclEntry) GetExpirationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpirationTime
	}
	return nil
}

func (x *AclEntry) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AclEntry) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// An Admin API warning message.
type ApiWarning struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Code to uniquely identify the warning type.
	Code ApiWarning_SqlApiWarningCode `protobuf:"varint,1,opt,name=code,proto3,enum=google.cloud.sql.v1beta4.ApiWarning_SqlApiWarningCode" json:"code,omitempty"`
	// The warning message.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// The region name for REGION_UNREACHABLE warning.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
}

func (x *ApiWarning) Reset() {
	*x = ApiWarning{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApiWarning) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApiWarning) ProtoMessage() {}

func (x *ApiWarning) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApiWarning.ProtoReflect.Descriptor instead.
func (*ApiWarning) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{1}
}

func (x *ApiWarning) GetCode() ApiWarning_SqlApiWarningCode {
	if x != nil {
		return x.Code
	}
	return ApiWarning_SQL_API_WARNING_CODE_UNSPECIFIED
}

func (x *ApiWarning) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *ApiWarning) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

// We currently only support backup retention by specifying the number
// of backups we will retain.
type BackupRetentionSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unit that 'retained_backups' represents.
	RetentionUnit BackupRetentionSettings_RetentionUnit `protobuf:"varint,1,opt,name=retention_unit,json=retentionUnit,proto3,enum=google.cloud.sql.v1beta4.BackupRetentionSettings_RetentionUnit" json:"retention_unit,omitempty"`
	// Depending on the value of retention_unit, this is used to determine
	// if a backup needs to be deleted.  If retention_unit is 'COUNT', we will
	// retain this many backups.
	RetainedBackups *wrapperspb.Int32Value `protobuf:"bytes,2,opt,name=retained_backups,json=retainedBackups,proto3" json:"retained_backups,omitempty"`
}

func (x *BackupRetentionSettings) Reset() {
	*x = BackupRetentionSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackupRetentionSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupRetentionSettings) ProtoMessage() {}

func (x *BackupRetentionSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupRetentionSettings.ProtoReflect.Descriptor instead.
func (*BackupRetentionSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{2}
}

func (x *BackupRetentionSettings) GetRetentionUnit() BackupRetentionSettings_RetentionUnit {
	if x != nil {
		return x.RetentionUnit
	}
	return BackupRetentionSettings_RETENTION_UNIT_UNSPECIFIED
}

func (x *BackupRetentionSettings) GetRetainedBackups() *wrapperspb.Int32Value {
	if x != nil {
		return x.RetainedBackups
	}
	return nil
}

// Database instance backup configuration.
type BackupConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start time for the daily backup configuration in UTC timezone in the 24
	// hour format - `HH:MM`.
	StartTime string `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Whether this configuration is enabled.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// This is always `sql#backupConfiguration`.
	Kind string `protobuf:"bytes,3,opt,name=kind,proto3" json:"kind,omitempty"`
	// (MySQL only) Whether binary log is enabled. If backup configuration is
	// disabled, binarylog must be disabled as well.
	BinaryLogEnabled *wrapperspb.BoolValue `protobuf:"bytes,4,opt,name=binary_log_enabled,json=binaryLogEnabled,proto3" json:"binary_log_enabled,omitempty"`
	// Reserved for future use.
	ReplicationLogArchivingEnabled *wrapperspb.BoolValue `protobuf:"bytes,5,opt,name=replication_log_archiving_enabled,json=replicationLogArchivingEnabled,proto3" json:"replication_log_archiving_enabled,omitempty"`
	// Location of the backup
	Location string `protobuf:"bytes,6,opt,name=location,proto3" json:"location,omitempty"`
	// (Postgres only) Whether point in time recovery is enabled.
	PointInTimeRecoveryEnabled *wrapperspb.BoolValue `protobuf:"bytes,7,opt,name=point_in_time_recovery_enabled,json=pointInTimeRecoveryEnabled,proto3" json:"point_in_time_recovery_enabled,omitempty"`
	// The number of days of transaction logs we retain for point in time
	// restore, from 1-7.
	TransactionLogRetentionDays *wrapperspb.Int32Value `protobuf:"bytes,9,opt,name=transaction_log_retention_days,json=transactionLogRetentionDays,proto3" json:"transaction_log_retention_days,omitempty"`
	// Backup retention settings.
	BackupRetentionSettings *BackupRetentionSettings `protobuf:"bytes,10,opt,name=backup_retention_settings,json=backupRetentionSettings,proto3" json:"backup_retention_settings,omitempty"`
}

func (x *BackupConfiguration) Reset() {
	*x = BackupConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackupConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupConfiguration) ProtoMessage() {}

func (x *BackupConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupConfiguration.ProtoReflect.Descriptor instead.
func (*BackupConfiguration) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{3}
}

func (x *BackupConfiguration) GetStartTime() string {
	if x != nil {
		return x.StartTime
	}
	return ""
}

func (x *BackupConfiguration) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *BackupConfiguration) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *BackupConfiguration) GetBinaryLogEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.BinaryLogEnabled
	}
	return nil
}

func (x *BackupConfiguration) GetReplicationLogArchivingEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.ReplicationLogArchivingEnabled
	}
	return nil
}

func (x *BackupConfiguration) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *BackupConfiguration) GetPointInTimeRecoveryEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.PointInTimeRecoveryEnabled
	}
	return nil
}

func (x *BackupConfiguration) GetTransactionLogRetentionDays() *wrapperspb.Int32Value {
	if x != nil {
		return x.TransactionLogRetentionDays
	}
	return nil
}

func (x *BackupConfiguration) GetBackupRetentionSettings() *BackupRetentionSettings {
	if x != nil {
		return x.BackupRetentionSettings
	}
	return nil
}

// A BackupRun resource.
type BackupRun struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#backupRun`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The status of this run.
	Status SqlBackupRunStatus `protobuf:"varint,2,opt,name=status,proto3,enum=google.cloud.sql.v1beta4.SqlBackupRunStatus" json:"status,omitempty"`
	// The time the run was enqueued in UTC timezone in
	// [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	EnqueuedTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=enqueued_time,json=enqueuedTime,proto3" json:"enqueued_time,omitempty"`
	// The identifier for this backup run. Unique only for a specific Cloud SQL
	// instance.
	Id int64 `protobuf:"varint,4,opt,name=id,proto3" json:"id,omitempty"`
	// The time the backup operation actually started in UTC timezone in
	// [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the backup operation completed in UTC timezone in
	// [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Information about why the backup operation failed. This is only present if
	// the run has the FAILED status.
	Error *OperationError `protobuf:"bytes,7,opt,name=error,proto3" json:"error,omitempty"`
	// The type of this run; can be either "AUTOMATED" or "ON_DEMAND". This field
	// defaults to "ON_DEMAND" and is ignored, when specified for insert requests.
	Type SqlBackupRunType `protobuf:"varint,8,opt,name=type,proto3,enum=google.cloud.sql.v1beta4.SqlBackupRunType" json:"type,omitempty"`
	// The description of this run, only applicable to on-demand backups.
	Description string `protobuf:"bytes,9,opt,name=description,proto3" json:"description,omitempty"`
	// The start time of the backup window during which this the backup was
	// attempted in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for
	// example `2012-11-15T16:19:00.094Z`.
	WindowStartTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=window_start_time,json=windowStartTime,proto3" json:"window_start_time,omitempty"`
	// Name of the database instance.
	Instance string `protobuf:"bytes,11,opt,name=instance,proto3" json:"instance,omitempty"`
	// The URI of this resource.
	SelfLink string `protobuf:"bytes,12,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// Location of the backups.
	Location string `protobuf:"bytes,13,opt,name=location,proto3" json:"location,omitempty"`
	// Encryption configuration specific to a backup.
	DiskEncryptionConfiguration *DiskEncryptionConfiguration `protobuf:"bytes,16,opt,name=disk_encryption_configuration,json=diskEncryptionConfiguration,proto3" json:"disk_encryption_configuration,omitempty"`
	// Encryption status specific to a backup.
	DiskEncryptionStatus *DiskEncryptionStatus `protobuf:"bytes,17,opt,name=disk_encryption_status,json=diskEncryptionStatus,proto3" json:"disk_encryption_status,omitempty"`
	// Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.
	BackupKind SqlBackupKind `protobuf:"varint,19,opt,name=backup_kind,json=backupKind,proto3,enum=google.cloud.sql.v1beta4.SqlBackupKind" json:"backup_kind,omitempty"`
}

func (x *BackupRun) Reset() {
	*x = BackupRun{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackupRun) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupRun) ProtoMessage() {}

func (x *BackupRun) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupRun.ProtoReflect.Descriptor instead.
func (*BackupRun) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{4}
}

func (x *BackupRun) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *BackupRun) GetStatus() SqlBackupRunStatus {
	if x != nil {
		return x.Status
	}
	return SqlBackupRunStatus_SQL_BACKUP_RUN_STATUS_UNSPECIFIED
}

func (x *BackupRun) GetEnqueuedTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EnqueuedTime
	}
	return nil
}

func (x *BackupRun) GetId() int64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *BackupRun) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *BackupRun) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *BackupRun) GetError() *OperationError {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *BackupRun) GetType() SqlBackupRunType {
	if x != nil {
		return x.Type
	}
	return SqlBackupRunType_SQL_BACKUP_RUN_TYPE_UNSPECIFIED
}

func (x *BackupRun) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *BackupRun) GetWindowStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.WindowStartTime
	}
	return nil
}

func (x *BackupRun) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *BackupRun) GetSelfLink() string {
	if x != nil {
		return x.SelfLink
	}
	return ""
}

func (x *BackupRun) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *BackupRun) GetDiskEncryptionConfiguration() *DiskEncryptionConfiguration {
	if x != nil {
		return x.DiskEncryptionConfiguration
	}
	return nil
}

func (x *BackupRun) GetDiskEncryptionStatus() *DiskEncryptionStatus {
	if x != nil {
		return x.DiskEncryptionStatus
	}
	return nil
}

func (x *BackupRun) GetBackupKind() SqlBackupKind {
	if x != nil {
		return x.BackupKind
	}
	return SqlBackupKind_SQL_BACKUP_KIND_UNSPECIFIED
}

// Backup run list results.
type BackupRunsListResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#backupRunsList`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// A list of backup runs in reverse chronological order of the enqueued time.
	Items []*BackupRun `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
	// The continuation token, used to page through large result sets. Provide
	// this value in a subsequent request to return the next page of results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *BackupRunsListResponse) Reset() {
	*x = BackupRunsListResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackupRunsListResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupRunsListResponse) ProtoMessage() {}

func (x *BackupRunsListResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupRunsListResponse.ProtoReflect.Descriptor instead.
func (*BackupRunsListResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{5}
}

func (x *BackupRunsListResponse) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *BackupRunsListResponse) GetItems() []*BackupRun {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *BackupRunsListResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Binary log coordinates.
type BinLogCoordinates struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the binary log file for a Cloud SQL instance.
	BinLogFileName string `protobuf:"bytes,1,opt,name=bin_log_file_name,json=binLogFileName,proto3" json:"bin_log_file_name,omitempty"`
	// Position (offset) within the binary log file.
	BinLogPosition int64 `protobuf:"varint,2,opt,name=bin_log_position,json=binLogPosition,proto3" json:"bin_log_position,omitempty"`
	// This is always `sql#binLogCoordinates`.
	Kind string `protobuf:"bytes,3,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *BinLogCoordinates) Reset() {
	*x = BinLogCoordinates{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BinLogCoordinates) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BinLogCoordinates) ProtoMessage() {}

func (x *BinLogCoordinates) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BinLogCoordinates.ProtoReflect.Descriptor instead.
func (*BinLogCoordinates) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{6}
}

func (x *BinLogCoordinates) GetBinLogFileName() string {
	if x != nil {
		return x.BinLogFileName
	}
	return ""
}

func (x *BinLogCoordinates) GetBinLogPosition() int64 {
	if x != nil {
		return x.BinLogPosition
	}
	return 0
}

func (x *BinLogCoordinates) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// Backup context.
type BackupContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifier of the backup.
	BackupId int64 `protobuf:"varint,1,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	// This is always `sql#backupContext`.
	Kind string `protobuf:"bytes,2,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *BackupContext) Reset() {
	*x = BackupContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackupContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupContext) ProtoMessage() {}

func (x *BackupContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupContext.ProtoReflect.Descriptor instead.
func (*BackupContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{7}
}

func (x *BackupContext) GetBackupId() int64 {
	if x != nil {
		return x.BackupId
	}
	return 0
}

func (x *BackupContext) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// Database instance clone context.
type CloneContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#cloneContext`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// Reserved for future use.
	PitrTimestampMs int64 `protobuf:"varint,2,opt,name=pitr_timestamp_ms,json=pitrTimestampMs,proto3" json:"pitr_timestamp_ms,omitempty"`
	// Name of the Cloud SQL instance to be created as a clone.
	DestinationInstanceName string `protobuf:"bytes,3,opt,name=destination_instance_name,json=destinationInstanceName,proto3" json:"destination_instance_name,omitempty"`
	// Binary log coordinates, if specified, identify the position up to which the
	// source instance is cloned. If not specified, the source instance is
	// cloned up to the most recent binary log coordinates.
	BinLogCoordinates *BinLogCoordinates `protobuf:"bytes,4,opt,name=bin_log_coordinates,json=binLogCoordinates,proto3" json:"bin_log_coordinates,omitempty"`
	// Timestamp, if specified, identifies the time to which the source instance
	// is cloned.
	PointInTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=point_in_time,json=pointInTime,proto3" json:"point_in_time,omitempty"`
	// The name of the allocated ip range for the private ip CloudSQL instance.
	// For example: "google-managed-services-default". If set, the cloned instance
	// ip will be created in the allocated range. The range name must comply with
	// [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name
	// must be 1-63 characters long and match the regular expression
	// [a-z]([-a-z0-9]*[a-z0-9])?.
	// Reserved for future use.
	AllocatedIpRange string `protobuf:"bytes,6,opt,name=allocated_ip_range,json=allocatedIpRange,proto3" json:"allocated_ip_range,omitempty"`
}

func (x *CloneContext) Reset() {
	*x = CloneContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloneContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloneContext) ProtoMessage() {}

func (x *CloneContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloneContext.ProtoReflect.Descriptor instead.
func (*CloneContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{8}
}

func (x *CloneContext) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *CloneContext) GetPitrTimestampMs() int64 {
	if x != nil {
		return x.PitrTimestampMs
	}
	return 0
}

func (x *CloneContext) GetDestinationInstanceName() string {
	if x != nil {
		return x.DestinationInstanceName
	}
	return ""
}

func (x *CloneContext) GetBinLogCoordinates() *BinLogCoordinates {
	if x != nil {
		return x.BinLogCoordinates
	}
	return nil
}

func (x *CloneContext) GetPointInTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PointInTime
	}
	return nil
}

func (x *CloneContext) GetAllocatedIpRange() string {
	if x != nil {
		return x.AllocatedIpRange
	}
	return ""
}

// Represents a SQL database on the Cloud SQL instance.
type Database struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#database`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The Cloud SQL charset value.
	Charset string `protobuf:"bytes,2,opt,name=charset,proto3" json:"charset,omitempty"`
	// The Cloud SQL collation value.
	Collation string `protobuf:"bytes,3,opt,name=collation,proto3" json:"collation,omitempty"`
	// This field is deprecated and will be removed from a future version of the
	// API.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
	// The name of the database in the Cloud SQL instance. This does not include
	// the project ID or instance name.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the Cloud SQL instance. This does not include the project ID.
	Instance string `protobuf:"bytes,6,opt,name=instance,proto3" json:"instance,omitempty"`
	// The URI of this resource.
	SelfLink string `protobuf:"bytes,7,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// The project ID of the project containing the Cloud SQL database. The Google
	// apps domain is prefixed if applicable.
	Project string `protobuf:"bytes,8,opt,name=project,proto3" json:"project,omitempty"`
	// Types that are assignable to DatabaseDetails:
	//	*Database_SqlserverDatabaseDetails
	DatabaseDetails isDatabase_DatabaseDetails `protobuf_oneof:"database_details"`
}

func (x *Database) Reset() {
	*x = Database{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Database) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Database) ProtoMessage() {}

func (x *Database) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Database.ProtoReflect.Descriptor instead.
func (*Database) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{9}
}

func (x *Database) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *Database) GetCharset() string {
	if x != nil {
		return x.Charset
	}
	return ""
}

func (x *Database) GetCollation() string {
	if x != nil {
		return x.Collation
	}
	return ""
}

func (x *Database) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Database) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Database) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *Database) GetSelfLink() string {
	if x != nil {
		return x.SelfLink
	}
	return ""
}

func (x *Database) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (m *Database) GetDatabaseDetails() isDatabase_DatabaseDetails {
	if m != nil {
		return m.DatabaseDetails
	}
	return nil
}

func (x *Database) GetSqlserverDatabaseDetails() *SqlServerDatabaseDetails {
	if x, ok := x.GetDatabaseDetails().(*Database_SqlserverDatabaseDetails); ok {
		return x.SqlserverDatabaseDetails
	}
	return nil
}

type isDatabase_DatabaseDetails interface {
	isDatabase_DatabaseDetails()
}

type Database_SqlserverDatabaseDetails struct {
	SqlserverDatabaseDetails *SqlServerDatabaseDetails `protobuf:"bytes,9,opt,name=sqlserver_database_details,json=sqlserverDatabaseDetails,proto3,oneof"`
}

func (*Database_SqlserverDatabaseDetails) isDatabase_DatabaseDetails() {}

// Represents a Sql Server database on the Cloud SQL instance.
type SqlServerDatabaseDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The version of SQL Server with which the database is to be made compatible
	CompatibilityLevel int32 `protobuf:"varint,1,opt,name=compatibility_level,json=compatibilityLevel,proto3" json:"compatibility_level,omitempty"`
	// The recovery model of a SQL Server database
	RecoveryModel string `protobuf:"bytes,2,opt,name=recovery_model,json=recoveryModel,proto3" json:"recovery_model,omitempty"`
}

func (x *SqlServerDatabaseDetails) Reset() {
	*x = SqlServerDatabaseDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlServerDatabaseDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlServerDatabaseDetails) ProtoMessage() {}

func (x *SqlServerDatabaseDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlServerDatabaseDetails.ProtoReflect.Descriptor instead.
func (*SqlServerDatabaseDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{10}
}

func (x *SqlServerDatabaseDetails) GetCompatibilityLevel() int32 {
	if x != nil {
		return x.CompatibilityLevel
	}
	return 0
}

func (x *SqlServerDatabaseDetails) GetRecoveryModel() string {
	if x != nil {
		return x.RecoveryModel
	}
	return ""
}

// Database flags for Cloud SQL instances.
type DatabaseFlags struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the flag. These flags are passed at instance startup, so
	// include both server options and system variables. Flags are
	// specified with underscores, not hyphens. For more information, see
	// [Configuring Database Flags](https://cloud.google.com/sql/docs/mysql/flags)
	// in the Cloud SQL documentation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The value of the flag. Boolean flags are set to `on` for true
	// and `off` for false. This field must be omitted if the flag
	// doesn't take a value.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *DatabaseFlags) Reset() {
	*x = DatabaseFlags{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabaseFlags) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseFlags) ProtoMessage() {}

func (x *DatabaseFlags) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseFlags.ProtoReflect.Descriptor instead.
func (*DatabaseFlags) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{11}
}

func (x *DatabaseFlags) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DatabaseFlags) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// Initial sync flags for certain Cloud SQL APIs.
// Currently used for the MySQL external server initial dump.
type SyncFlags struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the flag.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The value of the flag. This field must be omitted if the flag
	// doesn't take a value.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *SyncFlags) Reset() {
	*x = SyncFlags{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SyncFlags) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncFlags) ProtoMessage() {}

func (x *SyncFlags) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncFlags.ProtoReflect.Descriptor instead.
func (*SyncFlags) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{12}
}

func (x *SyncFlags) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SyncFlags) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// Reference to another Cloud SQL instance.
type InstanceReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the Cloud SQL instance being referenced.
	// This does not include the project ID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The region of the Cloud SQL instance being referenced.
	Region string `protobuf:"bytes,2,opt,name=region,proto3" json:"region,omitempty"`
	// The project ID of the Cloud SQL instance being referenced.
	// The default is the same project ID as the instance references it.
	Project string `protobuf:"bytes,3,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *InstanceReference) Reset() {
	*x = InstanceReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstanceReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceReference) ProtoMessage() {}

func (x *InstanceReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceReference.ProtoReflect.Descriptor instead.
func (*InstanceReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{13}
}

func (x *InstanceReference) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *InstanceReference) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *InstanceReference) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// A Cloud SQL instance resource.
type DatabaseInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#instance`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The current serving state of the Cloud SQL instance.
	State DatabaseInstance_SqlInstanceState `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.sql.v1beta4.DatabaseInstance_SqlInstanceState" json:"state,omitempty"`
	// The database engine type and version. The `databaseVersion` field cannot
	// be changed after instance creation.
	DatabaseVersion SqlDatabaseVersion `protobuf:"varint,3,opt,name=database_version,json=databaseVersion,proto3,enum=google.cloud.sql.v1beta4.SqlDatabaseVersion" json:"database_version,omitempty"`
	// The user settings.
	Settings *Settings `protobuf:"bytes,4,opt,name=settings,proto3" json:"settings,omitempty"`
	// This field is deprecated and will be removed from a future version of the
	// API. Use the `settings.settingsVersion` field instead.
	Etag string `protobuf:"bytes,5,opt,name=etag,proto3" json:"etag,omitempty"`
	// The name and status of the failover replica.
	FailoverReplica *DatabaseInstance_SqlFailoverReplica `protobuf:"bytes,6,opt,name=failover_replica,json=failoverReplica,proto3" json:"failover_replica,omitempty"`
	// The name of the instance which will act as primary in the replication
	// setup.
	MasterInstanceName string `protobuf:"bytes,7,opt,name=master_instance_name,json=masterInstanceName,proto3" json:"master_instance_name,omitempty"`
	// The replicas of the instance.
	ReplicaNames []string `protobuf:"bytes,8,rep,name=replica_names,json=replicaNames,proto3" json:"replica_names,omitempty"`
	// The maximum disk size of the instance in bytes.
	//
	// Deprecated: Do not use.
	MaxDiskSize *wrapperspb.Int64Value `protobuf:"bytes,9,opt,name=max_disk_size,json=maxDiskSize,proto3" json:"max_disk_size,omitempty"`
	// The current disk usage of the instance in bytes. This property has been
	// deprecated. Use the
	// "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud
	// Monitoring API instead. Please see [this
	// announcement](https://groups.google.com/d/msg/google-cloud-sql-announce/I_7-F9EBhT0/BtvFtdFeAgAJ)
	// for details.
	//
	// Deprecated: Do not use.
	CurrentDiskSize *wrapperspb.Int64Value `protobuf:"bytes,10,opt,name=current_disk_size,json=currentDiskSize,proto3" json:"current_disk_size,omitempty"`
	// The assigned IP addresses for the instance.
	IpAddresses []*IpMapping `protobuf:"bytes,11,rep,name=ip_addresses,json=ipAddresses,proto3" json:"ip_addresses,omitempty"`
	// SSL configuration.
	ServerCaCert *SslCert `protobuf:"bytes,12,opt,name=server_ca_cert,json=serverCaCert,proto3" json:"server_ca_cert,omitempty"`
	// The instance type.
	InstanceType SqlInstanceType `protobuf:"varint,13,opt,name=instance_type,json=instanceType,proto3,enum=google.cloud.sql.v1beta4.SqlInstanceType" json:"instance_type,omitempty"`
	// The project ID of the project containing the Cloud SQL instance. The Google
	// apps domain is prefixed if applicable.
	Project string `protobuf:"bytes,14,opt,name=project,proto3" json:"project,omitempty"`
	// The IPv6 address assigned to the instance.
	// (Deprecated) This property was applicable only
	// to First Generation instances.
	//
	// Deprecated: Do not use.
	Ipv6Address string `protobuf:"bytes,15,opt,name=ipv6_address,json=ipv6Address,proto3" json:"ipv6_address,omitempty"`
	// The service account email address assigned to the instance. \This
	// property is read-only.
	ServiceAccountEmailAddress string `protobuf:"bytes,16,opt,name=service_account_email_address,json=serviceAccountEmailAddress,proto3" json:"service_account_email_address,omitempty"`
	// Configuration specific to on-premises instances.
	OnPremisesConfiguration *OnPremisesConfiguration `protobuf:"bytes,17,opt,name=on_premises_configuration,json=onPremisesConfiguration,proto3" json:"on_premises_configuration,omitempty"`
	// Configuration specific to failover replicas and read replicas.
	ReplicaConfiguration *ReplicaConfiguration `protobuf:"bytes,18,opt,name=replica_configuration,json=replicaConfiguration,proto3" json:"replica_configuration,omitempty"`
	// The backend type.
	// `SECOND_GEN`: Cloud SQL database instance.
	// `EXTERNAL`: A database server that is not managed by Google.
	//
	// This property is read-only; use the `tier` property in the `settings`
	// object to determine the database type.
	BackendType SqlBackendType `protobuf:"varint,19,opt,name=backend_type,json=backendType,proto3,enum=google.cloud.sql.v1beta4.SqlBackendType" json:"backend_type,omitempty"`
	// The URI of this resource.
	SelfLink string `protobuf:"bytes,20,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// If the instance state is SUSPENDED, the reason for the suspension.
	SuspensionReason []SqlSuspensionReason `protobuf:"varint,21,rep,packed,name=suspension_reason,json=suspensionReason,proto3,enum=google.cloud.sql.v1beta4.SqlSuspensionReason" json:"suspension_reason,omitempty"`
	// Connection name of the Cloud SQL instance used in connection strings.
	ConnectionName string `protobuf:"bytes,22,opt,name=connection_name,json=connectionName,proto3" json:"connection_name,omitempty"`
	// Name of the Cloud SQL instance. This does not include the project ID.
	Name string `protobuf:"bytes,23,opt,name=name,proto3" json:"name,omitempty"`
	// The geographical region. Can be:
	// *  `us-central` (`FIRST_GEN` instances only)
	// *  `us-central1` (`SECOND_GEN` instances only)
	// *  `asia-east1` or `europe-west1`.
	//
	// Defaults to `us-central` or `us-central1` depending on the instance
	// type. The region cannot be changed after instance creation.
	Region string `protobuf:"bytes,24,opt,name=region,proto3" json:"region,omitempty"`
	// The Compute Engine zone that the instance is currently serving from. This
	// value could be different from the zone that was specified when the instance
	// was created if the instance has failed over to its secondary zone. WARNING:
	// Changing this might restart the instance.
	GceZone string `protobuf:"bytes,25,opt,name=gce_zone,json=gceZone,proto3" json:"gce_zone,omitempty"`
	// The Compute Engine zone that the failover instance is currently serving
	// from for a regional instance. This value could be different
	// from the zone that was specified when the instance
	// was created if the instance has failed over to its secondary/failover zone.
	SecondaryGceZone string `protobuf:"bytes,34,opt,name=secondary_gce_zone,json=secondaryGceZone,proto3" json:"secondary_gce_zone,omitempty"`
	// Disk encryption configuration specific to an instance.
	DiskEncryptionConfiguration *DiskEncryptionConfiguration `protobuf:"bytes,26,opt,name=disk_encryption_configuration,json=diskEncryptionConfiguration,proto3" json:"disk_encryption_configuration,omitempty"`
	// Disk encryption status specific to an instance.
	DiskEncryptionStatus *DiskEncryptionStatus `protobuf:"bytes,27,opt,name=disk_encryption_status,json=diskEncryptionStatus,proto3" json:"disk_encryption_status,omitempty"`
	// Initial root password. Use only on creation.
	RootPassword string `protobuf:"bytes,29,opt,name=root_password,json=rootPassword,proto3" json:"root_password,omitempty"`
	// The start time of any upcoming scheduled maintenance for this instance.
	ScheduledMaintenance *DatabaseInstance_SqlScheduledMaintenance `protobuf:"bytes,30,opt,name=scheduled_maintenance,json=scheduledMaintenance,proto3" json:"scheduled_maintenance,omitempty"`
	// The status indicating if instance satisfiesPzs.
	// Reserved for future use.
	SatisfiesPzs *wrapperspb.BoolValue `protobuf:"bytes,35,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
	// Output only. Stores the current database version running on the instance including
	// minor version such as `MYSQL_8_0_18`.
	DatabaseInstalledVersion string `protobuf:"bytes,40,opt,name=database_installed_version,json=databaseInstalledVersion,proto3" json:"database_installed_version,omitempty"`
	// This field represents the report generated by the proactive database
	// wellness job for OutOfDisk issues.
	// *  Writers:
	//   *  the proactive database wellness job for OOD.
	// *  Readers:
	//   *  the proactive database wellness job
	OutOfDiskReport *DatabaseInstance_SqlOutOfDiskReport `protobuf:"bytes,38,opt,name=out_of_disk_report,json=outOfDiskReport,proto3,oneof" json:"out_of_disk_report,omitempty"`
	// Output only. The time when the instance was created in
	// [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,39,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// List all maintenance versions applicable on the instance
	AvailableMaintenanceVersions []string `protobuf:"bytes,41,rep,name=available_maintenance_versions,json=availableMaintenanceVersions,proto3" json:"available_maintenance_versions,omitempty"`
	// The current software version on the instance.
	MaintenanceVersion string `protobuf:"bytes,42,opt,name=maintenance_version,json=maintenanceVersion,proto3" json:"maintenance_version,omitempty"`
}

func (x *DatabaseInstance) Reset() {
	*x = DatabaseInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabaseInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseInstance) ProtoMessage() {}

func (x *DatabaseInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseInstance.ProtoReflect.Descriptor instead.
func (*DatabaseInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{14}
}

func (x *DatabaseInstance) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *DatabaseInstance) GetState() DatabaseInstance_SqlInstanceState {
	if x != nil {
		return x.State
	}
	return DatabaseInstance_SQL_INSTANCE_STATE_UNSPECIFIED
}

func (x *DatabaseInstance) GetDatabaseVersion() SqlDatabaseVersion {
	if x != nil {
		return x.DatabaseVersion
	}
	return SqlDatabaseVersion_SQL_DATABASE_VERSION_UNSPECIFIED
}

func (x *DatabaseInstance) GetSettings() *Settings {
	if x != nil {
		return x.Settings
	}
	return nil
}

func (x *DatabaseInstance) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DatabaseInstance) GetFailoverReplica() *DatabaseInstance_SqlFailoverReplica {
	if x != nil {
		return x.FailoverReplica
	}
	return nil
}

func (x *DatabaseInstance) GetMasterInstanceName() string {
	if x != nil {
		return x.MasterInstanceName
	}
	return ""
}

func (x *DatabaseInstance) GetReplicaNames() []string {
	if x != nil {
		return x.ReplicaNames
	}
	return nil
}

// Deprecated: Do not use.
func (x *DatabaseInstance) GetMaxDiskSize() *wrapperspb.Int64Value {
	if x != nil {
		return x.MaxDiskSize
	}
	return nil
}

// Deprecated: Do not use.
func (x *DatabaseInstance) GetCurrentDiskSize() *wrapperspb.Int64Value {
	if x != nil {
		return x.CurrentDiskSize
	}
	return nil
}

func (x *DatabaseInstance) GetIpAddresses() []*IpMapping {
	if x != nil {
		return x.IpAddresses
	}
	return nil
}

func (x *DatabaseInstance) GetServerCaCert() *SslCert {
	if x != nil {
		return x.ServerCaCert
	}
	return nil
}

func (x *DatabaseInstance) GetInstanceType() SqlInstanceType {
	if x != nil {
		return x.InstanceType
	}
	return SqlInstanceType_SQL_INSTANCE_TYPE_UNSPECIFIED
}

func (x *DatabaseInstance) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// Deprecated: Do not use.
func (x *DatabaseInstance) GetIpv6Address() string {
	if x != nil {
		return x.Ipv6Address
	}
	return ""
}

func (x *DatabaseInstance) GetServiceAccountEmailAddress() string {
	if x != nil {
		return x.ServiceAccountEmailAddress
	}
	return ""
}

func (x *DatabaseInstance) GetOnPremisesConfiguration() *OnPremisesConfiguration {
	if x != nil {
		return x.OnPremisesConfiguration
	}
	return nil
}

func (x *DatabaseInstance) GetReplicaConfiguration() *ReplicaConfiguration {
	if x != nil {
		return x.ReplicaConfiguration
	}
	return nil
}

func (x *DatabaseInstance) GetBackendType() SqlBackendType {
	if x != nil {
		return x.BackendType
	}
	return SqlBackendType_SQL_BACKEND_TYPE_UNSPECIFIED
}

func (x *DatabaseInstance) GetSelfLink() string {
	if x != nil {
		return x.SelfLink
	}
	return ""
}

func (x *DatabaseInstance) GetSuspensionReason() []SqlSuspensionReason {
	if x != nil {
		return x.SuspensionReason
	}
	return nil
}

func (x *DatabaseInstance) GetConnectionName() string {
	if x != nil {
		return x.ConnectionName
	}
	return ""
}

func (x *DatabaseInstance) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DatabaseInstance) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *DatabaseInstance) GetGceZone() string {
	if x != nil {
		return x.GceZone
	}
	return ""
}

func (x *DatabaseInstance) GetSecondaryGceZone() string {
	if x != nil {
		return x.SecondaryGceZone
	}
	return ""
}

func (x *DatabaseInstance) GetDiskEncryptionConfiguration() *DiskEncryptionConfiguration {
	if x != nil {
		return x.DiskEncryptionConfiguration
	}
	return nil
}

func (x *DatabaseInstance) GetDiskEncryptionStatus() *DiskEncryptionStatus {
	if x != nil {
		return x.DiskEncryptionStatus
	}
	return nil
}

func (x *DatabaseInstance) GetRootPassword() string {
	if x != nil {
		return x.RootPassword
	}
	return ""
}

func (x *DatabaseInstance) GetScheduledMaintenance() *DatabaseInstance_SqlScheduledMaintenance {
	if x != nil {
		return x.ScheduledMaintenance
	}
	return nil
}

func (x *DatabaseInstance) GetSatisfiesPzs() *wrapperspb.BoolValue {
	if x != nil {
		return x.SatisfiesPzs
	}
	return nil
}

func (x *DatabaseInstance) GetDatabaseInstalledVersion() string {
	if x != nil {
		return x.DatabaseInstalledVersion
	}
	return ""
}

func (x *DatabaseInstance) GetOutOfDiskReport() *DatabaseInstance_SqlOutOfDiskReport {
	if x != nil {
		return x.OutOfDiskReport
	}
	return nil
}

func (x *DatabaseInstance) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DatabaseInstance) GetAvailableMaintenanceVersions() []string {
	if x != nil {
		return x.AvailableMaintenanceVersions
	}
	return nil
}

func (x *DatabaseInstance) GetMaintenanceVersion() string {
	if x != nil {
		return x.MaintenanceVersion
	}
	return ""
}

// Database list response.
type DatabasesListResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#databasesList`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// List of database resources in the instance.
	Items []*Database `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *DatabasesListResponse) Reset() {
	*x = DatabasesListResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabasesListResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabasesListResponse) ProtoMessage() {}

func (x *DatabasesListResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabasesListResponse.ProtoReflect.Descriptor instead.
func (*DatabasesListResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{15}
}

func (x *DatabasesListResponse) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *DatabasesListResponse) GetItems() []*Database {
	if x != nil {
		return x.Items
	}
	return nil
}

// Read-replica configuration for connecting to the on-premises primary
// instance.
type DemoteMasterConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#demoteMasterConfiguration`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// MySQL specific configuration when replicating from a MySQL on-premises
	// primary instance. Replication configuration information such as the
	// username, password, certificates, and keys are not stored in the instance
	// metadata. The configuration information is used only to set up the
	// replication connection and is stored by MySQL in a file named
	// `master.info` in the data directory.
	MysqlReplicaConfiguration *DemoteMasterMySqlReplicaConfiguration `protobuf:"bytes,2,opt,name=mysql_replica_configuration,json=mysqlReplicaConfiguration,proto3" json:"mysql_replica_configuration,omitempty"`
}

func (x *DemoteMasterConfiguration) Reset() {
	*x = DemoteMasterConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DemoteMasterConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DemoteMasterConfiguration) ProtoMessage() {}

func (x *DemoteMasterConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DemoteMasterConfiguration.ProtoReflect.Descriptor instead.
func (*DemoteMasterConfiguration) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{16}
}

func (x *DemoteMasterConfiguration) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *DemoteMasterConfiguration) GetMysqlReplicaConfiguration() *DemoteMasterMySqlReplicaConfiguration {
	if x != nil {
		return x.MysqlReplicaConfiguration
	}
	return nil
}

// Database instance demote primary instance context.
type DemoteMasterContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#demoteMasterContext`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// Verify the GTID consistency for demote operation. Default value:
	// `True`. Setting this flag to `false` enables you to bypass the GTID
	// consistency check between on-premises primary instance and Cloud SQL
	// instance during the demotion operation but also exposes you to the risk of
	// future replication failures. Change the value only if you know the reason
	// for the GTID divergence and are confident that doing so will not cause any
	// replication issues.
	VerifyGtidConsistency *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=verify_gtid_consistency,json=verifyGtidConsistency,proto3" json:"verify_gtid_consistency,omitempty"`
	// The name of the instance which will act as on-premises primary instance
	// in the replication setup.
	MasterInstanceName string `protobuf:"bytes,3,opt,name=master_instance_name,json=masterInstanceName,proto3" json:"master_instance_name,omitempty"`
	// Configuration specific to read-replicas replicating from the on-premises
	// primary instance.
	ReplicaConfiguration *DemoteMasterConfiguration `protobuf:"bytes,4,opt,name=replica_configuration,json=replicaConfiguration,proto3" json:"replica_configuration,omitempty"`
	// Flag to skip replication setup on the instance.
	SkipReplicationSetup bool `protobuf:"varint,5,opt,name=skip_replication_setup,json=skipReplicationSetup,proto3" json:"skip_replication_setup,omitempty"`
}

func (x *DemoteMasterContext) Reset() {
	*x = DemoteMasterContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DemoteMasterContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DemoteMasterContext) ProtoMessage() {}

func (x *DemoteMasterContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DemoteMasterContext.ProtoReflect.Descriptor instead.
func (*DemoteMasterContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{17}
}

func (x *DemoteMasterContext) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *DemoteMasterContext) GetVerifyGtidConsistency() *wrapperspb.BoolValue {
	if x != nil {
		return x.VerifyGtidConsistency
	}
	return nil
}

func (x *DemoteMasterContext) GetMasterInstanceName() string {
	if x != nil {
		return x.MasterInstanceName
	}
	return ""
}

func (x *DemoteMasterContext) GetReplicaConfiguration() *DemoteMasterConfiguration {
	if x != nil {
		return x.ReplicaConfiguration
	}
	return nil
}

func (x *DemoteMasterContext) GetSkipReplicationSetup() bool {
	if x != nil {
		return x.SkipReplicationSetup
	}
	return false
}

// Read-replica configuration specific to MySQL databases.
type DemoteMasterMySqlReplicaConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#demoteMasterMysqlReplicaConfiguration`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The username for the replication connection.
	Username string `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
	// The password for the replication connection.
	Password string `protobuf:"bytes,3,opt,name=password,proto3" json:"password,omitempty"`
	// PEM representation of the replica's private key. The corresponsing public
	// key is encoded in the client's certificate. The format of the replica's
	// private key can be either PKCS #1 or PKCS #8.
	ClientKey string `protobuf:"bytes,4,opt,name=client_key,json=clientKey,proto3" json:"client_key,omitempty"`
	// PEM representation of the replica's x509 certificate.
	ClientCertificate string `protobuf:"bytes,5,opt,name=client_certificate,json=clientCertificate,proto3" json:"client_certificate,omitempty"`
	// PEM representation of the trusted CA's x509 certificate.
	CaCertificate string `protobuf:"bytes,6,opt,name=ca_certificate,json=caCertificate,proto3" json:"ca_certificate,omitempty"`
}

func (x *DemoteMasterMySqlReplicaConfiguration) Reset() {
	*x = DemoteMasterMySqlReplicaConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DemoteMasterMySqlReplicaConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DemoteMasterMySqlReplicaConfiguration) ProtoMessage() {}

func (x *DemoteMasterMySqlReplicaConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DemoteMasterMySqlReplicaConfiguration.ProtoReflect.Descriptor instead.
func (*DemoteMasterMySqlReplicaConfiguration) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{18}
}

func (x *DemoteMasterMySqlReplicaConfiguration) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *DemoteMasterMySqlReplicaConfiguration) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *DemoteMasterMySqlReplicaConfiguration) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *DemoteMasterMySqlReplicaConfiguration) GetClientKey() string {
	if x != nil {
		return x.ClientKey
	}
	return ""
}

func (x *DemoteMasterMySqlReplicaConfiguration) GetClientCertificate() string {
	if x != nil {
		return x.ClientCertificate
	}
	return ""
}

func (x *DemoteMasterMySqlReplicaConfiguration) GetCaCertificate() string {
	if x != nil {
		return x.CaCertificate
	}
	return ""
}

// Database instance export context.
type ExportContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The path to the file in Google Cloud Storage where the export will be
	// stored. The URI is in the form `gs://bucketName/fileName`. If the file
	// already exists, the request succeeds, but the operation fails. If
	// `fileType` is `SQL` and the filename ends with .gz,
	// the contents are compressed.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Databases to be exported. <br /> `MySQL instances:` If
	// `fileType` is `SQL` and no database is specified, all
	// databases are exported, except for the `mysql` system database.
	// If `fileType` is `CSV`, you can specify one database,
	// either by using this property or by using the
	// `csvExportOptions.selectQuery` property, which takes precedence
	// over this property. <br /> `PostgreSQL instances:` You must specify
	// one database to be exported. If `fileType` is `CSV`,
	// this database must match the one specified in the
	// `csvExportOptions.selectQuery` property. <br /> `SQL Server
	// instances:` You must specify one database to be exported, and the
	// `fileType` must be `BAK`.
	Databases []string `protobuf:"bytes,2,rep,name=databases,proto3" json:"databases,omitempty"`
	// This is always `sql#exportContext`.
	Kind string `protobuf:"bytes,3,opt,name=kind,proto3" json:"kind,omitempty"`
	// Options for exporting data as SQL statements.
	SqlExportOptions *ExportContext_SqlExportOptions `protobuf:"bytes,4,opt,name=sql_export_options,json=sqlExportOptions,proto3" json:"sql_export_options,omitempty"`
	// Options for exporting data as CSV. `MySQL` and `PostgreSQL`
	// instances only.
	CsvExportOptions *ExportContext_SqlCsvExportOptions `protobuf:"bytes,5,opt,name=csv_export_options,json=csvExportOptions,proto3" json:"csv_export_options,omitempty"`
	// The file type for the specified uri.
	FileType SqlFileType `protobuf:"varint,6,opt,name=file_type,json=fileType,proto3,enum=google.cloud.sql.v1beta4.SqlFileType" json:"file_type,omitempty"`
	// Option for export offload.
	Offload *wrapperspb.BoolValue `protobuf:"bytes,8,opt,name=offload,proto3" json:"offload,omitempty"`
}

func (x *ExportContext) Reset() {
	*x = ExportContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportContext) ProtoMessage() {}

func (x *ExportContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportContext.ProtoReflect.Descriptor instead.
func (*ExportContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{19}
}

func (x *ExportContext) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *ExportContext) GetDatabases() []string {
	if x != nil {
		return x.Databases
	}
	return nil
}

func (x *ExportContext) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *ExportContext) GetSqlExportOptions() *ExportContext_SqlExportOptions {
	if x != nil {
		return x.SqlExportOptions
	}
	return nil
}

func (x *ExportContext) GetCsvExportOptions() *ExportContext_SqlCsvExportOptions {
	if x != nil {
		return x.CsvExportOptions
	}
	return nil
}

func (x *ExportContext) GetFileType() SqlFileType {
	if x != nil {
		return x.FileType
	}
	return SqlFileType_SQL_FILE_TYPE_UNSPECIFIED
}

func (x *ExportContext) GetOffload() *wrapperspb.BoolValue {
	if x != nil {
		return x.Offload
	}
	return nil
}

// Database instance failover context.
type FailoverContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current settings version of this instance. Request will be rejected if
	// this version doesn't match the current settings version.
	SettingsVersion int64 `protobuf:"varint,1,opt,name=settings_version,json=settingsVersion,proto3" json:"settings_version,omitempty"`
	// This is always `sql#failoverContext`.
	Kind string `protobuf:"bytes,2,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *FailoverContext) Reset() {
	*x = FailoverContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FailoverContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FailoverContext) ProtoMessage() {}

func (x *FailoverContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FailoverContext.ProtoReflect.Descriptor instead.
func (*FailoverContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{20}
}

func (x *FailoverContext) GetSettingsVersion() int64 {
	if x != nil {
		return x.SettingsVersion
	}
	return 0
}

func (x *FailoverContext) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// A flag resource.
type Flag struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is the name of the flag. Flag names always use underscores, not
	// hyphens, for example: `max_allowed_packet`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The type of the flag. Flags are typed to being `BOOLEAN`, `STRING`,
	// `INTEGER` or `NONE`. `NONE` is used for flags which do not take a
	// value, such as `skip_grant_tables`.
	Type SqlFlagType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.sql.v1beta4.SqlFlagType" json:"type,omitempty"`
	// The database version this flag applies to. Can be
	// MySQL instances: `MYSQL_8_0`, `MYSQL_8_0_18`, `MYSQL_8_0_26`, `MYSQL_5_7`,
	// or `MYSQL_5_6`. PostgreSQL instances: `POSTGRES_9_6`, `POSTGRES_10`,
	// `POSTGRES_11` or `POSTGRES_12`. SQL Server instances:
	// `SQLSERVER_2017_STANDARD`, `SQLSERVER_2017_ENTERPRISE`,
	// `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`, `SQLSERVER_2019_STANDARD`,
	// `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`, or
	// `SQLSERVER_2019_WEB`.
	// See [the complete
	// list](/sql/docs/mysql/admin-api/rest/v1/SqlDatabaseVersion).
	AppliesTo []SqlDatabaseVersion `protobuf:"varint,3,rep,packed,name=applies_to,json=appliesTo,proto3,enum=google.cloud.sql.v1beta4.SqlDatabaseVersion" json:"applies_to,omitempty"`
	// For `STRING` flags, a list of strings that the value can be set to.
	AllowedStringValues []string `protobuf:"bytes,4,rep,name=allowed_string_values,json=allowedStringValues,proto3" json:"allowed_string_values,omitempty"`
	// For `INTEGER` flags, the minimum allowed value.
	MinValue *wrapperspb.Int64Value `protobuf:"bytes,5,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// For `INTEGER` flags, the maximum allowed value.
	MaxValue *wrapperspb.Int64Value `protobuf:"bytes,6,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
	// Indicates whether changing this flag will trigger a database restart. Only
	// applicable to Second Generation instances.
	RequiresRestart *wrapperspb.BoolValue `protobuf:"bytes,7,opt,name=requires_restart,json=requiresRestart,proto3" json:"requires_restart,omitempty"`
	// This is always `sql#flag`.
	Kind string `protobuf:"bytes,8,opt,name=kind,proto3" json:"kind,omitempty"`
	// Whether or not the flag is considered in beta.
	InBeta *wrapperspb.BoolValue `protobuf:"bytes,9,opt,name=in_beta,json=inBeta,proto3" json:"in_beta,omitempty"`
	// Use this field if only certain integers are accepted. Can be combined
	// with min_value and max_value to add additional values.
	AllowedIntValues []int64 `protobuf:"varint,10,rep,packed,name=allowed_int_values,json=allowedIntValues,proto3" json:"allowed_int_values,omitempty"`
}

func (x *Flag) Reset() {
	*x = Flag{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Flag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Flag) ProtoMessage() {}

func (x *Flag) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Flag.ProtoReflect.Descriptor instead.
func (*Flag) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{21}
}

func (x *Flag) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Flag) GetType() SqlFlagType {
	if x != nil {
		return x.Type
	}
	return SqlFlagType_SQL_FLAG_TYPE_UNSPECIFIED
}

func (x *Flag) GetAppliesTo() []SqlDatabaseVersion {
	if x != nil {
		return x.AppliesTo
	}
	return nil
}

func (x *Flag) GetAllowedStringValues() []string {
	if x != nil {
		return x.AllowedStringValues
	}
	return nil
}

func (x *Flag) GetMinValue() *wrapperspb.Int64Value {
	if x != nil {
		return x.MinValue
	}
	return nil
}

func (x *Flag) GetMaxValue() *wrapperspb.Int64Value {
	if x != nil {
		return x.MaxValue
	}
	return nil
}

func (x *Flag) GetRequiresRestart() *wrapperspb.BoolValue {
	if x != nil {
		return x.RequiresRestart
	}
	return nil
}

func (x *Flag) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *Flag) GetInBeta() *wrapperspb.BoolValue {
	if x != nil {
		return x.InBeta
	}
	return nil
}

func (x *Flag) GetAllowedIntValues() []int64 {
	if x != nil {
		return x.AllowedIntValues
	}
	return nil
}

// Flags list response.
type FlagsListResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#flagsList`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// List of flags.
	Items []*Flag `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *FlagsListResponse) Reset() {
	*x = FlagsListResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FlagsListResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlagsListResponse) ProtoMessage() {}

func (x *FlagsListResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlagsListResponse.ProtoReflect.Descriptor instead.
func (*FlagsListResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{22}
}

func (x *FlagsListResponse) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *FlagsListResponse) GetItems() []*Flag {
	if x != nil {
		return x.Items
	}
	return nil
}

// Database instance import context.
type ImportContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path to the import file in Cloud Storage, in the form
	// `gs://bucketName/fileName`. Compressed gzip files (.gz) are supported
	// when `fileType` is `SQL`. The instance must have
	// write permissions to the bucket and read access to the file.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// The target database for the import. If `fileType` is `SQL`, this field
	// is required only if the import file does not specify a database, and is
	// overridden by any database specification in the import file. If
	// `fileType` is `CSV`, one database must be specified.
	Database string `protobuf:"bytes,2,opt,name=database,proto3" json:"database,omitempty"`
	// This is always `sql#importContext`.
	Kind string `protobuf:"bytes,3,opt,name=kind,proto3" json:"kind,omitempty"`
	// The file type for the specified uri.
	// *  `SQL`: The file contains SQL statements.
	// *  `CSV`: The file contains CSV data.
	// *  `BAK`: The file contains backup data for a SQL Server instance.
	FileType SqlFileType `protobuf:"varint,4,opt,name=file_type,json=fileType,proto3,enum=google.cloud.sql.v1beta4.SqlFileType" json:"file_type,omitempty"`
	// Options for importing data as CSV.
	CsvImportOptions *ImportContext_SqlCsvImportOptions `protobuf:"bytes,5,opt,name=csv_import_options,json=csvImportOptions,proto3" json:"csv_import_options,omitempty"`
	// The PostgreSQL user for this import operation. PostgreSQL instances only.
	ImportUser string `protobuf:"bytes,6,opt,name=import_user,json=importUser,proto3" json:"import_user,omitempty"`
	// Import parameters specific to SQL Server .BAK files
	BakImportOptions *ImportContext_SqlBakImportOptions `protobuf:"bytes,7,opt,name=bak_import_options,json=bakImportOptions,proto3" json:"bak_import_options,omitempty"`
}

func (x *ImportContext) Reset() {
	*x = ImportContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportContext) ProtoMessage() {}

func (x *ImportContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportContext.ProtoReflect.Descriptor instead.
func (*ImportContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{23}
}

func (x *ImportContext) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *ImportContext) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *ImportContext) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *ImportContext) GetFileType() SqlFileType {
	if x != nil {
		return x.FileType
	}
	return SqlFileType_SQL_FILE_TYPE_UNSPECIFIED
}

func (x *ImportContext) GetCsvImportOptions() *ImportContext_SqlCsvImportOptions {
	if x != nil {
		return x.CsvImportOptions
	}
	return nil
}

func (x *ImportContext) GetImportUser() string {
	if x != nil {
		return x.ImportUser
	}
	return ""
}

func (x *ImportContext) GetBakImportOptions() *ImportContext_SqlBakImportOptions {
	if x != nil {
		return x.BakImportOptions
	}
	return nil
}

// Database instance clone request.
type InstancesCloneRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains details about the clone operation.
	CloneContext *CloneContext `protobuf:"bytes,1,opt,name=clone_context,json=cloneContext,proto3" json:"clone_context,omitempty"`
}

func (x *InstancesCloneRequest) Reset() {
	*x = InstancesCloneRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstancesCloneRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancesCloneRequest) ProtoMessage() {}

func (x *InstancesCloneRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancesCloneRequest.ProtoReflect.Descriptor instead.
func (*InstancesCloneRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{24}
}

func (x *InstancesCloneRequest) GetCloneContext() *CloneContext {
	if x != nil {
		return x.CloneContext
	}
	return nil
}

// Database demote primary instance request.
type InstancesDemoteMasterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains details about the demoteMaster operation.
	DemoteMasterContext *DemoteMasterContext `protobuf:"bytes,1,opt,name=demote_master_context,json=demoteMasterContext,proto3" json:"demote_master_context,omitempty"`
}

func (x *InstancesDemoteMasterRequest) Reset() {
	*x = InstancesDemoteMasterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstancesDemoteMasterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancesDemoteMasterRequest) ProtoMessage() {}

func (x *InstancesDemoteMasterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancesDemoteMasterRequest.ProtoReflect.Descriptor instead.
func (*InstancesDemoteMasterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{25}
}

func (x *InstancesDemoteMasterRequest) GetDemoteMasterContext() *DemoteMasterContext {
	if x != nil {
		return x.DemoteMasterContext
	}
	return nil
}

// Database instance export request.
type InstancesExportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains details about the export operation.
	ExportContext *ExportContext `protobuf:"bytes,1,opt,name=export_context,json=exportContext,proto3" json:"export_context,omitempty"`
}

func (x *InstancesExportRequest) Reset() {
	*x = InstancesExportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstancesExportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancesExportRequest) ProtoMessage() {}

func (x *InstancesExportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancesExportRequest.ProtoReflect.Descriptor instead.
func (*InstancesExportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{26}
}

func (x *InstancesExportRequest) GetExportContext() *ExportContext {
	if x != nil {
		return x.ExportContext
	}
	return nil
}

// Instance failover request.
type InstancesFailoverRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Failover Context.
	FailoverContext *FailoverContext `protobuf:"bytes,1,opt,name=failover_context,json=failoverContext,proto3" json:"failover_context,omitempty"`
}

func (x *InstancesFailoverRequest) Reset() {
	*x = InstancesFailoverRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstancesFailoverRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancesFailoverRequest) ProtoMessage() {}

func (x *InstancesFailoverRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancesFailoverRequest.ProtoReflect.Descriptor instead.
func (*InstancesFailoverRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{27}
}

func (x *InstancesFailoverRequest) GetFailoverContext() *FailoverContext {
	if x != nil {
		return x.FailoverContext
	}
	return nil
}

// Database instance import request.
type InstancesImportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains details about the import operation.
	ImportContext *ImportContext `protobuf:"bytes,1,opt,name=import_context,json=importContext,proto3" json:"import_context,omitempty"`
}

func (x *InstancesImportRequest) Reset() {
	*x = InstancesImportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstancesImportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancesImportRequest) ProtoMessage() {}

func (x *InstancesImportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancesImportRequest.ProtoReflect.Descriptor instead.
func (*InstancesImportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{28}
}

func (x *InstancesImportRequest) GetImportContext() *ImportContext {
	if x != nil {
		return x.ImportContext
	}
	return nil
}

// MySQL-specific external server sync settings.
type MySqlSyncConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Flags to use for the initial dump.
	InitialSyncFlags []*SyncFlags `protobuf:"bytes,1,rep,name=initial_sync_flags,json=initialSyncFlags,proto3" json:"initial_sync_flags,omitempty"`
}

func (x *MySqlSyncConfig) Reset() {
	*x = MySqlSyncConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MySqlSyncConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MySqlSyncConfig) ProtoMessage() {}

func (x *MySqlSyncConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MySqlSyncConfig.ProtoReflect.Descriptor instead.
func (*MySqlSyncConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{29}
}

func (x *MySqlSyncConfig) GetInitialSyncFlags() []*SyncFlags {
	if x != nil {
		return x.InitialSyncFlags
	}
	return nil
}

// Database instances list response.
type InstancesListResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#instancesList`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// List of warnings that occurred while handling the request.
	Warnings []*ApiWarning `protobuf:"bytes,2,rep,name=warnings,proto3" json:"warnings,omitempty"`
	// List of database instance resources.
	Items []*DatabaseInstance `protobuf:"bytes,3,rep,name=items,proto3" json:"items,omitempty"`
	// The continuation token, used to page through large result sets. Provide
	// this value in a subsequent request to return the next page of results.
	NextPageToken string `protobuf:"bytes,4,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *InstancesListResponse) Reset() {
	*x = InstancesListResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstancesListResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancesListResponse) ProtoMessage() {}

func (x *InstancesListResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancesListResponse.ProtoReflect.Descriptor instead.
func (*InstancesListResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{30}
}

func (x *InstancesListResponse) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *InstancesListResponse) GetWarnings() []*ApiWarning {
	if x != nil {
		return x.Warnings
	}
	return nil
}

func (x *InstancesListResponse) GetItems() []*DatabaseInstance {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *InstancesListResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Instances ListServerCas response.
type InstancesListServerCasResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of server CA certificates for the instance.
	Certs         []*SslCert `protobuf:"bytes,1,rep,name=certs,proto3" json:"certs,omitempty"`
	ActiveVersion string     `protobuf:"bytes,2,opt,name=active_version,json=activeVersion,proto3" json:"active_version,omitempty"`
	// This is always `sql#instancesListServerCas`.
	Kind string `protobuf:"bytes,3,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *InstancesListServerCasResponse) Reset() {
	*x = InstancesListServerCasResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstancesListServerCasResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancesListServerCasResponse) ProtoMessage() {}

func (x *InstancesListServerCasResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancesListServerCasResponse.ProtoReflect.Descriptor instead.
func (*InstancesListServerCasResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{31}
}

func (x *InstancesListServerCasResponse) GetCerts() []*SslCert {
	if x != nil {
		return x.Certs
	}
	return nil
}

func (x *InstancesListServerCasResponse) GetActiveVersion() string {
	if x != nil {
		return x.ActiveVersion
	}
	return ""
}

func (x *InstancesListServerCasResponse) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// Database instance restore backup request.
type InstancesRestoreBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parameters required to perform the restore backup operation.
	RestoreBackupContext *RestoreBackupContext `protobuf:"bytes,1,opt,name=restore_backup_context,json=restoreBackupContext,proto3" json:"restore_backup_context,omitempty"`
}

func (x *InstancesRestoreBackupRequest) Reset() {
	*x = InstancesRestoreBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstancesRestoreBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancesRestoreBackupRequest) ProtoMessage() {}

func (x *InstancesRestoreBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancesRestoreBackupRequest.ProtoReflect.Descriptor instead.
func (*InstancesRestoreBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{32}
}

func (x *InstancesRestoreBackupRequest) GetRestoreBackupContext() *RestoreBackupContext {
	if x != nil {
		return x.RestoreBackupContext
	}
	return nil
}

// Rotate Server CA request.
type InstancesRotateServerCaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains details about the rotate server CA operation.
	RotateServerCaContext *RotateServerCaContext `protobuf:"bytes,1,opt,name=rotate_server_ca_context,json=rotateServerCaContext,proto3" json:"rotate_server_ca_context,omitempty"`
}

func (x *InstancesRotateServerCaRequest) Reset() {
	*x = InstancesRotateServerCaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstancesRotateServerCaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancesRotateServerCaRequest) ProtoMessage() {}

func (x *InstancesRotateServerCaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancesRotateServerCaRequest.ProtoReflect.Descriptor instead.
func (*InstancesRotateServerCaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{33}
}

func (x *InstancesRotateServerCaRequest) GetRotateServerCaContext() *RotateServerCaContext {
	if x != nil {
		return x.RotateServerCaContext
	}
	return nil
}

// Instance truncate log request.
type InstancesTruncateLogRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains details about the truncate log operation.
	TruncateLogContext *TruncateLogContext `protobuf:"bytes,1,opt,name=truncate_log_context,json=truncateLogContext,proto3" json:"truncate_log_context,omitempty"`
}

func (x *InstancesTruncateLogRequest) Reset() {
	*x = InstancesTruncateLogRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstancesTruncateLogRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancesTruncateLogRequest) ProtoMessage() {}

func (x *InstancesTruncateLogRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancesTruncateLogRequest.ProtoReflect.Descriptor instead.
func (*InstancesTruncateLogRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{34}
}

func (x *InstancesTruncateLogRequest) GetTruncateLogContext() *TruncateLogContext {
	if x != nil {
		return x.TruncateLogContext
	}
	return nil
}

// Instance verify external sync settings response.
type SqlInstancesVerifyExternalSyncSettingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#migrationSettingErrorList`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// List of migration violations.
	Errors []*SqlExternalSyncSettingError `protobuf:"bytes,2,rep,name=errors,proto3" json:"errors,omitempty"`
	// List of migration warnings.
	Warnings []*SqlExternalSyncSettingError `protobuf:"bytes,3,rep,name=warnings,proto3" json:"warnings,omitempty"`
}

func (x *SqlInstancesVerifyExternalSyncSettingsResponse) Reset() {
	*x = SqlInstancesVerifyExternalSyncSettingsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesVerifyExternalSyncSettingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesVerifyExternalSyncSettingsResponse) ProtoMessage() {}

func (x *SqlInstancesVerifyExternalSyncSettingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesVerifyExternalSyncSettingsResponse.ProtoReflect.Descriptor instead.
func (*SqlInstancesVerifyExternalSyncSettingsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{35}
}

func (x *SqlInstancesVerifyExternalSyncSettingsResponse) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *SqlInstancesVerifyExternalSyncSettingsResponse) GetErrors() []*SqlExternalSyncSettingError {
	if x != nil {
		return x.Errors
	}
	return nil
}

func (x *SqlInstancesVerifyExternalSyncSettingsResponse) GetWarnings() []*SqlExternalSyncSettingError {
	if x != nil {
		return x.Warnings
	}
	return nil
}

// External primary instance migration setting error/warning.
type SqlExternalSyncSettingError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Can be `sql#externalSyncSettingError` or
	// `sql#externalSyncSettingWarning`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// Identifies the specific error that occurred.
	Type SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.sql.v1beta4.SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType" json:"type,omitempty"`
	// Additional information about the error encountered.
	Detail string `protobuf:"bytes,3,opt,name=detail,proto3" json:"detail,omitempty"`
}

func (x *SqlExternalSyncSettingError) Reset() {
	*x = SqlExternalSyncSettingError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlExternalSyncSettingError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlExternalSyncSettingError) ProtoMessage() {}

func (x *SqlExternalSyncSettingError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlExternalSyncSettingError.ProtoReflect.Descriptor instead.
func (*SqlExternalSyncSettingError) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{36}
}

func (x *SqlExternalSyncSettingError) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *SqlExternalSyncSettingError) GetType() SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType {
	if x != nil {
		return x.Type
	}
	return SqlExternalSyncSettingError_SQL_EXTERNAL_SYNC_SETTING_ERROR_TYPE_UNSPECIFIED
}

func (x *SqlExternalSyncSettingError) GetDetail() string {
	if x != nil {
		return x.Detail
	}
	return ""
}

// IP Management configuration.
type IpConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the instance is assigned a public IP address or not.
	Ipv4Enabled *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=ipv4_enabled,json=ipv4Enabled,proto3" json:"ipv4_enabled,omitempty"`
	// The resource link for the VPC network from which the Cloud SQL instance is
	// accessible for private IP. For example,
	// `/projects/myProject/global/networks/default`. This setting can
	// be updated, but it cannot be removed after it is set.
	PrivateNetwork string `protobuf:"bytes,2,opt,name=private_network,json=privateNetwork,proto3" json:"private_network,omitempty"`
	// Whether SSL connections over IP are enforced or not.
	RequireSsl *wrapperspb.BoolValue `protobuf:"bytes,3,opt,name=require_ssl,json=requireSsl,proto3" json:"require_ssl,omitempty"`
	// The list of external networks that are allowed to connect to the instance
	// using the IP. In 'CIDR' notation, also known as 'slash' notation (for
	// example: `157.197.200.0/24`).
	AuthorizedNetworks []*AclEntry `protobuf:"bytes,4,rep,name=authorized_networks,json=authorizedNetworks,proto3" json:"authorized_networks,omitempty"`
	// The name of the allocated ip range for the private ip CloudSQL instance.
	// For example: "google-managed-services-default". If set, the instance ip
	// will be created in the allocated range. The range name must comply with
	// [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name
	// must be 1-63 characters long and match the regular expression
	// `[a-z]([-a-z0-9]*[a-z0-9])?.`
	AllocatedIpRange string `protobuf:"bytes,6,opt,name=allocated_ip_range,json=allocatedIpRange,proto3" json:"allocated_ip_range,omitempty"`
}

func (x *IpConfiguration) Reset() {
	*x = IpConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IpConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IpConfiguration) ProtoMessage() {}

func (x *IpConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IpConfiguration.ProtoReflect.Descriptor instead.
func (*IpConfiguration) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{37}
}

func (x *IpConfiguration) GetIpv4Enabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Ipv4Enabled
	}
	return nil
}

func (x *IpConfiguration) GetPrivateNetwork() string {
	if x != nil {
		return x.PrivateNetwork
	}
	return ""
}

func (x *IpConfiguration) GetRequireSsl() *wrapperspb.BoolValue {
	if x != nil {
		return x.RequireSsl
	}
	return nil
}

func (x *IpConfiguration) GetAuthorizedNetworks() []*AclEntry {
	if x != nil {
		return x.AuthorizedNetworks
	}
	return nil
}

func (x *IpConfiguration) GetAllocatedIpRange() string {
	if x != nil {
		return x.AllocatedIpRange
	}
	return ""
}

// Database instance IP Mapping.
type IpMapping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of this IP address. A `PRIMARY` address is a public address that
	// can accept incoming connections. A `PRIVATE` address is a private address
	// that can accept incoming connections. An `OUTGOING` address is the source
	// address of connections originating from the instance, if supported.
	Type SqlIpAddressType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.sql.v1beta4.SqlIpAddressType" json:"type,omitempty"`
	// The IP address assigned.
	IpAddress string `protobuf:"bytes,2,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// The due time for this IP to be retired in
	// [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`. This field is only available when
	// the IP is scheduled to be retired.
	TimeToRetire *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=time_to_retire,json=timeToRetire,proto3" json:"time_to_retire,omitempty"`
}

func (x *IpMapping) Reset() {
	*x = IpMapping{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IpMapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IpMapping) ProtoMessage() {}

func (x *IpMapping) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IpMapping.ProtoReflect.Descriptor instead.
func (*IpMapping) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{38}
}

func (x *IpMapping) GetType() SqlIpAddressType {
	if x != nil {
		return x.Type
	}
	return SqlIpAddressType_SQL_IP_ADDRESS_TYPE_UNSPECIFIED
}

func (x *IpMapping) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *IpMapping) GetTimeToRetire() *timestamppb.Timestamp {
	if x != nil {
		return x.TimeToRetire
	}
	return nil
}

// Preferred location. This specifies where a Cloud SQL instance is located.
// Note that if the preferred location is not available, the instance will be
// located as close as possible within the region. Only one location may be
// specified.
type LocationPreference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The App Engine application to follow, it must be in the same region as the
	// Cloud SQL instance. WARNING: Changing this might restart the instance.
	//
	// Deprecated: Do not use.
	FollowGaeApplication string `protobuf:"bytes,1,opt,name=follow_gae_application,json=followGaeApplication,proto3" json:"follow_gae_application,omitempty"`
	// The preferred Compute Engine zone (for example: us-central1-a,
	// us-central1-b, etc.). WARNING: Changing this might restart the instance.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// The preferred Compute Engine zone for the secondary/failover
	// (for example: us-central1-a, us-central1-b, etc.).
	SecondaryZone string `protobuf:"bytes,4,opt,name=secondary_zone,json=secondaryZone,proto3" json:"secondary_zone,omitempty"`
	// This is always `sql#locationPreference`.
	Kind string `protobuf:"bytes,3,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *LocationPreference) Reset() {
	*x = LocationPreference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocationPreference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationPreference) ProtoMessage() {}

func (x *LocationPreference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationPreference.ProtoReflect.Descriptor instead.
func (*LocationPreference) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{39}
}

// Deprecated: Do not use.
func (x *LocationPreference) GetFollowGaeApplication() string {
	if x != nil {
		return x.FollowGaeApplication
	}
	return ""
}

func (x *LocationPreference) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *LocationPreference) GetSecondaryZone() string {
	if x != nil {
		return x.SecondaryZone
	}
	return ""
}

func (x *LocationPreference) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// Maintenance window. This specifies when a Cloud SQL instance
// is restarted for system maintenance purposes.
type MaintenanceWindow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// hour of day - 0 to 23.
	Hour *wrapperspb.Int32Value `protobuf:"bytes,1,opt,name=hour,proto3" json:"hour,omitempty"`
	// day of week (1-7), starting on Monday.
	Day *wrapperspb.Int32Value `protobuf:"bytes,2,opt,name=day,proto3" json:"day,omitempty"`
	// Maintenance timing setting: `canary` (Earlier) or `stable` (Later).
	// [Learn
	// more](https://cloud.google.com/sql/docs/mysql/instance-settings#maintenance-timing-2ndgen).
	UpdateTrack SqlUpdateTrack `protobuf:"varint,3,opt,name=update_track,json=updateTrack,proto3,enum=google.cloud.sql.v1beta4.SqlUpdateTrack" json:"update_track,omitempty"`
	// This is always `sql#maintenanceWindow`.
	Kind string `protobuf:"bytes,4,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *MaintenanceWindow) Reset() {
	*x = MaintenanceWindow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MaintenanceWindow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaintenanceWindow) ProtoMessage() {}

func (x *MaintenanceWindow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaintenanceWindow.ProtoReflect.Descriptor instead.
func (*MaintenanceWindow) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{40}
}

func (x *MaintenanceWindow) GetHour() *wrapperspb.Int32Value {
	if x != nil {
		return x.Hour
	}
	return nil
}

func (x *MaintenanceWindow) GetDay() *wrapperspb.Int32Value {
	if x != nil {
		return x.Day
	}
	return nil
}

func (x *MaintenanceWindow) GetUpdateTrack() SqlUpdateTrack {
	if x != nil {
		return x.UpdateTrack
	}
	return SqlUpdateTrack_SQL_UPDATE_TRACK_UNSPECIFIED
}

func (x *MaintenanceWindow) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// Deny Maintenance Periods. This specifies a date range during when all CSA
// rollout will be denied.
type DenyMaintenancePeriod struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// "deny maintenance period" start date. If the year of the start date is
	// empty, the year of the end date also must be empty. In this case, it means
	// the deny maintenance period recurs every year. The date is in format
	// yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
	StartDate string `protobuf:"bytes,1,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// "deny maintenance period" end date. If the year of the end date is empty,
	// the year of the start date also must be empty. In this case, it means the
	// deny maintenance period recurs every year. The date is in format yyyy-mm-dd
	// i.e., 2020-11-01, or mm-dd, i.e., 11-01
	EndDate string `protobuf:"bytes,2,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	// Time in UTC when the "deny maintenance period" starts on start_date and
	// ends on end_date. The time is in format: HH:mm:SS, i.e., 00:00:00
	Time string `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *DenyMaintenancePeriod) Reset() {
	*x = DenyMaintenancePeriod{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DenyMaintenancePeriod) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DenyMaintenancePeriod) ProtoMessage() {}

func (x *DenyMaintenancePeriod) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DenyMaintenancePeriod.ProtoReflect.Descriptor instead.
func (*DenyMaintenancePeriod) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{41}
}

func (x *DenyMaintenancePeriod) GetStartDate() string {
	if x != nil {
		return x.StartDate
	}
	return ""
}

func (x *DenyMaintenancePeriod) GetEndDate() string {
	if x != nil {
		return x.EndDate
	}
	return ""
}

func (x *DenyMaintenancePeriod) GetTime() string {
	if x != nil {
		return x.Time
	}
	return ""
}

// Insights configuration. This specifies when Cloud SQL Insights feature is
// enabled and optional configuration.
type InsightsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether Query Insights feature is enabled.
	QueryInsightsEnabled bool `protobuf:"varint,1,opt,name=query_insights_enabled,json=queryInsightsEnabled,proto3" json:"query_insights_enabled,omitempty"`
	// Whether Query Insights will record client address when enabled.
	RecordClientAddress bool `protobuf:"varint,2,opt,name=record_client_address,json=recordClientAddress,proto3" json:"record_client_address,omitempty"`
	// Whether Query Insights will record application tags from query when
	// enabled.
	RecordApplicationTags bool `protobuf:"varint,3,opt,name=record_application_tags,json=recordApplicationTags,proto3" json:"record_application_tags,omitempty"`
	// Maximum query length stored in bytes. Default value: 1024 bytes.
	// Range: 256-4500 bytes. Query length more than this field value will be
	// truncated to this value. When unset, query length will be the default
	// value. Changing query length will restart the database.
	QueryStringLength *wrapperspb.Int32Value `protobuf:"bytes,4,opt,name=query_string_length,json=queryStringLength,proto3" json:"query_string_length,omitempty"`
	// Number of query execution plans captured by Insights per minute
	// for all queries combined. Default is 5.
	QueryPlansPerMinute *wrapperspb.Int32Value `protobuf:"bytes,5,opt,name=query_plans_per_minute,json=queryPlansPerMinute,proto3" json:"query_plans_per_minute,omitempty"`
}

func (x *InsightsConfig) Reset() {
	*x = InsightsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InsightsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InsightsConfig) ProtoMessage() {}

func (x *InsightsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InsightsConfig.ProtoReflect.Descriptor instead.
func (*InsightsConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{42}
}

func (x *InsightsConfig) GetQueryInsightsEnabled() bool {
	if x != nil {
		return x.QueryInsightsEnabled
	}
	return false
}

func (x *InsightsConfig) GetRecordClientAddress() bool {
	if x != nil {
		return x.RecordClientAddress
	}
	return false
}

func (x *InsightsConfig) GetRecordApplicationTags() bool {
	if x != nil {
		return x.RecordApplicationTags
	}
	return false
}

func (x *InsightsConfig) GetQueryStringLength() *wrapperspb.Int32Value {
	if x != nil {
		return x.QueryStringLength
	}
	return nil
}

func (x *InsightsConfig) GetQueryPlansPerMinute() *wrapperspb.Int32Value {
	if x != nil {
		return x.QueryPlansPerMinute
	}
	return nil
}

// Read-replica configuration specific to MySQL databases.
type MySqlReplicaConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path to a SQL dump file in Google Cloud Storage from which the replica
	// instance is to be created. The URI is in the form gs://bucketName/fileName.
	// Compressed gzip files (.gz) are also supported.
	// Dumps have the binlog co-ordinates from which replication
	// begins. This can be accomplished by setting --master-data to 1 when using
	// mysqldump.
	DumpFilePath string `protobuf:"bytes,1,opt,name=dump_file_path,json=dumpFilePath,proto3" json:"dump_file_path,omitempty"`
	// The username for the replication connection.
	Username string `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
	// The password for the replication connection.
	Password string `protobuf:"bytes,3,opt,name=password,proto3" json:"password,omitempty"`
	// Seconds to wait between connect retries. MySQL's default is 60 seconds.
	ConnectRetryInterval *wrapperspb.Int32Value `protobuf:"bytes,4,opt,name=connect_retry_interval,json=connectRetryInterval,proto3" json:"connect_retry_interval,omitempty"`
	// Interval in milliseconds between replication heartbeats.
	MasterHeartbeatPeriod *wrapperspb.Int64Value `protobuf:"bytes,5,opt,name=master_heartbeat_period,json=masterHeartbeatPeriod,proto3" json:"master_heartbeat_period,omitempty"`
	// PEM representation of the trusted CA's x509 certificate.
	CaCertificate string `protobuf:"bytes,6,opt,name=ca_certificate,json=caCertificate,proto3" json:"ca_certificate,omitempty"`
	// PEM representation of the replica's x509 certificate.
	ClientCertificate string `protobuf:"bytes,7,opt,name=client_certificate,json=clientCertificate,proto3" json:"client_certificate,omitempty"`
	// PEM representation of the replica's private key. The corresponsing public
	// key is encoded in the client's certificate.
	ClientKey string `protobuf:"bytes,8,opt,name=client_key,json=clientKey,proto3" json:"client_key,omitempty"`
	// A list of permissible ciphers to use for SSL encryption.
	SslCipher string `protobuf:"bytes,9,opt,name=ssl_cipher,json=sslCipher,proto3" json:"ssl_cipher,omitempty"`
	// Whether or not to check the primary instance's Common Name value in the
	// certificate that it sends during the SSL handshake.
	VerifyServerCertificate *wrapperspb.BoolValue `protobuf:"bytes,10,opt,name=verify_server_certificate,json=verifyServerCertificate,proto3" json:"verify_server_certificate,omitempty"`
	// This is always `sql#mysqlReplicaConfiguration`.
	Kind string `protobuf:"bytes,11,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *MySqlReplicaConfiguration) Reset() {
	*x = MySqlReplicaConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MySqlReplicaConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MySqlReplicaConfiguration) ProtoMessage() {}

func (x *MySqlReplicaConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MySqlReplicaConfiguration.ProtoReflect.Descriptor instead.
func (*MySqlReplicaConfiguration) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{43}
}

func (x *MySqlReplicaConfiguration) GetDumpFilePath() string {
	if x != nil {
		return x.DumpFilePath
	}
	return ""
}

func (x *MySqlReplicaConfiguration) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *MySqlReplicaConfiguration) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *MySqlReplicaConfiguration) GetConnectRetryInterval() *wrapperspb.Int32Value {
	if x != nil {
		return x.ConnectRetryInterval
	}
	return nil
}

func (x *MySqlReplicaConfiguration) GetMasterHeartbeatPeriod() *wrapperspb.Int64Value {
	if x != nil {
		return x.MasterHeartbeatPeriod
	}
	return nil
}

func (x *MySqlReplicaConfiguration) GetCaCertificate() string {
	if x != nil {
		return x.CaCertificate
	}
	return ""
}

func (x *MySqlReplicaConfiguration) GetClientCertificate() string {
	if x != nil {
		return x.ClientCertificate
	}
	return ""
}

func (x *MySqlReplicaConfiguration) GetClientKey() string {
	if x != nil {
		return x.ClientKey
	}
	return ""
}

func (x *MySqlReplicaConfiguration) GetSslCipher() string {
	if x != nil {
		return x.SslCipher
	}
	return ""
}

func (x *MySqlReplicaConfiguration) GetVerifyServerCertificate() *wrapperspb.BoolValue {
	if x != nil {
		return x.VerifyServerCertificate
	}
	return nil
}

func (x *MySqlReplicaConfiguration) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// On-premises instance configuration.
type OnPremisesConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The host and port of the on-premises instance in host:port format
	HostPort string `protobuf:"bytes,1,opt,name=host_port,json=hostPort,proto3" json:"host_port,omitempty"`
	// This is always `sql#onPremisesConfiguration`.
	Kind string `protobuf:"bytes,2,opt,name=kind,proto3" json:"kind,omitempty"`
	// The username for connecting to on-premises instance.
	Username string `protobuf:"bytes,3,opt,name=username,proto3" json:"username,omitempty"`
	// The password for connecting to on-premises instance.
	Password string `protobuf:"bytes,4,opt,name=password,proto3" json:"password,omitempty"`
	// PEM representation of the trusted CA's x509 certificate.
	CaCertificate string `protobuf:"bytes,5,opt,name=ca_certificate,json=caCertificate,proto3" json:"ca_certificate,omitempty"`
	// PEM representation of the replica's x509 certificate.
	ClientCertificate string `protobuf:"bytes,6,opt,name=client_certificate,json=clientCertificate,proto3" json:"client_certificate,omitempty"`
	// PEM representation of the replica's private key. The corresponsing public
	// key is encoded in the client's certificate.
	ClientKey string `protobuf:"bytes,7,opt,name=client_key,json=clientKey,proto3" json:"client_key,omitempty"`
	// The dump file to create the Cloud SQL replica.
	DumpFilePath string `protobuf:"bytes,8,opt,name=dump_file_path,json=dumpFilePath,proto3" json:"dump_file_path,omitempty"`
	// The reference to Cloud SQL instance if the source is Cloud SQL.
	SourceInstance *InstanceReference `protobuf:"bytes,15,opt,name=source_instance,json=sourceInstance,proto3" json:"source_instance,omitempty"`
}

func (x *OnPremisesConfiguration) Reset() {
	*x = OnPremisesConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OnPremisesConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnPremisesConfiguration) ProtoMessage() {}

func (x *OnPremisesConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnPremisesConfiguration.ProtoReflect.Descriptor instead.
func (*OnPremisesConfiguration) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{44}
}

func (x *OnPremisesConfiguration) GetHostPort() string {
	if x != nil {
		return x.HostPort
	}
	return ""
}

func (x *OnPremisesConfiguration) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *OnPremisesConfiguration) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *OnPremisesConfiguration) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *OnPremisesConfiguration) GetCaCertificate() string {
	if x != nil {
		return x.CaCertificate
	}
	return ""
}

func (x *OnPremisesConfiguration) GetClientCertificate() string {
	if x != nil {
		return x.ClientCertificate
	}
	return ""
}

func (x *OnPremisesConfiguration) GetClientKey() string {
	if x != nil {
		return x.ClientKey
	}
	return ""
}

func (x *OnPremisesConfiguration) GetDumpFilePath() string {
	if x != nil {
		return x.DumpFilePath
	}
	return ""
}

func (x *OnPremisesConfiguration) GetSourceInstance() *InstanceReference {
	if x != nil {
		return x.SourceInstance
	}
	return nil
}

// Disk encryption configuration for an instance.
type DiskEncryptionConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of KMS key for disk encryption
	KmsKeyName string `protobuf:"bytes,1,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// This is always `sql#diskEncryptionConfiguration`.
	Kind string `protobuf:"bytes,2,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *DiskEncryptionConfiguration) Reset() {
	*x = DiskEncryptionConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskEncryptionConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskEncryptionConfiguration) ProtoMessage() {}

func (x *DiskEncryptionConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskEncryptionConfiguration.ProtoReflect.Descriptor instead.
func (*DiskEncryptionConfiguration) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{45}
}

func (x *DiskEncryptionConfiguration) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *DiskEncryptionConfiguration) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// Disk encryption status for an instance.
type DiskEncryptionStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// KMS key version used to encrypt the Cloud SQL instance resource
	KmsKeyVersionName string `protobuf:"bytes,1,opt,name=kms_key_version_name,json=kmsKeyVersionName,proto3" json:"kms_key_version_name,omitempty"`
	// This is always `sql#diskEncryptionStatus`.
	Kind string `protobuf:"bytes,2,opt,name=kind,proto3" json:"kind,omitempty"`
}

func (x *DiskEncryptionStatus) Reset() {
	*x = DiskEncryptionStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DiskEncryptionStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskEncryptionStatus) ProtoMessage() {}

func (x *DiskEncryptionStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskEncryptionStatus.ProtoReflect.Descriptor instead.
func (*DiskEncryptionStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{46}
}

func (x *DiskEncryptionStatus) GetKmsKeyVersionName() string {
	if x != nil {
		return x.KmsKeyVersionName
	}
	return ""
}

func (x *DiskEncryptionStatus) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

// An Operation resource.&nbsp;For successful operations that return an
// Operation resource, only the fields relevant to the operation are populated
// in the resource.
type Operation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#operation`.
	Kind       string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	TargetLink string `protobuf:"bytes,2,opt,name=target_link,json=targetLink,proto3" json:"target_link,omitempty"`
	// The status of an operation.
	Status Operation_SqlOperationStatus `protobuf:"varint,3,opt,name=status,proto3,enum=google.cloud.sql.v1beta4.Operation_SqlOperationStatus" json:"status,omitempty"`
	// The email address of the user who initiated this operation.
	User string `protobuf:"bytes,4,opt,name=user,proto3" json:"user,omitempty"`
	// The time this operation was enqueued in UTC timezone in
	// [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	InsertTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=insert_time,json=insertTime,proto3" json:"insert_time,omitempty"`
	// The time this operation actually started in UTC timezone in
	// [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time this operation finished in UTC timezone in
	// [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// If errors occurred during processing of this operation, this field will be
	// populated.
	Error *OperationErrors `protobuf:"bytes,8,opt,name=error,proto3" json:"error,omitempty"`
	// The type of the operation. Valid values are:
	// *  `CREATE`
	// *  `DELETE`
	// *  `UPDATE`
	// *  `RESTART`
	// *  `IMPORT`
	// *  `EXPORT`
	// *  `BACKUP_VOLUME`
	// *  `RESTORE_VOLUME`
	// *  `CREATE_USER`
	// *  `DELETE_USER`
	// *  `CREATE_DATABASE`
	// *  `DELETE_DATABASE`
	OperationType Operation_SqlOperationType `protobuf:"varint,9,opt,name=operation_type,json=operationType,proto3,enum=google.cloud.sql.v1beta4.Operation_SqlOperationType" json:"operation_type,omitempty"`
	// The context for import operation, if applicable.
	ImportContext *ImportContext `protobuf:"bytes,10,opt,name=import_context,json=importContext,proto3" json:"import_context,omitempty"`
	// The context for export operation, if applicable.
	ExportContext *ExportContext `protobuf:"bytes,11,opt,name=export_context,json=exportContext,proto3" json:"export_context,omitempty"`
	// The context for backup operation, if applicable.
	BackupContext *BackupContext `protobuf:"bytes,17,opt,name=backup_context,json=backupContext,proto3" json:"backup_context,omitempty"`
	// An identifier that uniquely identifies the operation. You can use this
	// identifier to retrieve the Operations resource that has information about
	// the operation.
	Name string `protobuf:"bytes,12,opt,name=name,proto3" json:"name,omitempty"`
	// Name of the database instance related to this operation.
	TargetId string `protobuf:"bytes,13,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// The URI of this resource.
	SelfLink string `protobuf:"bytes,14,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// The project ID of the target instance related to this operation.
	TargetProject string `protobuf:"bytes,15,opt,name=target_project,json=targetProject,proto3" json:"target_project,omitempty"`
}

func (x *Operation) Reset() {
	*x = Operation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Operation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Operation) ProtoMessage() {}

func (x *Operation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Operation.ProtoReflect.Descriptor instead.
func (*Operation) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{47}
}

func (x *Operation) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *Operation) GetTargetLink() string {
	if x != nil {
		return x.TargetLink
	}
	return ""
}

func (x *Operation) GetStatus() Operation_SqlOperationStatus {
	if x != nil {
		return x.Status
	}
	return Operation_SQL_OPERATION_STATUS_UNSPECIFIED
}

func (x *Operation) GetUser() string {
	if x != nil {
		return x.User
	}
	return ""
}

func (x *Operation) GetInsertTime() *timestamppb.Timestamp {
	if x != nil {
		return x.InsertTime
	}
	return nil
}

func (x *Operation) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Operation) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Operation) GetError() *OperationErrors {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *Operation) GetOperationType() Operation_SqlOperationType {
	if x != nil {
		return x.OperationType
	}
	return Operation_SQL_OPERATION_TYPE_UNSPECIFIED
}

func (x *Operation) GetImportContext() *ImportContext {
	if x != nil {
		return x.ImportContext
	}
	return nil
}

func (x *Operation) GetExportContext() *ExportContext {
	if x != nil {
		return x.ExportContext
	}
	return nil
}

func (x *Operation) GetBackupContext() *BackupContext {
	if x != nil {
		return x.BackupContext
	}
	return nil
}

func (x *Operation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Operation) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *Operation) GetSelfLink() string {
	if x != nil {
		return x.SelfLink
	}
	return ""
}

func (x *Operation) GetTargetProject() string {
	if x != nil {
		return x.TargetProject
	}
	return ""
}

// Database instance operation error.
type OperationError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#operationError`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// Identifies the specific error that occurred.
	Code string `protobuf:"bytes,2,opt,name=code,proto3" json:"code,omitempty"`
	// Additional information about the error encountered.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *OperationError) Reset() {
	*x = OperationError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationError) ProtoMessage() {}

func (x *OperationError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationError.ProtoReflect.Descriptor instead.
func (*OperationError) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{48}
}

func (x *OperationError) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *OperationError) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

func (x *OperationError) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// Database instance operation errors list wrapper.
type OperationErrors struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#operationErrors`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The list of errors encountered while processing this operation.
	Errors []*OperationError `protobuf:"bytes,2,rep,name=errors,proto3" json:"errors,omitempty"`
}

func (x *OperationErrors) Reset() {
	*x = OperationErrors{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationErrors) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationErrors) ProtoMessage() {}

func (x *OperationErrors) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationErrors.ProtoReflect.Descriptor instead.
func (*OperationErrors) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{49}
}

func (x *OperationErrors) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *OperationErrors) GetErrors() []*OperationError {
	if x != nil {
		return x.Errors
	}
	return nil
}

// Database instance local user password validation policy
type PasswordValidationPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Minimum number of characters allowed.
	MinLength *wrapperspb.Int32Value `protobuf:"bytes,1,opt,name=min_length,json=minLength,proto3" json:"min_length,omitempty"`
	// The complexity of the password.
	Complexity PasswordValidationPolicy_Complexity `protobuf:"varint,2,opt,name=complexity,proto3,enum=google.cloud.sql.v1beta4.PasswordValidationPolicy_Complexity" json:"complexity,omitempty"`
	// Number of previous passwords that cannot be reused.
	ReuseInterval *wrapperspb.Int32Value `protobuf:"bytes,3,opt,name=reuse_interval,json=reuseInterval,proto3" json:"reuse_interval,omitempty"`
	// Disallow username as a part of the password.
	DisallowUsernameSubstring *wrapperspb.BoolValue `protobuf:"bytes,4,opt,name=disallow_username_substring,json=disallowUsernameSubstring,proto3" json:"disallow_username_substring,omitempty"`
	// Minimum interval after which the password can be changed. This flag is only
	// supported for PostgresSQL.
	PasswordChangeInterval *durationpb.Duration `protobuf:"bytes,5,opt,name=password_change_interval,json=passwordChangeInterval,proto3" json:"password_change_interval,omitempty"`
	// Whether the password policy is enabled or not.
	EnablePasswordPolicy *wrapperspb.BoolValue `protobuf:"bytes,6,opt,name=enable_password_policy,json=enablePasswordPolicy,proto3" json:"enable_password_policy,omitempty"`
}

func (x *PasswordValidationPolicy) Reset() {
	*x = PasswordValidationPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PasswordValidationPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PasswordValidationPolicy) ProtoMessage() {}

func (x *PasswordValidationPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PasswordValidationPolicy.ProtoReflect.Descriptor instead.
func (*PasswordValidationPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{50}
}

func (x *PasswordValidationPolicy) GetMinLength() *wrapperspb.Int32Value {
	if x != nil {
		return x.MinLength
	}
	return nil
}

func (x *PasswordValidationPolicy) GetComplexity() PasswordValidationPolicy_Complexity {
	if x != nil {
		return x.Complexity
	}
	return PasswordValidationPolicy_COMPLEXITY_UNSPECIFIED
}

func (x *PasswordValidationPolicy) GetReuseInterval() *wrapperspb.Int32Value {
	if x != nil {
		return x.ReuseInterval
	}
	return nil
}

func (x *PasswordValidationPolicy) GetDisallowUsernameSubstring() *wrapperspb.BoolValue {
	if x != nil {
		return x.DisallowUsernameSubstring
	}
	return nil
}

func (x *PasswordValidationPolicy) GetPasswordChangeInterval() *durationpb.Duration {
	if x != nil {
		return x.PasswordChangeInterval
	}
	return nil
}

func (x *PasswordValidationPolicy) GetEnablePasswordPolicy() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnablePasswordPolicy
	}
	return nil
}

// Operations list response.
type OperationsListResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#operationsList`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// List of operation resources.
	Items []*Operation `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
	// The continuation token, used to page through large result sets. Provide
	// this value in a subsequent request to return the next page of results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *OperationsListResponse) Reset() {
	*x = OperationsListResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationsListResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationsListResponse) ProtoMessage() {}

func (x *OperationsListResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationsListResponse.ProtoReflect.Descriptor instead.
func (*OperationsListResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{51}
}

func (x *OperationsListResponse) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *OperationsListResponse) GetItems() []*Operation {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *OperationsListResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Read-replica configuration for connecting to the primary instance.
type ReplicaConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#replicaConfiguration`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// MySQL specific configuration when replicating from a MySQL on-premises
	// primary instance. Replication configuration information such as the
	// username, password, certificates, and keys are not stored in the instance
	// metadata. The configuration information is used only to set up the
	// replication connection and is stored by MySQL in a file named
	// `master.info` in the data directory.
	MysqlReplicaConfiguration *MySqlReplicaConfiguration `protobuf:"bytes,2,opt,name=mysql_replica_configuration,json=mysqlReplicaConfiguration,proto3" json:"mysql_replica_configuration,omitempty"`
	// Specifies if the replica is the failover target. If the field is set to
	// `true` the replica will be designated as a failover replica. In case the
	// primary instance fails, the replica instance will be promoted as the new
	// primary instance. Only one replica can be specified as failover target, and
	// the replica has to be in different zone with the primary instance.
	FailoverTarget *wrapperspb.BoolValue `protobuf:"bytes,3,opt,name=failover_target,json=failoverTarget,proto3" json:"failover_target,omitempty"`
}

func (x *ReplicaConfiguration) Reset() {
	*x = ReplicaConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplicaConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicaConfiguration) ProtoMessage() {}

func (x *ReplicaConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicaConfiguration.ProtoReflect.Descriptor instead.
func (*ReplicaConfiguration) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{52}
}

func (x *ReplicaConfiguration) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *ReplicaConfiguration) GetMysqlReplicaConfiguration() *MySqlReplicaConfiguration {
	if x != nil {
		return x.MysqlReplicaConfiguration
	}
	return nil
}

func (x *ReplicaConfiguration) GetFailoverTarget() *wrapperspb.BoolValue {
	if x != nil {
		return x.FailoverTarget
	}
	return nil
}

// Database instance restore from backup context.
// Backup context contains source instance id and project id.
type RestoreBackupContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#restoreBackupContext`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The ID of the backup run to restore from.
	BackupRunId int64 `protobuf:"varint,2,opt,name=backup_run_id,json=backupRunId,proto3" json:"backup_run_id,omitempty"`
	// The ID of the instance that the backup was taken from.
	InstanceId string `protobuf:"bytes,3,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// The full project ID of the source instance.
	Project string `protobuf:"bytes,4,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *RestoreBackupContext) Reset() {
	*x = RestoreBackupContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreBackupContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreBackupContext) ProtoMessage() {}

func (x *RestoreBackupContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreBackupContext.ProtoReflect.Descriptor instead.
func (*RestoreBackupContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{53}
}

func (x *RestoreBackupContext) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *RestoreBackupContext) GetBackupRunId() int64 {
	if x != nil {
		return x.BackupRunId
	}
	return 0
}

func (x *RestoreBackupContext) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *RestoreBackupContext) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// Instance rotate server CA context.
type RotateServerCaContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#rotateServerCaContext`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The fingerprint of the next version to be rotated to. If left unspecified,
	// will be rotated to the most recently added server CA version.
	NextVersion string `protobuf:"bytes,2,opt,name=next_version,json=nextVersion,proto3" json:"next_version,omitempty"`
}

func (x *RotateServerCaContext) Reset() {
	*x = RotateServerCaContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RotateServerCaContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RotateServerCaContext) ProtoMessage() {}

func (x *RotateServerCaContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RotateServerCaContext.ProtoReflect.Descriptor instead.
func (*RotateServerCaContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{54}
}

func (x *RotateServerCaContext) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *RotateServerCaContext) GetNextVersion() string {
	if x != nil {
		return x.NextVersion
	}
	return ""
}

// Database instance settings.
type Settings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The version of instance settings. This is a required field for update
	// method to make sure concurrent updates are handled properly. During update,
	// use the most recent settingsVersion value for this instance and do not try
	// to update this value.
	SettingsVersion *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=settings_version,json=settingsVersion,proto3" json:"settings_version,omitempty"`
	// The App Engine app IDs that can access this instance.
	// (Deprecated) Applied to First Generation instances only.
	//
	// Deprecated: Do not use.
	AuthorizedGaeApplications []string `protobuf:"bytes,2,rep,name=authorized_gae_applications,json=authorizedGaeApplications,proto3" json:"authorized_gae_applications,omitempty"`
	// The tier (or machine type) for this instance, for example
	// `db-custom-1-3840`. WARNING: Changing this restarts the instance.
	Tier string `protobuf:"bytes,3,opt,name=tier,proto3" json:"tier,omitempty"`
	// This is always `sql#settings`.
	Kind string `protobuf:"bytes,4,opt,name=kind,proto3" json:"kind,omitempty"`
	// User-provided labels, represented as a dictionary where each label is a
	// single key value pair.
	UserLabels map[string]string `protobuf:"bytes,5,rep,name=user_labels,json=userLabels,proto3" json:"user_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Availability type. Potential values:
	// *  `ZONAL`: The instance serves data from only one zone. Outages in that
	// zone affect data accessibility.
	// *  `REGIONAL`: The instance can serve data from more than one zone in a
	// region (it is highly available)./
	//
	// For more information, see [Overview of the High Availability
	// Configuration](https://cloud.google.com/sql/docs/mysql/high-availability).
	AvailabilityType SqlAvailabilityType `protobuf:"varint,6,opt,name=availability_type,json=availabilityType,proto3,enum=google.cloud.sql.v1beta4.SqlAvailabilityType" json:"availability_type,omitempty"`
	// The pricing plan for this instance. This can be either `PER_USE` or
	// `PACKAGE`. Only `PER_USE` is supported for Second Generation instances.
	PricingPlan SqlPricingPlan `protobuf:"varint,7,opt,name=pricing_plan,json=pricingPlan,proto3,enum=google.cloud.sql.v1beta4.SqlPricingPlan" json:"pricing_plan,omitempty"`
	// The type of replication this instance uses. This can be either
	// `ASYNCHRONOUS` or `SYNCHRONOUS`. (Deprecated) This property was only
	// applicable to First Generation instances.
	//
	// Deprecated: Do not use.
	ReplicationType SqlReplicationType `protobuf:"varint,8,opt,name=replication_type,json=replicationType,proto3,enum=google.cloud.sql.v1beta4.SqlReplicationType" json:"replication_type,omitempty"`
	// The maximum size to which storage capacity can be automatically increased.
	// The default value is 0, which specifies that there is no limit.
	StorageAutoResizeLimit *wrapperspb.Int64Value `protobuf:"bytes,9,opt,name=storage_auto_resize_limit,json=storageAutoResizeLimit,proto3" json:"storage_auto_resize_limit,omitempty"`
	// The activation policy specifies when the instance is activated; it is
	// applicable only when the instance state is RUNNABLE. Valid values:
	// *  `ALWAYS`: The instance is on, and remains so even in the absence of
	// connection requests.
	// *  `NEVER`: The instance is off; it is not activated, even if a
	// connection request arrives.
	ActivationPolicy Settings_SqlActivationPolicy `protobuf:"varint,10,opt,name=activation_policy,json=activationPolicy,proto3,enum=google.cloud.sql.v1beta4.Settings_SqlActivationPolicy" json:"activation_policy,omitempty"`
	// The settings for IP Management. This allows to enable or disable the
	// instance IP and manage which external networks can connect to the instance.
	// The IPv4 address cannot be disabled for Second Generation instances.
	IpConfiguration *IpConfiguration `protobuf:"bytes,11,opt,name=ip_configuration,json=ipConfiguration,proto3" json:"ip_configuration,omitempty"`
	// Configuration to increase storage size automatically. The default value is
	// true.
	StorageAutoResize *wrapperspb.BoolValue `protobuf:"bytes,12,opt,name=storage_auto_resize,json=storageAutoResize,proto3" json:"storage_auto_resize,omitempty"`
	// The location preference settings. This allows the instance to be located as
	// near as possible to either an App Engine app or Compute Engine zone for
	// better performance. App Engine co-location was only applicable to First
	// Generation instances.
	LocationPreference *LocationPreference `protobuf:"bytes,13,opt,name=location_preference,json=locationPreference,proto3" json:"location_preference,omitempty"`
	// The database flags passed to the instance at startup.
	DatabaseFlags []*DatabaseFlags `protobuf:"bytes,14,rep,name=database_flags,json=databaseFlags,proto3" json:"database_flags,omitempty"`
	// The type of data disk: `PD_SSD` (default) or `PD_HDD`. Not used for
	// First Generation instances.
	DataDiskType SqlDataDiskType `protobuf:"varint,15,opt,name=data_disk_type,json=dataDiskType,proto3,enum=google.cloud.sql.v1beta4.SqlDataDiskType" json:"data_disk_type,omitempty"`
	// The maintenance window for this instance. This specifies when the instance
	// can be restarted for maintenance purposes.
	MaintenanceWindow *MaintenanceWindow `protobuf:"bytes,16,opt,name=maintenance_window,json=maintenanceWindow,proto3" json:"maintenance_window,omitempty"`
	// The daily backup configuration for the instance.
	BackupConfiguration *BackupConfiguration `protobuf:"bytes,17,opt,name=backup_configuration,json=backupConfiguration,proto3" json:"backup_configuration,omitempty"`
	// Configuration specific to read replica instances. Indicates whether
	// replication is enabled or not. WARNING: Changing this restarts the
	// instance.
	DatabaseReplicationEnabled *wrapperspb.BoolValue `protobuf:"bytes,18,opt,name=database_replication_enabled,json=databaseReplicationEnabled,proto3" json:"database_replication_enabled,omitempty"`
	// Configuration specific to read replica instances. Indicates whether
	// database flags for crash-safe replication are enabled. This property was
	// only applicable to First Generation instances.
	//
	// Deprecated: Do not use.
	CrashSafeReplicationEnabled *wrapperspb.BoolValue `protobuf:"bytes,19,opt,name=crash_safe_replication_enabled,json=crashSafeReplicationEnabled,proto3" json:"crash_safe_replication_enabled,omitempty"`
	// The size of data disk, in GB. The data disk size minimum is 10GB.
	DataDiskSizeGb *wrapperspb.Int64Value `protobuf:"bytes,20,opt,name=data_disk_size_gb,json=dataDiskSizeGb,proto3" json:"data_disk_size_gb,omitempty"`
	// Active Directory configuration, relevant only for Cloud SQL for SQL Server.
	ActiveDirectoryConfig *SqlActiveDirectoryConfig `protobuf:"bytes,22,opt,name=active_directory_config,json=activeDirectoryConfig,proto3" json:"active_directory_config,omitempty"`
	// The name of server Instance collation.
	Collation string `protobuf:"bytes,23,opt,name=collation,proto3" json:"collation,omitempty"`
	// Deny maintenance periods
	DenyMaintenancePeriods []*DenyMaintenancePeriod `protobuf:"bytes,24,rep,name=deny_maintenance_periods,json=denyMaintenancePeriods,proto3" json:"deny_maintenance_periods,omitempty"`
	// Insights configuration, for now relevant only for Postgres.
	InsightsConfig *InsightsConfig `protobuf:"bytes,25,opt,name=insights_config,json=insightsConfig,proto3" json:"insights_config,omitempty"`
	// The local user password validation policy of the instance.
	PasswordValidationPolicy *PasswordValidationPolicy `protobuf:"bytes,27,opt,name=password_validation_policy,json=passwordValidationPolicy,proto3" json:"password_validation_policy,omitempty"`
	// SQL Server specific audit configuration.
	SqlServerAuditConfig *SqlServerAuditConfig `protobuf:"bytes,29,opt,name=sql_server_audit_config,json=sqlServerAuditConfig,proto3" json:"sql_server_audit_config,omitempty"`
}

func (x *Settings) Reset() {
	*x = Settings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Settings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Settings) ProtoMessage() {}

func (x *Settings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Settings.ProtoReflect.Descriptor instead.
func (*Settings) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{55}
}

func (x *Settings) GetSettingsVersion() *wrapperspb.Int64Value {
	if x != nil {
		return x.SettingsVersion
	}
	return nil
}

// Deprecated: Do not use.
func (x *Settings) GetAuthorizedGaeApplications() []string {
	if x != nil {
		return x.AuthorizedGaeApplications
	}
	return nil
}

func (x *Settings) GetTier() string {
	if x != nil {
		return x.Tier
	}
	return ""
}

func (x *Settings) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *Settings) GetUserLabels() map[string]string {
	if x != nil {
		return x.UserLabels
	}
	return nil
}

func (x *Settings) GetAvailabilityType() SqlAvailabilityType {
	if x != nil {
		return x.AvailabilityType
	}
	return SqlAvailabilityType_SQL_AVAILABILITY_TYPE_UNSPECIFIED
}

func (x *Settings) GetPricingPlan() SqlPricingPlan {
	if x != nil {
		return x.PricingPlan
	}
	return SqlPricingPlan_SQL_PRICING_PLAN_UNSPECIFIED
}

// Deprecated: Do not use.
func (x *Settings) GetReplicationType() SqlReplicationType {
	if x != nil {
		return x.ReplicationType
	}
	return SqlReplicationType_SQL_REPLICATION_TYPE_UNSPECIFIED
}

func (x *Settings) GetStorageAutoResizeLimit() *wrapperspb.Int64Value {
	if x != nil {
		return x.StorageAutoResizeLimit
	}
	return nil
}

func (x *Settings) GetActivationPolicy() Settings_SqlActivationPolicy {
	if x != nil {
		return x.ActivationPolicy
	}
	return Settings_SQL_ACTIVATION_POLICY_UNSPECIFIED
}

func (x *Settings) GetIpConfiguration() *IpConfiguration {
	if x != nil {
		return x.IpConfiguration
	}
	return nil
}

func (x *Settings) GetStorageAutoResize() *wrapperspb.BoolValue {
	if x != nil {
		return x.StorageAutoResize
	}
	return nil
}

func (x *Settings) GetLocationPreference() *LocationPreference {
	if x != nil {
		return x.LocationPreference
	}
	return nil
}

func (x *Settings) GetDatabaseFlags() []*DatabaseFlags {
	if x != nil {
		return x.DatabaseFlags
	}
	return nil
}

func (x *Settings) GetDataDiskType() SqlDataDiskType {
	if x != nil {
		return x.DataDiskType
	}
	return SqlDataDiskType_SQL_DATA_DISK_TYPE_UNSPECIFIED
}

func (x *Settings) GetMaintenanceWindow() *MaintenanceWindow {
	if x != nil {
		return x.MaintenanceWindow
	}
	return nil
}

func (x *Settings) GetBackupConfiguration() *BackupConfiguration {
	if x != nil {
		return x.BackupConfiguration
	}
	return nil
}

func (x *Settings) GetDatabaseReplicationEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.DatabaseReplicationEnabled
	}
	return nil
}

// Deprecated: Do not use.
func (x *Settings) GetCrashSafeReplicationEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.CrashSafeReplicationEnabled
	}
	return nil
}

func (x *Settings) GetDataDiskSizeGb() *wrapperspb.Int64Value {
	if x != nil {
		return x.DataDiskSizeGb
	}
	return nil
}

func (x *Settings) GetActiveDirectoryConfig() *SqlActiveDirectoryConfig {
	if x != nil {
		return x.ActiveDirectoryConfig
	}
	return nil
}

func (x *Settings) GetCollation() string {
	if x != nil {
		return x.Collation
	}
	return ""
}

func (x *Settings) GetDenyMaintenancePeriods() []*DenyMaintenancePeriod {
	if x != nil {
		return x.DenyMaintenancePeriods
	}
	return nil
}

func (x *Settings) GetInsightsConfig() *InsightsConfig {
	if x != nil {
		return x.InsightsConfig
	}
	return nil
}

func (x *Settings) GetPasswordValidationPolicy() *PasswordValidationPolicy {
	if x != nil {
		return x.PasswordValidationPolicy
	}
	return nil
}

func (x *Settings) GetSqlServerAuditConfig() *SqlServerAuditConfig {
	if x != nil {
		return x.SqlServerAuditConfig
	}
	return nil
}

// SslCerts Resource
type SslCert struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#sslCert`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// Serial number, as extracted from the certificate.
	CertSerialNumber string `protobuf:"bytes,2,opt,name=cert_serial_number,json=certSerialNumber,proto3" json:"cert_serial_number,omitempty"`
	// PEM representation.
	Cert string `protobuf:"bytes,3,opt,name=cert,proto3" json:"cert,omitempty"`
	// The time when the certificate was created in
	// [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// User supplied name.  Constrained to [a-zA-Z.-_ ]+.
	CommonName string `protobuf:"bytes,5,opt,name=common_name,json=commonName,proto3" json:"common_name,omitempty"`
	// The time when the certificate expires in
	// [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	ExpirationTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
	// Sha1 Fingerprint.
	Sha1Fingerprint string `protobuf:"bytes,7,opt,name=sha1_fingerprint,json=sha1Fingerprint,proto3" json:"sha1_fingerprint,omitempty"`
	// Name of the database instance.
	Instance string `protobuf:"bytes,8,opt,name=instance,proto3" json:"instance,omitempty"`
	// The URI of this resource.
	SelfLink string `protobuf:"bytes,9,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
}

func (x *SslCert) Reset() {
	*x = SslCert{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SslCert) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SslCert) ProtoMessage() {}

func (x *SslCert) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SslCert.ProtoReflect.Descriptor instead.
func (*SslCert) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{56}
}

func (x *SslCert) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *SslCert) GetCertSerialNumber() string {
	if x != nil {
		return x.CertSerialNumber
	}
	return ""
}

func (x *SslCert) GetCert() string {
	if x != nil {
		return x.Cert
	}
	return ""
}

func (x *SslCert) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *SslCert) GetCommonName() string {
	if x != nil {
		return x.CommonName
	}
	return ""
}

func (x *SslCert) GetExpirationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpirationTime
	}
	return nil
}

func (x *SslCert) GetSha1Fingerprint() string {
	if x != nil {
		return x.Sha1Fingerprint
	}
	return ""
}

func (x *SslCert) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *SslCert) GetSelfLink() string {
	if x != nil {
		return x.SelfLink
	}
	return ""
}

// SslCertDetail.
type SslCertDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The public information about the cert.
	CertInfo *SslCert `protobuf:"bytes,1,opt,name=cert_info,json=certInfo,proto3" json:"cert_info,omitempty"`
	// The private key for the client cert, in pem format.  Keep private in order
	// to protect your security.
	CertPrivateKey string `protobuf:"bytes,2,opt,name=cert_private_key,json=certPrivateKey,proto3" json:"cert_private_key,omitempty"`
}

func (x *SslCertDetail) Reset() {
	*x = SslCertDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SslCertDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SslCertDetail) ProtoMessage() {}

func (x *SslCertDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SslCertDetail.ProtoReflect.Descriptor instead.
func (*SslCertDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{57}
}

func (x *SslCertDetail) GetCertInfo() *SslCert {
	if x != nil {
		return x.CertInfo
	}
	return nil
}

func (x *SslCertDetail) GetCertPrivateKey() string {
	if x != nil {
		return x.CertPrivateKey
	}
	return ""
}

// SslCerts create ephemeral certificate request.
type SslCertsCreateEphemeralRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PEM encoded public key to include in the signed certificate.
	PublicKey string `protobuf:"bytes,1,opt,name=public_key,json=publicKey,proto3" json:"public_key,omitempty"`
	// Access token to include in the signed certificate.
	AccessToken string `protobuf:"bytes,2,opt,name=access_token,json=accessToken,proto3" json:"access_token,omitempty"`
}

func (x *SslCertsCreateEphemeralRequest) Reset() {
	*x = SslCertsCreateEphemeralRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SslCertsCreateEphemeralRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SslCertsCreateEphemeralRequest) ProtoMessage() {}

func (x *SslCertsCreateEphemeralRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SslCertsCreateEphemeralRequest.ProtoReflect.Descriptor instead.
func (*SslCertsCreateEphemeralRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{58}
}

func (x *SslCertsCreateEphemeralRequest) GetPublicKey() string {
	if x != nil {
		return x.PublicKey
	}
	return ""
}

func (x *SslCertsCreateEphemeralRequest) GetAccessToken() string {
	if x != nil {
		return x.AccessToken
	}
	return ""
}

// SslCerts insert request.
type SslCertsInsertRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User supplied name.  Must be a distinct name from the other certificates
	// for this instance.
	CommonName string `protobuf:"bytes,1,opt,name=common_name,json=commonName,proto3" json:"common_name,omitempty"`
}

func (x *SslCertsInsertRequest) Reset() {
	*x = SslCertsInsertRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SslCertsInsertRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SslCertsInsertRequest) ProtoMessage() {}

func (x *SslCertsInsertRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SslCertsInsertRequest.ProtoReflect.Descriptor instead.
func (*SslCertsInsertRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{59}
}

func (x *SslCertsInsertRequest) GetCommonName() string {
	if x != nil {
		return x.CommonName
	}
	return ""
}

// Reschedule options for maintenance windows.
type SqlInstancesRescheduleMaintenanceRequestBody struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The type of the reschedule the user wants.
	Reschedule *SqlInstancesRescheduleMaintenanceRequestBody_Reschedule `protobuf:"bytes,3,opt,name=reschedule,proto3" json:"reschedule,omitempty"`
}

func (x *SqlInstancesRescheduleMaintenanceRequestBody) Reset() {
	*x = SqlInstancesRescheduleMaintenanceRequestBody{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesRescheduleMaintenanceRequestBody) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesRescheduleMaintenanceRequestBody) ProtoMessage() {}

func (x *SqlInstancesRescheduleMaintenanceRequestBody) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesRescheduleMaintenanceRequestBody.ProtoReflect.Descriptor instead.
func (*SqlInstancesRescheduleMaintenanceRequestBody) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{60}
}

func (x *SqlInstancesRescheduleMaintenanceRequestBody) GetReschedule() *SqlInstancesRescheduleMaintenanceRequestBody_Reschedule {
	if x != nil {
		return x.Reschedule
	}
	return nil
}

// SslCert insert response.
type SslCertsInsertResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#sslCertsInsert`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The operation to track the ssl certs insert request.
	Operation *Operation `protobuf:"bytes,2,opt,name=operation,proto3" json:"operation,omitempty"`
	// The server Certificate Authority's certificate.  If this is missing you can
	// force a new one to be generated by calling resetSslConfig method on
	// instances resource.
	ServerCaCert *SslCert `protobuf:"bytes,3,opt,name=server_ca_cert,json=serverCaCert,proto3" json:"server_ca_cert,omitempty"`
	// The new client certificate and private key.
	ClientCert *SslCertDetail `protobuf:"bytes,4,opt,name=client_cert,json=clientCert,proto3" json:"client_cert,omitempty"`
}

func (x *SslCertsInsertResponse) Reset() {
	*x = SslCertsInsertResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SslCertsInsertResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SslCertsInsertResponse) ProtoMessage() {}

func (x *SslCertsInsertResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SslCertsInsertResponse.ProtoReflect.Descriptor instead.
func (*SslCertsInsertResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{61}
}

func (x *SslCertsInsertResponse) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *SslCertsInsertResponse) GetOperation() *Operation {
	if x != nil {
		return x.Operation
	}
	return nil
}

func (x *SslCertsInsertResponse) GetServerCaCert() *SslCert {
	if x != nil {
		return x.ServerCaCert
	}
	return nil
}

func (x *SslCertsInsertResponse) GetClientCert() *SslCertDetail {
	if x != nil {
		return x.ClientCert
	}
	return nil
}

// SslCerts list response.
type SslCertsListResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#sslCertsList`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// List of client certificates for the instance.
	Items []*SslCert `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *SslCertsListResponse) Reset() {
	*x = SslCertsListResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SslCertsListResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SslCertsListResponse) ProtoMessage() {}

func (x *SslCertsListResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SslCertsListResponse.ProtoReflect.Descriptor instead.
func (*SslCertsListResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{62}
}

func (x *SslCertsListResponse) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *SslCertsListResponse) GetItems() []*SslCert {
	if x != nil {
		return x.Items
	}
	return nil
}

// Database Instance truncate log context.
type TruncateLogContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always `sql#truncateLogContext`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The type of log to truncate. Valid values are `MYSQL_GENERAL_TABLE` and
	// `MYSQL_SLOW_TABLE`.
	LogType string `protobuf:"bytes,2,opt,name=log_type,json=logType,proto3" json:"log_type,omitempty"`
}

func (x *TruncateLogContext) Reset() {
	*x = TruncateLogContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TruncateLogContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TruncateLogContext) ProtoMessage() {}

func (x *TruncateLogContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TruncateLogContext.ProtoReflect.Descriptor instead.
func (*TruncateLogContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{63}
}

func (x *TruncateLogContext) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *TruncateLogContext) GetLogType() string {
	if x != nil {
		return x.LogType
	}
	return ""
}

// Active Directory configuration, relevant only for Cloud SQL for SQL Server.
type SqlActiveDirectoryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always sql#activeDirectoryConfig.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The name of the domain (e.g., mydomain.com).
	Domain string `protobuf:"bytes,2,opt,name=domain,proto3" json:"domain,omitempty"`
}

func (x *SqlActiveDirectoryConfig) Reset() {
	*x = SqlActiveDirectoryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlActiveDirectoryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlActiveDirectoryConfig) ProtoMessage() {}

func (x *SqlActiveDirectoryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlActiveDirectoryConfig.ProtoReflect.Descriptor instead.
func (*SqlActiveDirectoryConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{64}
}

func (x *SqlActiveDirectoryConfig) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *SqlActiveDirectoryConfig) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

// SQL Server specific audit configuration.
type SqlServerAuditConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is always sql#sqlServerAuditConfig
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The name of the destination bucket (e.g., gs://mybucket).
	Bucket string `protobuf:"bytes,2,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// How long to keep generated audit files.
	RetentionInterval *durationpb.Duration `protobuf:"bytes,3,opt,name=retention_interval,json=retentionInterval,proto3" json:"retention_interval,omitempty"`
	// How often to upload generated audit files.
	UploadInterval *durationpb.Duration `protobuf:"bytes,4,opt,name=upload_interval,json=uploadInterval,proto3" json:"upload_interval,omitempty"`
}

func (x *SqlServerAuditConfig) Reset() {
	*x = SqlServerAuditConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlServerAuditConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlServerAuditConfig) ProtoMessage() {}

func (x *SqlServerAuditConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlServerAuditConfig.ProtoReflect.Descriptor instead.
func (*SqlServerAuditConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{65}
}

func (x *SqlServerAuditConfig) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *SqlServerAuditConfig) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *SqlServerAuditConfig) GetRetentionInterval() *durationpb.Duration {
	if x != nil {
		return x.RetentionInterval
	}
	return nil
}

func (x *SqlServerAuditConfig) GetUploadInterval() *durationpb.Duration {
	if x != nil {
		return x.UploadInterval
	}
	return nil
}

type DatabaseInstance_SqlFailoverReplica struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the failover replica. If specified at instance creation, a
	// failover replica is created for the instance. The name
	// doesn't include the project ID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The availability status of the failover replica. A false status indicates
	// that the failover replica is out of sync. The primary instance can only
	// failover to the failover replica when the status is true.
	Available *wrapperspb.BoolValue `protobuf:"bytes,2,opt,name=available,proto3" json:"available,omitempty"`
}

func (x *DatabaseInstance_SqlFailoverReplica) Reset() {
	*x = DatabaseInstance_SqlFailoverReplica{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabaseInstance_SqlFailoverReplica) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseInstance_SqlFailoverReplica) ProtoMessage() {}

func (x *DatabaseInstance_SqlFailoverReplica) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseInstance_SqlFailoverReplica.ProtoReflect.Descriptor instead.
func (*DatabaseInstance_SqlFailoverReplica) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{14, 0}
}

func (x *DatabaseInstance_SqlFailoverReplica) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DatabaseInstance_SqlFailoverReplica) GetAvailable() *wrapperspb.BoolValue {
	if x != nil {
		return x.Available
	}
	return nil
}

// Any scheduled maintenance for this instance.
type DatabaseInstance_SqlScheduledMaintenance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The start time of any upcoming scheduled maintenance for this instance.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Deprecated: Do not use.
	CanDefer bool `protobuf:"varint,2,opt,name=can_defer,json=canDefer,proto3" json:"can_defer,omitempty"`
	// If the scheduled maintenance can be rescheduled.
	CanReschedule bool `protobuf:"varint,3,opt,name=can_reschedule,json=canReschedule,proto3" json:"can_reschedule,omitempty"`
	// Maintenance cannot be rescheduled to start beyond this deadline.
	ScheduleDeadlineTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=schedule_deadline_time,json=scheduleDeadlineTime,proto3,oneof" json:"schedule_deadline_time,omitempty"`
}

func (x *DatabaseInstance_SqlScheduledMaintenance) Reset() {
	*x = DatabaseInstance_SqlScheduledMaintenance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabaseInstance_SqlScheduledMaintenance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseInstance_SqlScheduledMaintenance) ProtoMessage() {}

func (x *DatabaseInstance_SqlScheduledMaintenance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseInstance_SqlScheduledMaintenance.ProtoReflect.Descriptor instead.
func (*DatabaseInstance_SqlScheduledMaintenance) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{14, 1}
}

func (x *DatabaseInstance_SqlScheduledMaintenance) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

// Deprecated: Do not use.
func (x *DatabaseInstance_SqlScheduledMaintenance) GetCanDefer() bool {
	if x != nil {
		return x.CanDefer
	}
	return false
}

func (x *DatabaseInstance_SqlScheduledMaintenance) GetCanReschedule() bool {
	if x != nil {
		return x.CanReschedule
	}
	return false
}

func (x *DatabaseInstance_SqlScheduledMaintenance) GetScheduleDeadlineTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ScheduleDeadlineTime
	}
	return nil
}

// This message wraps up the information written by out-of-disk detection job.
type DatabaseInstance_SqlOutOfDiskReport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This field represents the state generated by the proactive database
	// wellness job for OutOfDisk issues.
	// *  Writers:
	//   *  the proactive database wellness job for OOD.
	// *  Readers:
	//   *  the proactive database wellness job
	SqlOutOfDiskState *DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState `protobuf:"varint,1,opt,name=sql_out_of_disk_state,json=sqlOutOfDiskState,proto3,enum=google.cloud.sql.v1beta4.DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState,oneof" json:"sql_out_of_disk_state,omitempty"`
	// The minimum recommended increase size in GigaBytes
	// This field is consumed by the frontend
	// *  Writers:
	//   *  the proactive database wellness job for OOD.
	// *  Readers:
	SqlMinRecommendedIncreaseSizeGb *int32 `protobuf:"varint,2,opt,name=sql_min_recommended_increase_size_gb,json=sqlMinRecommendedIncreaseSizeGb,proto3,oneof" json:"sql_min_recommended_increase_size_gb,omitempty"`
}

func (x *DatabaseInstance_SqlOutOfDiskReport) Reset() {
	*x = DatabaseInstance_SqlOutOfDiskReport{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabaseInstance_SqlOutOfDiskReport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseInstance_SqlOutOfDiskReport) ProtoMessage() {}

func (x *DatabaseInstance_SqlOutOfDiskReport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseInstance_SqlOutOfDiskReport.ProtoReflect.Descriptor instead.
func (*DatabaseInstance_SqlOutOfDiskReport) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{14, 2}
}

func (x *DatabaseInstance_SqlOutOfDiskReport) GetSqlOutOfDiskState() DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState {
	if x != nil && x.SqlOutOfDiskState != nil {
		return *x.SqlOutOfDiskState
	}
	return DatabaseInstance_SqlOutOfDiskReport_SQL_OUT_OF_DISK_STATE_UNSPECIFIED
}

func (x *DatabaseInstance_SqlOutOfDiskReport) GetSqlMinRecommendedIncreaseSizeGb() int32 {
	if x != nil && x.SqlMinRecommendedIncreaseSizeGb != nil {
		return *x.SqlMinRecommendedIncreaseSizeGb
	}
	return 0
}

type ExportContext_SqlCsvExportOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The select query used to extract the data.
	SelectQuery string `protobuf:"bytes,1,opt,name=select_query,json=selectQuery,proto3" json:"select_query,omitempty"`
	// Specifies the character that should appear before a data character that
	// needs to be escaped.
	EscapeCharacter string `protobuf:"bytes,2,opt,name=escape_character,json=escapeCharacter,proto3" json:"escape_character,omitempty"`
	// Specifies the quoting character to be used when a data value is quoted.
	QuoteCharacter string `protobuf:"bytes,3,opt,name=quote_character,json=quoteCharacter,proto3" json:"quote_character,omitempty"`
	// Specifies the character that separates columns within each row (line) of
	// the file.
	FieldsTerminatedBy string `protobuf:"bytes,4,opt,name=fields_terminated_by,json=fieldsTerminatedBy,proto3" json:"fields_terminated_by,omitempty"`
	// This is used to separate lines. If a line does not contain all fields,
	// the rest of the columns are set to their default values.
	LinesTerminatedBy string `protobuf:"bytes,6,opt,name=lines_terminated_by,json=linesTerminatedBy,proto3" json:"lines_terminated_by,omitempty"`
}

func (x *ExportContext_SqlCsvExportOptions) Reset() {
	*x = ExportContext_SqlCsvExportOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportContext_SqlCsvExportOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportContext_SqlCsvExportOptions) ProtoMessage() {}

func (x *ExportContext_SqlCsvExportOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportContext_SqlCsvExportOptions.ProtoReflect.Descriptor instead.
func (*ExportContext_SqlCsvExportOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{19, 0}
}

func (x *ExportContext_SqlCsvExportOptions) GetSelectQuery() string {
	if x != nil {
		return x.SelectQuery
	}
	return ""
}

func (x *ExportContext_SqlCsvExportOptions) GetEscapeCharacter() string {
	if x != nil {
		return x.EscapeCharacter
	}
	return ""
}

func (x *ExportContext_SqlCsvExportOptions) GetQuoteCharacter() string {
	if x != nil {
		return x.QuoteCharacter
	}
	return ""
}

func (x *ExportContext_SqlCsvExportOptions) GetFieldsTerminatedBy() string {
	if x != nil {
		return x.FieldsTerminatedBy
	}
	return ""
}

func (x *ExportContext_SqlCsvExportOptions) GetLinesTerminatedBy() string {
	if x != nil {
		return x.LinesTerminatedBy
	}
	return ""
}

type ExportContext_SqlExportOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Tables to export, or that were exported, from the specified database. If
	// you specify tables, specify one and only one database. For PostgreSQL
	// instances, you can specify only one table.
	Tables []string `protobuf:"bytes,1,rep,name=tables,proto3" json:"tables,omitempty"`
	// Export only schemas.
	SchemaOnly         *wrapperspb.BoolValue                              `protobuf:"bytes,2,opt,name=schema_only,json=schemaOnly,proto3" json:"schema_only,omitempty"`
	MysqlExportOptions *ExportContext_SqlExportOptions_MysqlExportOptions `protobuf:"bytes,3,opt,name=mysql_export_options,json=mysqlExportOptions,proto3" json:"mysql_export_options,omitempty"`
}

func (x *ExportContext_SqlExportOptions) Reset() {
	*x = ExportContext_SqlExportOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportContext_SqlExportOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportContext_SqlExportOptions) ProtoMessage() {}

func (x *ExportContext_SqlExportOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportContext_SqlExportOptions.ProtoReflect.Descriptor instead.
func (*ExportContext_SqlExportOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{19, 1}
}

func (x *ExportContext_SqlExportOptions) GetTables() []string {
	if x != nil {
		return x.Tables
	}
	return nil
}

func (x *ExportContext_SqlExportOptions) GetSchemaOnly() *wrapperspb.BoolValue {
	if x != nil {
		return x.SchemaOnly
	}
	return nil
}

func (x *ExportContext_SqlExportOptions) GetMysqlExportOptions() *ExportContext_SqlExportOptions_MysqlExportOptions {
	if x != nil {
		return x.MysqlExportOptions
	}
	return nil
}

// Options for exporting from MySQL.
type ExportContext_SqlExportOptions_MysqlExportOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Option to include SQL statement required to set up replication. If set
	// to `1`, the dump file includes a CHANGE MASTER TO statement with the
	// binary log coordinates, and --set-gtid-purged is set to ON. If set to
	// `2`, the CHANGE MASTER TO statement is written as a SQL comment and
	// has no effect. If set to any value other than `1`, --set-gtid-purged
	// is set to OFF.
	MasterData *wrapperspb.Int32Value `protobuf:"bytes,1,opt,name=master_data,json=masterData,proto3" json:"master_data,omitempty"`
}

func (x *ExportContext_SqlExportOptions_MysqlExportOptions) Reset() {
	*x = ExportContext_SqlExportOptions_MysqlExportOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportContext_SqlExportOptions_MysqlExportOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportContext_SqlExportOptions_MysqlExportOptions) ProtoMessage() {}

func (x *ExportContext_SqlExportOptions_MysqlExportOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportContext_SqlExportOptions_MysqlExportOptions.ProtoReflect.Descriptor instead.
func (*ExportContext_SqlExportOptions_MysqlExportOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{19, 1, 0}
}

func (x *ExportContext_SqlExportOptions_MysqlExportOptions) GetMasterData() *wrapperspb.Int32Value {
	if x != nil {
		return x.MasterData
	}
	return nil
}

type ImportContext_SqlCsvImportOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The table to which CSV data is imported.
	Table string `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	// The columns to which CSV data is imported. If not specified, all columns
	// of the database table are loaded with CSV data.
	Columns []string `protobuf:"bytes,2,rep,name=columns,proto3" json:"columns,omitempty"`
	// Specifies the character that should appear before a data character that
	// needs to be escaped.
	EscapeCharacter string `protobuf:"bytes,4,opt,name=escape_character,json=escapeCharacter,proto3" json:"escape_character,omitempty"`
	// Specifies the quoting character to be used when a data value is quoted.
	QuoteCharacter string `protobuf:"bytes,5,opt,name=quote_character,json=quoteCharacter,proto3" json:"quote_character,omitempty"`
	// Specifies the character that separates columns within each row (line) of
	// the file.
	FieldsTerminatedBy string `protobuf:"bytes,6,opt,name=fields_terminated_by,json=fieldsTerminatedBy,proto3" json:"fields_terminated_by,omitempty"`
	// This is used to separate lines. If a line does not contain all fields,
	// the rest of the columns are set to their default values.
	LinesTerminatedBy string `protobuf:"bytes,8,opt,name=lines_terminated_by,json=linesTerminatedBy,proto3" json:"lines_terminated_by,omitempty"`
}

func (x *ImportContext_SqlCsvImportOptions) Reset() {
	*x = ImportContext_SqlCsvImportOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportContext_SqlCsvImportOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportContext_SqlCsvImportOptions) ProtoMessage() {}

func (x *ImportContext_SqlCsvImportOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportContext_SqlCsvImportOptions.ProtoReflect.Descriptor instead.
func (*ImportContext_SqlCsvImportOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{23, 0}
}

func (x *ImportContext_SqlCsvImportOptions) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *ImportContext_SqlCsvImportOptions) GetColumns() []string {
	if x != nil {
		return x.Columns
	}
	return nil
}

func (x *ImportContext_SqlCsvImportOptions) GetEscapeCharacter() string {
	if x != nil {
		return x.EscapeCharacter
	}
	return ""
}

func (x *ImportContext_SqlCsvImportOptions) GetQuoteCharacter() string {
	if x != nil {
		return x.QuoteCharacter
	}
	return ""
}

func (x *ImportContext_SqlCsvImportOptions) GetFieldsTerminatedBy() string {
	if x != nil {
		return x.FieldsTerminatedBy
	}
	return ""
}

func (x *ImportContext_SqlCsvImportOptions) GetLinesTerminatedBy() string {
	if x != nil {
		return x.LinesTerminatedBy
	}
	return ""
}

type ImportContext_SqlBakImportOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	EncryptionOptions *ImportContext_SqlBakImportOptions_EncryptionOptions `protobuf:"bytes,1,opt,name=encryption_options,json=encryptionOptions,proto3" json:"encryption_options,omitempty"`
}

func (x *ImportContext_SqlBakImportOptions) Reset() {
	*x = ImportContext_SqlBakImportOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportContext_SqlBakImportOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportContext_SqlBakImportOptions) ProtoMessage() {}

func (x *ImportContext_SqlBakImportOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportContext_SqlBakImportOptions.ProtoReflect.Descriptor instead.
func (*ImportContext_SqlBakImportOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{23, 1}
}

func (x *ImportContext_SqlBakImportOptions) GetEncryptionOptions() *ImportContext_SqlBakImportOptions_EncryptionOptions {
	if x != nil {
		return x.EncryptionOptions
	}
	return nil
}

type ImportContext_SqlBakImportOptions_EncryptionOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Path to the Certificate (.cer) in Cloud Storage, in the form
	// `gs://bucketName/fileName`. The instance must have write permissions
	// to the bucket and read access to the file.
	CertPath string `protobuf:"bytes,1,opt,name=cert_path,json=certPath,proto3" json:"cert_path,omitempty"`
	// Path to the Certificate Private Key (.pvk)  in Cloud Storage, in the
	// form `gs://bucketName/fileName`. The instance must have write
	// permissions to the bucket and read access to the file.
	PvkPath string `protobuf:"bytes,2,opt,name=pvk_path,json=pvkPath,proto3" json:"pvk_path,omitempty"`
	// Password that encrypts the private key
	PvkPassword string `protobuf:"bytes,3,opt,name=pvk_password,json=pvkPassword,proto3" json:"pvk_password,omitempty"`
}

func (x *ImportContext_SqlBakImportOptions_EncryptionOptions) Reset() {
	*x = ImportContext_SqlBakImportOptions_EncryptionOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportContext_SqlBakImportOptions_EncryptionOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportContext_SqlBakImportOptions_EncryptionOptions) ProtoMessage() {}

func (x *ImportContext_SqlBakImportOptions_EncryptionOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportContext_SqlBakImportOptions_EncryptionOptions.ProtoReflect.Descriptor instead.
func (*ImportContext_SqlBakImportOptions_EncryptionOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{23, 1, 0}
}

func (x *ImportContext_SqlBakImportOptions_EncryptionOptions) GetCertPath() string {
	if x != nil {
		return x.CertPath
	}
	return ""
}

func (x *ImportContext_SqlBakImportOptions_EncryptionOptions) GetPvkPath() string {
	if x != nil {
		return x.PvkPath
	}
	return ""
}

func (x *ImportContext_SqlBakImportOptions_EncryptionOptions) GetPvkPassword() string {
	if x != nil {
		return x.PvkPassword
	}
	return ""
}

type SqlInstancesRescheduleMaintenanceRequestBody_Reschedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The type of the reschedule.
	RescheduleType SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType `protobuf:"varint,1,opt,name=reschedule_type,json=rescheduleType,proto3,enum=google.cloud.sql.v1beta4.SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType" json:"reschedule_type,omitempty"`
	// Optional. Timestamp when the maintenance shall be rescheduled to if
	// reschedule_type=SPECIFIC_TIME, in
	// [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	ScheduleTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=schedule_time,json=scheduleTime,proto3" json:"schedule_time,omitempty"`
}

func (x *SqlInstancesRescheduleMaintenanceRequestBody_Reschedule) Reset() {
	*x = SqlInstancesRescheduleMaintenanceRequestBody_Reschedule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlInstancesRescheduleMaintenanceRequestBody_Reschedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlInstancesRescheduleMaintenanceRequestBody_Reschedule) ProtoMessage() {}

func (x *SqlInstancesRescheduleMaintenanceRequestBody_Reschedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlInstancesRescheduleMaintenanceRequestBody_Reschedule.ProtoReflect.Descriptor instead.
func (*SqlInstancesRescheduleMaintenanceRequestBody_Reschedule) Descriptor() ([]byte, []int) {
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP(), []int{60, 0}
}

func (x *SqlInstancesRescheduleMaintenanceRequestBody_Reschedule) GetRescheduleType() SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType {
	if x != nil {
		return x.RescheduleType
	}
	return SqlInstancesRescheduleMaintenanceRequestBody_RESCHEDULE_TYPE_UNSPECIFIED
}

func (x *SqlInstancesRescheduleMaintenanceRequestBody_Reschedule) GetScheduleTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ScheduleTime
	}
	return nil
}

var File_google_cloud_sql_v1beta4_cloud_sql_resources_proto protoreflect.FileDescriptor

var file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x92, 0x01, 0x0a, 0x08, 0x41, 0x63, 0x6c, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x43, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0xdd, 0x01, 0x0a, 0x0a, 0x41, 0x70, 0x69, 0x57, 0x61, 0x72,
	0x6e, 0x69, 0x6e, 0x67, 0x12, 0x4a, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x41, 0x70,
	0x69, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x53, 0x71, 0x6c, 0x41, 0x70, 0x69, 0x57,
	0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x22, 0x51, 0x0a, 0x11, 0x53, 0x71, 0x6c, 0x41, 0x70, 0x69, 0x57, 0x61, 0x72, 0x6e,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x53, 0x51, 0x4c, 0x5f, 0x41,
	0x50, 0x49, 0x5f, 0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a,
	0x12, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x52, 0x45, 0x41, 0x43, 0x48, 0x41,
	0x42, 0x4c, 0x45, 0x10, 0x01, 0x22, 0x85, 0x02, 0x0a, 0x17, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x12, 0x66, 0x0a, 0x0e, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75,
	0x6e, 0x69, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x34, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x74, 0x65, 0x6e,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x52, 0x65, 0x74,
	0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x6e, 0x69, 0x74, 0x52, 0x0d, 0x72, 0x65, 0x74, 0x65,
	0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x6e, 0x69, 0x74, 0x12, 0x46, 0x0a, 0x10, 0x72, 0x65, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x73, 0x22, 0x3a, 0x0a, 0x0d, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x6e,
	0x69, 0x74, 0x12, 0x1e, 0x0a, 0x1a, 0x52, 0x45, 0x54, 0x45, 0x4e, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x55, 0x4e, 0x49, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x01, 0x22, 0xfc, 0x04,
	0x0a, 0x13, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69,
	0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x48,
	0x0a, 0x12, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f,
	0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x4c, 0x6f,
	0x67, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x65, 0x0a, 0x21, 0x72, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x61, 0x72, 0x63, 0x68,
	0x69, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x1e, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67, 0x41,
	0x72, 0x63, 0x68, 0x69, 0x76, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12,
	0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5e, 0x0a, 0x1e, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x72, 0x65, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x1a, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x49, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x65, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x60, 0x0a, 0x1e, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x72,
	0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x1b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x67,
	0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x79, 0x73, 0x12, 0x6d, 0x0a,
	0x19, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x17, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x74, 0x65, 0x6e,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x92, 0x07, 0x0a,
	0x09, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69,
	0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x44,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x3f, 0x0a, 0x0d, 0x65, 0x6e, 0x71, 0x75, 0x65, 0x75, 0x65, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x65, 0x6e, 0x71, 0x75, 0x65, 0x75, 0x65,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07,
	0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x3e, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34,
	0x2e, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x11, 0x77, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x1b, 0x0a,
	0x09, 0x73, 0x65, 0x6c, 0x66, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x73, 0x65, 0x6c, 0x66, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x79, 0x0a, 0x1d, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1b, 0x64, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x64, 0x0a, 0x16, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x44, 0x69, 0x73,
	0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x14, 0x64, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x48, 0x0a, 0x0b, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x0a, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x4b, 0x69, 0x6e,
	0x64, 0x22, 0x8f, 0x01, 0x0a, 0x16, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x73,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64,
	0x12, 0x39, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x52, 0x75, 0x6e, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x7c, 0x0a, 0x11, 0x42, 0x69, 0x6e, 0x4c, 0x6f, 0x67, 0x43, 0x6f, 0x6f,
	0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x73, 0x12, 0x29, 0x0a, 0x11, 0x62, 0x69, 0x6e, 0x5f,
	0x6c, 0x6f, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0e, 0x62, 0x69, 0x6e, 0x4c, 0x6f, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x62, 0x69, 0x6e, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x62,
	0x69, 0x6e, 0x4c, 0x6f, 0x67, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x22, 0x40, 0x0a, 0x0d, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x49, 0x64, 0x12,
	0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b,
	0x69, 0x6e, 0x64, 0x22, 0xd5, 0x02, 0x0a, 0x0c, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x2a, 0x0a, 0x11, 0x70, 0x69, 0x74, 0x72,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x6d, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0f, 0x70, 0x69, 0x74, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x4d, 0x73, 0x12, 0x3a, 0x0a, 0x19, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x5b, 0x0a, 0x13, 0x62, 0x69, 0x6e, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x63, 0x6f, 0x6f, 0x72,
	0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x42, 0x69, 0x6e, 0x4c, 0x6f, 0x67, 0x43,
	0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x73, 0x52, 0x11, 0x62, 0x69, 0x6e, 0x4c,
	0x6f, 0x67, 0x43, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x73, 0x12, 0x3e, 0x0a,
	0x0d, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x49, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2c, 0x0a,
	0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x70, 0x5f, 0x72, 0x61,
	0x6e, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x22, 0xd9, 0x02, 0x0a, 0x08,
	0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x18, 0x0a, 0x07,
	0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63,
	0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6f, 0x6c, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x65, 0x6c, 0x66,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x65, 0x6c,
	0x66, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12,
	0x72, 0x0a, 0x1a, 0x73, 0x71, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53,
	0x71, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x18, 0x73, 0x71, 0x6c, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x42, 0x12, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x72, 0x0a, 0x18, 0x53, 0x71, 0x6c, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x2f, 0x0a, 0x13, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x12, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0x39, 0x0a, 0x0d, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x35, 0x0a, 0x09, 0x53, 0x79, 0x6e, 0x63, 0x46, 0x6c,
	0x61, 0x67, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x59, 0x0a,
	0x11, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x18,
	0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x98, 0x1a, 0x0a, 0x10, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x12, 0x51, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x53, 0x71, 0x6c,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x57, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a,
	0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x12, 0x0a,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x12, 0x68, 0x0a, 0x10, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x72, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x53, 0x71, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x6f,
	0x76, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x52, 0x0f, 0x66, 0x61, 0x69, 0x6c,
	0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x12, 0x30, 0x0a, 0x14, 0x6d,
	0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x6d, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x08,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x4e, 0x61, 0x6d,
	0x65, 0x73, 0x12, 0x43, 0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0b, 0x6d, 0x61, 0x78, 0x44,
	0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x4b, 0x0a, 0x11, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x0f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x6b,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x46, 0x0a, 0x0c, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x65, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x49, 0x70, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52,
	0x0b, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x47, 0x0a, 0x0e,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e,
	0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x52, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43,
	0x61, 0x43, 0x65, 0x72, 0x74, 0x12, 0x4e, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12,
	0x25, 0x0a, 0x0c, 0x69, 0x70, 0x76, 0x36, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0b, 0x69, 0x70, 0x76, 0x36, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x41, 0x0a, 0x1d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f,
	0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1a, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61,
	0x69, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x6d, 0x0a, 0x19, 0x6f, 0x6e, 0x5f,
	0x70, 0x72, 0x65, 0x6d, 0x69, 0x73, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x6e, 0x50, 0x72, 0x65, 0x6d, 0x69, 0x73,
	0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x17, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x6d, 0x69, 0x73, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x63, 0x0a, 0x15, 0x72, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x34, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a,
	0x0c, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x13, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53,
	0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x62,
	0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x65,
	0x6c, 0x66, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73,
	0x65, 0x6c, 0x66, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x5a, 0x0a, 0x11, 0x73, 0x75, 0x73, 0x70, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x15, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71,
	0x6c, 0x53, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x52, 0x10, 0x73, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x18, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x67, 0x63, 0x65, 0x5f,
	0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x19, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x67, 0x63, 0x65, 0x5a,
	0x6f, 0x6e, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79,
	0x5f, 0x67, 0x63, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x22, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x10, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x47, 0x63, 0x65, 0x5a, 0x6f, 0x6e,
	0x65, 0x12, 0x79, 0x0a, 0x1d, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x34, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x1b, 0x64, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x64, 0x0a, 0x16,
	0x64, 0x69, 0x73, 0x6b, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x14, 0x64, 0x69,
	0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x6f, 0x6f, 0x74, 0x50,
	0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x77, 0x0a, 0x15, 0x73, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x64, 0x5f, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x34, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x2e, 0x53, 0x71, 0x6c, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x4d,
	0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x14, 0x73, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x64, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x3f, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a,
	0x73, 0x18, 0x23, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a,
	0x73, 0x12, 0x41, 0x0a, 0x1a, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x28, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x18, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x6f, 0x0a, 0x12, 0x6f, 0x75, 0x74, 0x5f, 0x6f, 0x66, 0x5f, 0x64,
	0x69, 0x73, 0x6b, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x26, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x53, 0x71, 0x6c,
	0x4f, 0x75, 0x74, 0x4f, 0x66, 0x44, 0x69, 0x73, 0x6b, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x48,
	0x00, 0x52, 0x0f, 0x6f, 0x75, 0x74, 0x4f, 0x66, 0x44, 0x69, 0x73, 0x6b, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x88, 0x01, 0x01, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x27, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x1e, 0x61, 0x76, 0x61, 0x69, 0x6c,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x29, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x1c, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2f, 0x0a,
	0x13, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x2a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x6d, 0x61, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x62,
	0x0a, 0x12, 0x53, 0x71, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x09, 0x61, 0x76, 0x61, 0x69,
	0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f,
	0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x1a, 0x8e, 0x02, 0x0a, 0x17, 0x53, 0x71, 0x6c, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x65, 0x64, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x39,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x09, 0x63, 0x61, 0x6e,
	0x5f, 0x64, 0x65, 0x66, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x08, 0x63, 0x61, 0x6e, 0x44, 0x65, 0x66, 0x65, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x61,
	0x6e, 0x5f, 0x72, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0d, 0x63, 0x61, 0x6e, 0x52, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x12, 0x55, 0x0a, 0x16, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x64, 0x65,
	0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00, 0x52,
	0x14, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x44, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x73, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x1a, 0x8f, 0x03, 0x0a, 0x12, 0x53, 0x71, 0x6c, 0x4f, 0x75, 0x74, 0x4f, 0x66,
	0x44, 0x69, 0x73, 0x6b, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x86, 0x01, 0x0a, 0x15, 0x73,
	0x71, 0x6c, 0x5f, 0x6f, 0x75, 0x74, 0x5f, 0x6f, 0x66, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x53, 0x71, 0x6c, 0x4f, 0x75, 0x74, 0x4f, 0x66, 0x44,
	0x69, 0x73, 0x6b, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x53, 0x71, 0x6c, 0x4f, 0x75, 0x74,
	0x4f, 0x66, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x11, 0x73,
	0x71, 0x6c, 0x4f, 0x75, 0x74, 0x4f, 0x66, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x88, 0x01, 0x01, 0x12, 0x52, 0x0a, 0x24, 0x73, 0x71, 0x6c, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x72,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x63, 0x72, 0x65,
	0x61, 0x73, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x48, 0x01, 0x52, 0x1f, 0x73, 0x71, 0x6c, 0x4d, 0x69, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x49, 0x6e, 0x63, 0x72, 0x65, 0x61, 0x73, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x47, 0x62, 0x88, 0x01, 0x01, 0x22, 0x59, 0x0a, 0x11, 0x53, 0x71, 0x6c, 0x4f, 0x75,
	0x74, 0x4f, 0x66, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x25, 0x0a, 0x21,
	0x53, 0x51, 0x4c, 0x5f, 0x4f, 0x55, 0x54, 0x5f, 0x4f, 0x46, 0x5f, 0x44, 0x49, 0x53, 0x4b, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x10, 0x01, 0x12,
	0x11, 0x0a, 0x0d, 0x53, 0x4f, 0x46, 0x54, 0x5f, 0x53, 0x48, 0x55, 0x54, 0x44, 0x4f, 0x57, 0x4e,
	0x10, 0x02, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x6f, 0x75, 0x74, 0x5f, 0x6f,
	0x66, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x42, 0x27, 0x0a, 0x25,
	0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x5f, 0x67, 0x62, 0x22, 0xb4, 0x01, 0x0a, 0x10, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x53, 0x51,
	0x4c, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x52, 0x55, 0x4e, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09,
	0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x50,
	0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x03, 0x12,
	0x12, 0x0a, 0x0e, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x45, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e,
	0x43, 0x45, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x06,
	0x12, 0x1a, 0x0a, 0x12, 0x4f, 0x4e, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x4d, 0x41, 0x49, 0x4e, 0x54,
	0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x07, 0x1a, 0x02, 0x08, 0x01, 0x42, 0x15, 0x0a, 0x13,
	0x5f, 0x6f, 0x75, 0x74, 0x5f, 0x6f, 0x66, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x72, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x22, 0x65, 0x0a, 0x15, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64,
	0x12, 0x38, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x22, 0xb0, 0x01, 0x0a, 0x19, 0x44,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x7f, 0x0a, 0x1b,
	0x6d, 0x79, 0x73, 0x71, 0x6c, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x44, 0x65, 0x6d,
	0x6f, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x4d, 0x79, 0x53, 0x71, 0x6c, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x19, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xcf, 0x02,
	0x0a, 0x13, 0x44, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x52, 0x0a, 0x17, 0x76, 0x65, 0x72,
	0x69, 0x66, 0x79, 0x5f, 0x67, 0x74, 0x69, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74,
	0x65, 0x6e, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f,
	0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x15, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x47, 0x74,
	0x69, 0x64, 0x43, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x30, 0x0a,
	0x14, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x6d, 0x61, 0x73,
	0x74, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x68, 0x0a, 0x15, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x44, 0x65, 0x6d, 0x6f, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x14, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x16, 0x73, 0x6b, 0x69,
	0x70, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65,
	0x74, 0x75, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x73, 0x6b, 0x69, 0x70, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x74, 0x75, 0x70, 0x22,
	0xe8, 0x01, 0x0a, 0x25, 0x44, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72,
	0x4d, 0x79, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x1a, 0x0a,
	0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x61, 0x73,
	0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x61, 0x73,
	0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x4b, 0x65, 0x79, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x11, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x61, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x22, 0xce, 0x07, 0x0a, 0x0d, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x10, 0x0a, 0x03,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x1c,
	0x0a, 0x09, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04,
	0x6b, 0x69, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64,
	0x12, 0x66, 0x0a, 0x12, 0x73, 0x71, 0x6c, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x53, 0x71, 0x6c, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x10, 0x73, 0x71, 0x6c, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x69, 0x0a, 0x12, 0x63, 0x73, 0x76, 0x5f,
	0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x53, 0x71,
	0x6c, 0x43, 0x73, 0x76, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x10, 0x63, 0x73, 0x76, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x42, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x34, 0x2e, 0x53, 0x71, 0x6c, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x66,
	0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x34, 0x0a, 0x07, 0x6f, 0x66, 0x66, 0x6c, 0x6f,
	0x61, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x6f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x1a, 0xee, 0x01,
	0x0a, 0x13, 0x53, 0x71, 0x6c, 0x43, 0x73, 0x76, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x5f,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x29, 0x0a, 0x10, 0x65, 0x73, 0x63, 0x61,
	0x70, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0f, 0x65, 0x73, 0x63, 0x61, 0x70, 0x65, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63,
	0x74, 0x65, 0x72, 0x12, 0x27, 0x0a, 0x0f, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x61,
	0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x71, 0x75,
	0x6f, 0x74, 0x65, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x12, 0x30, 0x0a, 0x14,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x62, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x73, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x64, 0x42, 0x79, 0x12, 0x2e,
	0x0a, 0x13, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74,
	0x65, 0x64, 0x5f, 0x62, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6c, 0x69, 0x6e,
	0x65, 0x73, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x64, 0x42, 0x79, 0x1a, 0xba,
	0x02, 0x0a, 0x10, 0x53, 0x71, 0x6c, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x7d, 0x0a, 0x14, 0x6d, 0x79, 0x73, 0x71,
	0x6c, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x34, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e,
	0x53, 0x71, 0x6c, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x4d, 0x79, 0x73, 0x71, 0x6c, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x12, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x52, 0x0a, 0x12, 0x4d, 0x79, 0x73, 0x71, 0x6c,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3c, 0x0a,
	0x0b, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x0a, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x44, 0x61, 0x74, 0x61, 0x22, 0x50, 0x0a, 0x0f, 0x46,
	0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x29,
	0x0a, 0x10, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0x88, 0x04,
	0x0a, 0x04, 0x46, 0x6c, 0x61, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x46, 0x6c, 0x61, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x4b, 0x0a, 0x0a, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x73,
	0x5f, 0x74, 0x6f, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x73,
	0x54, 0x6f, 0x12, 0x32, 0x0a, 0x15, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x73, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x13, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x38, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x38, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x08, 0x6d, 0x61, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x45, 0x0a, 0x10, 0x72, 0x65,
	0x71, 0x75, 0x69, 0x72, 0x65, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x33, 0x0a, 0x07, 0x69, 0x6e, 0x5f, 0x62, 0x65, 0x74, 0x61,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x06, 0x69, 0x6e, 0x42, 0x65, 0x74, 0x61, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x18, 0x0a, 0x20, 0x03, 0x28, 0x03, 0x52, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x49,
	0x6e, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x5d, 0x0a, 0x11, 0x46, 0x6c, 0x61, 0x67,
	0x73, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x12, 0x34, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x46, 0x6c, 0x61, 0x67,
	0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x22, 0x90, 0x07, 0x0a, 0x0d, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x1a, 0x0a, 0x08, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x42, 0x0a, 0x09, 0x66,
	0x69, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x46, 0x69, 0x6c,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x69, 0x0a, 0x12, 0x63, 0x73, 0x76, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x2e, 0x53, 0x71, 0x6c, 0x43, 0x73, 0x76, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x10, 0x63, 0x73, 0x76, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x55, 0x73, 0x65, 0x72, 0x12, 0x69, 0x0a, 0x12, 0x62,
	0x61, 0x6b, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x34, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x2e, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x6b, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x10, 0x62, 0x61, 0x6b, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xfb, 0x01, 0x0a, 0x13, 0x53, 0x71, 0x6c, 0x43, 0x73,
	0x76, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x14,
	0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x29,
	0x0a, 0x10, 0x65, 0x73, 0x63, 0x61, 0x70, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x65, 0x73, 0x63, 0x61, 0x70, 0x65,
	0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x12, 0x27, 0x0a, 0x0f, 0x71, 0x75, 0x6f,
	0x74, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74,
	0x65, 0x72, 0x12, 0x30, 0x0a, 0x14, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x5f, 0x74, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x12, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74,
	0x65, 0x64, 0x42, 0x79, 0x12, 0x2e, 0x0a, 0x13, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x5f, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x11, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74,
	0x65, 0x64, 0x42, 0x79, 0x1a, 0x83, 0x02, 0x0a, 0x13, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x6b, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x7c, 0x0a, 0x12,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x34, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x2e, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x6b, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x11, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x6e, 0x0a, 0x11, 0x45, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x1b, 0x0a, 0x09, 0x63, 0x65, 0x72, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x63, 0x65, 0x72, 0x74, 0x50, 0x61, 0x74, 0x68, 0x12, 0x19, 0x0a, 0x08,
	0x70, 0x76, 0x6b, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x70, 0x76, 0x6b, 0x50, 0x61, 0x74, 0x68, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x76, 0x6b, 0x5f, 0x70,
	0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70,
	0x76, 0x6b, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22, 0x64, 0x0a, 0x15, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x0d, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x52, 0x0c, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x22, 0x81, 0x01, 0x0a, 0x1c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x44, 0x65,
	0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x61, 0x0a, 0x15, 0x64, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x74,
	0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x44, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52,
	0x13, 0x64, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x22, 0x68, 0x0a, 0x16, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e,
	0x0a, 0x0e, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x34, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52,
	0x0d, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x70,
	0x0a, 0x18, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x6f,
	0x76, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x10, 0x66, 0x61,
	0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e,
	0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52,
	0x0f, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x22, 0x68, 0x0a, 0x16, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x0e, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0d, 0x69, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x64, 0x0a, 0x0f, 0x4d, 0x79,
	0x53, 0x71, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x51, 0x0a,
	0x12, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x66, 0x6c,
	0x61, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x79, 0x6e, 0x63, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x52, 0x10,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x46, 0x6c, 0x61, 0x67, 0x73,
	0x22, 0xd7, 0x01, 0x0a, 0x15, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69,
	0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x40,
	0x0a, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x41, 0x70, 0x69, 0x57,
	0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x40, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x05, 0x69, 0x74, 0x65,
	0x6d, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x94, 0x01, 0x0a, 0x1e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x43, 0x61, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a,
	0x05, 0x63, 0x65, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x52,
	0x05, 0x63, 0x65, 0x72, 0x74, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x22, 0x85, 0x01, 0x0a, 0x1d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x64, 0x0a, 0x16, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x52,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x52, 0x14, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x8a, 0x01, 0x0a, 0x1e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x43, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x68, 0x0a, 0x18,
	0x72, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x61,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x65,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52,
	0x15, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x7d, 0x0a, 0x1b, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x4c, 0x6f, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5e, 0x0a, 0x14, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74,
	0x65, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x54,
	0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x4c, 0x6f, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x52, 0x12, 0x74, 0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x4c, 0x6f, 0x67, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0xe6, 0x01, 0x0a, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x45, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x4d, 0x0a, 0x06,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x45, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x51, 0x0a, 0x08, 0x77,
	0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x45, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x52, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x22, 0xa7,
	0x08, 0x0a, 0x1b, 0x53, 0x71, 0x6c, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79,
	0x6e, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x12,
	0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69,
	0x6e, 0x64, 0x12, 0x69, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x45,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0x53, 0x71, 0x6c, 0x45, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a,
	0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x22, 0xf0, 0x06, 0x0a, 0x1f, 0x53, 0x71, 0x6c, 0x45, 0x78, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x34, 0x0a, 0x30, 0x53, 0x51, 0x4c,
	0x5f, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x53, 0x59, 0x4e, 0x43, 0x5f, 0x53,
	0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x16, 0x0a, 0x12, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41,
	0x49, 0x4c, 0x55, 0x52, 0x45, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x42, 0x49, 0x4e, 0x4c, 0x4f,
	0x47, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12,
	0x21, 0x0a, 0x1d, 0x49, 0x4e, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x54, 0x49, 0x42, 0x4c, 0x45, 0x5f,
	0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e,
	0x10, 0x03, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x5f, 0x41, 0x4c,
	0x52, 0x45, 0x41, 0x44, 0x59, 0x5f, 0x53, 0x45, 0x54, 0x55, 0x50, 0x10, 0x04, 0x12, 0x1a, 0x0a,
	0x16, 0x49, 0x4e, 0x53, 0x55, 0x46, 0x46, 0x49, 0x43, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x50, 0x52,
	0x49, 0x56, 0x49, 0x4c, 0x45, 0x47, 0x45, 0x10, 0x05, 0x12, 0x1e, 0x0a, 0x1a, 0x55, 0x4e, 0x53,
	0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x06, 0x12, 0x1a, 0x0a, 0x16, 0x4e, 0x4f, 0x5f,
	0x50, 0x47, 0x4c, 0x4f, 0x47, 0x49, 0x43, 0x41, 0x4c, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4c,
	0x4c, 0x45, 0x44, 0x10, 0x07, 0x12, 0x21, 0x0a, 0x1d, 0x50, 0x47, 0x4c, 0x4f, 0x47, 0x49, 0x43,
	0x41, 0x4c, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x5f, 0x41, 0x4c, 0x52, 0x45, 0x41, 0x44, 0x59, 0x5f,
	0x45, 0x58, 0x49, 0x53, 0x54, 0x53, 0x10, 0x08, 0x12, 0x15, 0x0a, 0x11, 0x49, 0x4e, 0x56, 0x41,
	0x4c, 0x49, 0x44, 0x5f, 0x57, 0x41, 0x4c, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x10, 0x09, 0x12,
	0x22, 0x0a, 0x1e, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x53, 0x48, 0x41, 0x52, 0x45,
	0x44, 0x5f, 0x50, 0x52, 0x45, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x4c, 0x49, 0x42, 0x52, 0x41, 0x52,
	0x59, 0x10, 0x0a, 0x12, 0x26, 0x0a, 0x22, 0x49, 0x4e, 0x53, 0x55, 0x46, 0x46, 0x49, 0x43, 0x49,
	0x45, 0x4e, 0x54, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x4c, 0x4f, 0x54, 0x53, 0x10, 0x0b, 0x12, 0x20, 0x0a, 0x1c, 0x49,
	0x4e, 0x53, 0x55, 0x46, 0x46, 0x49, 0x43, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x4d, 0x41, 0x58, 0x5f,
	0x57, 0x41, 0x4c, 0x5f, 0x53, 0x45, 0x4e, 0x44, 0x45, 0x52, 0x53, 0x10, 0x0c, 0x12, 0x25, 0x0a,
	0x21, 0x49, 0x4e, 0x53, 0x55, 0x46, 0x46, 0x49, 0x43, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x4d, 0x41,
	0x58, 0x5f, 0x57, 0x4f, 0x52, 0x4b, 0x45, 0x52, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53,
	0x45, 0x53, 0x10, 0x0d, 0x12, 0x1a, 0x0a, 0x16, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52,
	0x54, 0x45, 0x44, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x4e, 0x53, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x0e,
	0x12, 0x23, 0x0a, 0x1f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x52, 0x44, 0x53, 0x5f,
	0x4c, 0x4f, 0x47, 0x49, 0x43, 0x41, 0x4c, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x0f, 0x12, 0x19, 0x0a, 0x15, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44,
	0x5f, 0x4c, 0x4f, 0x47, 0x47, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x45, 0x54, 0x55, 0x50, 0x10, 0x10,
	0x12, 0x14, 0x0a, 0x10, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x44, 0x42, 0x5f, 0x50,
	0x41, 0x52, 0x41, 0x4d, 0x10, 0x11, 0x12, 0x19, 0x0a, 0x15, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50,
	0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x47, 0x54, 0x49, 0x44, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x10,
	0x12, 0x12, 0x1f, 0x0a, 0x1b, 0x53, 0x51, 0x4c, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x41,
	0x47, 0x45, 0x4e, 0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47,
	0x10, 0x13, 0x12, 0x20, 0x0a, 0x1c, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45,
	0x44, 0x5f, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x49, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x14, 0x12, 0x17, 0x0a, 0x13, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52,
	0x54, 0x45, 0x44, 0x5f, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x52, 0x10, 0x15, 0x12, 0x21, 0x0a,
	0x1d, 0x53, 0x51, 0x4c, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45,
	0x52, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x16,
	0x12, 0x19, 0x0a, 0x15, 0x50, 0x52, 0x49, 0x4d, 0x41, 0x52, 0x59, 0x5f, 0x41, 0x4c, 0x52, 0x45,
	0x41, 0x44, 0x59, 0x5f, 0x53, 0x45, 0x54, 0x55, 0x50, 0x10, 0x17, 0x12, 0x1d, 0x0a, 0x19, 0x55,
	0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x42, 0x49, 0x4e, 0x4c, 0x4f,
	0x47, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x10, 0x18, 0x12, 0x1c, 0x0a, 0x18, 0x42, 0x49,
	0x4e, 0x4c, 0x4f, 0x47, 0x5f, 0x52, 0x45, 0x54, 0x45, 0x4e, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53,
	0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x19, 0x12, 0x1e, 0x0a, 0x1a, 0x55, 0x4e, 0x53, 0x55,
	0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x53, 0x54, 0x4f, 0x52, 0x41, 0x47, 0x45, 0x5f,
	0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x10, 0x1a, 0x22, 0xb9, 0x02, 0x0a, 0x0f, 0x49, 0x70, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x0c,
	0x69, 0x70, 0x76, 0x34, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b,
	0x69, 0x70, 0x76, 0x34, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x12, 0x3b, 0x0a, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x5f,
	0x73, 0x73, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x53, 0x73,
	0x6c, 0x12, 0x53, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x41, 0x63, 0x6c, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x69, 0x70, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x10, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x49, 0x70, 0x52,
	0x61, 0x6e, 0x67, 0x65, 0x22, 0xac, 0x01, 0x0a, 0x09, 0x49, 0x70, 0x4d, 0x61, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x12, 0x3e, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49,
	0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x12, 0x40, 0x0a, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x6f, 0x5f, 0x72, 0x65, 0x74,
	0x69, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x54, 0x6f, 0x52, 0x65, 0x74,
	0x69, 0x72, 0x65, 0x22, 0x9d, 0x01, 0x0a, 0x12, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x38, 0x0a, 0x16, 0x66, 0x6f,
	0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x67, 0x61, 0x65, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x14,
	0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x47, 0x61, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5a, 0x6f, 0x6e, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b,
	0x69, 0x6e, 0x64, 0x22, 0xd4, 0x01, 0x0a, 0x11, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x2f, 0x0a, 0x04, 0x68, 0x6f, 0x75,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x68, 0x6f, 0x75, 0x72, 0x12, 0x2d, 0x0a, 0x03, 0x64, 0x61,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x64, 0x61, 0x79, 0x12, 0x4b, 0x0a, 0x0c, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x52, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0x65, 0x0a, 0x15, 0x44, 0x65,
	0x6e, 0x79, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x44, 0x61,
	0x74, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x44, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x69, 0x6d,
	0x65, 0x22, 0xd1, 0x02, 0x0a, 0x0e, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x0a, 0x16, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x71, 0x75, 0x65, 0x72, 0x79, 0x49, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x32, 0x0a, 0x15, 0x72, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x72, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x36,
	0x0a, 0x17, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x15, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x61, 0x67, 0x73, 0x12, 0x4b, 0x0a, 0x13, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f,
	0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x11, 0x71, 0x75, 0x65, 0x72, 0x79, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x4c, 0x65, 0x6e,
	0x67, 0x74, 0x68, 0x12, 0x50, 0x0a, 0x16, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x6c, 0x61,
	0x6e, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x13, 0x71, 0x75, 0x65, 0x72, 0x79, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x50, 0x65, 0x72, 0x4d,
	0x69, 0x6e, 0x75, 0x74, 0x65, 0x22, 0xa1, 0x04, 0x0a, 0x19, 0x4d, 0x79, 0x53, 0x71, 0x6c, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0e, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x75, 0x6d,
	0x70, 0x46, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65,
	0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65,
	0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72,
	0x64, 0x12, 0x51, 0x0a, 0x16, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x74,
	0x72, 0x79, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x14,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x52, 0x65, 0x74, 0x72, 0x79, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x12, 0x53, 0x0a, 0x17, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x68,
	0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x15, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62,
	0x65, 0x61, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x61, 0x5f,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x63, 0x61, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x1d,
	0x0a, 0x0a, 0x73, 0x73, 0x6c, 0x5f, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x73, 0x73, 0x6c, 0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x12, 0x56, 0x0a,
	0x19, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x17, 0x76, 0x65,
	0x72, 0x69, 0x66, 0x79, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0xf3, 0x02, 0x0a, 0x17, 0x4f, 0x6e,
	0x50, 0x72, 0x65, 0x6d, 0x69, 0x73, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x6f,
	0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x50, 0x6f,
	0x72, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x25,
	0x0a, 0x0e, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x61, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x11, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x6b,
	0x65, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x4b, 0x65, 0x79, 0x12, 0x24, 0x0a, 0x0e, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x75, 0x6d,
	0x70, 0x46, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x54, 0x0a, 0x0f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52,
	0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22,
	0x53, 0x0a, 0x1b, 0x44, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20,
	0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6b, 0x69, 0x6e, 0x64, 0x22, 0x5b, 0x0a, 0x14, 0x44, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x2f, 0x0a, 0x14,
	0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6b, 0x6d, 0x73, 0x4b,
	0x65, 0x79, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x22, 0xde, 0x0c, 0x0a, 0x09, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b,
	0x69, 0x6e, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x4e, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x71, 0x6c, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x12, 0x3b, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x65,
	0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x65, 0x72,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07,
	0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x5b, 0x0a, 0x0e, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x71, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4e, 0x0a, 0x0e, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0d, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x4e, 0x0a, 0x0e, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0d, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x4e, 0x0a, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0d, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x65, 0x6c, 0x66, 0x5f, 0x6c,
	0x69, 0x6e, 0x6b, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x65, 0x6c, 0x66, 0x4c,
	0x69, 0x6e, 0x6b, 0x12, 0x25, 0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0xa5, 0x05, 0x0a, 0x10, 0x53,
	0x71, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x22, 0x0a, 0x1e, 0x53, 0x51, 0x4c, 0x5f, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x10, 0x01, 0x12,
	0x0a, 0x0a, 0x06, 0x45, 0x58, 0x50, 0x4f, 0x52, 0x54, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x43,
	0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x50, 0x44, 0x41, 0x54,
	0x45, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x05, 0x12,
	0x0b, 0x0a, 0x07, 0x52, 0x45, 0x53, 0x54, 0x41, 0x52, 0x54, 0x10, 0x06, 0x12, 0x0e, 0x0a, 0x06,
	0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x10, 0x07, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x10, 0x0a, 0x08,
	0x53, 0x4e, 0x41, 0x50, 0x53, 0x48, 0x4f, 0x54, 0x10, 0x08, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x11,
	0x0a, 0x0d, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x56, 0x4f, 0x4c, 0x55, 0x4d, 0x45, 0x10,
	0x09, 0x12, 0x11, 0x0a, 0x0d, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x56, 0x4f, 0x4c, 0x55,
	0x4d, 0x45, 0x10, 0x0a, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x45, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x5f,
	0x56, 0x4f, 0x4c, 0x55, 0x4d, 0x45, 0x10, 0x0b, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x4a, 0x45,
	0x43, 0x54, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x10, 0x0c, 0x12, 0x09, 0x0a, 0x05, 0x43, 0x4c, 0x4f,
	0x4e, 0x45, 0x10, 0x0e, 0x12, 0x10, 0x0a, 0x0c, 0x53, 0x54, 0x4f, 0x50, 0x5f, 0x52, 0x45, 0x50,
	0x4c, 0x49, 0x43, 0x41, 0x10, 0x0f, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f,
	0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x10, 0x10, 0x12, 0x13, 0x0a, 0x0f, 0x50, 0x52, 0x4f,
	0x4d, 0x4f, 0x54, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x10, 0x11, 0x12, 0x12,
	0x0a, 0x0e, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41,
	0x10, 0x12, 0x12, 0x0f, 0x0a, 0x0b, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x53, 0x45,
	0x52, 0x10, 0x13, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x55, 0x53,
	0x45, 0x52, 0x10, 0x14, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x53, 0x45, 0x52, 0x10, 0x15, 0x12, 0x13, 0x0a, 0x0f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f,
	0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x10, 0x16, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x10, 0x17, 0x12,
	0x13, 0x0a, 0x0f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41,
	0x53, 0x45, 0x10, 0x18, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x41, 0x49, 0x4c, 0x4f, 0x56, 0x45, 0x52,
	0x10, 0x19, 0x12, 0x11, 0x0a, 0x0d, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x42, 0x41, 0x43,
	0x4b, 0x55, 0x50, 0x10, 0x1a, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x45, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x45, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x10, 0x1b, 0x12, 0x10, 0x0a, 0x0c, 0x54,
	0x52, 0x55, 0x4e, 0x43, 0x41, 0x54, 0x45, 0x5f, 0x4c, 0x4f, 0x47, 0x10, 0x1c, 0x12, 0x11, 0x0a,
	0x0d, 0x44, 0x45, 0x4d, 0x4f, 0x54, 0x45, 0x5f, 0x4d, 0x41, 0x53, 0x54, 0x45, 0x52, 0x10, 0x1d,
	0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x10,
	0x1e, 0x12, 0x19, 0x0a, 0x11, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x50, 0x52, 0x49, 0x56,
	0x41, 0x54, 0x45, 0x5f, 0x49, 0x50, 0x10, 0x1f, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x19, 0x0a, 0x11,
	0x44, 0x45, 0x46, 0x45, 0x52, 0x5f, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43,
	0x45, 0x10, 0x20, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x14, 0x0a, 0x0c, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x45, 0x5f, 0x43, 0x4c, 0x4f, 0x4e, 0x45, 0x10, 0x21, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x1a, 0x0a,
	0x16, 0x52, 0x45, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x5f, 0x4d, 0x41, 0x49, 0x4e,
	0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x22, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x54, 0x41,
	0x52, 0x54, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x53, 0x59, 0x4e, 0x43,
	0x10, 0x23, 0x22, 0x5e, 0x0a, 0x12, 0x53, 0x71, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x24, 0x0a, 0x20, 0x53, 0x51, 0x4c, 0x5f,
	0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b,
	0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52,
	0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x4f, 0x4e, 0x45,
	0x10, 0x03, 0x22, 0x52, 0x0a, 0x0e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x67, 0x0a, 0x0f, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x40, 0x0a,
	0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x22,
	0xbe, 0x04, 0x0a, 0x18, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x3a, 0x0a, 0x0a,
	0x6d, 0x69, 0x6e, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x6d,
	0x69, 0x6e, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x5d, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x70,
	0x6c, 0x65, 0x78, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64,
	0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x69, 0x74, 0x79, 0x52, 0x0a, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x78, 0x69, 0x74, 0x79, 0x12, 0x42, 0x0a, 0x0e, 0x72, 0x65, 0x75, 0x73, 0x65,
	0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x72, 0x65,
	0x75, 0x73, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x5a, 0x0a, 0x1b, 0x64,
	0x69, 0x73, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65,
	0x5f, 0x73, 0x75, 0x62, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x19, 0x64, 0x69,
	0x73, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x55, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x53, 0x75,
	0x62, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x53, 0x0a, 0x18, 0x70, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x76, 0x61, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x16, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x50, 0x0a, 0x16,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42,
	0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x14, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x40,
	0x0a, 0x0a, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x69, 0x74, 0x79, 0x12, 0x1a, 0x0a, 0x16,
	0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x58, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x43, 0x4f, 0x4d, 0x50,
	0x4c, 0x45, 0x58, 0x49, 0x54, 0x59, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x01,
	0x22, 0x8f, 0x01, 0x0a, 0x16, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b,
	0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12,
	0x39, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xe4, 0x01, 0x0a, 0x14, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6b,
	0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12,
	0x73, 0x0a, 0x1b, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e,
	0x4d, 0x79, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x19, 0x6d, 0x79, 0x73, 0x71, 0x6c,
	0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x0f, 0x66, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72,
	0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x6f,
	0x76, 0x65, 0x72, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x89, 0x01, 0x0a, 0x14, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x22, 0x0a, 0x0d, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x4e, 0x0a, 0x15, 0x52, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69,
	0x6e, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6e, 0x65, 0x78, 0x74, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x12, 0x0a, 0x08, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x46, 0x0a, 0x10, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x73, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x1b, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x67, 0x61, 0x65, 0x5f, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x19, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x47,
	0x61, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x12,
	0x0a, 0x04, 0x74, 0x69, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x69,
	0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x53, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x0a, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x5a, 0x0a, 0x11, 0x61,
	0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x34, 0x2e, 0x53, 0x71, 0x6c, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x10, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4b, 0x0a, 0x0c, 0x70, 0x72, 0x69, 0x63, 0x69,
	0x6e, 0x67, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x50, 0x72, 0x69, 0x63,
	0x69, 0x6e, 0x67, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x0b, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67,
	0x50, 0x6c, 0x61, 0x6e, 0x12, 0x5b, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x0f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x56, 0x0a, 0x19, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x61, 0x75, 0x74,
	0x6f, 0x5f, 0x72, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x16, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x52, 0x65,
	0x73, 0x69, 0x7a, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x63, 0x0a, 0x11, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x53, 0x71, 0x6c, 0x41, 0x63, 0x74, 0x69,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x10, 0x61, 0x63,
	0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x54,
	0x0a, 0x10, 0x69, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x34, 0x2e, 0x49, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x69, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x13, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f,
	0x61, 0x75, 0x74, 0x6f, 0x5f, 0x72, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x52, 0x65, 0x73, 0x69, 0x7a, 0x65,
	0x12, 0x5d, 0x0a, 0x13, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x12, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12,
	0x4e, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x66, 0x6c, 0x61, 0x67,
	0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x34, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73,
	0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x12,
	0x4f, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x5a, 0x0a, 0x12, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x52, 0x11, 0x6d, 0x61, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x60, 0x0a, 0x14,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5c,
	0x0a, 0x1c, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x12,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x1a, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x63, 0x0a, 0x1e,
	0x63, 0x72, 0x61, 0x73, 0x68, 0x5f, 0x73, 0x61, 0x66, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x1b, 0x63, 0x72, 0x61, 0x73, 0x68, 0x53, 0x61, 0x66, 0x65, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x12, 0x46, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x44,
	0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x6a, 0x0a, 0x17, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x15,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x69, 0x0a, 0x18, 0x64, 0x65, 0x6e, 0x79, 0x5f, 0x6d, 0x61, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x73, 0x18,
	0x18, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34,
	0x2e, 0x44, 0x65, 0x6e, 0x79, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x52, 0x16, 0x64, 0x65, 0x6e, 0x79, 0x4d, 0x61, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x73, 0x12, 0x51,
	0x0a, 0x0f, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x34, 0x2e, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x0e, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x70, 0x0a, 0x1a, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18,
	0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34,
	0x2e, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x18, 0x70, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x65, 0x0a, 0x17, 0x73, 0x71, 0x6c, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x1d,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e,
	0x53, 0x71, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41, 0x75, 0x64, 0x69, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x14, 0x73, 0x71, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x41,
	0x75, 0x64, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x3d, 0x0a, 0x0f, 0x55, 0x73,
	0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x66, 0x0a, 0x13, 0x53, 0x71, 0x6c,
	0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x25, 0x0a, 0x21, 0x53, 0x51, 0x4c, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x4c, 0x57, 0x41, 0x59,
	0x53, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4e, 0x45, 0x56, 0x45, 0x52, 0x10, 0x02, 0x12, 0x11,
	0x0a, 0x09, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4d, 0x41, 0x4e, 0x44, 0x10, 0x03, 0x1a, 0x02, 0x08,
	0x01, 0x22, 0xe6, 0x02, 0x0a, 0x07, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x12, 0x2c, 0x0a, 0x12, 0x63, 0x65, 0x72, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c,
	0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x63,
	0x65, 0x72, 0x74, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12,
	0x12, 0x0a, 0x04, 0x63, 0x65, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x63,
	0x65, 0x72, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x43, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x68, 0x61, 0x31, 0x5f, 0x66,
	0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x73, 0x68, 0x61, 0x31, 0x46, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e,
	0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x1b, 0x0a,
	0x09, 0x73, 0x65, 0x6c, 0x66, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x73, 0x65, 0x6c, 0x66, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x79, 0x0a, 0x0d, 0x53, 0x73,
	0x6c, 0x43, 0x65, 0x72, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x3e, 0x0a, 0x09, 0x63,
	0x65, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72,
	0x74, 0x52, 0x08, 0x63, 0x65, 0x72, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x28, 0x0a, 0x10, 0x63,
	0x65, 0x72, 0x74, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x65, 0x72, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x4b, 0x65, 0x79, 0x22, 0x62, 0x0a, 0x1e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74,
	0x73, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x70, 0x68, 0x65, 0x6d, 0x65, 0x72, 0x61, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x38, 0x0a, 0x15, 0x53, 0x73, 0x6c,
	0x43, 0x65, 0x72, 0x74, 0x73, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x4e,
	0x61, 0x6d, 0x65, 0x22, 0xe6, 0x03, 0x0a, 0x2c, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x4d, 0x61,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x42, 0x6f, 0x64, 0x79, 0x12, 0x71, 0x0a, 0x0a, 0x72, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x6f, 0x64, 0x79,
	0x2e, 0x52, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x0a, 0x72, 0x65, 0x73,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x1a, 0xd2, 0x01, 0x0a, 0x0a, 0x52, 0x65, 0x73, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x7e, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x42, 0x6f, 0x64, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0e, 0x72, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x44, 0x0a, 0x0d, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x6e, 0x0a, 0x0e,
	0x52, 0x65, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f,
	0x0a, 0x1b, 0x52, 0x45, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0d, 0x0a, 0x09, 0x49, 0x4d, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x19,
	0x0a, 0x15, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45,
	0x5f, 0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x43, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x03, 0x22, 0x82, 0x02, 0x0a,
	0x16, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x41, 0x0a, 0x09, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71,
	0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x47,
	0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x34, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x52, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x43, 0x61, 0x43, 0x65, 0x72, 0x74, 0x12, 0x48, 0x0a, 0x0b, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72,
	0x74, 0x22, 0x63, 0x0a, 0x14, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x73, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x37, 0x0a,
	0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x52,
	0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x22, 0x43, 0x0a, 0x12, 0x54, 0x72, 0x75, 0x6e, 0x63, 0x61,
	0x74, 0x65, 0x4c, 0x6f, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64,
	0x12, 0x19, 0x0a, 0x08, 0x6c, 0x6f, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6c, 0x6f, 0x67, 0x54, 0x79, 0x70, 0x65, 0x22, 0x46, 0x0a, 0x18, 0x53,
	0x71, 0x6c, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x22, 0xd0, 0x01, 0x0a, 0x14, 0x53, 0x71, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x41, 0x75, 0x64, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04,
	0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64,
	0x12, 0x16, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x48, 0x0a, 0x12, 0x72, 0x65, 0x74, 0x65,
	0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x11, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76,
	0x61, 0x6c, 0x12, 0x42, 0x0a, 0x0f, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x2a, 0x47, 0x0a, 0x0b, 0x53, 0x71, 0x6c, 0x46, 0x69, 0x6c,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x51, 0x4c, 0x5f, 0x46, 0x49, 0x4c,
	0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x53, 0x51, 0x4c, 0x10, 0x01, 0x12, 0x07, 0x0a,
	0x03, 0x43, 0x53, 0x56, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x42, 0x41, 0x4b, 0x10, 0x04, 0x2a,
	0xc4, 0x01, 0x0a, 0x12, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x25, 0x0a, 0x21, 0x53, 0x51, 0x4c, 0x5f, 0x42, 0x41,
	0x43, 0x4b, 0x55, 0x50, 0x5f, 0x52, 0x55, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x45, 0x4e, 0x51, 0x55, 0x45, 0x55, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x4f,
	0x56, 0x45, 0x52, 0x44, 0x55, 0x45, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e,
	0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10,
	0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x46, 0x55, 0x4c, 0x10,
	0x05, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x4b, 0x49, 0x50, 0x50, 0x45, 0x44, 0x10, 0x06, 0x12, 0x14,
	0x0a, 0x10, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x45, 0x4e, 0x44, 0x49,
	0x4e, 0x47, 0x10, 0x07, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x08, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c,
	0x45, 0x54, 0x45, 0x44, 0x10, 0x09, 0x2a, 0x55, 0x0a, 0x10, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x53, 0x51,
	0x4c, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x52, 0x55, 0x4e, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0d, 0x0a, 0x09, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0d,
	0x0a, 0x09, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4d, 0x41, 0x4e, 0x44, 0x10, 0x02, 0x2a, 0x4c, 0x0a,
	0x0d, 0x53, 0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x1f,
	0x0a, 0x1b, 0x53, 0x51, 0x4c, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x4b, 0x49, 0x4e,
	0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0c, 0x0a, 0x08, 0x53, 0x4e, 0x41, 0x50, 0x53, 0x48, 0x4f, 0x54, 0x10, 0x01, 0x12, 0x0c, 0x0a,
	0x08, 0x50, 0x48, 0x59, 0x53, 0x49, 0x43, 0x41, 0x4c, 0x10, 0x02, 0x2a, 0x63, 0x0a, 0x0e, 0x53,
	0x71, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a,
	0x1c, 0x53, 0x51, 0x4c, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x45, 0x4e, 0x44, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x11, 0x0a, 0x09, 0x46, 0x49, 0x52, 0x53, 0x54, 0x5f, 0x47, 0x45, 0x4e, 0x10, 0x01, 0x1a, 0x02,
	0x08, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x5f, 0x47, 0x45, 0x4e,
	0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x10, 0x03,
	0x2a, 0x75, 0x0a, 0x10, 0x53, 0x71, 0x6c, 0x49, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x53, 0x51, 0x4c, 0x5f, 0x49, 0x50, 0x5f, 0x41,
	0x44, 0x44, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52, 0x49,
	0x4d, 0x41, 0x52, 0x59, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x4f, 0x55, 0x54, 0x47, 0x4f, 0x49,
	0x4e, 0x47, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x10,
	0x03, 0x12, 0x14, 0x0a, 0x10, 0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x31, 0x53,
	0x54, 0x5f, 0x47, 0x45, 0x4e, 0x10, 0x04, 0x2a, 0x81, 0x01, 0x0a, 0x0f, 0x53, 0x71, 0x6c, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x1d, 0x53,
	0x51, 0x4c, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16,
	0x0a, 0x12, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x51, 0x4c, 0x5f, 0x49, 0x4e, 0x53, 0x54,
	0x41, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x4f, 0x4e, 0x5f, 0x50, 0x52, 0x45,
	0x4d, 0x49, 0x53, 0x45, 0x53, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x02,
	0x12, 0x19, 0x0a, 0x15, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41,
	0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x03, 0x2a, 0x9d, 0x04, 0x0a, 0x12,
	0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x20, 0x53, 0x51, 0x4c, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41,
	0x53, 0x45, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x09, 0x4d, 0x59, 0x53, 0x51,
	0x4c, 0x5f, 0x35, 0x5f, 0x31, 0x10, 0x02, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x11, 0x0a, 0x09, 0x4d,
	0x59, 0x53, 0x51, 0x4c, 0x5f, 0x35, 0x5f, 0x35, 0x10, 0x03, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x0d,
	0x0a, 0x09, 0x4d, 0x59, 0x53, 0x51, 0x4c, 0x5f, 0x35, 0x5f, 0x36, 0x10, 0x05, 0x12, 0x0d, 0x0a,
	0x09, 0x4d, 0x59, 0x53, 0x51, 0x4c, 0x5f, 0x35, 0x5f, 0x37, 0x10, 0x06, 0x12, 0x10, 0x0a, 0x0c,
	0x50, 0x4f, 0x53, 0x54, 0x47, 0x52, 0x45, 0x53, 0x5f, 0x39, 0x5f, 0x36, 0x10, 0x09, 0x12, 0x0f,
	0x0a, 0x0b, 0x50, 0x4f, 0x53, 0x54, 0x47, 0x52, 0x45, 0x53, 0x5f, 0x31, 0x31, 0x10, 0x0a, 0x12,
	0x1b, 0x0a, 0x17, 0x53, 0x51, 0x4c, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x32, 0x30, 0x31,
	0x37, 0x5f, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x0b, 0x12, 0x1d, 0x0a, 0x19,
	0x53, 0x51, 0x4c, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x32, 0x30, 0x31, 0x37, 0x5f, 0x45,
	0x4e, 0x54, 0x45, 0x52, 0x50, 0x52, 0x49, 0x53, 0x45, 0x10, 0x0e, 0x12, 0x1a, 0x0a, 0x16, 0x53,
	0x51, 0x4c, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x32, 0x30, 0x31, 0x37, 0x5f, 0x45, 0x58,
	0x50, 0x52, 0x45, 0x53, 0x53, 0x10, 0x0f, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x51, 0x4c, 0x53, 0x45,
	0x52, 0x56, 0x45, 0x52, 0x5f, 0x32, 0x30, 0x31, 0x37, 0x5f, 0x57, 0x45, 0x42, 0x10, 0x10, 0x12,
	0x0f, 0x0a, 0x0b, 0x50, 0x4f, 0x53, 0x54, 0x47, 0x52, 0x45, 0x53, 0x5f, 0x31, 0x30, 0x10, 0x12,
	0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x4f, 0x53, 0x54, 0x47, 0x52, 0x45, 0x53, 0x5f, 0x31, 0x32, 0x10,
	0x13, 0x12, 0x0d, 0x0a, 0x09, 0x4d, 0x59, 0x53, 0x51, 0x4c, 0x5f, 0x38, 0x5f, 0x30, 0x10, 0x14,
	0x12, 0x10, 0x0a, 0x0c, 0x4d, 0x59, 0x53, 0x51, 0x4c, 0x5f, 0x38, 0x5f, 0x30, 0x5f, 0x31, 0x38,
	0x10, 0x29, 0x12, 0x10, 0x0a, 0x0c, 0x4d, 0x59, 0x53, 0x51, 0x4c, 0x5f, 0x38, 0x5f, 0x30, 0x5f,
	0x32, 0x36, 0x10, 0x55, 0x12, 0x10, 0x0a, 0x0c, 0x4d, 0x59, 0x53, 0x51, 0x4c, 0x5f, 0x38, 0x5f,
	0x30, 0x5f, 0x32, 0x37, 0x10, 0x6f, 0x12, 0x11, 0x0a, 0x0c, 0x4d, 0x59, 0x53, 0x51, 0x4c, 0x5f,
	0x38, 0x5f, 0x30, 0x5f, 0x32, 0x38, 0x10, 0x84, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x4f, 0x53,
	0x54, 0x47, 0x52, 0x45, 0x53, 0x5f, 0x31, 0x33, 0x10, 0x17, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x4f,
	0x53, 0x54, 0x47, 0x52, 0x45, 0x53, 0x5f, 0x31, 0x34, 0x10, 0x6e, 0x12, 0x1b, 0x0a, 0x17, 0x53,
	0x51, 0x4c, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x32, 0x30, 0x31, 0x39, 0x5f, 0x53, 0x54,
	0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x1a, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x51, 0x4c, 0x53,
	0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x32, 0x30, 0x31, 0x39, 0x5f, 0x45, 0x4e, 0x54, 0x45, 0x52,
	0x50, 0x52, 0x49, 0x53, 0x45, 0x10, 0x1b, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x51, 0x4c, 0x53, 0x45,
	0x52, 0x56, 0x45, 0x52, 0x5f, 0x32, 0x30, 0x31, 0x39, 0x5f, 0x45, 0x58, 0x50, 0x52, 0x45, 0x53,
	0x53, 0x10, 0x1c, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x51, 0x4c, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52,
	0x5f, 0x32, 0x30, 0x31, 0x39, 0x5f, 0x57, 0x45, 0x42, 0x10, 0x1d, 0x2a, 0x8a, 0x01, 0x0a, 0x13,
	0x53, 0x71, 0x6c, 0x53, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x21, 0x53, 0x51, 0x4c, 0x5f, 0x53, 0x55, 0x53, 0x50, 0x45,
	0x4e, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x42, 0x49,
	0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x5f, 0x49, 0x53, 0x53, 0x55, 0x45, 0x10, 0x02, 0x12, 0x0f, 0x0a,
	0x0b, 0x4c, 0x45, 0x47, 0x41, 0x4c, 0x5f, 0x49, 0x53, 0x53, 0x55, 0x45, 0x10, 0x03, 0x12, 0x15,
	0x0a, 0x11, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x5f, 0x49, 0x53,
	0x53, 0x55, 0x45, 0x10, 0x04, 0x12, 0x11, 0x0a, 0x0d, 0x4b, 0x4d, 0x53, 0x5f, 0x4b, 0x45, 0x59,
	0x5f, 0x49, 0x53, 0x53, 0x55, 0x45, 0x10, 0x05, 0x2a, 0x4c, 0x0a, 0x0e, 0x53, 0x71, 0x6c, 0x50,
	0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x20, 0x0a, 0x1c, 0x53, 0x51,
	0x4c, 0x5f, 0x50, 0x52, 0x49, 0x43, 0x49, 0x4e, 0x47, 0x5f, 0x50, 0x4c, 0x41, 0x4e, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x50, 0x41, 0x43, 0x4b, 0x41, 0x47, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x52,
	0x5f, 0x55, 0x53, 0x45, 0x10, 0x02, 0x2a, 0x5d, 0x0a, 0x12, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x24, 0x0a, 0x20,
	0x53, 0x51, 0x4c, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x59, 0x4e, 0x43, 0x48, 0x52, 0x4f, 0x4e, 0x4f, 0x55,
	0x53, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x41, 0x53, 0x59, 0x4e, 0x43, 0x48, 0x52, 0x4f, 0x4e,
	0x4f, 0x55, 0x53, 0x10, 0x02, 0x2a, 0x69, 0x0a, 0x0f, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61,
	0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x53, 0x51, 0x4c, 0x5f,
	0x44, 0x41, 0x54, 0x41, 0x5f, 0x44, 0x49, 0x53, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06,
	0x50, 0x44, 0x5f, 0x53, 0x53, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x44, 0x5f, 0x48,
	0x44, 0x44, 0x10, 0x02, 0x12, 0x1a, 0x0a, 0x12, 0x4f, 0x42, 0x53, 0x4f, 0x4c, 0x45, 0x54, 0x45,
	0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x5f, 0x53, 0x53, 0x44, 0x10, 0x03, 0x1a, 0x02, 0x08, 0x01,
	0x2a, 0x55, 0x0a, 0x13, 0x53, 0x71, 0x6c, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x21, 0x53, 0x51, 0x4c, 0x5f, 0x41,
	0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09,
	0x0a, 0x05, 0x5a, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x47,
	0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x02, 0x2a, 0x4a, 0x0a, 0x0e, 0x53, 0x71, 0x6c, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x12, 0x20, 0x0a, 0x1c, 0x53, 0x51, 0x4c,
	0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x52, 0x41, 0x43, 0x4b, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x63,
	0x61, 0x6e, 0x61, 0x72, 0x79, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x10, 0x02, 0x2a, 0x97, 0x01, 0x0a, 0x0b, 0x53, 0x71, 0x6c, 0x46, 0x6c, 0x61, 0x67, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x51, 0x4c, 0x5f, 0x46, 0x4c, 0x41, 0x47, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x42, 0x4f, 0x4f, 0x4c, 0x45, 0x41, 0x4e, 0x10, 0x01, 0x12,
	0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x49,
	0x4e, 0x54, 0x45, 0x47, 0x45, 0x52, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45,
	0x10, 0x04, 0x12, 0x19, 0x0a, 0x15, 0x4d, 0x59, 0x53, 0x51, 0x4c, 0x5f, 0x54, 0x49, 0x4d, 0x45,
	0x5a, 0x4f, 0x4e, 0x45, 0x5f, 0x4f, 0x46, 0x46, 0x53, 0x45, 0x54, 0x10, 0x05, 0x12, 0x09, 0x0a,
	0x05, 0x46, 0x4c, 0x4f, 0x41, 0x54, 0x10, 0x06, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45, 0x50, 0x45,
	0x41, 0x54, 0x45, 0x44, 0x5f, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x42, 0x75, 0x0a,
	0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x71, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34, 0x42, 0x16, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x71, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x34,
	0x3b, 0x73, 0x71, 0x6c, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescOnce sync.Once
	file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescData = file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDesc
)

func file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescData)
	})
	return file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDescData
}

var file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 25)
var file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 77)
var file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_goTypes = []interface{}{
	(SqlFileType)(0),                           // 0: google.cloud.sql.v1beta4.SqlFileType
	(SqlBackupRunStatus)(0),                    // 1: google.cloud.sql.v1beta4.SqlBackupRunStatus
	(SqlBackupRunType)(0),                      // 2: google.cloud.sql.v1beta4.SqlBackupRunType
	(SqlBackupKind)(0),                         // 3: google.cloud.sql.v1beta4.SqlBackupKind
	(SqlBackendType)(0),                        // 4: google.cloud.sql.v1beta4.SqlBackendType
	(SqlIpAddressType)(0),                      // 5: google.cloud.sql.v1beta4.SqlIpAddressType
	(SqlInstanceType)(0),                       // 6: google.cloud.sql.v1beta4.SqlInstanceType
	(SqlDatabaseVersion)(0),                    // 7: google.cloud.sql.v1beta4.SqlDatabaseVersion
	(SqlSuspensionReason)(0),                   // 8: google.cloud.sql.v1beta4.SqlSuspensionReason
	(SqlPricingPlan)(0),                        // 9: google.cloud.sql.v1beta4.SqlPricingPlan
	(SqlReplicationType)(0),                    // 10: google.cloud.sql.v1beta4.SqlReplicationType
	(SqlDataDiskType)(0),                       // 11: google.cloud.sql.v1beta4.SqlDataDiskType
	(SqlAvailabilityType)(0),                   // 12: google.cloud.sql.v1beta4.SqlAvailabilityType
	(SqlUpdateTrack)(0),                        // 13: google.cloud.sql.v1beta4.SqlUpdateTrack
	(SqlFlagType)(0),                           // 14: google.cloud.sql.v1beta4.SqlFlagType
	(ApiWarning_SqlApiWarningCode)(0),          // 15: google.cloud.sql.v1beta4.ApiWarning.SqlApiWarningCode
	(BackupRetentionSettings_RetentionUnit)(0), // 16: google.cloud.sql.v1beta4.BackupRetentionSettings.RetentionUnit
	(DatabaseInstance_SqlInstanceState)(0),     // 17: google.cloud.sql.v1beta4.DatabaseInstance.SqlInstanceState
	(DatabaseInstance_SqlOutOfDiskReport_SqlOutOfDiskState)(0),       // 18: google.cloud.sql.v1beta4.DatabaseInstance.SqlOutOfDiskReport.SqlOutOfDiskState
	(SqlExternalSyncSettingError_SqlExternalSyncSettingErrorType)(0), // 19: google.cloud.sql.v1beta4.SqlExternalSyncSettingError.SqlExternalSyncSettingErrorType
	(Operation_SqlOperationType)(0),                                  // 20: google.cloud.sql.v1beta4.Operation.SqlOperationType
	(Operation_SqlOperationStatus)(0),                                // 21: google.cloud.sql.v1beta4.Operation.SqlOperationStatus
	(PasswordValidationPolicy_Complexity)(0),                         // 22: google.cloud.sql.v1beta4.PasswordValidationPolicy.Complexity
	(Settings_SqlActivationPolicy)(0),                                // 23: google.cloud.sql.v1beta4.Settings.SqlActivationPolicy
	(SqlInstancesRescheduleMaintenanceRequestBody_RescheduleType)(0), // 24: google.cloud.sql.v1beta4.SqlInstancesRescheduleMaintenanceRequestBody.RescheduleType
	(*AclEntry)(nil),                                            // 25: google.cloud.sql.v1beta4.AclEntry
	(*ApiWarning)(nil),                                          // 26: google.cloud.sql.v1beta4.ApiWarning
	(*BackupRetentionSettings)(nil),                             // 27: google.cloud.sql.v1beta4.BackupRetentionSettings
	(*BackupConfiguration)(nil),                                 // 28: google.cloud.sql.v1beta4.BackupConfiguration
	(*BackupRun)(nil),                                           // 29: google.cloud.sql.v1beta4.BackupRun
	(*BackupRunsListResponse)(nil),                              // 30: google.cloud.sql.v1beta4.BackupRunsListResponse
	(*BinLogCoordinates)(nil),                                   // 31: google.cloud.sql.v1beta4.BinLogCoordinates
	(*BackupContext)(nil),                                       // 32: google.cloud.sql.v1beta4.BackupContext
	(*CloneContext)(nil),                                        // 33: google.cloud.sql.v1beta4.CloneContext
	(*Database)(nil),                                            // 34: google.cloud.sql.v1beta4.Database
	(*SqlServerDatabaseDetails)(nil),                            // 35: google.cloud.sql.v1beta4.SqlServerDatabaseDetails
	(*DatabaseFlags)(nil),                                       // 36: google.cloud.sql.v1beta4.DatabaseFlags
	(*SyncFlags)(nil),                                           // 37: google.cloud.sql.v1beta4.SyncFlags
	(*InstanceReference)(nil),                                   // 38: google.cloud.sql.v1beta4.InstanceReference
	(*DatabaseInstance)(nil),                                    // 39: google.cloud.sql.v1beta4.DatabaseInstance
	(*DatabasesListResponse)(nil),                               // 40: google.cloud.sql.v1beta4.DatabasesListResponse
	(*DemoteMasterConfiguration)(nil),                           // 41: google.cloud.sql.v1beta4.DemoteMasterConfiguration
	(*DemoteMasterContext)(nil),                                 // 42: google.cloud.sql.v1beta4.DemoteMasterContext
	(*DemoteMasterMySqlReplicaConfiguration)(nil),               // 43: google.cloud.sql.v1beta4.DemoteMasterMySqlReplicaConfiguration
	(*ExportContext)(nil),                                       // 44: google.cloud.sql.v1beta4.ExportContext
	(*FailoverContext)(nil),                                     // 45: google.cloud.sql.v1beta4.FailoverContext
	(*Flag)(nil),                                                // 46: google.cloud.sql.v1beta4.Flag
	(*FlagsListResponse)(nil),                                   // 47: google.cloud.sql.v1beta4.FlagsListResponse
	(*ImportContext)(nil),                                       // 48: google.cloud.sql.v1beta4.ImportContext
	(*InstancesCloneRequest)(nil),                               // 49: google.cloud.sql.v1beta4.InstancesCloneRequest
	(*InstancesDemoteMasterRequest)(nil),                        // 50: google.cloud.sql.v1beta4.InstancesDemoteMasterRequest
	(*InstancesExportRequest)(nil),                              // 51: google.cloud.sql.v1beta4.InstancesExportRequest
	(*InstancesFailoverRequest)(nil),                            // 52: google.cloud.sql.v1beta4.InstancesFailoverRequest
	(*InstancesImportRequest)(nil),                              // 53: google.cloud.sql.v1beta4.InstancesImportRequest
	(*MySqlSyncConfig)(nil),                                     // 54: google.cloud.sql.v1beta4.MySqlSyncConfig
	(*InstancesListResponse)(nil),                               // 55: google.cloud.sql.v1beta4.InstancesListResponse
	(*InstancesListServerCasResponse)(nil),                      // 56: google.cloud.sql.v1beta4.InstancesListServerCasResponse
	(*InstancesRestoreBackupRequest)(nil),                       // 57: google.cloud.sql.v1beta4.InstancesRestoreBackupRequest
	(*InstancesRotateServerCaRequest)(nil),                      // 58: google.cloud.sql.v1beta4.InstancesRotateServerCaRequest
	(*InstancesTruncateLogRequest)(nil),                         // 59: google.cloud.sql.v1beta4.InstancesTruncateLogRequest
	(*SqlInstancesVerifyExternalSyncSettingsResponse)(nil),      // 60: google.cloud.sql.v1beta4.SqlInstancesVerifyExternalSyncSettingsResponse
	(*SqlExternalSyncSettingError)(nil),                         // 61: google.cloud.sql.v1beta4.SqlExternalSyncSettingError
	(*IpConfiguration)(nil),                                     // 62: google.cloud.sql.v1beta4.IpConfiguration
	(*IpMapping)(nil),                                           // 63: google.cloud.sql.v1beta4.IpMapping
	(*LocationPreference)(nil),                                  // 64: google.cloud.sql.v1beta4.LocationPreference
	(*MaintenanceWindow)(nil),                                   // 65: google.cloud.sql.v1beta4.MaintenanceWindow
	(*DenyMaintenancePeriod)(nil),                               // 66: google.cloud.sql.v1beta4.DenyMaintenancePeriod
	(*InsightsConfig)(nil),                                      // 67: google.cloud.sql.v1beta4.InsightsConfig
	(*MySqlReplicaConfiguration)(nil),                           // 68: google.cloud.sql.v1beta4.MySqlReplicaConfiguration
	(*OnPremisesConfiguration)(nil),                             // 69: google.cloud.sql.v1beta4.OnPremisesConfiguration
	(*DiskEncryptionConfiguration)(nil),                         // 70: google.cloud.sql.v1beta4.DiskEncryptionConfiguration
	(*DiskEncryptionStatus)(nil),                                // 71: google.cloud.sql.v1beta4.DiskEncryptionStatus
	(*Operation)(nil),                                           // 72: google.cloud.sql.v1beta4.Operation
	(*OperationError)(nil),                                      // 73: google.cloud.sql.v1beta4.OperationError
	(*OperationErrors)(nil),                                     // 74: google.cloud.sql.v1beta4.OperationErrors
	(*PasswordValidationPolicy)(nil),                            // 75: google.cloud.sql.v1beta4.PasswordValidationPolicy
	(*OperationsListResponse)(nil),                              // 76: google.cloud.sql.v1beta4.OperationsListResponse
	(*ReplicaConfiguration)(nil),                                // 77: google.cloud.sql.v1beta4.ReplicaConfiguration
	(*RestoreBackupContext)(nil),                                // 78: google.cloud.sql.v1beta4.RestoreBackupContext
	(*RotateServerCaContext)(nil),                               // 79: google.cloud.sql.v1beta4.RotateServerCaContext
	(*Settings)(nil),                                            // 80: google.cloud.sql.v1beta4.Settings
	(*SslCert)(nil),                                             // 81: google.cloud.sql.v1beta4.SslCert
	(*SslCertDetail)(nil),                                       // 82: google.cloud.sql.v1beta4.SslCertDetail
	(*SslCertsCreateEphemeralRequest)(nil),                      // 83: google.cloud.sql.v1beta4.SslCertsCreateEphemeralRequest
	(*SslCertsInsertRequest)(nil),                               // 84: google.cloud.sql.v1beta4.SslCertsInsertRequest
	(*SqlInstancesRescheduleMaintenanceRequestBody)(nil),        // 85: google.cloud.sql.v1beta4.SqlInstancesRescheduleMaintenanceRequestBody
	(*SslCertsInsertResponse)(nil),                              // 86: google.cloud.sql.v1beta4.SslCertsInsertResponse
	(*SslCertsListResponse)(nil),                                // 87: google.cloud.sql.v1beta4.SslCertsListResponse
	(*TruncateLogContext)(nil),                                  // 88: google.cloud.sql.v1beta4.TruncateLogContext
	(*SqlActiveDirectoryConfig)(nil),                            // 89: google.cloud.sql.v1beta4.SqlActiveDirectoryConfig
	(*SqlServerAuditConfig)(nil),                                // 90: google.cloud.sql.v1beta4.SqlServerAuditConfig
	(*DatabaseInstance_SqlFailoverReplica)(nil),                 // 91: google.cloud.sql.v1beta4.DatabaseInstance.SqlFailoverReplica
	(*DatabaseInstance_SqlScheduledMaintenance)(nil),            // 92: google.cloud.sql.v1beta4.DatabaseInstance.SqlScheduledMaintenance
	(*DatabaseInstance_SqlOutOfDiskReport)(nil),                 // 93: google.cloud.sql.v1beta4.DatabaseInstance.SqlOutOfDiskReport
	(*ExportContext_SqlCsvExportOptions)(nil),                   // 94: google.cloud.sql.v1beta4.ExportContext.SqlCsvExportOptions
	(*ExportContext_SqlExportOptions)(nil),                      // 95: google.cloud.sql.v1beta4.ExportContext.SqlExportOptions
	(*ExportContext_SqlExportOptions_MysqlExportOptions)(nil),   // 96: google.cloud.sql.v1beta4.ExportContext.SqlExportOptions.MysqlExportOptions
	(*ImportContext_SqlCsvImportOptions)(nil),                   // 97: google.cloud.sql.v1beta4.ImportContext.SqlCsvImportOptions
	(*ImportContext_SqlBakImportOptions)(nil),                   // 98: google.cloud.sql.v1beta4.ImportContext.SqlBakImportOptions
	(*ImportContext_SqlBakImportOptions_EncryptionOptions)(nil), // 99: google.cloud.sql.v1beta4.ImportContext.SqlBakImportOptions.EncryptionOptions
	nil, // 100: google.cloud.sql.v1beta4.Settings.UserLabelsEntry
	(*SqlInstancesRescheduleMaintenanceRequestBody_Reschedule)(nil), // 101: google.cloud.sql.v1beta4.SqlInstancesRescheduleMaintenanceRequestBody.Reschedule
	(*timestamppb.Timestamp)(nil),                                   // 102: google.protobuf.Timestamp
	(*wrapperspb.Int32Value)(nil),                                   // 103: google.protobuf.Int32Value
	(*wrapperspb.BoolValue)(nil),                                    // 104: google.protobuf.BoolValue
	(*wrapperspb.Int64Value)(nil),                                   // 105: google.protobuf.Int64Value
	(*durationpb.Duration)(nil),                                     // 106: google.protobuf.Duration
}
var file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_depIdxs = []int32{
	102, // 0: google.cloud.sql.v1beta4.AclEntry.expiration_time:type_name -> google.protobuf.Timestamp
	15,  // 1: google.cloud.sql.v1beta4.ApiWarning.code:type_name -> google.cloud.sql.v1beta4.ApiWarning.SqlApiWarningCode
	16,  // 2: google.cloud.sql.v1beta4.BackupRetentionSettings.retention_unit:type_name -> google.cloud.sql.v1beta4.BackupRetentionSettings.RetentionUnit
	103, // 3: google.cloud.sql.v1beta4.BackupRetentionSettings.retained_backups:type_name -> google.protobuf.Int32Value
	104, // 4: google.cloud.sql.v1beta4.BackupConfiguration.enabled:type_name -> google.protobuf.BoolValue
	104, // 5: google.cloud.sql.v1beta4.BackupConfiguration.binary_log_enabled:type_name -> google.protobuf.BoolValue
	104, // 6: google.cloud.sql.v1beta4.BackupConfiguration.replication_log_archiving_enabled:type_name -> google.protobuf.BoolValue
	104, // 7: google.cloud.sql.v1beta4.BackupConfiguration.point_in_time_recovery_enabled:type_name -> google.protobuf.BoolValue
	103, // 8: google.cloud.sql.v1beta4.BackupConfiguration.transaction_log_retention_days:type_name -> google.protobuf.Int32Value
	27,  // 9: google.cloud.sql.v1beta4.BackupConfiguration.backup_retention_settings:type_name -> google.cloud.sql.v1beta4.BackupRetentionSettings
	1,   // 10: google.cloud.sql.v1beta4.BackupRun.status:type_name -> google.cloud.sql.v1beta4.SqlBackupRunStatus
	102, // 11: google.cloud.sql.v1beta4.BackupRun.enqueued_time:type_name -> google.protobuf.Timestamp
	102, // 12: google.cloud.sql.v1beta4.BackupRun.start_time:type_name -> google.protobuf.Timestamp
	102, // 13: google.cloud.sql.v1beta4.BackupRun.end_time:type_name -> google.protobuf.Timestamp
	73,  // 14: google.cloud.sql.v1beta4.BackupRun.error:type_name -> google.cloud.sql.v1beta4.OperationError
	2,   // 15: google.cloud.sql.v1beta4.BackupRun.type:type_name -> google.cloud.sql.v1beta4.SqlBackupRunType
	102, // 16: google.cloud.sql.v1beta4.BackupRun.window_start_time:type_name -> google.protobuf.Timestamp
	70,  // 17: google.cloud.sql.v1beta4.BackupRun.disk_encryption_configuration:type_name -> google.cloud.sql.v1beta4.DiskEncryptionConfiguration
	71,  // 18: google.cloud.sql.v1beta4.BackupRun.disk_encryption_status:type_name -> google.cloud.sql.v1beta4.DiskEncryptionStatus
	3,   // 19: google.cloud.sql.v1beta4.BackupRun.backup_kind:type_name -> google.cloud.sql.v1beta4.SqlBackupKind
	29,  // 20: google.cloud.sql.v1beta4.BackupRunsListResponse.items:type_name -> google.cloud.sql.v1beta4.BackupRun
	31,  // 21: google.cloud.sql.v1beta4.CloneContext.bin_log_coordinates:type_name -> google.cloud.sql.v1beta4.BinLogCoordinates
	102, // 22: google.cloud.sql.v1beta4.CloneContext.point_in_time:type_name -> google.protobuf.Timestamp
	35,  // 23: google.cloud.sql.v1beta4.Database.sqlserver_database_details:type_name -> google.cloud.sql.v1beta4.SqlServerDatabaseDetails
	17,  // 24: google.cloud.sql.v1beta4.DatabaseInstance.state:type_name -> google.cloud.sql.v1beta4.DatabaseInstance.SqlInstanceState
	7,   // 25: google.cloud.sql.v1beta4.DatabaseInstance.database_version:type_name -> google.cloud.sql.v1beta4.SqlDatabaseVersion
	80,  // 26: google.cloud.sql.v1beta4.DatabaseInstance.settings:type_name -> google.cloud.sql.v1beta4.Settings
	91,  // 27: google.cloud.sql.v1beta4.DatabaseInstance.failover_replica:type_name -> google.cloud.sql.v1beta4.DatabaseInstance.SqlFailoverReplica
	105, // 28: google.cloud.sql.v1beta4.DatabaseInstance.max_disk_size:type_name -> google.protobuf.Int64Value
	105, // 29: google.cloud.sql.v1beta4.DatabaseInstance.current_disk_size:type_name -> google.protobuf.Int64Value
	63,  // 30: google.cloud.sql.v1beta4.DatabaseInstance.ip_addresses:type_name -> google.cloud.sql.v1beta4.IpMapping
	81,  // 31: google.cloud.sql.v1beta4.DatabaseInstance.server_ca_cert:type_name -> google.cloud.sql.v1beta4.SslCert
	6,   // 32: google.cloud.sql.v1beta4.DatabaseInstance.instance_type:type_name -> google.cloud.sql.v1beta4.SqlInstanceType
	69,  // 33: google.cloud.sql.v1beta4.DatabaseInstance.on_premises_configuration:type_name -> google.cloud.sql.v1beta4.OnPremisesConfiguration
	77,  // 34: google.cloud.sql.v1beta4.DatabaseInstance.replica_configuration:type_name -> google.cloud.sql.v1beta4.ReplicaConfiguration
	4,   // 35: google.cloud.sql.v1beta4.DatabaseInstance.backend_type:type_name -> google.cloud.sql.v1beta4.SqlBackendType
	8,   // 36: google.cloud.sql.v1beta4.DatabaseInstance.suspension_reason:type_name -> google.cloud.sql.v1beta4.SqlSuspensionReason
	70,  // 37: google.cloud.sql.v1beta4.DatabaseInstance.disk_encryption_configuration:type_name -> google.cloud.sql.v1beta4.DiskEncryptionConfiguration
	71,  // 38: google.cloud.sql.v1beta4.DatabaseInstance.disk_encryption_status:type_name -> google.cloud.sql.v1beta4.DiskEncryptionStatus
	92,  // 39: google.cloud.sql.v1beta4.DatabaseInstance.scheduled_maintenance:type_name -> google.cloud.sql.v1beta4.DatabaseInstance.SqlScheduledMaintenance
	104, // 40: google.cloud.sql.v1beta4.DatabaseInstance.satisfies_pzs:type_name -> google.protobuf.BoolValue
	93,  // 41: google.cloud.sql.v1beta4.DatabaseInstance.out_of_disk_report:type_name -> google.cloud.sql.v1beta4.DatabaseInstance.SqlOutOfDiskReport
	102, // 42: google.cloud.sql.v1beta4.DatabaseInstance.create_time:type_name -> google.protobuf.Timestamp
	34,  // 43: google.cloud.sql.v1beta4.DatabasesListResponse.items:type_name -> google.cloud.sql.v1beta4.Database
	43,  // 44: google.cloud.sql.v1beta4.DemoteMasterConfiguration.mysql_replica_configuration:type_name -> google.cloud.sql.v1beta4.DemoteMasterMySqlReplicaConfiguration
	104, // 45: google.cloud.sql.v1beta4.DemoteMasterContext.verify_gtid_consistency:type_name -> google.protobuf.BoolValue
	41,  // 46: google.cloud.sql.v1beta4.DemoteMasterContext.replica_configuration:type_name -> google.cloud.sql.v1beta4.DemoteMasterConfiguration
	95,  // 47: google.cloud.sql.v1beta4.ExportContext.sql_export_options:type_name -> google.cloud.sql.v1beta4.ExportContext.SqlExportOptions
	94,  // 48: google.cloud.sql.v1beta4.ExportContext.csv_export_options:type_name -> google.cloud.sql.v1beta4.ExportContext.SqlCsvExportOptions
	0,   // 49: google.cloud.sql.v1beta4.ExportContext.file_type:type_name -> google.cloud.sql.v1beta4.SqlFileType
	104, // 50: google.cloud.sql.v1beta4.ExportContext.offload:type_name -> google.protobuf.BoolValue
	14,  // 51: google.cloud.sql.v1beta4.Flag.type:type_name -> google.cloud.sql.v1beta4.SqlFlagType
	7,   // 52: google.cloud.sql.v1beta4.Flag.applies_to:type_name -> google.cloud.sql.v1beta4.SqlDatabaseVersion
	105, // 53: google.cloud.sql.v1beta4.Flag.min_value:type_name -> google.protobuf.Int64Value
	105, // 54: google.cloud.sql.v1beta4.Flag.max_value:type_name -> google.protobuf.Int64Value
	104, // 55: google.cloud.sql.v1beta4.Flag.requires_restart:type_name -> google.protobuf.BoolValue
	104, // 56: google.cloud.sql.v1beta4.Flag.in_beta:type_name -> google.protobuf.BoolValue
	46,  // 57: google.cloud.sql.v1beta4.FlagsListResponse.items:type_name -> google.cloud.sql.v1beta4.Flag
	0,   // 58: google.cloud.sql.v1beta4.ImportContext.file_type:type_name -> google.cloud.sql.v1beta4.SqlFileType
	97,  // 59: google.cloud.sql.v1beta4.ImportContext.csv_import_options:type_name -> google.cloud.sql.v1beta4.ImportContext.SqlCsvImportOptions
	98,  // 60: google.cloud.sql.v1beta4.ImportContext.bak_import_options:type_name -> google.cloud.sql.v1beta4.ImportContext.SqlBakImportOptions
	33,  // 61: google.cloud.sql.v1beta4.InstancesCloneRequest.clone_context:type_name -> google.cloud.sql.v1beta4.CloneContext
	42,  // 62: google.cloud.sql.v1beta4.InstancesDemoteMasterRequest.demote_master_context:type_name -> google.cloud.sql.v1beta4.DemoteMasterContext
	44,  // 63: google.cloud.sql.v1beta4.InstancesExportRequest.export_context:type_name -> google.cloud.sql.v1beta4.ExportContext
	45,  // 64: google.cloud.sql.v1beta4.InstancesFailoverRequest.failover_context:type_name -> google.cloud.sql.v1beta4.FailoverContext
	48,  // 65: google.cloud.sql.v1beta4.InstancesImportRequest.import_context:type_name -> google.cloud.sql.v1beta4.ImportContext
	37,  // 66: google.cloud.sql.v1beta4.MySqlSyncConfig.initial_sync_flags:type_name -> google.cloud.sql.v1beta4.SyncFlags
	26,  // 67: google.cloud.sql.v1beta4.InstancesListResponse.warnings:type_name -> google.cloud.sql.v1beta4.ApiWarning
	39,  // 68: google.cloud.sql.v1beta4.InstancesListResponse.items:type_name -> google.cloud.sql.v1beta4.DatabaseInstance
	81,  // 69: google.cloud.sql.v1beta4.InstancesListServerCasResponse.certs:type_name -> google.cloud.sql.v1beta4.SslCert
	78,  // 70: google.cloud.sql.v1beta4.InstancesRestoreBackupRequest.restore_backup_context:type_name -> google.cloud.sql.v1beta4.RestoreBackupContext
	79,  // 71: google.cloud.sql.v1beta4.InstancesRotateServerCaRequest.rotate_server_ca_context:type_name -> google.cloud.sql.v1beta4.RotateServerCaContext
	88,  // 72: google.cloud.sql.v1beta4.InstancesTruncateLogRequest.truncate_log_context:type_name -> google.cloud.sql.v1beta4.TruncateLogContext
	61,  // 73: google.cloud.sql.v1beta4.SqlInstancesVerifyExternalSyncSettingsResponse.errors:type_name -> google.cloud.sql.v1beta4.SqlExternalSyncSettingError
	61,  // 74: google.cloud.sql.v1beta4.SqlInstancesVerifyExternalSyncSettingsResponse.warnings:type_name -> google.cloud.sql.v1beta4.SqlExternalSyncSettingError
	19,  // 75: google.cloud.sql.v1beta4.SqlExternalSyncSettingError.type:type_name -> google.cloud.sql.v1beta4.SqlExternalSyncSettingError.SqlExternalSyncSettingErrorType
	104, // 76: google.cloud.sql.v1beta4.IpConfiguration.ipv4_enabled:type_name -> google.protobuf.BoolValue
	104, // 77: google.cloud.sql.v1beta4.IpConfiguration.require_ssl:type_name -> google.protobuf.BoolValue
	25,  // 78: google.cloud.sql.v1beta4.IpConfiguration.authorized_networks:type_name -> google.cloud.sql.v1beta4.AclEntry
	5,   // 79: google.cloud.sql.v1beta4.IpMapping.type:type_name -> google.cloud.sql.v1beta4.SqlIpAddressType
	102, // 80: google.cloud.sql.v1beta4.IpMapping.time_to_retire:type_name -> google.protobuf.Timestamp
	103, // 81: google.cloud.sql.v1beta4.MaintenanceWindow.hour:type_name -> google.protobuf.Int32Value
	103, // 82: google.cloud.sql.v1beta4.MaintenanceWindow.day:type_name -> google.protobuf.Int32Value
	13,  // 83: google.cloud.sql.v1beta4.MaintenanceWindow.update_track:type_name -> google.cloud.sql.v1beta4.SqlUpdateTrack
	103, // 84: google.cloud.sql.v1beta4.InsightsConfig.query_string_length:type_name -> google.protobuf.Int32Value
	103, // 85: google.cloud.sql.v1beta4.InsightsConfig.query_plans_per_minute:type_name -> google.protobuf.Int32Value
	103, // 86: google.cloud.sql.v1beta4.MySqlReplicaConfiguration.connect_retry_interval:type_name -> google.protobuf.Int32Value
	105, // 87: google.cloud.sql.v1beta4.MySqlReplicaConfiguration.master_heartbeat_period:type_name -> google.protobuf.Int64Value
	104, // 88: google.cloud.sql.v1beta4.MySqlReplicaConfiguration.verify_server_certificate:type_name -> google.protobuf.BoolValue
	38,  // 89: google.cloud.sql.v1beta4.OnPremisesConfiguration.source_instance:type_name -> google.cloud.sql.v1beta4.InstanceReference
	21,  // 90: google.cloud.sql.v1beta4.Operation.status:type_name -> google.cloud.sql.v1beta4.Operation.SqlOperationStatus
	102, // 91: google.cloud.sql.v1beta4.Operation.insert_time:type_name -> google.protobuf.Timestamp
	102, // 92: google.cloud.sql.v1beta4.Operation.start_time:type_name -> google.protobuf.Timestamp
	102, // 93: google.cloud.sql.v1beta4.Operation.end_time:type_name -> google.protobuf.Timestamp
	74,  // 94: google.cloud.sql.v1beta4.Operation.error:type_name -> google.cloud.sql.v1beta4.OperationErrors
	20,  // 95: google.cloud.sql.v1beta4.Operation.operation_type:type_name -> google.cloud.sql.v1beta4.Operation.SqlOperationType
	48,  // 96: google.cloud.sql.v1beta4.Operation.import_context:type_name -> google.cloud.sql.v1beta4.ImportContext
	44,  // 97: google.cloud.sql.v1beta4.Operation.export_context:type_name -> google.cloud.sql.v1beta4.ExportContext
	32,  // 98: google.cloud.sql.v1beta4.Operation.backup_context:type_name -> google.cloud.sql.v1beta4.BackupContext
	73,  // 99: google.cloud.sql.v1beta4.OperationErrors.errors:type_name -> google.cloud.sql.v1beta4.OperationError
	103, // 100: google.cloud.sql.v1beta4.PasswordValidationPolicy.min_length:type_name -> google.protobuf.Int32Value
	22,  // 101: google.cloud.sql.v1beta4.PasswordValidationPolicy.complexity:type_name -> google.cloud.sql.v1beta4.PasswordValidationPolicy.Complexity
	103, // 102: google.cloud.sql.v1beta4.PasswordValidationPolicy.reuse_interval:type_name -> google.protobuf.Int32Value
	104, // 103: google.cloud.sql.v1beta4.PasswordValidationPolicy.disallow_username_substring:type_name -> google.protobuf.BoolValue
	106, // 104: google.cloud.sql.v1beta4.PasswordValidationPolicy.password_change_interval:type_name -> google.protobuf.Duration
	104, // 105: google.cloud.sql.v1beta4.PasswordValidationPolicy.enable_password_policy:type_name -> google.protobuf.BoolValue
	72,  // 106: google.cloud.sql.v1beta4.OperationsListResponse.items:type_name -> google.cloud.sql.v1beta4.Operation
	68,  // 107: google.cloud.sql.v1beta4.ReplicaConfiguration.mysql_replica_configuration:type_name -> google.cloud.sql.v1beta4.MySqlReplicaConfiguration
	104, // 108: google.cloud.sql.v1beta4.ReplicaConfiguration.failover_target:type_name -> google.protobuf.BoolValue
	105, // 109: google.cloud.sql.v1beta4.Settings.settings_version:type_name -> google.protobuf.Int64Value
	100, // 110: google.cloud.sql.v1beta4.Settings.user_labels:type_name -> google.cloud.sql.v1beta4.Settings.UserLabelsEntry
	12,  // 111: google.cloud.sql.v1beta4.Settings.availability_type:type_name -> google.cloud.sql.v1beta4.SqlAvailabilityType
	9,   // 112: google.cloud.sql.v1beta4.Settings.pricing_plan:type_name -> google.cloud.sql.v1beta4.SqlPricingPlan
	10,  // 113: google.cloud.sql.v1beta4.Settings.replication_type:type_name -> google.cloud.sql.v1beta4.SqlReplicationType
	105, // 114: google.cloud.sql.v1beta4.Settings.storage_auto_resize_limit:type_name -> google.protobuf.Int64Value
	23,  // 115: google.cloud.sql.v1beta4.Settings.activation_policy:type_name -> google.cloud.sql.v1beta4.Settings.SqlActivationPolicy
	62,  // 116: google.cloud.sql.v1beta4.Settings.ip_configuration:type_name -> google.cloud.sql.v1beta4.IpConfiguration
	104, // 117: google.cloud.sql.v1beta4.Settings.storage_auto_resize:type_name -> google.protobuf.BoolValue
	64,  // 118: google.cloud.sql.v1beta4.Settings.location_preference:type_name -> google.cloud.sql.v1beta4.LocationPreference
	36,  // 119: google.cloud.sql.v1beta4.Settings.database_flags:type_name -> google.cloud.sql.v1beta4.DatabaseFlags
	11,  // 120: google.cloud.sql.v1beta4.Settings.data_disk_type:type_name -> google.cloud.sql.v1beta4.SqlDataDiskType
	65,  // 121: google.cloud.sql.v1beta4.Settings.maintenance_window:type_name -> google.cloud.sql.v1beta4.MaintenanceWindow
	28,  // 122: google.cloud.sql.v1beta4.Settings.backup_configuration:type_name -> google.cloud.sql.v1beta4.BackupConfiguration
	104, // 123: google.cloud.sql.v1beta4.Settings.database_replication_enabled:type_name -> google.protobuf.BoolValue
	104, // 124: google.cloud.sql.v1beta4.Settings.crash_safe_replication_enabled:type_name -> google.protobuf.BoolValue
	105, // 125: google.cloud.sql.v1beta4.Settings.data_disk_size_gb:type_name -> google.protobuf.Int64Value
	89,  // 126: google.cloud.sql.v1beta4.Settings.active_directory_config:type_name -> google.cloud.sql.v1beta4.SqlActiveDirectoryConfig
	66,  // 127: google.cloud.sql.v1beta4.Settings.deny_maintenance_periods:type_name -> google.cloud.sql.v1beta4.DenyMaintenancePeriod
	67,  // 128: google.cloud.sql.v1beta4.Settings.insights_config:type_name -> google.cloud.sql.v1beta4.InsightsConfig
	75,  // 129: google.cloud.sql.v1beta4.Settings.password_validation_policy:type_name -> google.cloud.sql.v1beta4.PasswordValidationPolicy
	90,  // 130: google.cloud.sql.v1beta4.Settings.sql_server_audit_config:type_name -> google.cloud.sql.v1beta4.SqlServerAuditConfig
	102, // 131: google.cloud.sql.v1beta4.SslCert.create_time:type_name -> google.protobuf.Timestamp
	102, // 132: google.cloud.sql.v1beta4.SslCert.expiration_time:type_name -> google.protobuf.Timestamp
	81,  // 133: google.cloud.sql.v1beta4.SslCertDetail.cert_info:type_name -> google.cloud.sql.v1beta4.SslCert
	101, // 134: google.cloud.sql.v1beta4.SqlInstancesRescheduleMaintenanceRequestBody.reschedule:type_name -> google.cloud.sql.v1beta4.SqlInstancesRescheduleMaintenanceRequestBody.Reschedule
	72,  // 135: google.cloud.sql.v1beta4.SslCertsInsertResponse.operation:type_name -> google.cloud.sql.v1beta4.Operation
	81,  // 136: google.cloud.sql.v1beta4.SslCertsInsertResponse.server_ca_cert:type_name -> google.cloud.sql.v1beta4.SslCert
	82,  // 137: google.cloud.sql.v1beta4.SslCertsInsertResponse.client_cert:type_name -> google.cloud.sql.v1beta4.SslCertDetail
	81,  // 138: google.cloud.sql.v1beta4.SslCertsListResponse.items:type_name -> google.cloud.sql.v1beta4.SslCert
	106, // 139: google.cloud.sql.v1beta4.SqlServerAuditConfig.retention_interval:type_name -> google.protobuf.Duration
	106, // 140: google.cloud.sql.v1beta4.SqlServerAuditConfig.upload_interval:type_name -> google.protobuf.Duration
	104, // 141: google.cloud.sql.v1beta4.DatabaseInstance.SqlFailoverReplica.available:type_name -> google.protobuf.BoolValue
	102, // 142: google.cloud.sql.v1beta4.DatabaseInstance.SqlScheduledMaintenance.start_time:type_name -> google.protobuf.Timestamp
	102, // 143: google.cloud.sql.v1beta4.DatabaseInstance.SqlScheduledMaintenance.schedule_deadline_time:type_name -> google.protobuf.Timestamp
	18,  // 144: google.cloud.sql.v1beta4.DatabaseInstance.SqlOutOfDiskReport.sql_out_of_disk_state:type_name -> google.cloud.sql.v1beta4.DatabaseInstance.SqlOutOfDiskReport.SqlOutOfDiskState
	104, // 145: google.cloud.sql.v1beta4.ExportContext.SqlExportOptions.schema_only:type_name -> google.protobuf.BoolValue
	96,  // 146: google.cloud.sql.v1beta4.ExportContext.SqlExportOptions.mysql_export_options:type_name -> google.cloud.sql.v1beta4.ExportContext.SqlExportOptions.MysqlExportOptions
	103, // 147: google.cloud.sql.v1beta4.ExportContext.SqlExportOptions.MysqlExportOptions.master_data:type_name -> google.protobuf.Int32Value
	99,  // 148: google.cloud.sql.v1beta4.ImportContext.SqlBakImportOptions.encryption_options:type_name -> google.cloud.sql.v1beta4.ImportContext.SqlBakImportOptions.EncryptionOptions
	24,  // 149: google.cloud.sql.v1beta4.SqlInstancesRescheduleMaintenanceRequestBody.Reschedule.reschedule_type:type_name -> google.cloud.sql.v1beta4.SqlInstancesRescheduleMaintenanceRequestBody.RescheduleType
	102, // 150: google.cloud.sql.v1beta4.SqlInstancesRescheduleMaintenanceRequestBody.Reschedule.schedule_time:type_name -> google.protobuf.Timestamp
	151, // [151:151] is the sub-list for method output_type
	151, // [151:151] is the sub-list for method input_type
	151, // [151:151] is the sub-list for extension type_name
	151, // [151:151] is the sub-list for extension extendee
	0,   // [0:151] is the sub-list for field type_name
}

func init() { file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_init() }
func file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_init() {
	if File_google_cloud_sql_v1beta4_cloud_sql_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AclEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApiWarning); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BackupRetentionSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BackupConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BackupRun); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BackupRunsListResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BinLogCoordinates); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BackupContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloneContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Database); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlServerDatabaseDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabaseFlags); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SyncFlags); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstanceReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabaseInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabasesListResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DemoteMasterConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DemoteMasterContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DemoteMasterMySqlReplicaConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FailoverContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Flag); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FlagsListResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstancesCloneRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstancesDemoteMasterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstancesExportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstancesFailoverRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstancesImportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MySqlSyncConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstancesListResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstancesListServerCasResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstancesRestoreBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstancesRotateServerCaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstancesTruncateLogRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesVerifyExternalSyncSettingsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlExternalSyncSettingError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IpConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IpMapping); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LocationPreference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MaintenanceWindow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DenyMaintenancePeriod); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InsightsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MySqlReplicaConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OnPremisesConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiskEncryptionConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DiskEncryptionStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Operation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationErrors); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PasswordValidationPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationsListResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReplicaConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RestoreBackupContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RotateServerCaContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Settings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SslCert); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SslCertDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SslCertsCreateEphemeralRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SslCertsInsertRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesRescheduleMaintenanceRequestBody); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SslCertsInsertResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SslCertsListResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TruncateLogContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlActiveDirectoryConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlServerAuditConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabaseInstance_SqlFailoverReplica); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabaseInstance_SqlScheduledMaintenance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabaseInstance_SqlOutOfDiskReport); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportContext_SqlCsvExportOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportContext_SqlExportOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportContext_SqlExportOptions_MysqlExportOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportContext_SqlCsvImportOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportContext_SqlBakImportOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportContext_SqlBakImportOptions_EncryptionOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlInstancesRescheduleMaintenanceRequestBody_Reschedule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*Database_SqlserverDatabaseDetails)(nil),
	}
	file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[14].OneofWrappers = []interface{}{}
	file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[67].OneofWrappers = []interface{}{}
	file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes[68].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDesc,
			NumEnums:      25,
			NumMessages:   77,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_sql_v1beta4_cloud_sql_resources_proto = out.File
	file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_rawDesc = nil
	file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_goTypes = nil
	file_google_cloud_sql_v1beta4_cloud_sql_resources_proto_depIdxs = nil
}
