/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.model;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.model.JBBPAbstractArrayField;
import com.igormaznitsa.jbbp.model.JBBPFieldShort;
import com.igormaznitsa.jbbp.model.JBBPNumericArray;
import com.igormaznitsa.jbbp.utils.JBBPUtils;

public final class JBBPFieldArrayShort
extends JBBPAbstractArrayField<JBBPFieldShort>
implements JBBPNumericArray {
    private static final long serialVersionUID = 6119269534023759155L;
    private final short[] array;

    public JBBPFieldArrayShort(JBBPNamedFieldInfo name, short[] array) {
        super(name);
        JBBPUtils.assertNotNull(array, "Array must not be null");
        this.array = array;
    }

    public short[] getArray() {
        return (short[])this.array.clone();
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public JBBPFieldShort getElementAt(int index) {
        JBBPFieldShort result = new JBBPFieldShort(this.fieldNameInfo, this.array[index]);
        result.payload = this.payload;
        return result;
    }

    @Override
    public int getAsInt(int index) {
        return this.array[index];
    }

    @Override
    public long getAsLong(int index) {
        return this.getAsInt(index);
    }

    @Override
    public boolean getAsBool(int index) {
        return this.array[index] != 0;
    }

    @Override
    public Object getValueArrayAsObject(boolean reverseBits) {
        short[] result;
        if (reverseBits) {
            result = (short[])this.array.clone();
            for (int i = 0; i < result.length; ++i) {
                result[i] = (short)JBBPFieldShort.reverseBits(result[i]);
            }
        } else {
            result = (short[])this.array.clone();
        }
        return result;
    }

    @Override
    public String getTypeAsString() {
        return "short [" + this.array.length + ']';
    }
}

