//! Header: `sys/stat.h`

use super::super::*;
use crate::prelude::*;

// File type constants for stat.st_mode
pub const S_IFMT: mode_t = 0o170000;
pub const S_IFSOCK: mode_t = 0o140000;
pub const S_IFLNK: mode_t = 0o120000;
pub const S_IFREG: mode_t = 0o100000;
pub const S_IFBLK: mode_t = 0o060000;
pub const S_IFDIR: mode_t = 0o040000;
pub const S_IFCHR: mode_t = 0o020000;
pub const S_IFIFO: mode_t = 0o010000;

// File permission constants
pub const S_ISUID: mode_t = 0o4000;
pub const S_ISGID: mode_t = 0o2000;
pub const S_ISVTX: mode_t = 0o1000;
pub const S_IRWXU: mode_t = 0o0700;
pub const S_IRUSR: mode_t = 0o0400;
pub const S_IWUSR: mode_t = 0o0200;
pub const S_IXUSR: mode_t = 0o0100;
pub const S_IRWXG: mode_t = 0o0070;
pub const S_IRGRP: mode_t = 0o0040;
pub const S_IWGRP: mode_t = 0o0020;
pub const S_IXGRP: mode_t = 0o0010;
pub const S_IRWXO: mode_t = 0o0007;
pub const S_IROTH: mode_t = 0o0004;
pub const S_IWOTH: mode_t = 0o0002;
pub const S_IXOTH: mode_t = 0o0001;

extern "C" {
    pub fn stat(pathname: *const c_char, statbuf: *mut stat) -> c_int;
    pub fn fstat(fd: c_int, statbuf: *mut stat) -> c_int;
    pub fn lstat(pathname: *const c_char, statbuf: *mut stat) -> c_int;
    pub fn chmod(pathname: *const c_char, mode: mode_t) -> c_int;
    pub fn fchmod(fd: c_int, mode: mode_t) -> c_int;
    pub fn mkdir(pathname: *const c_char, mode: mode_t) -> c_int;
    pub fn mkfifo(pathname: *const c_char, mode: mode_t) -> c_int;
    pub fn umask(mask: mode_t) -> mode_t;
}
