# generated by datamodel-codegen:
#   filename:  cose_schema.json
#   version:   0.26.3

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, ConfigDict, Field, RootModel, StrictStr


class Algorithm(str, Enum):
    """The hashing function used to compute the hash value"""

    SHA256 = "sha256"


class PayloadHash(BaseModel):
    """Specifies the hash algorithm and value for the content"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    algorithm: Algorithm = Field(
        ...,
        description="The hashing function used to compute the hash value",
    )
    value: StrictStr = Field(..., description="The hash value for the content")


class EnvelopeHash(BaseModel):
    """Specifies the hash algorithm and value for the COSE envelope"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    algorithm: Algorithm = Field(
        ...,
        description="The hashing function used to compute the hash value",
    )
    value: StrictStr = Field(..., description="The hash value for the envelope")


class Data(BaseModel):
    """Information about the content associated with the entry"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    payload_hash: Optional[PayloadHash] = Field(
        default=None,
        alias="payloadHash",
        description="Specifies the hash algorithm and value for the content",
    )
    envelope_hash: Optional[EnvelopeHash] = Field(
        default=None,
        alias="envelopeHash",
        description="Specifies the hash algorithm and value for the COSE envelope",
    )
    aad: Optional[str] = Field(
        default=None,
        description="Specifies the additional authenticated data required to verify the signature",
    )


class CoseV001Schema(BaseModel):
    """Schema for cose object"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    message: Optional[str] = Field(default=None, description="The COSE Sign1 Message")
    public_key: str = Field(
        ...,
        alias="publicKey",
        description="The public key that can verify the signature",
    )
    data: Optional[Data] = Field(
        default=None,
        description="Information about the content associated with the entry",
    )


class CoseSchema(RootModel[CoseV001Schema]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: CoseV001Schema = Field(..., description="COSE for Rekord objects", title="COSE Schema")
