#!/usr/bin/perl -w

# gnome-keyring asks to remember the password for unlocking the keyring every
# time, and defaults to yes every time. If, like me, you don't want it to do
# so, this script will delete the relevant item.

use strict;
use Net::DBus;
use Net::DBus::Reactor;

my $ct = 0;
my $service = Net::DBus->session->get_service("org.freedesktop.secrets");
for my $path (@{$service->get_object("/org/freedesktop/secrets/collection/login")->Items}) {
    my $item = $service->get_object($path);
    if (($item->Attributes->{"keyring"} // "") eq "LOCAL:/keyrings/wmpasman.keyring") {
        print "Deleting \"" . $item->Label . "\" ($path)\n";
        my $prompt = $item->Delete();
        if ($prompt ne "/") {
            $ct++;
            $prompt = $service->get_object($prompt);
            $prompt->connect_to_signal( 'Completed', sub {
                exit if --$ct <= 0;
            } );
            $prompt->Prompt("");
        }
    }
}

Net::DBus::Reactor->main()->run() if $ct;
