/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2002 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <iostream.h>

#include "dialog.h"
#include "intl.h"

gint 
Dialog::DeleteCB(GtkWidget *widget, GdkEvent *event, gpointer data)
{
   ((Dialog*) data)->OnCancel();
   return TRUE;
}

Dialog::Dialog(const char* title)
{
   _window = gtk_dialog_new();
   gtk_window_set_title(GTK_WINDOW(_window), title);

   // Ok button
   GtkWidget* button = gtk_dialog_add_button(GTK_DIALOG(_window),
					     GTK_STOCK_OK, 
					     GTK_RESPONSE_NONE);
   g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(Dialog::OkCB), 
		    this);
   g_signal_connect(G_OBJECT(_window), "delete_event",
		    G_CALLBACK(Dialog::DeleteCB), this);

   gtk_widget_grab_default(button);
}

void
Dialog::DoDialog()
{

   if (GTK_WIDGET_VISIBLE(_window))
      gdk_window_raise(_window->window);
   else
      gtk_widget_show_all(_window);
}

void
Dialog::OnCancel()
{
   gtk_widget_hide(_window);
}

void
Dialog::OkCB(GtkWidget *widget, gpointer data)
{
   Dialog* dialog = (Dialog*) data;
   gtk_widget_hide(dialog->_window);
   dialog->OnOk();
}

void
Dialog::CancelCB(GtkWidget *widget, gpointer data)
{
   ((Dialog*) data)->OnCancel();
}

void
Dialog::AddCancelButton()
{
   GtkWidget* button = gtk_dialog_add_button(GTK_DIALOG(_window),
					     GTK_STOCK_CANCEL,
					     GTK_RESPONSE_NONE);
   g_signal_connect(G_OBJECT(button), "clicked",
		    G_CALLBACK(Dialog::CancelCB), (gpointer) this);
}





