;; Tests for f32x4 [pmin, pmax] operations on major boundary values and all special values.


(module
  (func (export "f32x4.pmin") (param v128 v128) (result v128) (f32x4.pmin (local.get 0) (local.get 1)))
  (func (export "f32x4.pmax") (param v128 v128) (result v128) (f32x4.pmax (local.get 0) (local.get 1)))
)

(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan nan nan nan)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan -nan -nan -nan)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
(assert_return (invoke "f32x4.pmin" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                    (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 inf inf inf inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37 0x1.b25ffd636ec12p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 -inf -inf -inf -inf)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26 0x1.d6f34540ca458p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56 0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75 0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37 0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89 0x1.fe9af5b6bcbd5p+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                    (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37 0x1.b25ffd62b4311p-37))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26 0x1.d6f3454000000p+26))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                    (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89 0x1.fe9af5b5e16fap+89))
(assert_return (invoke "f32x4.pmax" (v128.const f32x4 0123456789e-019