#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1249
#define LARGE_STATE_COUNT 76
#define SYMBOL_COUNT 189
#define ALIAS_COUNT 1
#define TOKEN_COUNT 90
#define EXTERNAL_TOKEN_COUNT 14
#define FIELD_COUNT 10
#define MAX_ALIAS_SEQUENCE_LENGTH 10
#define PRODUCTION_ID_COUNT 25

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_SEMI = 2,
  anon_sym_COMMA = 3,
  anon_sym_LPAREN = 4,
  anon_sym_RPAREN = 5,
  anon_sym_PLUS = 6,
  anon_sym_DOT_PLUS = 7,
  anon_sym_DASH = 8,
  anon_sym_DOT_DASH = 9,
  anon_sym_STAR = 10,
  anon_sym_DOT_STAR = 11,
  anon_sym_SLASH = 12,
  anon_sym_DOT_SLASH = 13,
  anon_sym_BSLASH = 14,
  anon_sym_DOT_BSLASH = 15,
  anon_sym_CARET = 16,
  anon_sym_DOT_CARET = 17,
  anon_sym_PIPE = 18,
  anon_sym_AMP = 19,
  anon_sym_DOT = 20,
  anon_sym_TILDE = 21,
  anon_sym_QMARK = 22,
  anon_sym_AT = 23,
  anon_sym_LT = 24,
  anon_sym_LT_EQ = 25,
  anon_sym_EQ_EQ = 26,
  anon_sym_TILDE_EQ = 27,
  anon_sym_GT_EQ = 28,
  anon_sym_GT = 29,
  anon_sym_AMP_AMP = 30,
  anon_sym_PIPE_PIPE = 31,
  anon_sym_DOT_SQUOTE = 32,
  anon_sym_SQUOTE = 33,
  anon_sym_LBRACK = 34,
  aux_sym_matrix_token1 = 35,
  anon_sym_RBRACK = 36,
  anon_sym_LBRACE = 37,
  anon_sym_RBRACE = 38,
  anon_sym_EQ = 39,
  anon_sym_COLON = 40,
  sym_return_statement = 41,
  sym_continue_statement = 42,
  sym_break_statement = 43,
  anon_sym_elseif = 44,
  anon_sym_else = 45,
  anon_sym_if = 46,
  anon_sym_end = 47,
  anon_sym_for = 48,
  anon_sym_parfor = 49,
  anon_sym_while = 50,
  anon_sym_case = 51,
  anon_sym_otherwise = 52,
  anon_sym_switch = 53,
  anon_sym_global = 54,
  anon_sym_persistent = 55,
  anon_sym_arguments = 56,
  anon_sym_function = 57,
  anon_sym_get_DOT = 58,
  anon_sym_set_DOT = 59,
  anon_sym_endfunction = 60,
  anon_sym_vector = 61,
  anon_sym_matrix = 62,
  anon_sym_scalar = 63,
  anon_sym_properties = 64,
  anon_sym_methods = 65,
  anon_sym_events = 66,
  anon_sym_enumeration = 67,
  anon_sym_classdef = 68,
  anon_sym_catch = 69,
  anon_sym_try = 70,
  sym_number = 71,
  anon_sym_true = 72,
  anon_sym_false = 73,
  anon_sym_LF = 74,
  anon_sym_CR = 75,
  sym_comment = 76,
  sym_line_continuation = 77,
  sym_command_name = 78,
  sym_command_argument = 79,
  sym__single_quote_string_start = 80,
  sym__single_quote_string_end = 81,
  sym__double_quote_string_start = 82,
  sym__double_quote_string_end = 83,
  sym_formatting_sequence = 84,
  sym_escape_sequence = 85,
  sym_string_content = 86,
  sym__entry_delimiter = 87,
  sym__multioutput_variable_start = 88,
  sym_error_sentinel = 89,
  sym_source_file = 90,
  aux_sym__block = 91,
  sym_block = 92,
  sym__statement = 93,
  sym__expression = 94,
  sym_parenthesis = 95,
  sym__binary_expression = 96,
  sym_binary_operator = 97,
  sym_unary_operator = 98,
  sym_indirect_access = 99,
  sym_field_expression = 100,
  sym_not_operator = 101,
  sym_metaclass_operator = 102,
  sym_handle_operator = 103,
  sym_comparison_operator = 104,
  sym_boolean_operator = 105,
  sym_postfix_operator = 106,
  sym_string = 107,
  sym_row = 108,
  sym_matrix = 109,
  sym_cell = 110,
  sym_ignored_argument = 111,
  sym_assignment = 112,
  sym_multioutput_variable = 113,
  sym_spread_operator = 114,
  sym_arguments = 115,
  sym__args = 116,
  sym_function_call = 117,
  sym_command = 118,
  sym__range_element = 119,
  sym_range = 120,
  sym_elseif_clause = 121,
  sym_else_clause = 122,
  sym_if_statement = 123,
  sym_iterator = 124,
  sym_parfor_options = 125,
  sym_for_statement = 126,
  sym_while_statement = 127,
  sym_case_clause = 128,
  sym_otherwise_clause = 129,
  sym_switch_statement = 130,
  sym__lambda_arguments = 131,
  sym_lambda = 132,
  sym_global_operator = 133,
  sym_persistent_operator = 134,
  sym__argument_attributes = 135,
  sym_arguments_statement = 136,
  sym_function_output = 137,
  sym_function_arguments = 138,
  sym_function_definition = 139,
  sym__function_definition_with_end = 140,
  sym_attribute = 141,
  sym_attributes = 142,
  sym_superclasses = 143,
  sym_dimensions = 144,
  sym_validation_functions = 145,
  sym_default_value = 146,
  sym_property_name = 147,
  sym_property = 148,
  sym_properties = 149,
  sym_function_signature = 150,
  sym_methods = 151,
  sym_events = 152,
  sym__enum_value = 153,
  sym_enum = 154,
  sym_enumeration = 155,
  sym_class_definition = 156,
  sym_catch_clause = 157,
  sym_try_statement = 158,
  sym_boolean = 159,
  sym__end_of_line = 160,
  aux_sym_source_file_repeat1 = 161,
  aux_sym__block_repeat1 = 162,
  aux_sym_field_expression_repeat1 = 163,
  aux_sym_metaclass_operator_repeat1 = 164,
  aux_sym_string_repeat1 = 165,
  aux_sym_row_repeat1 = 166,
  aux_sym_matrix_repeat1 = 167,
  aux_sym_multioutput_variable_repeat1 = 168,
  aux_sym_arguments_repeat1 = 169,
  aux_sym_arguments_repeat2 = 170,
  aux_sym_command_repeat1 = 171,
  aux_sym_elseif_clause_repeat1 = 172,
  aux_sym_if_statement_repeat1 = 173,
  aux_sym_switch_statement_repeat1 = 174,
  aux_sym__lambda_arguments_repeat1 = 175,
  aux_sym_global_operator_repeat1 = 176,
  aux_sym__argument_attributes_repeat1 = 177,
  aux_sym_arguments_statement_repeat1 = 178,
  aux_sym_function_definition_repeat1 = 179,
  aux_sym_attributes_repeat1 = 180,
  aux_sym_superclasses_repeat1 = 181,
  aux_sym_dimensions_repeat1 = 182,
  aux_sym_validation_functions_repeat1 = 183,
  aux_sym_methods_repeat1 = 184,
  aux_sym_events_repeat1 = 185,
  aux_sym_enum_repeat1 = 186,
  aux_sym_enumeration_repeat1 = 187,
  aux_sym_class_definition_repeat1 = 188,
  alias_sym_superclass = 189,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_SEMI] = ";",
  [anon_sym_COMMA] = ",",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_PLUS] = "+",
  [anon_sym_DOT_PLUS] = ".+",
  [anon_sym_DASH] = "-",
  [anon_sym_DOT_DASH] = ".-",
  [anon_sym_STAR] = "*",
  [anon_sym_DOT_STAR] = ".*",
  [anon_sym_SLASH] = "/",
  [anon_sym_DOT_SLASH] = "./",
  [anon_sym_BSLASH] = "\\",
  [anon_sym_DOT_BSLASH] = ".\\",
  [anon_sym_CARET] = "^",
  [anon_sym_DOT_CARET] = ".^",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP] = "&",
  [anon_sym_DOT] = ".",
  [anon_sym_TILDE] = "~",
  [anon_sym_QMARK] = "\?",
  [anon_sym_AT] = "@",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_TILDE_EQ] = "~=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_DOT_SQUOTE] = ".'",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_LBRACK] = "[",
  [aux_sym_matrix_token1] = "matrix_token1",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_EQ] = "=",
  [anon_sym_COLON] = ":",
  [sym_return_statement] = "return_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_break_statement] = "break_statement",
  [anon_sym_elseif] = "elseif",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_end] = "end",
  [anon_sym_for] = "for",
  [anon_sym_parfor] = "parfor",
  [anon_sym_while] = "while",
  [anon_sym_case] = "case",
  [anon_sym_otherwise] = "otherwise",
  [anon_sym_switch] = "switch",
  [anon_sym_global] = "global",
  [anon_sym_persistent] = "persistent",
  [anon_sym_arguments] = "arguments",
  [anon_sym_function] = "function",
  [anon_sym_get_DOT] = "get.",
  [anon_sym_set_DOT] = "set.",
  [anon_sym_endfunction] = "endfunction",
  [anon_sym_vector] = "identifier",
  [anon_sym_matrix] = "identifier",
  [anon_sym_scalar] = "identifier",
  [anon_sym_properties] = "properties",
  [anon_sym_methods] = "methods",
  [anon_sym_events] = "events",
  [anon_sym_enumeration] = "enumeration",
  [anon_sym_classdef] = "classdef",
  [anon_sym_catch] = "catch",
  [anon_sym_try] = "try",
  [sym_number] = "number",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_LF] = "\n",
  [anon_sym_CR] = "\r",
  [sym_comment] = "comment",
  [sym_line_continuation] = "line_continuation",
  [sym_command_name] = "command_name",
  [sym_command_argument] = "command_argument",
  [sym__single_quote_string_start] = "'",
  [sym__single_quote_string_end] = "'",
  [sym__double_quote_string_start] = "\"",
  [sym__double_quote_string_end] = "\"",
  [sym_formatting_sequence] = "formatting_sequence",
  [sym_escape_sequence] = "escape_sequence",
  [sym_string_content] = "string_content",
  [sym__entry_delimiter] = ";",
  [sym__multioutput_variable_start] = "[",
  [sym_error_sentinel] = "error_sentinel",
  [sym_source_file] = "source_file",
  [aux_sym__block] = "_block",
  [sym_block] = "block",
  [sym__statement] = "_statement",
  [sym__expression] = "_expression",
  [sym_parenthesis] = "parenthesis",
  [sym__binary_expression] = "_binary_expression",
  [sym_binary_operator] = "binary_operator",
  [sym_unary_operator] = "unary_operator",
  [sym_indirect_access] = "indirect_access",
  [sym_field_expression] = "field_expression",
  [sym_not_operator] = "not_operator",
  [sym_metaclass_operator] = "metaclass_operator",
  [sym_handle_operator] = "handle_operator",
  [sym_comparison_operator] = "comparison_operator",
  [sym_boolean_operator] = "boolean_operator",
  [sym_postfix_operator] = "postfix_operator",
  [sym_string] = "string",
  [sym_row] = "row",
  [sym_matrix] = "matrix",
  [sym_cell] = "cell",
  [sym_ignored_argument] = "ignored_argument",
  [sym_assignment] = "assignment",
  [sym_multioutput_variable] = "multioutput_variable",
  [sym_spread_operator] = "spread_operator",
  [sym_arguments] = "arguments",
  [sym__args] = "_args",
  [sym_function_call] = "function_call",
  [sym_command] = "command",
  [sym__range_element] = "_range_element",
  [sym_range] = "range",
  [sym_elseif_clause] = "elseif_clause",
  [sym_else_clause] = "else_clause",
  [sym_if_statement] = "if_statement",
  [sym_iterator] = "iterator",
  [sym_parfor_options] = "parfor_options",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_case_clause] = "case_clause",
  [sym_otherwise_clause] = "otherwise_clause",
  [sym_switch_statement] = "switch_statement",
  [sym__lambda_arguments] = "_lambda_arguments",
  [sym_lambda] = "lambda",
  [sym_global_operator] = "global_operator",
  [sym_persistent_operator] = "persistent_operator",
  [sym__argument_attributes] = "attributes",
  [sym_arguments_statement] = "arguments_statement",
  [sym_function_output] = "function_output",
  [sym_function_arguments] = "function_arguments",
  [sym_function_definition] = "function_definition",
  [sym__function_definition_with_end] = "function_definition",
  [sym_attribute] = "attribute",
  [sym_attributes] = "attributes",
  [sym_superclasses] = "superclasses",
  [sym_dimensions] = "dimensions",
  [sym_validation_functions] = "validation_functions",
  [sym_default_value] = "default_value",
  [sym_property_name] = "property_name",
  [sym_property] = "property",
  [sym_properties] = "properties",
  [sym_function_signature] = "function_signature",
  [sym_methods] = "methods",
  [sym_events] = "events",
  [sym__enum_value] = "_enum_value",
  [sym_enum] = "enum",
  [sym_enumeration] = "enumeration",
  [sym_class_definition] = "class_definition",
  [sym_catch_clause] = "catch_clause",
  [sym_try_statement] = "try_statement",
  [sym_boolean] = "boolean",
  [sym__end_of_line] = "_end_of_line",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym__block_repeat1] = "_block_repeat1",
  [aux_sym_field_expression_repeat1] = "field_expression_repeat1",
  [aux_sym_metaclass_operator_repeat1] = "metaclass_operator_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_row_repeat1] = "row_repeat1",
  [aux_sym_matrix_repeat1] = "matrix_repeat1",
  [aux_sym_multioutput_variable_repeat1] = "multioutput_variable_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_arguments_repeat2] = "arguments_repeat2",
  [aux_sym_command_repeat1] = "command_repeat1",
  [aux_sym_elseif_clause_repeat1] = "elseif_clause_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_switch_statement_repeat1] = "switch_statement_repeat1",
  [aux_sym__lambda_arguments_repeat1] = "_lambda_arguments_repeat1",
  [aux_sym_global_operator_repeat1] = "global_operator_repeat1",
  [aux_sym__argument_attributes_repeat1] = "_argument_attributes_repeat1",
  [aux_sym_arguments_statement_repeat1] = "arguments_statement_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_attributes_repeat1] = "attributes_repeat1",
  [aux_sym_superclasses_repeat1] = "superclasses_repeat1",
  [aux_sym_dimensions_repeat1] = "dimensions_repeat1",
  [aux_sym_validation_functions_repeat1] = "validation_functions_repeat1",
  [aux_sym_methods_repeat1] = "methods_repeat1",
  [aux_sym_events_repeat1] = "events_repeat1",
  [aux_sym_enum_repeat1] = "enum_repeat1",
  [aux_sym_enumeration_repeat1] = "enumeration_repeat1",
  [aux_sym_class_definition_repeat1] = "class_definition_repeat1",
  [alias_sym_superclass] = "superclass",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DOT_PLUS] = anon_sym_DOT_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_DOT_DASH] = anon_sym_DOT_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_DOT_STAR] = anon_sym_DOT_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_DOT_SLASH] = anon_sym_DOT_SLASH,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [anon_sym_DOT_BSLASH] = anon_sym_DOT_BSLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_DOT_CARET] = anon_sym_DOT_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_TILDE_EQ] = anon_sym_TILDE_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_DOT_SQUOTE] = anon_sym_DOT_SQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [aux_sym_matrix_token1] = aux_sym_matrix_token1,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_COLON] = anon_sym_COLON,
  [sym_return_statement] = sym_return_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_break_statement] = sym_break_statement,
  [anon_sym_elseif] = anon_sym_elseif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_parfor] = anon_sym_parfor,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_otherwise] = anon_sym_otherwise,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_persistent] = anon_sym_persistent,
  [anon_sym_arguments] = anon_sym_arguments,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_get_DOT] = anon_sym_get_DOT,
  [anon_sym_set_DOT] = anon_sym_set_DOT,
  [anon_sym_endfunction] = anon_sym_endfunction,
  [anon_sym_vector] = sym_identifier,
  [anon_sym_matrix] = sym_identifier,
  [anon_sym_scalar] = sym_identifier,
  [anon_sym_properties] = anon_sym_properties,
  [anon_sym_methods] = anon_sym_methods,
  [anon_sym_events] = anon_sym_events,
  [anon_sym_enumeration] = anon_sym_enumeration,
  [anon_sym_classdef] = anon_sym_classdef,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_try] = anon_sym_try,
  [sym_number] = sym_number,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_CR] = anon_sym_CR,
  [sym_comment] = sym_comment,
  [sym_line_continuation] = sym_line_continuation,
  [sym_command_name] = sym_command_name,
  [sym_command_argument] = sym_command_argument,
  [sym__single_quote_string_start] = anon_sym_SQUOTE,
  [sym__single_quote_string_end] = anon_sym_SQUOTE,
  [sym__double_quote_string_start] = sym__double_quote_string_start,
  [sym__double_quote_string_end] = sym__double_quote_string_start,
  [sym_formatting_sequence] = sym_formatting_sequence,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_string_content] = sym_string_content,
  [sym__entry_delimiter] = anon_sym_SEMI,
  [sym__multioutput_variable_start] = anon_sym_LBRACK,
  [sym_error_sentinel] = sym_error_sentinel,
  [sym_source_file] = sym_source_file,
  [aux_sym__block] = aux_sym__block,
  [sym_block] = sym_block,
  [sym__statement] = sym__statement,
  [sym__expression] = sym__expression,
  [sym_parenthesis] = sym_parenthesis,
  [sym__binary_expression] = sym__binary_expression,
  [sym_binary_operator] = sym_binary_operator,
  [sym_unary_operator] = sym_unary_operator,
  [sym_indirect_access] = sym_indirect_access,
  [sym_field_expression] = sym_field_expression,
  [sym_not_operator] = sym_not_operator,
  [sym_metaclass_operator] = sym_metaclass_operator,
  [sym_handle_operator] = sym_handle_operator,
  [sym_comparison_operator] = sym_comparison_operator,
  [sym_boolean_operator] = sym_boolean_operator,
  [sym_postfix_operator] = sym_postfix_operator,
  [sym_string] = sym_string,
  [sym_row] = sym_row,
  [sym_matrix] = sym_matrix,
  [sym_cell] = sym_cell,
  [sym_ignored_argument] = sym_ignored_argument,
  [sym_assignment] = sym_assignment,
  [sym_multioutput_variable] = sym_multioutput_variable,
  [sym_spread_operator] = sym_spread_operator,
  [sym_arguments] = sym_arguments,
  [sym__args] = sym__args,
  [sym_function_call] = sym_function_call,
  [sym_command] = sym_command,
  [sym__range_element] = sym__range_element,
  [sym_range] = sym_range,
  [sym_elseif_clause] = sym_elseif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_iterator] = sym_iterator,
  [sym_parfor_options] = sym_parfor_options,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_case_clause] = sym_case_clause,
  [sym_otherwise_clause] = sym_otherwise_clause,
  [sym_switch_statement] = sym_switch_statement,
  [sym__lambda_arguments] = sym__lambda_arguments,
  [sym_lambda] = sym_lambda,
  [sym_global_operator] = sym_global_operator,
  [sym_persistent_operator] = sym_persistent_operator,
  [sym__argument_attributes] = sym_attributes,
  [sym_arguments_statement] = sym_arguments_statement,
  [sym_function_output] = sym_function_output,
  [sym_function_arguments] = sym_function_arguments,
  [sym_function_definition] = sym_function_definition,
  [sym__function_definition_with_end] = sym_function_definition,
  [sym_attribute] = sym_attribute,
  [sym_attributes] = sym_attributes,
  [sym_superclasses] = sym_superclasses,
  [sym_dimensions] = sym_dimensions,
  [sym_validation_functions] = sym_validation_functions,
  [sym_default_value] = sym_default_value,
  [sym_property_name] = sym_property_name,
  [sym_property] = sym_property,
  [sym_properties] = sym_properties,
  [sym_function_signature] = sym_function_signature,
  [sym_methods] = sym_methods,
  [sym_events] = sym_events,
  [sym__enum_value] = sym__enum_value,
  [sym_enum] = sym_enum,
  [sym_enumeration] = sym_enumeration,
  [sym_class_definition] = sym_class_definition,
  [sym_catch_clause] = sym_catch_clause,
  [sym_try_statement] = sym_try_statement,
  [sym_boolean] = sym_boolean,
  [sym__end_of_line] = sym__end_of_line,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym__block_repeat1] = aux_sym__block_repeat1,
  [aux_sym_field_expression_repeat1] = aux_sym_field_expression_repeat1,
  [aux_sym_metaclass_operator_repeat1] = aux_sym_metaclass_operator_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_row_repeat1] = aux_sym_row_repeat1,
  [aux_sym_matrix_repeat1] = aux_sym_matrix_repeat1,
  [aux_sym_multioutput_variable_repeat1] = aux_sym_multioutput_variable_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_arguments_repeat2] = aux_sym_arguments_repeat2,
  [aux_sym_command_repeat1] = aux_sym_command_repeat1,
  [aux_sym_elseif_clause_repeat1] = aux_sym_elseif_clause_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_switch_statement_repeat1] = aux_sym_switch_statement_repeat1,
  [aux_sym__lambda_arguments_repeat1] = aux_sym__lambda_arguments_repeat1,
  [aux_sym_global_operator_repeat1] = aux_sym_global_operator_repeat1,
  [aux_sym__argument_attributes_repeat1] = aux_sym__argument_attributes_repeat1,
  [aux_sym_arguments_statement_repeat1] = aux_sym_arguments_statement_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_attributes_repeat1] = aux_sym_attributes_repeat1,
  [aux_sym_superclasses_repeat1] = aux_sym_superclasses_repeat1,
  [aux_sym_dimensions_repeat1] = aux_sym_dimensions_repeat1,
  [aux_sym_validation_functions_repeat1] = aux_sym_validation_functions_repeat1,
  [aux_sym_methods_repeat1] = aux_sym_methods_repeat1,
  [aux_sym_events_repeat1] = aux_sym_events_repeat1,
  [aux_sym_enum_repeat1] = aux_sym_enum_repeat1,
  [aux_sym_enumeration_repeat1] = aux_sym_enumeration_repeat1,
  [aux_sym_class_definition_repeat1] = aux_sym_class_definition_repeat1,
  [alias_sym_superclass] = alias_sym_superclass,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_matrix_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_elseif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_parfor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_otherwise] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_persistent] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_arguments] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endfunction] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_vector] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_matrix] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_scalar] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_properties] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_methods] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_events] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enumeration] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_classdef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CR] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_line_continuation] = {
    .visible = true,
    .named = true,
  },
  [sym_command_name] = {
    .visible = true,
    .named = true,
  },
  [sym_command_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__single_quote_string_start] = {
    .visible = true,
    .named = false,
  },
  [sym__single_quote_string_end] = {
    .visible = true,
    .named = false,
  },
  [sym__double_quote_string_start] = {
    .visible = true,
    .named = false,
  },
  [sym__double_quote_string_end] = {
    .visible = true,
    .named = false,
  },
  [sym_formatting_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_string_content] = {
    .visible = true,
    .named = true,
  },
  [sym__entry_delimiter] = {
    .visible = true,
    .named = false,
  },
  [sym__multioutput_variable_start] = {
    .visible = true,
    .named = false,
  },
  [sym_error_sentinel] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__block] = {
    .visible = false,
    .named = false,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesis] = {
    .visible = true,
    .named = true,
  },
  [sym__binary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_indirect_access] = {
    .visible = true,
    .named = true,
  },
  [sym_field_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_not_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_metaclass_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_handle_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_row] = {
    .visible = true,
    .named = true,
  },
  [sym_matrix] = {
    .visible = true,
    .named = true,
  },
  [sym_cell] = {
    .visible = true,
    .named = true,
  },
  [sym_ignored_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_multioutput_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_spread_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__args] = {
    .visible = false,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_command] = {
    .visible = true,
    .named = true,
  },
  [sym__range_element] = {
    .visible = false,
    .named = true,
  },
  [sym_range] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_iterator] = {
    .visible = true,
    .named = true,
  },
  [sym_parfor_options] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_otherwise_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__lambda_arguments] = {
    .visible = false,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_global_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_persistent_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__argument_attributes] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_function_output] = {
    .visible = true,
    .named = true,
  },
  [sym_function_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__function_definition_with_end] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_attributes] = {
    .visible = true,
    .named = true,
  },
  [sym_superclasses] = {
    .visible = true,
    .named = true,
  },
  [sym_dimensions] = {
    .visible = true,
    .named = true,
  },
  [sym_validation_functions] = {
    .visible = true,
    .named = true,
  },
  [sym_default_value] = {
    .visible = true,
    .named = true,
  },
  [sym_property_name] = {
    .visible = true,
    .named = true,
  },
  [sym_property] = {
    .visible = true,
    .named = true,
  },
  [sym_properties] = {
    .visible = true,
    .named = true,
  },
  [sym_function_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_methods] = {
    .visible = true,
    .named = true,
  },
  [sym_events] = {
    .visible = true,
    .named = true,
  },
  [sym__enum_value] = {
    .visible = false,
    .named = true,
  },
  [sym_enum] = {
    .visible = true,
    .named = true,
  },
  [sym_enumeration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym__end_of_line] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_metaclass_operator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_row_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_matrix_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_multioutput_variable_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_elseif_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__lambda_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_global_operator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__argument_attributes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attributes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_superclasses_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimensions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_validation_functions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_methods_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_events_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enumeration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_superclass] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_argument = 1,
  field_arguments = 2,
  field_condition = 3,
  field_expression = 4,
  field_field = 5,
  field_left = 6,
  field_name = 7,
  field_object = 8,
  field_operand = 9,
  field_right = 10,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_condition] = "condition",
  [field_expression] = "expression",
  [field_field] = "field",
  [field_left] = "left",
  [field_name] = "name",
  [field_object] = "object",
  [field_operand] = "operand",
  [field_right] = "right",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 2},
  [5] = {.index = 5, .length = 1},
  [6] = {.index = 2, .length = 1},
  [7] = {.index = 6, .length = 1},
  [8] = {.index = 7, .length = 1},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 9, .length = 1},
  [11] = {.index = 10, .length = 2},
  [12] = {.index = 12, .length = 2},
  [13] = {.index = 14, .length = 1},
  [14] = {.index = 15, .length = 1},
  [15] = {.index = 16, .length = 2},
  [16] = {.index = 2, .length = 1},
  [17] = {.index = 2, .length = 1},
  [18] = {.index = 18, .length = 1},
  [19] = {.index = 19, .length = 1},
  [20] = {.index = 20, .length = 1},
  [21] = {.index = 21, .length = 1},
  [22] = {.index = 22, .length = 2},
  [23] = {.index = 24, .length = 1},
  [24] = {.index = 25, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_operand, 1},
  [1] =
    {field_operand, 0},
  [2] =
    {field_name, 0},
  [3] =
    {field_field, 1, .inherited = true},
    {field_object, 0},
  [5] =
    {field_name, 0, .inherited = true},
  [6] =
    {field_condition, 1},
  [7] =
    {field_name, 1},
  [8] =
    {field_argument, 0},
  [9] =
    {field_field, 1},
  [10] =
    {field_left, 0},
    {field_right, 2},
  [12] =
    {field_field, 0, .inherited = true},
    {field_field, 1, .inherited = true},
  [14] =
    {field_expression, 3},
  [15] =
    {field_name, 2},
  [16] =
    {field_argument, 0},
    {field_argument, 1, .inherited = true},
  [18] =
    {field_expression, 4},
  [19] =
    {field_arguments, 1},
  [20] =
    {field_name, 3},
  [21] =
    {field_argument, 1},
  [22] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [24] =
    {field_argument, 1, .inherited = true},
  [25] =
    {field_argument, 1},
    {field_argument, 2, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [6] = {
    [0] = sym_identifier,
  },
  [16] = {
    [2] = alias_sym_superclass,
  },
  [17] = {
    [0] = sym_identifier,
    [2] = alias_sym_superclass,
  },
  [18] = {
    [2] = sym_arguments,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__lambda_arguments, 2,
    sym__lambda_arguments,
    sym_arguments,
  sym_property_name, 2,
    sym_property_name,
    alias_sym_superclass,
  sym_boolean, 2,
    sym_boolean,
    sym_identifier,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 47,
  [56] = 56,
  [57] = 57,
  [58] = 53,
  [59] = 59,
  [60] = 60,
  [61] = 45,
  [62] = 57,
  [63] = 59,
  [64] = 46,
  [65] = 49,
  [66] = 54,
  [67] = 50,
  [68] = 56,
  [69] = 51,
  [70] = 52,
  [71] = 71,
  [72] = 48,
  [73] = 60,
  [74] = 48,
  [75] = 60,
  [76] = 76,
  [77] = 76,
  [78] = 76,
  [79] = 79,
  [80] = 76,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 91,
  [93] = 93,
  [94] = 91,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 91,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 104,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 106,
  [138] = 129,
  [139] = 131,
  [140] = 104,
  [141] = 131,
  [142] = 104,
  [143] = 132,
  [144] = 129,
  [145] = 129,
  [146] = 131,
  [147] = 132,
  [148] = 135,
  [149] = 134,
  [150] = 133,
  [151] = 136,
  [152] = 82,
  [153] = 85,
  [154] = 81,
  [155] = 84,
  [156] = 83,
  [157] = 93,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 166,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 172,
  [177] = 166,
  [178] = 172,
  [179] = 174,
  [180] = 174,
  [181] = 175,
  [182] = 174,
  [183] = 175,
  [184] = 172,
  [185] = 166,
  [186] = 175,
  [187] = 172,
  [188] = 166,
  [189] = 76,
  [190] = 76,
  [191] = 79,
  [192] = 86,
  [193] = 76,
  [194] = 76,
  [195] = 89,
  [196] = 196,
  [197] = 197,
  [198] = 99,
  [199] = 199,
  [200] = 95,
  [201] = 201,
  [202] = 90,
  [203] = 101,
  [204] = 96,
  [205] = 98,
  [206] = 97,
  [207] = 76,
  [208] = 208,
  [209] = 76,
  [210] = 91,
  [211] = 91,
  [212] = 79,
  [213] = 91,
  [214] = 91,
  [215] = 215,
  [216] = 216,
  [217] = 76,
  [218] = 218,
  [219] = 219,
  [220] = 161,
  [221] = 76,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 222,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 224,
  [239] = 239,
  [240] = 225,
  [241] = 226,
  [242] = 227,
  [243] = 222,
  [244] = 235,
  [245] = 229,
  [246] = 230,
  [247] = 231,
  [248] = 232,
  [249] = 249,
  [250] = 224,
  [251] = 225,
  [252] = 226,
  [253] = 227,
  [254] = 229,
  [255] = 230,
  [256] = 231,
  [257] = 232,
  [258] = 233,
  [259] = 259,
  [260] = 233,
  [261] = 86,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 234,
  [266] = 235,
  [267] = 267,
  [268] = 103,
  [269] = 269,
  [270] = 270,
  [271] = 224,
  [272] = 225,
  [273] = 226,
  [274] = 274,
  [275] = 275,
  [276] = 233,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 88,
  [281] = 234,
  [282] = 282,
  [283] = 224,
  [284] = 225,
  [285] = 226,
  [286] = 233,
  [287] = 234,
  [288] = 224,
  [289] = 225,
  [290] = 226,
  [291] = 233,
  [292] = 234,
  [293] = 293,
  [294] = 294,
  [295] = 224,
  [296] = 225,
  [297] = 226,
  [298] = 233,
  [299] = 299,
  [300] = 234,
  [301] = 234,
  [302] = 249,
  [303] = 168,
  [304] = 224,
  [305] = 225,
  [306] = 226,
  [307] = 227,
  [308] = 222,
  [309] = 229,
  [310] = 230,
  [311] = 231,
  [312] = 262,
  [313] = 232,
  [314] = 173,
  [315] = 237,
  [316] = 249,
  [317] = 233,
  [318] = 169,
  [319] = 233,
  [320] = 267,
  [321] = 234,
  [322] = 165,
  [323] = 234,
  [324] = 170,
  [325] = 235,
  [326] = 262,
  [327] = 327,
  [328] = 237,
  [329] = 249,
  [330] = 262,
  [331] = 331,
  [332] = 237,
  [333] = 237,
  [334] = 87,
  [335] = 223,
  [336] = 233,
  [337] = 234,
  [338] = 233,
  [339] = 234,
  [340] = 233,
  [341] = 234,
  [342] = 223,
  [343] = 233,
  [344] = 234,
  [345] = 223,
  [346] = 79,
  [347] = 91,
  [348] = 76,
  [349] = 84,
  [350] = 85,
  [351] = 96,
  [352] = 91,
  [353] = 81,
  [354] = 95,
  [355] = 82,
  [356] = 356,
  [357] = 76,
  [358] = 76,
  [359] = 76,
  [360] = 91,
  [361] = 91,
  [362] = 99,
  [363] = 98,
  [364] = 83,
  [365] = 101,
  [366] = 76,
  [367] = 90,
  [368] = 89,
  [369] = 97,
  [370] = 370,
  [371] = 371,
  [372] = 86,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 93,
  [377] = 103,
  [378] = 378,
  [379] = 104,
  [380] = 84,
  [381] = 85,
  [382] = 119,
  [383] = 81,
  [384] = 82,
  [385] = 83,
  [386] = 124,
  [387] = 95,
  [388] = 125,
  [389] = 87,
  [390] = 98,
  [391] = 375,
  [392] = 120,
  [393] = 375,
  [394] = 133,
  [395] = 131,
  [396] = 104,
  [397] = 104,
  [398] = 91,
  [399] = 131,
  [400] = 104,
  [401] = 132,
  [402] = 134,
  [403] = 375,
  [404] = 91,
  [405] = 91,
  [406] = 129,
  [407] = 91,
  [408] = 121,
  [409] = 129,
  [410] = 97,
  [411] = 126,
  [412] = 123,
  [413] = 114,
  [414] = 99,
  [415] = 115,
  [416] = 108,
  [417] = 116,
  [418] = 88,
  [419] = 109,
  [420] = 105,
  [421] = 117,
  [422] = 129,
  [423] = 118,
  [424] = 135,
  [425] = 128,
  [426] = 106,
  [427] = 110,
  [428] = 111,
  [429] = 131,
  [430] = 129,
  [431] = 132,
  [432] = 375,
  [433] = 375,
  [434] = 131,
  [435] = 101,
  [436] = 122,
  [437] = 106,
  [438] = 90,
  [439] = 375,
  [440] = 107,
  [441] = 112,
  [442] = 113,
  [443] = 102,
  [444] = 89,
  [445] = 136,
  [446] = 96,
  [447] = 127,
  [448] = 103,
  [449] = 449,
  [450] = 93,
  [451] = 129,
  [452] = 122,
  [453] = 129,
  [454] = 123,
  [455] = 124,
  [456] = 456,
  [457] = 125,
  [458] = 112,
  [459] = 115,
  [460] = 81,
  [461] = 135,
  [462] = 87,
  [463] = 88,
  [464] = 104,
  [465] = 117,
  [466] = 136,
  [467] = 113,
  [468] = 119,
  [469] = 82,
  [470] = 131,
  [471] = 118,
  [472] = 104,
  [473] = 104,
  [474] = 105,
  [475] = 475,
  [476] = 84,
  [477] = 83,
  [478] = 116,
  [479] = 126,
  [480] = 107,
  [481] = 131,
  [482] = 127,
  [483] = 114,
  [484] = 108,
  [485] = 131,
  [486] = 104,
  [487] = 109,
  [488] = 132,
  [489] = 110,
  [490] = 111,
  [491] = 85,
  [492] = 132,
  [493] = 132,
  [494] = 106,
  [495] = 129,
  [496] = 120,
  [497] = 102,
  [498] = 121,
  [499] = 129,
  [500] = 133,
  [501] = 128,
  [502] = 131,
  [503] = 134,
  [504] = 106,
  [505] = 135,
  [506] = 133,
  [507] = 134,
  [508] = 93,
  [509] = 136,
  [510] = 124,
  [511] = 129,
  [512] = 131,
  [513] = 105,
  [514] = 106,
  [515] = 107,
  [516] = 108,
  [517] = 109,
  [518] = 110,
  [519] = 111,
  [520] = 112,
  [521] = 113,
  [522] = 102,
  [523] = 114,
  [524] = 115,
  [525] = 116,
  [526] = 117,
  [527] = 118,
  [528] = 119,
  [529] = 120,
  [530] = 121,
  [531] = 122,
  [532] = 123,
  [533] = 125,
  [534] = 126,
  [535] = 127,
  [536] = 132,
  [537] = 104,
  [538] = 131,
  [539] = 129,
  [540] = 132,
  [541] = 133,
  [542] = 134,
  [543] = 135,
  [544] = 136,
  [545] = 129,
  [546] = 106,
  [547] = 104,
  [548] = 131,
  [549] = 104,
  [550] = 131,
  [551] = 104,
  [552] = 132,
  [553] = 129,
  [554] = 128,
  [555] = 555,
  [556] = 135,
  [557] = 136,
  [558] = 558,
  [559] = 134,
  [560] = 560,
  [561] = 133,
  [562] = 562,
  [563] = 563,
  [564] = 562,
  [565] = 560,
  [566] = 563,
  [567] = 562,
  [568] = 560,
  [569] = 569,
  [570] = 563,
  [571] = 563,
  [572] = 562,
  [573] = 560,
  [574] = 560,
  [575] = 563,
  [576] = 562,
  [577] = 132,
  [578] = 563,
  [579] = 562,
  [580] = 560,
  [581] = 581,
  [582] = 133,
  [583] = 129,
  [584] = 135,
  [585] = 129,
  [586] = 129,
  [587] = 134,
  [588] = 136,
  [589] = 106,
  [590] = 106,
  [591] = 106,
  [592] = 83,
  [593] = 93,
  [594] = 594,
  [595] = 595,
  [596] = 84,
  [597] = 81,
  [598] = 82,
  [599] = 85,
  [600] = 600,
  [601] = 83,
  [602] = 82,
  [603] = 83,
  [604] = 84,
  [605] = 85,
  [606] = 81,
  [607] = 607,
  [608] = 93,
  [609] = 93,
  [610] = 610,
  [611] = 607,
  [612] = 612,
  [613] = 613,
  [614] = 607,
  [615] = 615,
  [616] = 607,
  [617] = 85,
  [618] = 618,
  [619] = 619,
  [620] = 620,
  [621] = 620,
  [622] = 81,
  [623] = 82,
  [624] = 624,
  [625] = 620,
  [626] = 84,
  [627] = 627,
  [628] = 628,
  [629] = 629,
  [630] = 630,
  [631] = 99,
  [632] = 632,
  [633] = 633,
  [634] = 634,
  [635] = 635,
  [636] = 636,
  [637] = 637,
  [638] = 638,
  [639] = 95,
  [640] = 101,
  [641] = 641,
  [642] = 90,
  [643] = 89,
  [644] = 98,
  [645] = 645,
  [646] = 646,
  [647] = 647,
  [648] = 648,
  [649] = 649,
  [650] = 650,
  [651] = 651,
  [652] = 652,
  [653] = 653,
  [654] = 654,
  [655] = 655,
  [656] = 656,
  [657] = 657,
  [658] = 658,
  [659] = 659,
  [660] = 86,
  [661] = 661,
  [662] = 662,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 668,
  [669] = 669,
  [670] = 670,
  [671] = 96,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 88,
  [676] = 676,
  [677] = 677,
  [678] = 678,
  [679] = 160,
  [680] = 676,
  [681] = 87,
  [682] = 158,
  [683] = 683,
  [684] = 676,
  [685] = 676,
  [686] = 686,
  [687] = 678,
  [688] = 688,
  [689] = 688,
  [690] = 690,
  [691] = 688,
  [692] = 692,
  [693] = 688,
  [694] = 694,
  [695] = 688,
  [696] = 694,
  [697] = 697,
  [698] = 698,
  [699] = 699,
  [700] = 700,
  [701] = 701,
  [702] = 702,
  [703] = 703,
  [704] = 704,
  [705] = 705,
  [706] = 706,
  [707] = 707,
  [708] = 708,
  [709] = 709,
  [710] = 710,
  [711] = 711,
  [712] = 712,
  [713] = 713,
  [714] = 714,
  [715] = 715,
  [716] = 716,
  [717] = 717,
  [718] = 718,
  [719] = 719,
  [720] = 720,
  [721] = 718,
  [722] = 722,
  [723] = 723,
  [724] = 724,
  [725] = 725,
  [726] = 726,
  [727] = 727,
  [728] = 728,
  [729] = 729,
  [730] = 730,
  [731] = 731,
  [732] = 731,
  [733] = 733,
  [734] = 734,
  [735] = 735,
  [736] = 736,
  [737] = 737,
  [738] = 738,
  [739] = 739,
  [740] = 731,
  [741] = 741,
  [742] = 742,
  [743] = 743,
  [744] = 744,
  [745] = 745,
  [746] = 746,
  [747] = 731,
  [748] = 731,
  [749] = 698,
  [750] = 750,
  [751] = 751,
  [752] = 752,
  [753] = 753,
  [754] = 754,
  [755] = 755,
  [756] = 756,
  [757] = 757,
  [758] = 758,
  [759] = 759,
  [760] = 760,
  [761] = 761,
  [762] = 762,
  [763] = 763,
  [764] = 764,
  [765] = 765,
  [766] = 766,
  [767] = 767,
  [768] = 768,
  [769] = 752,
  [770] = 770,
  [771] = 771,
  [772] = 772,
  [773] = 773,
  [774] = 774,
  [775] = 775,
  [776] = 776,
  [777] = 777,
  [778] = 778,
  [779] = 779,
  [780] = 780,
  [781] = 781,
  [782] = 782,
  [783] = 783,
  [784] = 784,
  [785] = 785,
  [786] = 786,
  [787] = 787,
  [788] = 788,
  [789] = 789,
  [790] = 790,
  [791] = 791,
  [792] = 792,
  [793] = 793,
  [794] = 794,
  [795] = 795,
  [796] = 796,
  [797] = 797,
  [798] = 798,
  [799] = 799,
  [800] = 800,
  [801] = 801,
  [802] = 802,
  [803] = 803,
  [804] = 804,
  [805] = 805,
  [806] = 806,
  [807] = 807,
  [808] = 808,
  [809] = 809,
  [810] = 810,
  [811] = 811,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 817,
  [818] = 818,
  [819] = 819,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 824,
  [825] = 825,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 823,
  [830] = 830,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 835,
  [836] = 836,
  [837] = 837,
  [838] = 838,
  [839] = 839,
  [840] = 840,
  [841] = 841,
  [842] = 824,
  [843] = 843,
  [844] = 844,
  [845] = 834,
  [846] = 846,
  [847] = 847,
  [848] = 848,
  [849] = 843,
  [850] = 850,
  [851] = 851,
  [852] = 851,
  [853] = 841,
  [854] = 824,
  [855] = 855,
  [856] = 856,
  [857] = 857,
  [858] = 823,
  [859] = 859,
  [860] = 860,
  [861] = 861,
  [862] = 834,
  [863] = 841,
  [864] = 864,
  [865] = 846,
  [866] = 866,
  [867] = 867,
  [868] = 841,
  [869] = 824,
  [870] = 870,
  [871] = 831,
  [872] = 823,
  [873] = 823,
  [874] = 874,
  [875] = 875,
  [876] = 876,
  [877] = 834,
  [878] = 823,
  [879] = 879,
  [880] = 846,
  [881] = 843,
  [882] = 823,
  [883] = 823,
  [884] = 823,
  [885] = 823,
  [886] = 886,
  [887] = 887,
  [888] = 830,
  [889] = 844,
  [890] = 890,
  [891] = 867,
  [892] = 851,
  [893] = 893,
  [894] = 823,
  [895] = 823,
  [896] = 823,
  [897] = 846,
  [898] = 898,
  [899] = 899,
  [900] = 715,
  [901] = 716,
  [902] = 717,
  [903] = 903,
  [904] = 904,
  [905] = 905,
  [906] = 906,
  [907] = 714,
  [908] = 908,
  [909] = 909,
  [910] = 707,
  [911] = 911,
  [912] = 912,
  [913] = 913,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 917,
  [918] = 918,
  [919] = 919,
  [920] = 920,
  [921] = 921,
  [922] = 922,
  [923] = 923,
  [924] = 924,
  [925] = 925,
  [926] = 926,
  [927] = 927,
  [928] = 928,
  [929] = 929,
  [930] = 930,
  [931] = 931,
  [932] = 932,
  [933] = 739,
  [934] = 934,
  [935] = 935,
  [936] = 936,
  [937] = 708,
  [938] = 938,
  [939] = 939,
  [940] = 709,
  [941] = 941,
  [942] = 942,
  [943] = 943,
  [944] = 944,
  [945] = 945,
  [946] = 946,
  [947] = 947,
  [948] = 948,
  [949] = 949,
  [950] = 950,
  [951] = 938,
  [952] = 719,
  [953] = 720,
  [954] = 954,
  [955] = 955,
  [956] = 956,
  [957] = 957,
  [958] = 905,
  [959] = 914,
  [960] = 960,
  [961] = 941,
  [962] = 713,
  [963] = 963,
  [964] = 964,
  [965] = 965,
  [966] = 966,
  [967] = 967,
  [968] = 968,
  [969] = 969,
  [970] = 970,
  [971] = 954,
  [972] = 641,
  [973] = 973,
  [974] = 974,
  [975] = 938,
  [976] = 976,
  [977] = 977,
  [978] = 954,
  [979] = 979,
  [980] = 905,
  [981] = 914,
  [982] = 941,
  [983] = 944,
  [984] = 984,
  [985] = 938,
  [986] = 986,
  [987] = 954,
  [988] = 988,
  [989] = 905,
  [990] = 914,
  [991] = 991,
  [992] = 750,
  [993] = 941,
  [994] = 944,
  [995] = 938,
  [996] = 954,
  [997] = 997,
  [998] = 998,
  [999] = 999,
  [1000] = 1000,
  [1001] = 1001,
  [1002] = 1002,
  [1003] = 1003,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 712,
  [1008] = 1008,
  [1009] = 944,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 1015,
  [1016] = 1016,
  [1017] = 1017,
  [1018] = 1018,
  [1019] = 1019,
  [1020] = 1020,
  [1021] = 1021,
  [1022] = 1022,
  [1023] = 1023,
  [1024] = 1024,
  [1025] = 1025,
  [1026] = 1026,
  [1027] = 1027,
  [1028] = 1028,
  [1029] = 1029,
  [1030] = 1030,
  [1031] = 1031,
  [1032] = 1032,
  [1033] = 1033,
  [1034] = 1017,
  [1035] = 1035,
  [1036] = 1036,
  [1037] = 1037,
  [1038] = 1038,
  [1039] = 1039,
  [1040] = 1040,
  [1041] = 1041,
  [1042] = 1042,
  [1043] = 1043,
  [1044] = 1044,
  [1045] = 1045,
  [1046] = 1032,
  [1047] = 1047,
  [1048] = 1048,
  [1049] = 1049,
  [1050] = 1050,
  [1051] = 1051,
  [1052] = 1052,
  [1053] = 1032,
  [1054] = 1033,
  [1055] = 1055,
  [1056] = 1056,
  [1057] = 1057,
  [1058] = 1058,
  [1059] = 1033,
  [1060] = 1060,
  [1061] = 1032,
  [1062] = 1033,
  [1063] = 1063,
  [1064] = 1064,
  [1065] = 1045,
  [1066] = 1032,
  [1067] = 1033,
  [1068] = 1068,
  [1069] = 1069,
  [1070] = 1070,
  [1071] = 1071,
  [1072] = 1031,
  [1073] = 1073,
  [1074] = 1074,
  [1075] = 1075,
  [1076] = 1076,
  [1077] = 1077,
  [1078] = 1078,
  [1079] = 1079,
  [1080] = 1080,
  [1081] = 1081,
  [1082] = 1082,
  [1083] = 1083,
  [1084] = 1084,
  [1085] = 1083,
  [1086] = 1086,
  [1087] = 1087,
  [1088] = 1088,
  [1089] = 1089,
  [1090] = 1090,
  [1091] = 1091,
  [1092] = 1092,
  [1093] = 1093,
  [1094] = 1081,
  [1095] = 1095,
  [1096] = 1089,
  [1097] = 1081,
  [1098] = 1098,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 1098,
  [1102] = 1090,
  [1103] = 1103,
  [1104] = 670,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1092,
  [1108] = 1108,
  [1109] = 1088,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1081,
  [1113] = 1082,
  [1114] = 1084,
  [1115] = 1087,
  [1116] = 1116,
  [1117] = 1117,
  [1118] = 1106,
  [1119] = 1119,
  [1120] = 1120,
  [1121] = 1121,
  [1122] = 1122,
  [1123] = 1123,
  [1124] = 1124,
  [1125] = 1081,
  [1126] = 1081,
  [1127] = 1081,
  [1128] = 1081,
  [1129] = 1081,
  [1130] = 1081,
  [1131] = 1081,
  [1132] = 1132,
  [1133] = 1100,
  [1134] = 1119,
  [1135] = 1111,
  [1136] = 1136,
  [1137] = 669,
  [1138] = 1081,
  [1139] = 1139,
  [1140] = 1140,
  [1141] = 1141,
  [1142] = 1142,
  [1143] = 1143,
  [1144] = 1119,
  [1145] = 1111,
  [1146] = 1146,
  [1147] = 1086,
  [1148] = 1119,
  [1149] = 1111,
  [1150] = 1119,
  [1151] = 1111,
  [1152] = 1081,
  [1153] = 1153,
  [1154] = 1154,
  [1155] = 1154,
  [1156] = 1156,
  [1157] = 1157,
  [1158] = 1158,
  [1159] = 1159,
  [1160] = 1160,
  [1161] = 1161,
  [1162] = 1162,
  [1163] = 1163,
  [1164] = 1164,
  [1165] = 1165,
  [1166] = 1166,
  [1167] = 1167,
  [1168] = 1164,
  [1169] = 1169,
  [1170] = 974,
  [1171] = 1171,
  [1172] = 1172,
  [1173] = 1173,
  [1174] = 1174,
  [1175] = 1175,
  [1176] = 1176,
  [1177] = 1177,
  [1178] = 1178,
  [1179] = 1179,
  [1180] = 1163,
  [1181] = 1163,
  [1182] = 1164,
  [1183] = 1167,
  [1184] = 1184,
  [1185] = 1169,
  [1186] = 1164,
  [1187] = 1171,
  [1188] = 1188,
  [1189] = 1189,
  [1190] = 1163,
  [1191] = 1164,
  [1192] = 1171,
  [1193] = 1193,
  [1194] = 1194,
  [1195] = 1163,
  [1196] = 1164,
  [1197] = 1171,
  [1198] = 1171,
  [1199] = 1199,
  [1200] = 1163,
  [1201] = 1201,
  [1202] = 1202,
  [1203] = 1203,
  [1204] = 1204,
  [1205] = 1205,
  [1206] = 1163,
  [1207] = 1207,
  [1208] = 1162,
  [1209] = 1164,
  [1210] = 1210,
  [1211] = 984,
  [1212] = 1164,
  [1213] = 1213,
  [1214] = 1167,
  [1215] = 1215,
  [1216] = 1216,
  [1217] = 1169,
  [1218] = 1167,
  [1219] = 1171,
  [1220] = 1220,
  [1221] = 1221,
  [1222] = 1222,
  [1223] = 1169,
  [1224] = 1224,
  [1225] = 1225,
  [1226] = 1164,
  [1227] = 1227,
  [1228] = 1164,
  [1229] = 1229,
  [1230] = 1164,
  [1231] = 1231,
  [1232] = 1171,
  [1233] = 1233,
  [1234] = 1169,
  [1235] = 1235,
  [1236] = 1236,
  [1237] = 1164,
  [1238] = 1171,
  [1239] = 1239,
  [1240] = 1163,
  [1241] = 1154,
  [1242] = 1167,
  [1243] = 1243,
  [1244] = 1224,
  [1245] = 1245,
  [1246] = 1233,
  [1247] = 1154,
  [1248] = 1164,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(16);
      ADVANCE_MAP(
        '&', 35,
        '\'', 53,
        '(', 19,
        ')', 20,
        '*', 25,
        '+', 21,
        ',', 18,
        '-', 23,
        '.', 38,
        '/', 27,
        ':', 61,
        ';', 17,
        '<', 44,
        '=', 60,
        '>', 49,
        '?', 42,
        '@', 43,
        '[', 54,
        '\\', 29,
        ']', 56,
        '^', 31,
        'g', 70,
        's', 71,
        '{', 57,
        '|', 33,
        '}', 58,
        '~', 41,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '\n', 75,
        '\r', 76,
        '&', 35,
        '(', 19,
        '+', 21,
        ',', 18,
        '-', 23,
        '.', 39,
        ';', 17,
        '<', 44,
        '=', 60,
        '>', 49,
        '?', 42,
        '@', 43,
        '[', 54,
        '{', 57,
        '|', 10,
        '~', 41,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '\n', 75,
        '\r', 76,
        '&', 34,
        '(', 19,
        '+', 21,
        ',', 18,
        '-', 23,
        '.', 39,
        ';', 17,
        '=', 59,
        '?', 42,
        '@', 43,
        '[', 54,
        '{', 57,
        '~', 40,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '&', 35,
        '\'', 53,
        '(', 19,
        '*', 25,
        '+', 21,
        '-', 23,
        '.', 37,
        '/', 27,
        ':', 61,
        ';', 17,
        '<', 44,
        '=', 8,
        '>', 49,
        '@', 43,
        '\\', 29,
        ']', 56,
        '^', 31,
        '{', 57,
        '|', 33,
        '}', 58,
        '~', 9,
        '\n', 55,
        '\r', 55,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(3);
      END_STATE();
    case 4:
      if (lookahead == '&') ADVANCE(50);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '&', 4,
        '(', 19,
        ')', 20,
        ',', 18,
        '.', 36,
        '<', 44,
        '=', 8,
        '>', 49,
        '{', 57,
        '|', 10,
        '}', 58,
        '~', 9,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '&', 4,
        '.', 36,
        ';', 17,
        '<', 44,
        '=', 8,
        '>', 49,
        ']', 56,
        '|', 10,
        '}', 58,
        '~', 9,
        '\n', 55,
        '\r', 55,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(6);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '(', 19,
        '+', 21,
        ',', 18,
        '-', 23,
        '.', 12,
        ';', 17,
        '?', 42,
        '@', 43,
        '[', 54,
        ']', 56,
        '{', 57,
        '}', 58,
        '~', 40,
        '\n', 55,
        '\r', 55,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(7);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 8:
      if (lookahead == '=') ADVANCE(46);
      END_STATE();
    case 9:
      if (lookahead == '=') ADVANCE(47);
      END_STATE();
    case 10:
      if (lookahead == '|') ADVANCE(51);
      END_STATE();
    case 11:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(13);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(67);
      END_STATE();
    case 12:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      END_STATE();
    case 13:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(67);
      END_STATE();
    case 14:
      if (eof) ADVANCE(16);
      ADVANCE_MAP(
        '\n', 75,
        '\r', 76,
        '&', 35,
        '\'', 53,
        '(', 19,
        '*', 25,
        '+', 21,
        ',', 18,
        '-', 23,
        '.', 38,
        '/', 27,
        ':', 61,
        ';', 17,
        '<', 44,
        '=', 60,
        '>', 49,
        '?', 42,
        '@', 43,
        '[', 54,
        '\\', 29,
        '^', 31,
        '{', 57,
        '|', 33,
        '~', 41,
      );
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') SKIP(14);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 15:
      if (eof) ADVANCE(16);
      ADVANCE_MAP(
        '(', 19,
        ')', 20,
        '*', 25,
        '+', 21,
        ',', 18,
        '-', 23,
        '.', 39,
        ':', 61,
        ';', 17,
        '=', 59,
        '?', 42,
        '@', 43,
        '[', 54,
        ']', 56,
        '{', 57,
        '}', 58,
        '~', 40,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_DOT_PLUS);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_DOT_DASH);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_DOT_STAR);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_DOT_SLASH);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_DOT_BSLASH);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_DOT_CARET);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(51);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(50);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '\'') ADVANCE(52);
      if (lookahead == '*') ADVANCE(26);
      if (lookahead == '+') ADVANCE(22);
      if (lookahead == '-') ADVANCE(24);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == '^') ADVANCE(32);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '\'') ADVANCE(52);
      if (lookahead == '*') ADVANCE(26);
      if (lookahead == '+') ADVANCE(22);
      if (lookahead == '-') ADVANCE(24);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '\\') ADVANCE(30);
      if (lookahead == '^') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '=') ADVANCE(47);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(45);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_TILDE_EQ);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(48);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_DOT_SQUOTE);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(aux_sym_matrix_token1);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(55);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(46);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_get_DOT);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_set_DOT);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(66);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(11);
      if (lookahead == 'i' ||
          lookahead == 'j') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(11);
      if (lookahead == 'i' ||
          lookahead == 'j') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'i' ||
          lookahead == 'j') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(67);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(72);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(73);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(68);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(75);
      if (lookahead == '\r') ADVANCE(76);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_CR);
      if (lookahead == '\n') ADVANCE(75);
      if (lookahead == '\r') ADVANCE(76);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'c', 3,
        'e', 4,
        'f', 5,
        'g', 6,
        'i', 7,
        'm', 8,
        'o', 9,
        'p', 10,
        'r', 11,
        's', 12,
        't', 13,
        'v', 14,
        'w', 15,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'r') ADVANCE(16);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(17);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(18);
      if (lookahead == 'l') ADVANCE(19);
      if (lookahead == 'o') ADVANCE(20);
      END_STATE();
    case 4:
      if (lookahead == 'l') ADVANCE(21);
      if (lookahead == 'n') ADVANCE(22);
      if (lookahead == 'v') ADVANCE(23);
      END_STATE();
    case 5:
      if (lookahead == 'a') ADVANCE(24);
      if (lookahead == 'o') ADVANCE(25);
      if (lookahead == 'u') ADVANCE(26);
      END_STATE();
    case 6:
      if (lookahead == 'l') ADVANCE(27);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(28);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'e') ADVANCE(30);
      END_STATE();
    case 9:
      if (lookahead == 't') ADVANCE(31);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(32);
      if (lookahead == 'e') ADVANCE(33);
      if (lookahead == 'r') ADVANCE(34);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(35);
      END_STATE();
    case 12:
      if (lookahead == 'c') ADVANCE(36);
      if (lookahead == 'w') ADVANCE(37);
      END_STATE();
    case 13:
      if (lookahead == 'r') ADVANCE(38);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(39);
      END_STATE();
    case 15:
      if (lookahead == 'h') ADVANCE(40);
      END_STATE();
    case 16:
      if (lookahead == 'g') ADVANCE(41);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 18:
      if (lookahead == 's') ADVANCE(43);
      if (lookahead == 't') ADVANCE(44);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(45);
      END_STATE();
    case 20:
      if (lookahead == 'n') ADVANCE(46);
      END_STATE();
    case 21:
      if (lookahead == 's') ADVANCE(47);
      END_STATE();
    case 22:
      if (lookahead == 'd') ADVANCE(48);
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(50);
      END_STATE();
    case 24:
      if (lookahead == 'l') ADVANCE(51);
      END_STATE();
    case 25:
      if (lookahead == 'r') ADVANCE(52);
      END_STATE();
    case 26:
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 27:
      if (lookahead == 'o') ADVANCE(54);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 29:
      if (lookahead == 't') ADVANCE(55);
      END_STATE();
    case 30:
      if (lookahead == 't') ADVANCE(56);
      END_STATE();
    case 31:
      if (lookahead == 'h') ADVANCE(57);
      END_STATE();
    case 32:
      if (lookahead == 'r') ADVANCE(58);
      END_STATE();
    case 33:
      if (lookahead == 'r') ADVANCE(59);
      END_STATE();
    case 34:
      if (lookahead == 'o') ADVANCE(60);
      END_STATE();
    case 35:
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 36:
      if (lookahead == 'a') ADVANCE(62);
      END_STATE();
    case 37:
      if (lookahead == 'i') ADVANCE(63);
      END_STATE();
    case 38:
      if (lookahead == 'u') ADVANCE(64);
      if (lookahead == 'y') ADVANCE(65);
      END_STATE();
    case 39:
      if (lookahead == 'c') ADVANCE(66);
      END_STATE();
    case 40:
      if (lookahead == 'i') ADVANCE(67);
      END_STATE();
    case 41:
      if (lookahead == 'u') ADVANCE(68);
      END_STATE();
    case 42:
      if (lookahead == 'a') ADVANCE(69);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 44:
      if (lookahead == 'c') ADVANCE(71);
      END_STATE();
    case 45:
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 46:
      if (lookahead == 't') ADVANCE(73);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(74);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_end);
      if (lookahead == 'f') ADVANCE(75);
      END_STATE();
    case 49:
      if (lookahead == 'm') ADVANCE(76);
      END_STATE();
    case 50:
      if (lookahead == 'n') ADVANCE(77);
      END_STATE();
    case 51:
      if (lookahead == 's') ADVANCE(78);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 53:
      if (lookahead == 'c') ADVANCE(79);
      END_STATE();
    case 54:
      if (lookahead == 'b') ADVANCE(80);
      END_STATE();
    case 55:
      if (lookahead == 'r') ADVANCE(81);
      END_STATE();
    case 56:
      if (lookahead == 'h') ADVANCE(82);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(83);
      END_STATE();
    case 58:
      if (lookahead == 'f') ADVANCE(84);
      END_STATE();
    case 59:
      if (lookahead == 's') ADVANCE(85);
      END_STATE();
    case 60:
      if (lookahead == 'p') ADVANCE(86);
      END_STATE();
    case 61:
      if (lookahead == 'u') ADVANCE(87);
      END_STATE();
    case 62:
      if (lookahead == 'l') ADVANCE(88);
      END_STATE();
    case 63:
      if (lookahead == 't') ADVANCE(89);
      END_STATE();
    case 64:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 66:
      if (lookahead == 't') ADVANCE(91);
      END_STATE();
    case 67:
      if (lookahead == 'l') ADVANCE(92);
      END_STATE();
    case 68:
      if (lookahead == 'm') ADVANCE(93);
      END_STATE();
    case 69:
      if (lookahead == 'k') ADVANCE(94);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 71:
      if (lookahead == 'h') ADVANCE(95);
      END_STATE();
    case 72:
      if (lookahead == 's') ADVANCE(96);
      END_STATE();
    case 73:
      if (lookahead == 'i') ADVANCE(97);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == 'i') ADVANCE(98);
      END_STATE();
    case 75:
      if (lookahead == 'u') ADVANCE(99);
      END_STATE();
    case 76:
      if (lookahead == 'e') ADVANCE(100);
      END_STATE();
    case 77:
      if (lookahead == 't') ADVANCE(101);
      END_STATE();
    case 78:
      if (lookahead == 'e') ADVANCE(102);
      END_STATE();
    case 79:
      if (lookahead == 't') ADVANCE(103);
      END_STATE();
    case 80:
      if (lookahead == 'a') ADVANCE(104);
      END_STATE();
    case 81:
      if (lookahead == 'i') ADVANCE(105);
      END_STATE();
    case 82:
      if (lookahead == 'o') ADVANCE(106);
      END_STATE();
    case 83:
      if (lookahead == 'r') ADVANCE(107);
      END_STATE();
    case 84:
      if (lookahead == 'o') ADVANCE(108);
      END_STATE();
    case 85:
      if (lookahead == 'i') ADVANCE(109);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(110);
      END_STATE();
    case 87:
      if (lookahead == 'r') ADVANCE(111);
      END_STATE();
    case 88:
      if (lookahead == 'a') ADVANCE(112);
      END_STATE();
    case 89:
      if (lookahead == 'c') ADVANCE(113);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 91:
      if (lookahead == 'o') ADVANCE(114);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(115);
      END_STATE();
    case 93:
      if (lookahead == 'e') ADVANCE(116);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_break_statement);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 96:
      if (lookahead == 'd') ADVANCE(117);
      END_STATE();
    case 97:
      if (lookahead == 'n') ADVANCE(118);
      END_STATE();
    case 98:
      if (lookahead == 'f') ADVANCE(119);
      END_STATE();
    case 99:
      if (lookahead == 'n') ADVANCE(120);
      END_STATE();
    case 100:
      if (lookahead == 'r') ADVANCE(121);
      END_STATE();
    case 101:
      if (lookahead == 's') ADVANCE(122);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 103:
      if (lookahead == 'i') ADVANCE(123);
      END_STATE();
    case 104:
      if (lookahead == 'l') ADVANCE(124);
      END_STATE();
    case 105:
      if (lookahead == 'x') ADVANCE(125);
      END_STATE();
    case 106:
      if (lookahead == 'd') ADVANCE(126);
      END_STATE();
    case 107:
      if (lookahead == 'w') ADVANCE(127);
      END_STATE();
    case 108:
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 109:
      if (lookahead == 's') ADVANCE(129);
      END_STATE();
    case 110:
      if (lookahead == 'r') ADVANCE(130);
      END_STATE();
    case 111:
      if (lookahead == 'n') ADVANCE(131);
      END_STATE();
    case 112:
      if (lookahead == 'r') ADVANCE(132);
      END_STATE();
    case 113:
      if (lookahead == 'h') ADVANCE(133);
      END_STATE();
    case 114:
      if (lookahead == 'r') ADVANCE(134);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 116:
      if (lookahead == 'n') ADVANCE(135);
      END_STATE();
    case 117:
      if (lookahead == 'e') ADVANCE(136);
      END_STATE();
    case 118:
      if (lookahead == 'u') ADVANCE(137);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_elseif);
      END_STATE();
    case 120:
      if (lookahead == 'c') ADVANCE(138);
      END_STATE();
    case 121:
      if (lookahead == 'a') ADVANCE(139);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_events);
      END_STATE();
    case 123:
      if (lookahead == 'o') ADVANCE(140);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_matrix);
      END_STATE();
    case 126:
      if (lookahead == 's') ADVANCE(141);
      END_STATE();
    case 127:
      if (lookahead == 'i') ADVANCE(142);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_parfor);
      END_STATE();
    case 129:
      if (lookahead == 't') ADVANCE(143);
      END_STATE();
    case 130:
      if (lookahead == 't') ADVANCE(144);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_return_statement);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_scalar);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_vector);
      END_STATE();
    case 135:
      if (lookahead == 't') ADVANCE(145);
      END_STATE();
    case 136:
      if (lookahead == 'f') ADVANCE(146);
      END_STATE();
    case 137:
      if (lookahead == 'e') ADVANCE(147);
      END_STATE();
    case 138:
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 139:
      if (lookahead == 't') ADVANCE(149);
      END_STATE();
    case 140:
      if (lookahead == 'n') ADVANCE(150);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_methods);
      END_STATE();
    case 142:
      if (lookahead == 's') ADVANCE(151);
      END_STATE();
    case 143:
      if (lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 144:
      if (lookahead == 'i') ADVANCE(153);
      END_STATE();
    case 145:
      if (lookahead == 's') ADVANCE(154);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_classdef);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_continue_statement);
      END_STATE();
    case 148:
      if (lookahead == 'i') ADVANCE(155);
      END_STATE();
    case 149:
      if (lookahead == 'i') ADVANCE(156);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 151:
      if (lookahead == 'e') ADVANCE(157);
      END_STATE();
    case 152:
      if (lookahead == 'n') ADVANCE(158);
      END_STATE();
    case 153:
      if (lookahead == 'e') ADVANCE(159);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_arguments);
      END_STATE();
    case 155:
      if (lookahead == 'o') ADVANCE(160);
      END_STATE();
    case 156:
      if (lookahead == 'o') ADVANCE(161);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_otherwise);
      END_STATE();
    case 158:
      if (lookahead == 't') ADVANCE(162);
      END_STATE();
    case 159:
      if (lookahead == 's') ADVANCE(163);
      END_STATE();
    case 160:
      if (lookahead == 'n') ADVANCE(164);
      END_STATE();
    case 161:
      if (lookahead == 'n') ADVANCE(165);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_persistent);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_properties);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_endfunction);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_enumeration);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 15, .external_lex_state = 2},
  [2] = {.lex_state = 14, .external_lex_state = 2},
  [3] = {.lex_state = 14, .external_lex_state = 2},
  [4] = {.lex_state = 14, .external_lex_state = 2},
  [5] = {.lex_state = 2, .external_lex_state = 2},
  [6] = {.lex_state = 2, .external_lex_state = 2},
  [7] = {.lex_state = 2, .external_lex_state = 2},
  [8] = {.lex_state = 2, .external_lex_state = 2},
  [9] = {.lex_state = 2, .external_lex_state = 2},
  [10] = {.lex_state = 2, .external_lex_state = 2},
  [11] = {.lex_state = 2, .external_lex_state = 2},
  [12] = {.lex_state = 2, .external_lex_state = 2},
  [13] = {.lex_state = 2, .external_lex_state = 2},
  [14] = {.lex_state = 2, .external_lex_state = 2},
  [15] = {.lex_state = 2, .external_lex_state = 2},
  [16] = {.lex_state = 2, .external_lex_state = 2},
  [17] = {.lex_state = 2, .external_lex_state = 2},
  [18] = {.lex_state = 2, .external_lex_state = 2},
  [19] = {.lex_state = 2, .external_lex_state = 2},
  [20] = {.lex_state = 2, .external_lex_state = 2},
  [21] = {.lex_state = 15, .external_lex_state = 2},
  [22] = {.lex_state = 15, .external_lex_state = 2},
  [23] = {.lex_state = 15, .external_lex_state = 2},
  [24] = {.lex_state = 15, .external_lex_state = 2},
  [25] = {.lex_state = 15, .external_lex_state = 2},
  [26] = {.lex_state = 15, .external_lex_state = 2},
  [27] = {.lex_state = 15, .external_lex_state = 2},
  [28] = {.lex_state = 15, .external_lex_state = 2},
  [29] = {.lex_state = 15, .external_lex_state = 2},
  [30] = {.lex_state = 15, .external_lex_state = 2},
  [31] = {.lex_state = 15, .external_lex_state = 2},
  [32] = {.lex_state = 15, .external_lex_state = 2},
  [33] = {.lex_state = 15, .external_lex_state = 2},
  [34] = {.lex_state = 15, .external_lex_state = 2},
  [35] = {.lex_state = 15, .external_lex_state = 2},
  [36] = {.lex_state = 15, .external_lex_state = 2},
  [37] = {.lex_state = 15, .external_lex_state = 2},
  [38] = {.lex_state = 15, .external_lex_state = 2},
  [39] = {.lex_state = 15, .external_lex_state = 2},
  [40] = {.lex_state = 15, .external_lex_state = 2},
  [41] = {.lex_state = 15, .external_lex_state = 2},
  [42] = {.lex_state = 15, .external_lex_state = 2},
  [43] = {.lex_state = 15, .external_lex_state = 2},
  [44] = {.lex_state = 15, .external_lex_state = 2},
  [45] = {.lex_state = 15, .external_lex_state = 2},
  [46] = {.lex_state = 15, .external_lex_state = 2},
  [47] = {.lex_state = 15, .external_lex_state = 2},
  [48] = {.lex_state = 15, .external_lex_state = 2},
  [49] = {.lex_state = 15, .external_lex_state = 2},
  [50] = {.lex_state = 15, .external_lex_state = 2},
  [51] = {.lex_state = 15, .external_lex_state = 2},
  [52] = {.lex_state = 15, .external_lex_state = 2},
  [53] = {.lex_state = 15, .external_lex_state = 2},
  [54] = {.lex_state = 15, .external_lex_state = 2},
  [55] = {.lex_state = 15, .external_lex_state = 2},
  [56] = {.lex_state = 15, .external_lex_state = 2},
  [57] = {.lex_state = 15, .external_lex_state = 2},
  [58] = {.lex_state = 15, .external_lex_state = 2},
  [59] = {.lex_state = 15, .external_lex_state = 2},
  [60] = {.lex_state = 15, .external_lex_state = 2},
  [61] = {.lex_state = 15, .external_lex_state = 2},
  [62] = {.lex_state = 15, .external_lex_state = 2},
  [63] = {.lex_state = 15, .external_lex_state = 2},
  [64] = {.lex_state = 15, .external_lex_state = 2},
  [65] = {.lex_state = 15, .external_lex_state = 2},
  [66] = {.lex_state = 15, .external_lex_state = 2},
  [67] = {.lex_state = 15, .external_lex_state = 2},
  [68] = {.lex_state = 15, .external_lex_state = 2},
  [69] = {.lex_state = 15, .external_lex_state = 2},
  [70] = {.lex_state = 15, .external_lex_state = 2},
  [71] = {.lex_state = 15, .external_lex_state = 2},
  [72] = {.lex_state = 15, .external_lex_state = 2},
  [73] = {.lex_state = 15, .external_lex_state = 2},
  [74] = {.lex_state = 15, .external_lex_state = 2},
  [75] = {.lex_state = 15, .external_lex_state = 2},
  [76] = {.lex_state = 14, .external_lex_state = 2},
  [77] = {.lex_state = 14, .external_lex_state = 2},
  [78] = {.lex_state = 14, .external_lex_state = 2},
  [79] = {.lex_state = 14, .external_lex_state = 2},
  [80] = {.lex_state = 14, .external_lex_state = 2},
  [81] = {.lex_state = 14, .external_lex_state = 2},
  [82] = {.lex_state = 14, .external_lex_state = 2},
  [83] = {.lex_state = 14, .external_lex_state = 2},
  [84] = {.lex_state = 14, .external_lex_state = 2},
  [85] = {.lex_state = 14, .external_lex_state = 2},
  [86] = {.lex_state = 14, .external_lex_state = 2},
  [87] = {.lex_state = 14, .external_lex_state = 2},
  [88] = {.lex_state = 14, .external_lex_state = 2},
  [89] = {.lex_state = 14, .external_lex_state = 2},
  [90] = {.lex_state = 14, .external_lex_state = 2},
  [91] = {.lex_state = 14, .external_lex_state = 2},
  [92] = {.lex_state = 14, .external_lex_state = 2},
  [93] = {.lex_state = 14, .external_lex_state = 2},
  [94] = {.lex_state = 14, .external_lex_state = 2},
  [95] = {.lex_state = 14, .external_lex_state = 2},
  [96] = {.lex_state = 14, .external_lex_state = 2},
  [97] = {.lex_state = 14, .external_lex_state = 2},
  [98] = {.lex_state = 14, .external_lex_state = 2},
  [99] = {.lex_state = 14, .external_lex_state = 2},
  [100] = {.lex_state = 14, .external_lex_state = 2},
  [101] = {.lex_state = 14, .external_lex_state = 2},
  [102] = {.lex_state = 14, .external_lex_state = 2},
  [103] = {.lex_state = 14, .external_lex_state = 2},
  [104] = {.lex_state = 14, .external_lex_state = 2},
  [105] = {.lex_state = 14, .external_lex_state = 2},
  [106] = {.lex_state = 14, .external_lex_state = 2},
  [107] = {.lex_state = 14, .external_lex_state = 2},
  [108] = {.lex_state = 14, .external_lex_state = 2},
  [109] = {.lex_state = 14, .external_lex_state = 2},
  [110] = {.lex_state = 14, .external_lex_state = 2},
  [111] = {.lex_state = 14, .external_lex_state = 2},
  [112] = {.lex_state = 14, .external_lex_state = 2},
  [113] = {.lex_state = 14, .external_lex_state = 2},
  [114] = {.lex_state = 14, .external_lex_state = 2},
  [115] = {.lex_state = 14, .external_lex_state = 2},
  [116] = {.lex_state = 14, .external_lex_state = 2},
  [117] = {.lex_state = 14, .external_lex_state = 2},
  [118] = {.lex_state = 14, .external_lex_state = 2},
  [119] = {.lex_state = 14, .external_lex_state = 2},
  [120] = {.lex_state = 14, .external_lex_state = 2},
  [121] = {.lex_state = 14, .external_lex_state = 2},
  [122] = {.lex_state = 14, .external_lex_state = 2},
  [123] = {.lex_state = 14, .external_lex_state = 2},
  [124] = {.lex_state = 14, .external_lex_state = 2},
  [125] = {.lex_state = 14, .external_lex_state = 2},
  [126] = {.lex_state = 14, .external_lex_state = 2},
  [127] = {.lex_state = 14, .external_lex_state = 2},
  [128] = {.lex_state = 14, .external_lex_state = 2},
  [129] = {.lex_state = 14, .external_lex_state = 2},
  [130] = {.lex_state = 14, .external_lex_state = 2},
  [131] = {.lex_state = 14, .external_lex_state = 2},
  [132] = {.lex_state = 14, .external_lex_state = 2},
  [133] = {.lex_state = 14, .external_lex_state = 2},
  [134] = {.lex_state = 14, .external_lex_state = 2},
  [135] = {.lex_state = 14, .external_lex_state = 2},
  [136] = {.lex_state = 14, .external_lex_state = 2},
  [137] = {.lex_state = 14, .external_lex_state = 2},
  [138] = {.lex_state = 14, .external_lex_state = 2},
  [139] = {.lex_state = 14, .external_lex_state = 2},
  [140] = {.lex_state = 14, .external_lex_state = 2},
  [141] = {.lex_state = 14, .external_lex_state = 2},
  [142] = {.lex_state = 14, .external_lex_state = 2},
  [143] = {.lex_state = 14, .external_lex_state = 2},
  [144] = {.lex_state = 14, .external_lex_state = 2},
  [145] = {.lex_state = 14, .external_lex_state = 2},
  [146] = {.lex_state = 14, .external_lex_state = 2},
  [147] = {.lex_state = 14, .external_lex_state = 2},
  [148] = {.lex_state = 14, .external_lex_state = 2},
  [149] = {.lex_state = 14, .external_lex_state = 2},
  [150] = {.lex_state = 14, .external_lex_state = 2},
  [151] = {.lex_state = 14, .external_lex_state = 2},
  [152] = {.lex_state = 1, .external_lex_state = 2},
  [153] = {.lex_state = 1, .external_lex_state = 2},
  [154] = {.lex_state = 1, .external_lex_state = 2},
  [155] = {.lex_state = 1, .external_lex_state = 2},
  [156] = {.lex_state = 1, .external_lex_state = 2},
  [157] = {.lex_state = 1, .external_lex_state = 2},
  [158] = {.lex_state = 14, .external_lex_state = 2},
  [159] = {.lex_state = 7, .external_lex_state = 3},
  [160] = {.lex_state = 2, .external_lex_state = 2},
  [161] = {.lex_state = 7, .external_lex_state = 4},
  [162] = {.lex_state = 7, .external_lex_state = 3},
  [163] = {.lex_state = 7, .external_lex_state = 3},
  [164] = {.lex_state = 7, .external_lex_state = 3},
  [165] = {.lex_state = 15, .external_lex_state = 2},
  [166] = {.lex_state = 15, .external_lex_state = 3},
  [167] = {.lex_state = 15, .external_lex_state = 3},
  [168] = {.lex_state = 15, .external_lex_state = 2},
  [169] = {.lex_state = 15, .external_lex_state = 2},
  [170] = {.lex_state = 15, .external_lex_state = 2},
  [171] = {.lex_state = 15, .external_lex_state = 3},
  [172] = {.lex_state = 15, .external_lex_state = 3},
  [173] = {.lex_state = 15, .external_lex_state = 2},
  [174] = {.lex_state = 15, .external_lex_state = 3},
  [175] = {.lex_state = 15, .external_lex_state = 3},
  [176] = {.lex_state = 15, .external_lex_state = 3},
  [177] = {.lex_state = 15, .external_lex_state = 3},
  [178] = {.lex_state = 15, .external_lex_state = 3},
  [179] = {.lex_state = 15, .external_lex_state = 3},
  [180] = {.lex_state = 15, .external_lex_state = 3},
  [181] = {.lex_state = 15, .external_lex_state = 3},
  [182] = {.lex_state = 15, .external_lex_state = 3},
  [183] = {.lex_state = 15, .external_lex_state = 3},
  [184] = {.lex_state = 15, .external_lex_state = 3},
  [185] = {.lex_state = 15, .external_lex_state = 3},
  [186] = {.lex_state = 15, .external_lex_state = 3},
  [187] = {.lex_state = 15, .external_lex_state = 3},
  [188] = {.lex_state = 15, .external_lex_state = 3},
  [189] = {.lex_state = 14, .external_lex_state = 5},
  [190] = {.lex_state = 14, .external_lex_state = 5},
  [191] = {.lex_state = 14, .external_lex_state = 5},
  [192] = {.lex_state = 14, .external_lex_state = 5},
  [193] = {.lex_state = 14, .external_lex_state = 5},
  [194] = {.lex_state = 14, .external_lex_state = 5},
  [195] = {.lex_state = 14, .external_lex_state = 5},
  [196] = {.lex_state = 15, .external_lex_state = 3},
  [197] = {.lex_state = 15, .external_lex_state = 3},
  [198] = {.lex_state = 14, .external_lex_state = 5},
  [199] = {.lex_state = 15, .external_lex_state = 3},
  [200] = {.lex_state = 14, .external_lex_state = 5},
  [201] = {.lex_state = 15, .external_lex_state = 3},
  [202] = {.lex_state = 14, .external_lex_state = 5},
  [203] = {.lex_state = 14, .external_lex_state = 5},
  [204] = {.lex_state = 14, .external_lex_state = 5},
  [205] = {.lex_state = 14, .external_lex_state = 5},
  [206] = {.lex_state = 14, .external_lex_state = 5},
  [207] = {.lex_state = 3, .external_lex_state = 6},
  [208] = {.lex_state = 14, .external_lex_state = 5},
  [209] = {.lex_state = 3, .external_lex_state = 6},
  [210] = {.lex_state = 14, .external_lex_state = 5},
  [211] = {.lex_state = 14, .external_lex_state = 5},
  [212] = {.lex_state = 3, .external_lex_state = 6},
  [213] = {.lex_state = 14, .external_lex_state = 5},
  [214] = {.lex_state = 14, .external_lex_state = 5},
  [215] = {.lex_state = 15, .external_lex_state = 3},
  [216] = {.lex_state = 15, .external_lex_state = 3},
  [217] = {.lex_state = 3, .external_lex_state = 6},
  [218] = {.lex_state = 15, .external_lex_state = 3},
  [219] = {.lex_state = 15, .external_lex_state = 3},
  [220] = {.lex_state = 15, .external_lex_state = 3},
  [221] = {.lex_state = 3, .external_lex_state = 6},
  [222] = {.lex_state = 15, .external_lex_state = 3},
  [223] = {.lex_state = 15, .external_lex_state = 3},
  [224] = {.lex_state = 15, .external_lex_state = 3},
  [225] = {.lex_state = 15, .external_lex_state = 3},
  [226] = {.lex_state = 15, .external_lex_state = 3},
  [227] = {.lex_state = 15, .external_lex_state = 3},
  [228] = {.lex_state = 15, .external_lex_state = 3},
  [229] = {.lex_state = 15, .external_lex_state = 3},
  [230] = {.lex_state = 15, .external_lex_state = 3},
  [231] = {.lex_state = 15, .external_lex_state = 3},
  [232] = {.lex_state = 15, .external_lex_state = 3},
  [233] = {.lex_state = 15, .external_lex_state = 3},
  [234] = {.lex_state = 15, .external_lex_state = 3},
  [235] = {.lex_state = 15, .external_lex_state = 3},
  [236] = {.lex_state = 15, .external_lex_state = 3},
  [237] = {.lex_state = 15, .external_lex_state = 3},
  [238] = {.lex_state = 15, .external_lex_state = 3},
  [239] = {.lex_state = 15, .external_lex_state = 3},
  [240] = {.lex_state = 15, .external_lex_state = 3},
  [241] = {.lex_state = 15, .external_lex_state = 3},
  [242] = {.lex_state = 15, .external_lex_state = 3},
  [243] = {.lex_state = 15, .external_lex_state = 3},
  [244] = {.lex_state = 15, .external_lex_state = 3},
  [245] = {.lex_state = 15, .external_lex_state = 3},
  [246] = {.lex_state = 15, .external_lex_state = 3},
  [247] = {.lex_state = 15, .external_lex_state = 3},
  [248] = {.lex_state = 15, .external_lex_state = 3},
  [249] = {.lex_state = 15, .external_lex_state = 3},
  [250] = {.lex_state = 15, .external_lex_state = 3},
  [251] = {.lex_state = 15, .external_lex_state = 3},
  [252] = {.lex_state = 15, .external_lex_state = 3},
  [253] = {.lex_state = 15, .external_lex_state = 3},
  [254] = {.lex_state = 15, .external_lex_state = 3},
  [255] = {.lex_state = 15, .external_lex_state = 3},
  [256] = {.lex_state = 15, .external_lex_state = 3},
  [257] = {.lex_state = 15, .external_lex_state = 3},
  [258] = {.lex_state = 15, .external_lex_state = 3},
  [259] = {.lex_state = 15, .external_lex_state = 2},
  [260] = {.lex_state = 15, .external_lex_state = 3},
  [261] = {.lex_state = 3, .external_lex_state = 6},
  [262] = {.lex_state = 15, .external_lex_state = 3},
  [263] = {.lex_state = 0, .external_lex_state = 5},
  [264] = {.lex_state = 15, .external_lex_state = 3},
  [265] = {.lex_state = 15, .external_lex_state = 3},
  [266] = {.lex_state = 15, .external_lex_state = 3},
  [267] = {.lex_state = 15, .external_lex_state = 3},
  [268] = {.lex_state = 14, .external_lex_state = 5},
  [269] = {.lex_state = 15, .external_lex_state = 3},
  [270] = {.lex_state = 15, .external_lex_state = 3},
  [271] = {.lex_state = 15, .external_lex_state = 3},
  [272] = {.lex_state = 15, .external_lex_state = 3},
  [273] = {.lex_state = 15, .external_lex_state = 3},
  [274] = {.lex_state = 15, .external_lex_state = 3},
  [275] = {.lex_state = 15, .external_lex_state = 3},
  [276] = {.lex_state = 15, .external_lex_state = 3},
  [277] = {.lex_state = 0, .external_lex_state = 5},
  [278] = {.lex_state = 0, .external_lex_state = 5},
  [279] = {.lex_state = 0, .external_lex_state = 5},
  [280] = {.lex_state = 14, .external_lex_state = 5},
  [281] = {.lex_state = 15, .external_lex_state = 3},
  [282] = {.lex_state = 15, .external_lex_state = 3},
  [283] = {.lex_state = 15, .external_lex_state = 3},
  [284] = {.lex_state = 15, .external_lex_state = 3},
  [285] = {.lex_state = 15, .external_lex_state = 3},
  [286] = {.lex_state = 15, .external_lex_state = 3},
  [287] = {.lex_state = 15, .external_lex_state = 3},
  [288] = {.lex_state = 15, .external_lex_state = 3},
  [289] = {.lex_state = 15, .external_lex_state = 3},
  [290] = {.lex_state = 15, .external_lex_state = 3},
  [291] = {.lex_state = 15, .external_lex_state = 3},
  [292] = {.lex_state = 15, .external_lex_state = 3},
  [293] = {.lex_state = 15, .external_lex_state = 3},
  [294] = {.lex_state = 15, .external_lex_state = 3},
  [295] = {.lex_state = 15, .external_lex_state = 3},
  [296] = {.lex_state = 15, .external_lex_state = 3},
  [297] = {.lex_state = 15, .external_lex_state = 3},
  [298] = {.lex_state = 15, .external_lex_state = 3},
  [299] = {.lex_state = 15, .external_lex_state = 3},
  [300] = {.lex_state = 15, .external_lex_state = 3},
  [301] = {.lex_state = 15, .external_lex_state = 3},
  [302] = {.lex_state = 15, .external_lex_state = 3},
  [303] = {.lex_state = 15, .external_lex_state = 2},
  [304] = {.lex_state = 15, .external_lex_state = 3},
  [305] = {.lex_state = 15, .external_lex_state = 3},
  [306] = {.lex_state = 15, .external_lex_state = 3},
  [307] = {.lex_state = 15, .external_lex_state = 3},
  [308] = {.lex_state = 15, .external_lex_state = 3},
  [309] = {.lex_state = 15, .external_lex_state = 3},
  [310] = {.lex_state = 15, .external_lex_state = 3},
  [311] = {.lex_state = 15, .external_lex_state = 3},
  [312] = {.lex_state = 15, .external_lex_state = 3},
  [313] = {.lex_state = 15, .external_lex_state = 3},
  [314] = {.lex_state = 15, .external_lex_state = 2},
  [315] = {.lex_state = 15, .external_lex_state = 3},
  [316] = {.lex_state = 15, .external_lex_state = 3},
  [317] = {.lex_state = 15, .external_lex_state = 3},
  [318] = {.lex_state = 15, .external_lex_state = 2},
  [319] = {.lex_state = 15, .external_lex_state = 3},
  [320] = {.lex_state = 15, .external_lex_state = 3},
  [321] = {.lex_state = 15, .external_lex_state = 3},
  [322] = {.lex_state = 15, .external_lex_state = 2},
  [323] = {.lex_state = 15, .external_lex_state = 3},
  [324] = {.lex_state = 15, .external_lex_state = 2},
  [325] = {.lex_state = 15, .external_lex_state = 3},
  [326] = {.lex_state = 15, .external_lex_state = 3},
  [327] = {.lex_state = 15, .external_lex_state = 3},
  [328] = {.lex_state = 15, .external_lex_state = 3},
  [329] = {.lex_state = 15, .external_lex_state = 3},
  [330] = {.lex_state = 15, .external_lex_state = 3},
  [331] = {.lex_state = 15, .external_lex_state = 3},
  [332] = {.lex_state = 15, .external_lex_state = 3},
  [333] = {.lex_state = 15, .external_lex_state = 3},
  [334] = {.lex_state = 14, .external_lex_state = 5},
  [335] = {.lex_state = 15, .external_lex_state = 3},
  [336] = {.lex_state = 15, .external_lex_state = 3},
  [337] = {.lex_state = 15, .external_lex_state = 3},
  [338] = {.lex_state = 15, .external_lex_state = 3},
  [339] = {.lex_state = 15, .external_lex_state = 3},
  [340] = {.lex_state = 15, .external_lex_state = 3},
  [341] = {.lex_state = 15, .external_lex_state = 3},
  [342] = {.lex_state = 15, .external_lex_state = 3},
  [343] = {.lex_state = 15, .external_lex_state = 3},
  [344] = {.lex_state = 15, .external_lex_state = 3},
  [345] = {.lex_state = 15, .external_lex_state = 3},
  [346] = {.lex_state = 0, .external_lex_state = 5},
  [347] = {.lex_state = 3, .external_lex_state = 6},
  [348] = {.lex_state = 0, .external_lex_state = 5},
  [349] = {.lex_state = 14, .external_lex_state = 5},
  [350] = {.lex_state = 14, .external_lex_state = 5},
  [351] = {.lex_state = 3, .external_lex_state = 6},
  [352] = {.lex_state = 3, .external_lex_state = 6},
  [353] = {.lex_state = 14, .external_lex_state = 5},
  [354] = {.lex_state = 3, .external_lex_state = 6},
  [355] = {.lex_state = 14, .external_lex_state = 5},
  [356] = {.lex_state = 0, .external_lex_state = 5},
  [357] = {.lex_state = 0, .external_lex_state = 5},
  [358] = {.lex_state = 0, .external_lex_state = 5},
  [359] = {.lex_state = 0, .external_lex_state = 5},
  [360] = {.lex_state = 3, .external_lex_state = 6},
  [361] = {.lex_state = 3, .external_lex_state = 6},
  [362] = {.lex_state = 3, .external_lex_state = 6},
  [363] = {.lex_state = 3, .external_lex_state = 6},
  [364] = {.lex_state = 14, .external_lex_state = 5},
  [365] = {.lex_state = 3, .external_lex_state = 6},
  [366] = {.lex_state = 0, .external_lex_state = 5},
  [367] = {.lex_state = 3, .external_lex_state = 6},
  [368] = {.lex_state = 3, .external_lex_state = 6},
  [369] = {.lex_state = 3, .external_lex_state = 6},
  [370] = {.lex_state = 15, .external_lex_state = 2},
  [371] = {.lex_state = 15, .external_lex_state = 2},
  [372] = {.lex_state = 0, .external_lex_state = 5},
  [373] = {.lex_state = 15, .external_lex_state = 2},
  [374] = {.lex_state = 0, .external_lex_state = 5},
  [375] = {.lex_state = 0, .external_lex_state = 5},
  [376] = {.lex_state = 14, .external_lex_state = 5},
  [377] = {.lex_state = 3, .external_lex_state = 6},
  [378] = {.lex_state = 15, .external_lex_state = 2},
  [379] = {.lex_state = 14, .external_lex_state = 5},
  [380] = {.lex_state = 3, .external_lex_state = 6},
  [381] = {.lex_state = 3, .external_lex_state = 6},
  [382] = {.lex_state = 14, .external_lex_state = 5},
  [383] = {.lex_state = 3, .external_lex_state = 6},
  [384] = {.lex_state = 3, .external_lex_state = 6},
  [385] = {.lex_state = 3, .external_lex_state = 6},
  [386] = {.lex_state = 14, .external_lex_state = 5},
  [387] = {.lex_state = 0, .external_lex_state = 5},
  [388] = {.lex_state = 14, .external_lex_state = 5},
  [389] = {.lex_state = 3, .external_lex_state = 6},
  [390] = {.lex_state = 0, .external_lex_state = 5},
  [391] = {.lex_state = 0, .external_lex_state = 5},
  [392] = {.lex_state = 14, .external_lex_state = 5},
  [393] = {.lex_state = 0, .external_lex_state = 5},
  [394] = {.lex_state = 14, .external_lex_state = 5},
  [395] = {.lex_state = 14, .external_lex_state = 5},
  [396] = {.lex_state = 14, .external_lex_state = 5},
  [397] = {.lex_state = 14, .external_lex_state = 5},
  [398] = {.lex_state = 0, .external_lex_state = 5},
  [399] = {.lex_state = 14, .external_lex_state = 5},
  [400] = {.lex_state = 14, .external_lex_state = 5},
  [401] = {.lex_state = 14, .external_lex_state = 5},
  [402] = {.lex_state = 14, .external_lex_state = 5},
  [403] = {.lex_state = 0, .external_lex_state = 5},
  [404] = {.lex_state = 0, .external_lex_state = 5},
  [405] = {.lex_state = 0, .external_lex_state = 5},
  [406] = {.lex_state = 14, .external_lex_state = 5},
  [407] = {.lex_state = 0, .external_lex_state = 5},
  [408] = {.lex_state = 14, .external_lex_state = 5},
  [409] = {.lex_state = 14, .external_lex_state = 5},
  [410] = {.lex_state = 0, .external_lex_state = 5},
  [411] = {.lex_state = 14, .external_lex_state = 5},
  [412] = {.lex_state = 14, .external_lex_state = 5},
  [413] = {.lex_state = 14, .external_lex_state = 5},
  [414] = {.lex_state = 0, .external_lex_state = 5},
  [415] = {.lex_state = 14, .external_lex_state = 5},
  [416] = {.lex_state = 14, .external_lex_state = 5},
  [417] = {.lex_state = 14, .external_lex_state = 5},
  [418] = {.lex_state = 3, .external_lex_state = 6},
  [419] = {.lex_state = 14, .external_lex_state = 5},
  [420] = {.lex_state = 14, .external_lex_state = 5},
  [421] = {.lex_state = 14, .external_lex_state = 5},
  [422] = {.lex_state = 14, .external_lex_state = 5},
  [423] = {.lex_state = 14, .external_lex_state = 5},
  [424] = {.lex_state = 14, .external_lex_state = 5},
  [425] = {.lex_state = 14, .external_lex_state = 5},
  [426] = {.lex_state = 14, .external_lex_state = 5},
  [427] = {.lex_state = 14, .external_lex_state = 5},
  [428] = {.lex_state = 14, .external_lex_state = 5},
  [429] = {.lex_state = 14, .external_lex_state = 5},
  [430] = {.lex_state = 14, .external_lex_state = 5},
  [431] = {.lex_state = 14, .external_lex_state = 5},
  [432] = {.lex_state = 0, .external_lex_state = 5},
  [433] = {.lex_state = 0, .external_lex_state = 5},
  [434] = {.lex_state = 14, .external_lex_state = 5},
  [435] = {.lex_state = 0, .external_lex_state = 5},
  [436] = {.lex_state = 14, .external_lex_state = 5},
  [437] = {.lex_state = 14, .external_lex_state = 5},
  [438] = {.lex_state = 0, .external_lex_state = 5},
  [439] = {.lex_state = 0, .external_lex_state = 5},
  [440] = {.lex_state = 14, .external_lex_state = 5},
  [441] = {.lex_state = 14, .external_lex_state = 5},
  [442] = {.lex_state = 14, .external_lex_state = 5},
  [443] = {.lex_state = 14, .external_lex_state = 5},
  [444] = {.lex_state = 0, .external_lex_state = 5},
  [445] = {.lex_state = 14, .external_lex_state = 5},
  [446] = {.lex_state = 0, .external_lex_state = 5},
  [447] = {.lex_state = 14, .external_lex_state = 5},
  [448] = {.lex_state = 0, .external_lex_state = 5},
  [449] = {.lex_state = 0, .external_lex_state = 5},
  [450] = {.lex_state = 3, .external_lex_state = 6},
  [451] = {.lex_state = 3, .external_lex_state = 6},
  [452] = {.lex_state = 3, .external_lex_state = 6},
  [453] = {.lex_state = 3, .external_lex_state = 6},
  [454] = {.lex_state = 3, .external_lex_state = 6},
  [455] = {.lex_state = 3, .external_lex_state = 6},
  [456] = {.lex_state = 0, .external_lex_state = 5},
  [457] = {.lex_state = 3, .external_lex_state = 6},
  [458] = {.lex_state = 3, .external_lex_state = 6},
  [459] = {.lex_state = 3, .external_lex_state = 6},
  [460] = {.lex_state = 0, .external_lex_state = 5},
  [461] = {.lex_state = 3, .external_lex_state = 6},
  [462] = {.lex_state = 0, .external_lex_state = 5},
  [463] = {.lex_state = 0, .external_lex_state = 5},
  [464] = {.lex_state = 3, .external_lex_state = 6},
  [465] = {.lex_state = 3, .external_lex_state = 6},
  [466] = {.lex_state = 3, .external_lex_state = 6},
  [467] = {.lex_state = 3, .external_lex_state = 6},
  [468] = {.lex_state = 3, .external_lex_state = 6},
  [469] = {.lex_state = 0, .external_lex_state = 5},
  [470] = {.lex_state = 3, .external_lex_state = 6},
  [471] = {.lex_state = 3, .external_lex_state = 6},
  [472] = {.lex_state = 3, .external_lex_state = 6},
  [473] = {.lex_state = 3, .external_lex_state = 6},
  [474] = {.lex_state = 3, .external_lex_state = 6},
  [475] = {.lex_state = 14, .external_lex_state = 5},
  [476] = {.lex_state = 0, .external_lex_state = 5},
  [477] = {.lex_state = 0, .external_lex_state = 5},
  [478] = {.lex_state = 3, .external_lex_state = 6},
  [479] = {.lex_state = 3, .external_lex_state = 6},
  [480] = {.lex_state = 3, .external_lex_state = 6},
  [481] = {.lex_state = 3, .external_lex_state = 6},
  [482] = {.lex_state = 3, .external_lex_state = 6},
  [483] = {.lex_state = 3, .external_lex_state = 6},
  [484] = {.lex_state = 3, .external_lex_state = 6},
  [485] = {.lex_state = 3, .external_lex_state = 6},
  [486] = {.lex_state = 3, .external_lex_state = 6},
  [487] = {.lex_state = 3, .external_lex_state = 6},
  [488] = {.lex_state = 3, .external_lex_state = 6},
  [489] = {.lex_state = 3, .external_lex_state = 6},
  [490] = {.lex_state = 3, .external_lex_state = 6},
  [491] = {.lex_state = 0, .external_lex_state = 5},
  [492] = {.lex_state = 3, .external_lex_state = 6},
  [493] = {.lex_state = 14, .external_lex_state = 5},
  [494] = {.lex_state = 3, .external_lex_state = 6},
  [495] = {.lex_state = 3, .external_lex_state = 6},
  [496] = {.lex_state = 3, .external_lex_state = 6},
  [497] = {.lex_state = 3, .external_lex_state = 6},
  [498] = {.lex_state = 3, .external_lex_state = 6},
  [499] = {.lex_state = 3, .external_lex_state = 6},
  [500] = {.lex_state = 3, .external_lex_state = 6},
  [501] = {.lex_state = 3, .external_lex_state = 6},
  [502] = {.lex_state = 3, .external_lex_state = 6},
  [503] = {.lex_state = 3, .external_lex_state = 6},
  [504] = {.lex_state = 3, .external_lex_state = 6},
  [505] = {.lex_state = 14, .external_lex_state = 5},
  [506] = {.lex_state = 14, .external_lex_state = 5},
  [507] = {.lex_state = 14, .external_lex_state = 5},
  [508] = {.lex_state = 0, .external_lex_state = 5},
  [509] = {.lex_state = 14, .external_lex_state = 5},
  [510] = {.lex_state = 0, .external_lex_state = 5},
  [511] = {.lex_state = 0, .external_lex_state = 5},
  [512] = {.lex_state = 0, .external_lex_state = 5},
  [513] = {.lex_state = 0, .external_lex_state = 5},
  [514] = {.lex_state = 0, .external_lex_state = 5},
  [515] = {.lex_state = 0, .external_lex_state = 5},
  [516] = {.lex_state = 0, .external_lex_state = 5},
  [517] = {.lex_state = 0, .external_lex_state = 5},
  [518] = {.lex_state = 0, .external_lex_state = 5},
  [519] = {.lex_state = 0, .external_lex_state = 5},
  [520] = {.lex_state = 0, .external_lex_state = 5},
  [521] = {.lex_state = 0, .external_lex_state = 5},
  [522] = {.lex_state = 0, .external_lex_state = 5},
  [523] = {.lex_state = 0, .external_lex_state = 5},
  [524] = {.lex_state = 0, .external_lex_state = 5},
  [525] = {.lex_state = 0, .external_lex_state = 5},
  [526] = {.lex_state = 0, .external_lex_state = 5},
  [527] = {.lex_state = 0, .external_lex_state = 5},
  [528] = {.lex_state = 0, .external_lex_state = 5},
  [529] = {.lex_state = 0, .external_lex_state = 5},
  [530] = {.lex_state = 0, .external_lex_state = 5},
  [531] = {.lex_state = 0, .external_lex_state = 5},
  [532] = {.lex_state = 0, .external_lex_state = 5},
  [533] = {.lex_state = 0, .external_lex_state = 5},
  [534] = {.lex_state = 0, .external_lex_state = 5},
  [535] = {.lex_state = 0, .external_lex_state = 5},
  [536] = {.lex_state = 3, .external_lex_state = 6},
  [537] = {.lex_state = 0, .external_lex_state = 5},
  [538] = {.lex_state = 0, .external_lex_state = 5},
  [539] = {.lex_state = 0, .external_lex_state = 5},
  [540] = {.lex_state = 0, .external_lex_state = 5},
  [541] = {.lex_state = 0, .external_lex_state = 5},
  [542] = {.lex_state = 0, .external_lex_state = 5},
  [543] = {.lex_state = 0, .external_lex_state = 5},
  [544] = {.lex_state = 0, .external_lex_state = 5},
  [545] = {.lex_state = 0, .external_lex_state = 5},
  [546] = {.lex_state = 0, .external_lex_state = 5},
  [547] = {.lex_state = 0, .external_lex_state = 5},
  [548] = {.lex_state = 0, .external_lex_state = 5},
  [549] = {.lex_state = 0, .external_lex_state = 5},
  [550] = {.lex_state = 0, .external_lex_state = 5},
  [551] = {.lex_state = 0, .external_lex_state = 5},
  [552] = {.lex_state = 0, .external_lex_state = 5},
  [553] = {.lex_state = 0, .external_lex_state = 5},
  [554] = {.lex_state = 0, .external_lex_state = 5},
  [555] = {.lex_state = 0, .external_lex_state = 5},
  [556] = {.lex_state = 3, .external_lex_state = 6},
  [557] = {.lex_state = 3, .external_lex_state = 6},
  [558] = {.lex_state = 0, .external_lex_state = 5},
  [559] = {.lex_state = 3, .external_lex_state = 6},
  [560] = {.lex_state = 0, .external_lex_state = 5},
  [561] = {.lex_state = 3, .external_lex_state = 6},
  [562] = {.lex_state = 0, .external_lex_state = 5},
  [563] = {.lex_state = 0, .external_lex_state = 5},
  [564] = {.lex_state = 0, .external_lex_state = 5},
  [565] = {.lex_state = 0, .external_lex_state = 5},
  [566] = {.lex_state = 0, .external_lex_state = 5},
  [567] = {.lex_state = 0, .external_lex_state = 5},
  [568] = {.lex_state = 0, .external_lex_state = 5},
  [569] = {.lex_state = 0, .external_lex_state = 5},
  [570] = {.lex_state = 0, .external_lex_state = 5},
  [571] = {.lex_state = 0, .external_lex_state = 5},
  [572] = {.lex_state = 0, .external_lex_state = 5},
  [573] = {.lex_state = 0, .external_lex_state = 5},
  [574] = {.lex_state = 0, .external_lex_state = 5},
  [575] = {.lex_state = 0, .external_lex_state = 5},
  [576] = {.lex_state = 0, .external_lex_state = 5},
  [577] = {.lex_state = 0, .external_lex_state = 5},
  [578] = {.lex_state = 0, .external_lex_state = 5},
  [579] = {.lex_state = 0, .external_lex_state = 5},
  [580] = {.lex_state = 0, .external_lex_state = 5},
  [581] = {.lex_state = 0, .external_lex_state = 5},
  [582] = {.lex_state = 0, .external_lex_state = 5},
  [583] = {.lex_state = 0, .external_lex_state = 5},
  [584] = {.lex_state = 0, .external_lex_state = 5},
  [585] = {.lex_state = 0, .external_lex_state = 5},
  [586] = {.lex_state = 0, .external_lex_state = 5},
  [587] = {.lex_state = 0, .external_lex_state = 5},
  [588] = {.lex_state = 0, .external_lex_state = 5},
  [589] = {.lex_state = 0, .external_lex_state = 5},
  [590] = {.lex_state = 0, .external_lex_state = 5},
  [591] = {.lex_state = 0, .external_lex_state = 5},
  [592] = {.lex_state = 1, .external_lex_state = 5},
  [593] = {.lex_state = 1, .external_lex_state = 5},
  [594] = {.lex_state = 14, .external_lex_state = 5},
  [595] = {.lex_state = 15, .external_lex_state = 5},
  [596] = {.lex_state = 1, .external_lex_state = 5},
  [597] = {.lex_state = 1, .external_lex_state = 5},
  [598] = {.lex_state = 1, .external_lex_state = 5},
  [599] = {.lex_state = 1, .external_lex_state = 5},
  [600] = {.lex_state = 2, .external_lex_state = 5},
  [601] = {.lex_state = 6, .external_lex_state = 6},
  [602] = {.lex_state = 6, .external_lex_state = 6},
  [603] = {.lex_state = 5, .external_lex_state = 5},
  [604] = {.lex_state = 6, .external_lex_state = 6},
  [605] = {.lex_state = 6, .external_lex_state = 6},
  [606] = {.lex_state = 6, .external_lex_state = 6},
  [607] = {.lex_state = 0, .external_lex_state = 5},
  [608] = {.lex_state = 6, .external_lex_state = 6},
  [609] = {.lex_state = 5, .external_lex_state = 5},
  [610] = {.lex_state = 3, .external_lex_state = 6},
  [611] = {.lex_state = 0, .external_lex_state = 5},
  [612] = {.lex_state = 14, .external_lex_state = 5},
  [613] = {.lex_state = 14, .external_lex_state = 5},
  [614] = {.lex_state = 0, .external_lex_state = 5},
  [615] = {.lex_state = 3, .external_lex_state = 6},
  [616] = {.lex_state = 0, .external_lex_state = 5},
  [617] = {.lex_state = 5, .external_lex_state = 5},
  [618] = {.lex_state = 15, .external_lex_state = 5},
  [619] = {.lex_state = 15, .external_lex_state = 5},
  [620] = {.lex_state = 14, .external_lex_state = 5},
  [621] = {.lex_state = 14, .external_lex_state = 5},
  [622] = {.lex_state = 5, .external_lex_state = 5},
  [623] = {.lex_state = 5, .external_lex_state = 5},
  [624] = {.lex_state = 15, .external_lex_state = 5},
  [625] = {.lex_state = 14, .external_lex_state = 5},
  [626] = {.lex_state = 5, .external_lex_state = 5},
  [627] = {.lex_state = 3, .external_lex_state = 6},
  [628] = {.lex_state = 14, .external_lex_state = 5},
  [629] = {.lex_state = 0, .external_lex_state = 5},
  [630] = {.lex_state = 14, .external_lex_state = 5},
  [631] = {.lex_state = 15, .external_lex_state = 5},
  [632] = {.lex_state = 15, .external_lex_state = 5},
  [633] = {.lex_state = 0, .external_lex_state = 5},
  [634] = {.lex_state = 0, .external_lex_state = 5},
  [635] = {.lex_state = 14, .external_lex_state = 5},
  [636] = {.lex_state = 0, .external_lex_state = 5},
  [637] = {.lex_state = 0, .external_lex_state = 5},
  [638] = {.lex_state = 15, .external_lex_state = 5},
  [639] = {.lex_state = 15, .external_lex_state = 5},
  [640] = {.lex_state = 15, .external_lex_state = 5},
  [641] = {.lex_state = 2, .external_lex_state = 5},
  [642] = {.lex_state = 15, .external_lex_state = 5},
  [643] = {.lex_state = 15, .external_lex_state = 5},
  [644] = {.lex_state = 15, .external_lex_state = 5},
  [645] = {.lex_state = 15, .external_lex_state = 3},
  [646] = {.lex_state = 0, .external_lex_state = 7},
  [647] = {.lex_state = 15, .external_lex_state = 5},
  [648] = {.lex_state = 0, .external_lex_state = 5},
  [649] = {.lex_state = 15, .external_lex_state = 5},
  [650] = {.lex_state = 0, .external_lex_state = 7},
  [651] = {.lex_state = 0, .external_lex_state = 7},
  [652] = {.lex_state = 2, .external_lex_state = 5},
  [653] = {.lex_state = 15, .external_lex_state = 5},
  [654] = {.lex_state = 0, .external_lex_state = 5},
  [655] = {.lex_state = 15, .external_lex_state = 5},
  [656] = {.lex_state = 15, .external_lex_state = 5},
  [657] = {.lex_state = 15, .external_lex_state = 5},
  [658] = {.lex_state = 15, .external_lex_state = 5},
  [659] = {.lex_state = 15, .external_lex_state = 5},
  [660] = {.lex_state = 15, .external_lex_state = 5},
  [661] = {.lex_state = 2, .external_lex_state = 5},
  [662] = {.lex_state = 14, .external_lex_state = 5},
  [663] = {.lex_state = 15, .external_lex_state = 5},
  [664] = {.lex_state = 15, .external_lex_state = 5},
  [665] = {.lex_state = 15, .external_lex_state = 5},
  [666] = {.lex_state = 15, .external_lex_state = 5},
  [667] = {.lex_state = 0, .external_lex_state = 7},
  [668] = {.lex_state = 0, .external_lex_state = 7},
  [669] = {.lex_state = 14, .external_lex_state = 5},
  [670] = {.lex_state = 14, .external_lex_state = 5},
  [671] = {.lex_state = 15, .external_lex_state = 5},
  [672] = {.lex_state = 15, .external_lex_state = 5},
  [673] = {.lex_state = 14, .external_lex_state = 5},
  [674] = {.lex_state = 0, .external_lex_state = 5},
  [675] = {.lex_state = 15, .external_lex_state = 5},
  [676] = {.lex_state = 0, .external_lex_state = 5},
  [677] = {.lex_state = 14, .external_lex_state = 5},
  [678] = {.lex_state = 14, .external_lex_state = 5},
  [679] = {.lex_state = 14, .external_lex_state = 5},
  [680] = {.lex_state = 0, .external_lex_state = 5},
  [681] = {.lex_state = 15, .external_lex_state = 5},
  [682] = {.lex_state = 0, .external_lex_state = 5},
  [683] = {.lex_state = 14, .external_lex_state = 5},
  [684] = {.lex_state = 0, .external_lex_state = 5},
  [685] = {.lex_state = 0, .external_lex_state = 5},
  [686] = {.lex_state = 14, .external_lex_state = 5},
  [687] = {.lex_state = 15, .external_lex_state = 5},
  [688] = {.lex_state = 0, .external_lex_state = 5},
  [689] = {.lex_state = 0, .external_lex_state = 5},
  [690] = {.lex_state = 14, .external_lex_state = 5},
  [691] = {.lex_state = 0, .external_lex_state = 5},
  [692] = {.lex_state = 14, .external_lex_state = 5},
  [693] = {.lex_state = 0, .external_lex_state = 5},
  [694] = {.lex_state = 14, .external_lex_state = 5},
  [695] = {.lex_state = 0, .external_lex_state = 5},
  [696] = {.lex_state = 14, .external_lex_state = 5},
  [697] = {.lex_state = 15, .external_lex_state = 5},
  [698] = {.lex_state = 14, .external_lex_state = 5},
  [699] = {.lex_state = 14, .external_lex_state = 5},
  [700] = {.lex_state = 14, .external_lex_state = 5},
  [701] = {.lex_state = 14, .external_lex_state = 5},
  [702] = {.lex_state = 14, .external_lex_state = 5},
  [703] = {.lex_state = 0, .external_lex_state = 5},
  [704] = {.lex_state = 14, .external_lex_state = 5},
  [705] = {.lex_state = 14, .external_lex_state = 5},
  [706] = {.lex_state = 14, .external_lex_state = 5},
  [707] = {.lex_state = 0, .external_lex_state = 7},
  [708] = {.lex_state = 0, .external_lex_state = 7},
  [709] = {.lex_state = 0, .external_lex_state = 7},
  [710] = {.lex_state = 15, .external_lex_state = 5},
  [711] = {.lex_state = 15, .external_lex_state = 5},
  [712] = {.lex_state = 0, .external_lex_state = 7},
  [713] = {.lex_state = 0, .external_lex_state = 7},
  [714] = {.lex_state = 0, .external_lex_state = 7},
  [715] = {.lex_state = 0, .external_lex_state = 7},
  [716] = {.lex_state = 0, .external_lex_state = 7},
  [717] = {.lex_state = 0, .external_lex_state = 7},
  [718] = {.lex_state = 14, .external_lex_state = 5},
  [719] = {.lex_state = 0, .external_lex_state = 7},
  [720] = {.lex_state = 0, .external_lex_state = 7},
  [721] = {.lex_state = 14, .external_lex_state = 5},
  [722] = {.lex_state = 14, .external_lex_state = 5},
  [723] = {.lex_state = 14, .external_lex_state = 5},
  [724] = {.lex_state = 15, .external_lex_state = 5},
  [725] = {.lex_state = 15, .external_lex_state = 5},
  [726] = {.lex_state = 15, .external_lex_state = 5},
  [727] = {.lex_state = 15, .external_lex_state = 5},
  [728] = {.lex_state = 15, .external_lex_state = 5},
  [729] = {.lex_state = 14, .external_lex_state = 5},
  [730] = {.lex_state = 14, .external_lex_state = 5},
  [731] = {.lex_state = 15, .external_lex_state = 5},
  [732] = {.lex_state = 15, .external_lex_state = 5},
  [733] = {.lex_state = 15, .external_lex_state = 5},
  [734] = {.lex_state = 15, .external_lex_state = 5},
  [735] = {.lex_state = 14, .external_lex_state = 5},
  [736] = {.lex_state = 14, .external_lex_state = 5},
  [737] = {.lex_state = 15, .external_lex_state = 5},
  [738] = {.lex_state = 14, .external_lex_state = 5},
  [739] = {.lex_state = 2, .external_lex_state = 5},
  [740] = {.lex_state = 15, .external_lex_state = 5},
  [741] = {.lex_state = 14, .external_lex_state = 5},
  [742] = {.lex_state = 15, .external_lex_state = 5},
  [743] = {.lex_state = 14, .external_lex_state = 5},
  [744] = {.lex_state = 14, .external_lex_state = 5},
  [745] = {.lex_state = 14, .external_lex_state = 5},
  [746] = {.lex_state = 14, .external_lex_state = 5},
  [747] = {.lex_state = 15, .external_lex_state = 5},
  [748] = {.lex_state = 15, .external_lex_state = 5},
  [749] = {.lex_state = 14, .external_lex_state = 5},
  [750] = {.lex_state = 0, .external_lex_state = 7},
  [751] = {.lex_state = 7, .external_lex_state = 6},
  [752] = {.lex_state = 0, .external_lex_state = 7},
  [753] = {.lex_state = 14, .external_lex_state = 8},
  [754] = {.lex_state = 0, .external_lex_state = 7},
  [755] = {.lex_state = 14, .external_lex_state = 5},
  [756] = {.lex_state = 14, .external_lex_state = 5},
  [757] = {.lex_state = 0, .external_lex_state = 7},
  [758] = {.lex_state = 14, .external_lex_state = 5},
  [759] = {.lex_state = 7, .external_lex_state = 6},
  [760] = {.lex_state = 7, .external_lex_state = 6},
  [761] = {.lex_state = 0, .external_lex_state = 7},
  [762] = {.lex_state = 14, .external_lex_state = 5},
  [763] = {.lex_state = 14, .external_lex_state = 5},
  [764] = {.lex_state = 0, .external_lex_state = 7},
  [765] = {.lex_state = 14, .external_lex_state = 5},
  [766] = {.lex_state = 14, .external_lex_state = 5},
  [767] = {.lex_state = 15, .external_lex_state = 5},
  [768] = {.lex_state = 0, .external_lex_state = 7},
  [769] = {.lex_state = 0, .external_lex_state = 7},
  [770] = {.lex_state = 15, .external_lex_state = 5},
  [771] = {.lex_state = 0, .external_lex_state = 7},
  [772] = {.lex_state = 0, .external_lex_state = 7},
  [773] = {.lex_state = 15, .external_lex_state = 5},
  [774] = {.lex_state = 0, .external_lex_state = 7},
  [775] = {.lex_state = 15, .external_lex_state = 5},
  [776] = {.lex_state = 15, .external_lex_state = 5},
  [777] = {.lex_state = 7, .external_lex_state = 6},
  [778] = {.lex_state = 0, .external_lex_state = 5},
  [779] = {.lex_state = 7, .external_lex_state = 6},
  [780] = {.lex_state = 14, .external_lex_state = 8},
  [781] = {.lex_state = 0, .external_lex_state = 7},
  [782] = {.lex_state = 15, .external_lex_state = 5},
  [783] = {.lex_state = 15, .external_lex_state = 5},
  [784] = {.lex_state = 15, .external_lex_state = 5},
  [785] = {.lex_state = 15, .external_lex_state = 5},
  [786] = {.lex_state = 0, .external_lex_state = 7},
  [787] = {.lex_state = 0, .external_lex_state = 7},
  [788] = {.lex_state = 14, .external_lex_state = 5},
  [789] = {.lex_state = 14, .external_lex_state = 5},
  [790] = {.lex_state = 14, .external_lex_state = 5},
  [791] = {.lex_state = 14, .external_lex_state = 5},
  [792] = {.lex_state = 0, .external_lex_state = 7},
  [793] = {.lex_state = 15, .external_lex_state = 5},
  [794] = {.lex_state = 15, .external_lex_state = 5},
  [795] = {.lex_state = 14, .external_lex_state = 5},
  [796] = {.lex_state = 0, .external_lex_state = 7},
  [797] = {.lex_state = 14, .external_lex_state = 5},
  [798] = {.lex_state = 14, .external_lex_state = 5},
  [799] = {.lex_state = 14, .external_lex_state = 8},
  [800] = {.lex_state = 0, .external_lex_state = 7},
  [801] = {.lex_state = 14, .external_lex_state = 5},
  [802] = {.lex_state = 14, .external_lex_state = 5},
  [803] = {.lex_state = 14, .external_lex_state = 5},
  [804] = {.lex_state = 14, .external_lex_state = 5},
  [805] = {.lex_state = 15, .external_lex_state = 5},
  [806] = {.lex_state = 0, .external_lex_state = 7},
  [807] = {.lex_state = 15, .external_lex_state = 5},
  [808] = {.lex_state = 15, .external_lex_state = 5},
  [809] = {.lex_state = 15, .external_lex_state = 5},
  [810] = {.lex_state = 0, .external_lex_state = 7},
  [811] = {.lex_state = 0, .external_lex_state = 7},
  [812] = {.lex_state = 14, .external_lex_state = 5},
  [813] = {.lex_state = 0, .external_lex_state = 7},
  [814] = {.lex_state = 0, .external_lex_state = 7},
  [815] = {.lex_state = 0, .external_lex_state = 7},
  [816] = {.lex_state = 15, .external_lex_state = 5},
  [817] = {.lex_state = 14, .external_lex_state = 5},
  [818] = {.lex_state = 15, .external_lex_state = 5},
  [819] = {.lex_state = 0, .external_lex_state = 7},
  [820] = {.lex_state = 14, .external_lex_state = 5},
  [821] = {.lex_state = 15, .external_lex_state = 5},
  [822] = {.lex_state = 15, .external_lex_state = 5},
  [823] = {.lex_state = 15, .external_lex_state = 5},
  [824] = {.lex_state = 0, .external_lex_state = 9},
  [825] = {.lex_state = 14, .external_lex_state = 5},
  [826] = {.lex_state = 14, .external_lex_state = 5},
  [827] = {.lex_state = 14, .external_lex_state = 5},
  [828] = {.lex_state = 14, .external_lex_state = 5},
  [829] = {.lex_state = 15, .external_lex_state = 5},
  [830] = {.lex_state = 14, .external_lex_state = 5},
  [831] = {.lex_state = 0, .external_lex_state = 10},
  [832] = {.lex_state = 14, .external_lex_state = 5},
  [833] = {.lex_state = 14, .external_lex_state = 5},
  [834] = {.lex_state = 0, .external_lex_state = 10},
  [835] = {.lex_state = 14, .external_lex_state = 5},
  [836] = {.lex_state = 14, .external_lex_state = 5},
  [837] = {.lex_state = 15, .external_lex_state = 5},
  [838] = {.lex_state = 14, .external_lex_state = 5},
  [839] = {.lex_state = 14, .external_lex_state = 5},
  [840] = {.lex_state = 14, .external_lex_state = 5},
  [841] = {.lex_state = 0, .external_lex_state = 10},
  [842] = {.lex_state = 0, .external_lex_state = 9},
  [843] = {.lex_state = 14, .external_lex_state = 5},
  [844] = {.lex_state = 14, .external_lex_state = 5},
  [845] = {.lex_state = 0, .external_lex_state = 10},
  [846] = {.lex_state = 0, .external_lex_state = 9},
  [847] = {.lex_state = 14, .external_lex_state = 5},
  [848] = {.lex_state = 14, .external_lex_state = 5},
  [849] = {.lex_state = 14, .external_lex_state = 5},
  [850] = {.lex_state = 14, .external_lex_state = 5},
  [851] = {.lex_state = 14, .external_lex_state = 5},
  [852] = {.lex_state = 14, .external_lex_state = 5},
  [853] = {.lex_state = 0, .external_lex_state = 10},
  [854] = {.lex_state = 0, .external_lex_state = 9},
  [855] = {.lex_state = 15, .external_lex_state = 5},
  [856] = {.lex_state = 14, .external_lex_state = 5},
  [857] = {.lex_state = 14, .external_lex_state = 5},
  [858] = {.lex_state = 15, .external_lex_state = 5},
  [859] = {.lex_state = 14, .external_lex_state = 5},
  [860] = {.lex_state = 7, .external_lex_state = 6},
  [861] = {.lex_state = 14, .external_lex_state = 5},
  [862] = {.lex_state = 0, .external_lex_state = 10},
  [863] = {.lex_state = 0, .external_lex_state = 10},
  [864] = {.lex_state = 14, .external_lex_state = 5},
  [865] = {.lex_state = 0, .external_lex_state = 9},
  [866] = {.lex_state = 7, .external_lex_state = 5},
  [867] = {.lex_state = 14, .external_lex_state = 5},
  [868] = {.lex_state = 0, .external_lex_state = 10},
  [869] = {.lex_state = 0, .external_lex_state = 9},
  [870] = {.lex_state = 14, .external_lex_state = 5},
  [871] = {.lex_state = 0, .external_lex_state = 9},
  [872] = {.lex_state = 15, .external_lex_state = 5},
  [873] = {.lex_state = 15, .external_lex_state = 5},
  [874] = {.lex_state = 14, .external_lex_state = 5},
  [875] = {.lex_state = 14, .external_lex_state = 5},
  [876] = {.lex_state = 0, .external_lex_state = 5},
  [877] = {.lex_state = 0, .external_lex_state = 10},
  [878] = {.lex_state = 15, .external_lex_state = 5},
  [879] = {.lex_state = 14, .external_lex_state = 5},
  [880] = {.lex_state = 0, .external_lex_state = 9},
  [881] = {.lex_state = 14, .external_lex_state = 5},
  [882] = {.lex_state = 15, .external_lex_state = 5},
  [883] = {.lex_state = 15, .external_lex_state = 5},
  [884] = {.lex_state = 15, .external_lex_state = 5},
  [885] = {.lex_state = 15, .external_lex_state = 5},
  [886] = {.lex_state = 14, .external_lex_state = 5},
  [887] = {.lex_state = 14, .external_lex_state = 5},
  [888] = {.lex_state = 14, .external_lex_state = 5},
  [889] = {.lex_state = 14, .external_lex_state = 5},
  [890] = {.lex_state = 15, .external_lex_state = 5},
  [891] = {.lex_state = 14, .external_lex_state = 5},
  [892] = {.lex_state = 14, .external_lex_state = 5},
  [893] = {.lex_state = 14, .external_lex_state = 5},
  [894] = {.lex_state = 15, .external_lex_state = 5},
  [895] = {.lex_state = 15, .external_lex_state = 5},
  [896] = {.lex_state = 15, .external_lex_state = 5},
  [897] = {.lex_state = 0, .external_lex_state = 9},
  [898] = {.lex_state = 15, .external_lex_state = 5},
  [899] = {.lex_state = 0, .external_lex_state = 5},
  [900] = {.lex_state = 14, .external_lex_state = 5},
  [901] = {.lex_state = 14, .external_lex_state = 5},
  [902] = {.lex_state = 14, .external_lex_state = 5},
  [903] = {.lex_state = 14, .external_lex_state = 5},
  [904] = {.lex_state = 0, .external_lex_state = 5},
  [905] = {.lex_state = 7, .external_lex_state = 5},
  [906] = {.lex_state = 15, .external_lex_state = 5},
  [907] = {.lex_state = 14, .external_lex_state = 5},
  [908] = {.lex_state = 14, .external_lex_state = 5},
  [909] = {.lex_state = 14, .external_lex_state = 5},
  [910] = {.lex_state = 14, .external_lex_state = 5},
  [911] = {.lex_state = 15, .external_lex_state = 5},
  [912] = {.lex_state = 14, .external_lex_state = 5},
  [913] = {.lex_state = 15, .external_lex_state = 5},
  [914] = {.lex_state = 7, .external_lex_state = 5},
  [915] = {.lex_state = 14, .external_lex_state = 5},
  [916] = {.lex_state = 0, .external_lex_state = 5},
  [917] = {.lex_state = 14, .external_lex_state = 5},
  [918] = {.lex_state = 14, .external_lex_state = 5},
  [919] = {.lex_state = 14, .external_lex_state = 5},
  [920] = {.lex_state = 15, .external_lex_state = 5},
  [921] = {.lex_state = 7, .external_lex_state = 5},
  [922] = {.lex_state = 15, .external_lex_state = 5},
  [923] = {.lex_state = 15, .external_lex_state = 5},
  [924] = {.lex_state = 14, .external_lex_state = 5},
  [925] = {.lex_state = 15, .external_lex_state = 5},
  [926] = {.lex_state = 0, .external_lex_state = 5},
  [927] = {.lex_state = 14, .external_lex_state = 5},
  [928] = {.lex_state = 14, .external_lex_state = 5},
  [929] = {.lex_state = 14, .external_lex_state = 5},
  [930] = {.lex_state = 15, .external_lex_state = 5},
  [931] = {.lex_state = 14, .external_lex_state = 5},
  [932] = {.lex_state = 15, .external_lex_state = 5},
  [933] = {.lex_state = 15, .external_lex_state = 5},
  [934] = {.lex_state = 14, .external_lex_state = 5},
  [935] = {.lex_state = 15, .external_lex_state = 5},
  [936] = {.lex_state = 14, .external_lex_state = 5},
  [937] = {.lex_state = 14, .external_lex_state = 5},
  [938] = {.lex_state = 0, .external_lex_state = 5},
  [939] = {.lex_state = 15, .external_lex_state = 5},
  [940] = {.lex_state = 14, .external_lex_state = 5},
  [941] = {.lex_state = 7, .external_lex_state = 5},
  [942] = {.lex_state = 15, .external_lex_state = 5},
  [943] = {.lex_state = 0, .external_lex_state = 5},
  [944] = {.lex_state = 7, .external_lex_state = 5},
  [945] = {.lex_state = 14, .external_lex_state = 5},
  [946] = {.lex_state = 15, .external_lex_state = 5},
  [947] = {.lex_state = 15, .external_lex_state = 5},
  [948] = {.lex_state = 15, .external_lex_state = 5},
  [949] = {.lex_state = 14, .external_lex_state = 5},
  [950] = {.lex_state = 14, .external_lex_state = 5},
  [951] = {.lex_state = 0, .external_lex_state = 5},
  [952] = {.lex_state = 14, .external_lex_state = 5},
  [953] = {.lex_state = 14, .external_lex_state = 5},
  [954] = {.lex_state = 0, .external_lex_state = 5},
  [955] = {.lex_state = 14, .external_lex_state = 5},
  [956] = {.lex_state = 0, .external_lex_state = 5},
  [957] = {.lex_state = 0, .external_lex_state = 5},
  [958] = {.lex_state = 7, .external_lex_state = 5},
  [959] = {.lex_state = 7, .external_lex_state = 5},
  [960] = {.lex_state = 14, .external_lex_state = 5},
  [961] = {.lex_state = 7, .external_lex_state = 5},
  [962] = {.lex_state = 14, .external_lex_state = 5},
  [963] = {.lex_state = 15, .external_lex_state = 5},
  [964] = {.lex_state = 15, .external_lex_state = 5},
  [965] = {.lex_state = 14, .external_lex_state = 5},
  [966] = {.lex_state = 14, .external_lex_state = 5},
  [967] = {.lex_state = 14, .external_lex_state = 5},
  [968] = {.lex_state = 15, .external_lex_state = 5},
  [969] = {.lex_state = 0, .external_lex_state = 5},
  [970] = {.lex_state = 0, .external_lex_state = 5},
  [971] = {.lex_state = 0, .external_lex_state = 5},
  [972] = {.lex_state = 15, .external_lex_state = 5},
  [973] = {.lex_state = 15, .external_lex_state = 5},
  [974] = {.lex_state = 14, .external_lex_state = 5},
  [975] = {.lex_state = 0, .external_lex_state = 5},
  [976] = {.lex_state = 14, .external_lex_state = 5},
  [977] = {.lex_state = 14, .external_lex_state = 5},
  [978] = {.lex_state = 0, .external_lex_state = 5},
  [979] = {.lex_state = 15, .external_lex_state = 5},
  [980] = {.lex_state = 7, .external_lex_state = 5},
  [981] = {.lex_state = 7, .external_lex_state = 5},
  [982] = {.lex_state = 7, .external_lex_state = 5},
  [983] = {.lex_state = 7, .external_lex_state = 5},
  [984] = {.lex_state = 14, .external_lex_state = 5},
  [985] = {.lex_state = 0, .external_lex_state = 5},
  [986] = {.lex_state = 14, .external_lex_state = 5},
  [987] = {.lex_state = 0, .external_lex_state = 5},
  [988] = {.lex_state = 14, .external_lex_state = 5},
  [989] = {.lex_state = 7, .external_lex_state = 5},
  [990] = {.lex_state = 7, .external_lex_state = 5},
  [991] = {.lex_state = 14, .external_lex_state = 5},
  [992] = {.lex_state = 14, .external_lex_state = 5},
  [993] = {.lex_state = 7, .external_lex_state = 5},
  [994] = {.lex_state = 7, .external_lex_state = 5},
  [995] = {.lex_state = 0, .external_lex_state = 5},
  [996] = {.lex_state = 0, .external_lex_state = 5},
  [997] = {.lex_state = 14, .external_lex_state = 5},
  [998] = {.lex_state = 15, .external_lex_state = 5},
  [999] = {.lex_state = 14, .external_lex_state = 5},
  [1000] = {.lex_state = 15, .external_lex_state = 5},
  [1001] = {.lex_state = 14, .external_lex_state = 5},
  [1002] = {.lex_state = 15, .external_lex_state = 5},
  [1003] = {.lex_state = 14, .external_lex_state = 5},
  [1004] = {.lex_state = 14, .external_lex_state = 5},
  [1005] = {.lex_state = 15, .external_lex_state = 5},
  [1006] = {.lex_state = 14, .external_lex_state = 5},
  [1007] = {.lex_state = 14, .external_lex_state = 5},
  [1008] = {.lex_state = 15, .external_lex_state = 5},
  [1009] = {.lex_state = 7, .external_lex_state = 5},
  [1010] = {.lex_state = 0, .external_lex_state = 5},
  [1011] = {.lex_state = 0, .external_lex_state = 5},
  [1012] = {.lex_state = 0, .external_lex_state = 5},
  [1013] = {.lex_state = 15, .external_lex_state = 5},
  [1014] = {.lex_state = 15, .external_lex_state = 5},
  [1015] = {.lex_state = 15, .external_lex_state = 5},
  [1016] = {.lex_state = 0, .external_lex_state = 5},
  [1017] = {.lex_state = 0, .external_lex_state = 5},
  [1018] = {.lex_state = 15, .external_lex_state = 5},
  [1019] = {.lex_state = 0, .external_lex_state = 5},
  [1020] = {.lex_state = 15, .external_lex_state = 5},
  [1021] = {.lex_state = 0, .external_lex_state = 5},
  [1022] = {.lex_state = 0, .external_lex_state = 5},
  [1023] = {.lex_state = 0, .external_lex_state = 5},
  [1024] = {.lex_state = 15, .external_lex_state = 5},
  [1025] = {.lex_state = 0, .external_lex_state = 5},
  [1026] = {.lex_state = 15, .external_lex_state = 5},
  [1027] = {.lex_state = 0, .external_lex_state = 5},
  [1028] = {.lex_state = 15, .external_lex_state = 5},
  [1029] = {.lex_state = 15, .external_lex_state = 5},
  [1030] = {.lex_state = 15, .external_lex_state = 5},
  [1031] = {.lex_state = 0, .external_lex_state = 5},
  [1032] = {.lex_state = 0, .external_lex_state = 5},
  [1033] = {.lex_state = 0, .external_lex_state = 5},
  [1034] = {.lex_state = 0, .external_lex_state = 5},
  [1035] = {.lex_state = 0, .external_lex_state = 5},
  [1036] = {.lex_state = 15, .external_lex_state = 5},
  [1037] = {.lex_state = 0, .external_lex_state = 5},
  [1038] = {.lex_state = 15, .external_lex_state = 5},
  [1039] = {.lex_state = 15, .external_lex_state = 5},
  [1040] = {.lex_state = 15, .external_lex_state = 5},
  [1041] = {.lex_state = 15, .external_lex_state = 5},
  [1042] = {.lex_state = 0, .external_lex_state = 5},
  [1043] = {.lex_state = 0, .external_lex_state = 5},
  [1044] = {.lex_state = 15, .external_lex_state = 5},
  [1045] = {.lex_state = 0, .external_lex_state = 5},
  [1046] = {.lex_state = 0, .external_lex_state = 5},
  [1047] = {.lex_state = 15, .external_lex_state = 5},
  [1048] = {.lex_state = 0, .external_lex_state = 5},
  [1049] = {.lex_state = 0, .external_lex_state = 5},
  [1050] = {.lex_state = 0, .external_lex_state = 5},
  [1051] = {.lex_state = 15, .external_lex_state = 5},
  [1052] = {.lex_state = 15, .external_lex_state = 5},
  [1053] = {.lex_state = 0, .external_lex_state = 5},
  [1054] = {.lex_state = 0, .external_lex_state = 5},
  [1055] = {.lex_state = 0, .external_lex_state = 5},
  [1056] = {.lex_state = 15, .external_lex_state = 5},
  [1057] = {.lex_state = 0, .external_lex_state = 5},
  [1058] = {.lex_state = 0, .external_lex_state = 5},
  [1059] = {.lex_state = 0, .external_lex_state = 5},
  [1060] = {.lex_state = 0, .external_lex_state = 5},
  [1061] = {.lex_state = 0, .external_lex_state = 5},
  [1062] = {.lex_state = 0, .external_lex_state = 5},
  [1063] = {.lex_state = 0, .external_lex_state = 5},
  [1064] = {.lex_state = 15, .external_lex_state = 5},
  [1065] = {.lex_state = 0, .external_lex_state = 5},
  [1066] = {.lex_state = 0, .external_lex_state = 5},
  [1067] = {.lex_state = 0, .external_lex_state = 5},
  [1068] = {.lex_state = 15, .external_lex_state = 5},
  [1069] = {.lex_state = 15, .external_lex_state = 5},
  [1070] = {.lex_state = 15, .external_lex_state = 5},
  [1071] = {.lex_state = 0, .external_lex_state = 5},
  [1072] = {.lex_state = 0, .external_lex_state = 5},
  [1073] = {.lex_state = 15, .external_lex_state = 5},
  [1074] = {.lex_state = 15, .external_lex_state = 5},
  [1075] = {.lex_state = 15, .external_lex_state = 5},
  [1076] = {.lex_state = 15, .external_lex_state = 5},
  [1077] = {.lex_state = 15, .external_lex_state = 5},
  [1078] = {.lex_state = 0, .external_lex_state = 5},
  [1079] = {.lex_state = 15, .external_lex_state = 5},
  [1080] = {.lex_state = 15, .external_lex_state = 5},
  [1081] = {.lex_state = 15, .external_lex_state = 5},
  [1082] = {.lex_state = 15, .external_lex_state = 5},
  [1083] = {.lex_state = 15, .external_lex_state = 5},
  [1084] = {.lex_state = 15, .external_lex_state = 5},
  [1085] = {.lex_state = 15, .external_lex_state = 5},
  [1086] = {.lex_state = 15, .external_lex_state = 5},
  [1087] = {.lex_state = 15, .external_lex_state = 5},
  [1088] = {.lex_state = 15, .external_lex_state = 5},
  [1089] = {.lex_state = 15, .external_lex_state = 5},
  [1090] = {.lex_state = 15, .external_lex_state = 5},
  [1091] = {.lex_state = 15, .external_lex_state = 5},
  [1092] = {.lex_state = 15, .external_lex_state = 5},
  [1093] = {.lex_state = 0, .external_lex_state = 5},
  [1094] = {.lex_state = 15, .external_lex_state = 5},
  [1095] = {.lex_state = 15, .external_lex_state = 5},
  [1096] = {.lex_state = 15, .external_lex_state = 5},
  [1097] = {.lex_state = 15, .external_lex_state = 5},
  [1098] = {.lex_state = 15, .external_lex_state = 5},
  [1099] = {.lex_state = 15, .external_lex_state = 5},
  [1100] = {.lex_state = 15, .external_lex_state = 5},
  [1101] = {.lex_state = 15, .external_lex_state = 5},
  [1102] = {.lex_state = 15, .external_lex_state = 5},
  [1103] = {.lex_state = 0, .external_lex_state = 5},
  [1104] = {.lex_state = 0, .external_lex_state = 5},
  [1105] = {.lex_state = 15, .external_lex_state = 5},
  [1106] = {.lex_state = 15, .external_lex_state = 5},
  [1107] = {.lex_state = 15, .external_lex_state = 5},
  [1108] = {.lex_state = 0, .external_lex_state = 5},
  [1109] = {.lex_state = 15, .external_lex_state = 5},
  [1110] = {.lex_state = 0, .external_lex_state = 5},
  [1111] = {.lex_state = 15, .external_lex_state = 5},
  [1112] = {.lex_state = 15, .external_lex_state = 5},
  [1113] = {.lex_state = 15, .external_lex_state = 5},
  [1114] = {.lex_state = 15, .external_lex_state = 5},
  [1115] = {.lex_state = 15, .external_lex_state = 5},
  [1116] = {.lex_state = 15, .external_lex_state = 5},
  [1117] = {.lex_state = 15, .external_lex_state = 5},
  [1118] = {.lex_state = 15, .external_lex_state = 5},
  [1119] = {.lex_state = 15, .external_lex_state = 5},
  [1120] = {.lex_state = 15, .external_lex_state = 5},
  [1121] = {.lex_state = 15, .external_lex_state = 5},
  [1122] = {.lex_state = 15, .external_lex_state = 5},
  [1123] = {.lex_state = 15, .external_lex_state = 5},
  [1124] = {.lex_state = 15, .external_lex_state = 5},
  [1125] = {.lex_state = 15, .external_lex_state = 5},
  [1126] = {.lex_state = 15, .external_lex_state = 5},
  [1127] = {.lex_state = 15, .external_lex_state = 5},
  [1128] = {.lex_state = 15, .external_lex_state = 5},
  [1129] = {.lex_state = 15, .external_lex_state = 5},
  [1130] = {.lex_state = 15, .external_lex_state = 5},
  [1131] = {.lex_state = 15, .external_lex_state = 5},
  [1132] = {.lex_state = 15, .external_lex_state = 5},
  [1133] = {.lex_state = 15, .external_lex_state = 5},
  [1134] = {.lex_state = 15, .external_lex_state = 5},
  [1135] = {.lex_state = 15, .external_lex_state = 5},
  [1136] = {.lex_state = 15, .external_lex_state = 5},
  [1137] = {.lex_state = 0, .external_lex_state = 5},
  [1138] = {.lex_state = 15, .external_lex_state = 5},
  [1139] = {.lex_state = 15, .external_lex_state = 5},
  [1140] = {.lex_state = 15, .external_lex_state = 5},
  [1141] = {.lex_state = 0, .external_lex_state = 5},
  [1142] = {.lex_state = 15, .external_lex_state = 5},
  [1143] = {.lex_state = 15, .external_lex_state = 5},
  [1144] = {.lex_state = 15, .external_lex_state = 5},
  [1145] = {.lex_state = 15, .external_lex_state = 5},
  [1146] = {.lex_state = 15, .external_lex_state = 5},
  [1147] = {.lex_state = 15, .external_lex_state = 5},
  [1148] = {.lex_state = 15, .external_lex_state = 5},
  [1149] = {.lex_state = 15, .external_lex_state = 5},
  [1150] = {.lex_state = 15, .external_lex_state = 5},
  [1151] = {.lex_state = 15, .external_lex_state = 5},
  [1152] = {.lex_state = 15, .external_lex_state = 5},
  [1153] = {.lex_state = 15, .external_lex_state = 5},
  [1154] = {.lex_state = 0, .external_lex_state = 5},
  [1155] = {.lex_state = 0, .external_lex_state = 5},
  [1156] = {.lex_state = 15, .external_lex_state = 5},
  [1157] = {.lex_state = 15, .external_lex_state = 5},
  [1158] = {.lex_state = 15, .external_lex_state = 5},
  [1159] = {.lex_state = 15, .external_lex_state = 5},
  [1160] = {.lex_state = 15, .external_lex_state = 5},
  [1161] = {.lex_state = 15, .external_lex_state = 5},
  [1162] = {.lex_state = 0, .external_lex_state = 5},
  [1163] = {.lex_state = 15, .external_lex_state = 5},
  [1164] = {.lex_state = 0, .external_lex_state = 5},
  [1165] = {.lex_state = 15, .external_lex_state = 5},
  [1166] = {.lex_state = 15, .external_lex_state = 5},
  [1167] = {.lex_state = 0, .external_lex_state = 5},
  [1168] = {.lex_state = 0, .external_lex_state = 5},
  [1169] = {.lex_state = 0, .external_lex_state = 5},
  [1170] = {.lex_state = 15, .external_lex_state = 5},
  [1171] = {.lex_state = 15, .external_lex_state = 5},
  [1172] = {.lex_state = 0, .external_lex_state = 5},
  [1173] = {.lex_state = 15, .external_lex_state = 5},
  [1174] = {.lex_state = 15, .external_lex_state = 5},
  [1175] = {.lex_state = 15, .external_lex_state = 5},
  [1176] = {.lex_state = 0, .external_lex_state = 5},
  [1177] = {.lex_state = 0, .external_lex_state = 5},
  [1178] = {.lex_state = 15, .external_lex_state = 5},
  [1179] = {.lex_state = 0, .external_lex_state = 5},
  [1180] = {.lex_state = 15, .external_lex_state = 5},
  [1181] = {.lex_state = 15, .external_lex_state = 5},
  [1182] = {.lex_state = 0, .external_lex_state = 5},
  [1183] = {.lex_state = 0, .external_lex_state = 5},
  [1184] = {.lex_state = 15, .external_lex_state = 5},
  [1185] = {.lex_state = 0, .external_lex_state = 5},
  [1186] = {.lex_state = 0, .external_lex_state = 5},
  [1187] = {.lex_state = 15, .external_lex_state = 5},
  [1188] = {.lex_state = 0, .external_lex_state = 5},
  [1189] = {.lex_state = 15, .external_lex_state = 5},
  [1190] = {.lex_state = 15, .external_lex_state = 5},
  [1191] = {.lex_state = 0, .external_lex_state = 5},
  [1192] = {.lex_state = 15, .external_lex_state = 5},
  [1193] = {.lex_state = 15, .external_lex_state = 5},
  [1194] = {.lex_state = 15, .external_lex_state = 5},
  [1195] = {.lex_state = 15, .external_lex_state = 5},
  [1196] = {.lex_state = 0, .external_lex_state = 5},
  [1197] = {.lex_state = 15, .external_lex_state = 5},
  [1198] = {.lex_state = 15, .external_lex_state = 5},
  [1199] = {.lex_state = 15, .external_lex_state = 5},
  [1200] = {.lex_state = 15, .external_lex_state = 5},
  [1201] = {.lex_state = 15, .external_lex_state = 5},
  [1202] = {.lex_state = 15, .external_lex_state = 5},
  [1203] = {.lex_state = 0, .external_lex_state = 5},
  [1204] = {.lex_state = 15, .external_lex_state = 5},
  [1205] = {.lex_state = 0, .external_lex_state = 5},
  [1206] = {.lex_state = 15, .external_lex_state = 5},
  [1207] = {.lex_state = 0, .external_lex_state = 5},
  [1208] = {.lex_state = 0, .external_lex_state = 5},
  [1209] = {.lex_state = 0, .external_lex_state = 5},
  [1210] = {.lex_state = 15, .external_lex_state = 5},
  [1211] = {.lex_state = 15, .external_lex_state = 5},
  [1212] = {.lex_state = 0, .external_lex_state = 5},
  [1213] = {.lex_state = 15, .external_lex_state = 5},
  [1214] = {.lex_state = 0, .external_lex_state = 5},
  [1215] = {.lex_state = 15, .external_lex_state = 5},
  [1216] = {.lex_state = 0, .external_lex_state = 5},
  [1217] = {.lex_state = 0, .external_lex_state = 5},
  [1218] = {.lex_state = 0, .external_lex_state = 5},
  [1219] = {.lex_state = 15, .external_lex_state = 5},
  [1220] = {.lex_state = 15, .external_lex_state = 5},
  [1221] = {.lex_state = 0, .external_lex_state = 5},
  [1222] = {.lex_state = 15, .external_lex_state = 5},
  [1223] = {.lex_state = 0, .external_lex_state = 5},
  [1224] = {.lex_state = 15, .external_lex_state = 5},
  [1225] = {.lex_state = 15, .external_lex_state = 5},
  [1226] = {.lex_state = 0, .external_lex_state = 5},
  [1227] = {.lex_state = 0, .external_lex_state = 5},
  [1228] = {.lex_state = 0, .external_lex_state = 5},
  [1229] = {.lex_state = 15, .external_lex_state = 5},
  [1230] = {.lex_state = 0, .external_lex_state = 5},
  [1231] = {.lex_state = 15, .external_lex_state = 5},
  [1232] = {.lex_state = 15, .external_lex_state = 5},
  [1233] = {.lex_state = 15, .external_lex_state = 5},
  [1234] = {.lex_state = 0, .external_lex_state = 5},
  [1235] = {.lex_state = 0, .external_lex_state = 5},
  [1236] = {.lex_state = 15, .external_lex_state = 5},
  [1237] = {.lex_state = 0, .external_lex_state = 5},
  [1238] = {.lex_state = 15, .external_lex_state = 5},
  [1239] = {.lex_state = 15, .external_lex_state = 5},
  [1240] = {.lex_state = 15, .external_lex_state = 5},
  [1241] = {.lex_state = 0, .external_lex_state = 5},
  [1242] = {.lex_state = 0, .external_lex_state = 5},
  [1243] = {.lex_state = 15, .external_lex_state = 5},
  [1244] = {.lex_state = 15, .external_lex_state = 5},
  [1245] = {.lex_state = 15, .external_lex_state = 5},
  [1246] = {.lex_state = 15, .external_lex_state = 5},
  [1247] = {.lex_state = 0, .external_lex_state = 5},
  [1248] = {.lex_state = 0, .external_lex_state = 5},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DOT_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_DOT_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_DOT_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DOT_SLASH] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [anon_sym_DOT_BSLASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_DOT_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_TILDE_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_DOT_SQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [sym_return_statement] = ACTIONS(1),
    [sym_continue_statement] = ACTIONS(1),
    [sym_break_statement] = ACTIONS(1),
    [anon_sym_elseif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_parfor] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_otherwise] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_persistent] = ACTIONS(1),
    [anon_sym_arguments] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_get_DOT] = ACTIONS(1),
    [anon_sym_set_DOT] = ACTIONS(1),
    [anon_sym_endfunction] = ACTIONS(1),
    [anon_sym_vector] = ACTIONS(1),
    [anon_sym_matrix] = ACTIONS(1),
    [anon_sym_scalar] = ACTIONS(1),
    [anon_sym_properties] = ACTIONS(1),
    [anon_sym_methods] = ACTIONS(1),
    [anon_sym_events] = ACTIONS(1),
    [anon_sym_enumeration] = ACTIONS(1),
    [anon_sym_classdef] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(1),
    [sym_command_argument] = ACTIONS(1),
    [sym__single_quote_string_start] = ACTIONS(1),
    [sym__single_quote_string_end] = ACTIONS(1),
    [sym__double_quote_string_start] = ACTIONS(1),
    [sym__double_quote_string_end] = ACTIONS(1),
    [sym_formatting_sequence] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_string_content] = ACTIONS(1),
    [sym__entry_delimiter] = ACTIONS(1),
    [sym__multioutput_variable_start] = ACTIONS(1),
    [sym_error_sentinel] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(1227),
    [aux_sym__block] = STATE(71),
    [sym__statement] = STATE(843),
    [sym__expression] = STATE(621),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(621),
    [sym_handle_operator] = STATE(621),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(843),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(843),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(621),
    [sym_if_statement] = STATE(843),
    [sym_for_statement] = STATE(843),
    [sym_while_statement] = STATE(843),
    [sym_switch_statement] = STATE(843),
    [sym_lambda] = STATE(621),
    [sym_global_operator] = STATE(843),
    [sym_persistent_operator] = STATE(843),
    [sym_function_definition] = STATE(923),
    [sym__function_definition_with_end] = STATE(851),
    [sym_class_definition] = STATE(843),
    [sym_try_statement] = STATE(843),
    [sym_boolean] = STATE(210),
    [aux_sym_source_file_repeat1] = STATE(923),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(23),
    [sym_continue_statement] = ACTIONS(23),
    [sym_break_statement] = ACTIONS(23),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(39),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [2] = {
    [aux_sym__block] = STATE(48),
    [sym_block] = STATE(783),
    [sym__statement] = STATE(881),
    [sym__expression] = STATE(620),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(620),
    [sym_handle_operator] = STATE(620),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(881),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(881),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(620),
    [sym_elseif_clause] = STATE(785),
    [sym_else_clause] = STATE(1204),
    [sym_if_statement] = STATE(881),
    [sym_for_statement] = STATE(881),
    [sym_while_statement] = STATE(881),
    [sym_switch_statement] = STATE(881),
    [sym_lambda] = STATE(620),
    [sym_global_operator] = STATE(881),
    [sym_persistent_operator] = STATE(881),
    [sym__function_definition_with_end] = STATE(892),
    [sym_class_definition] = STATE(881),
    [sym_try_statement] = STATE(881),
    [sym_boolean] = STATE(210),
    [sym__end_of_line] = STATE(5),
    [aux_sym_elseif_clause_repeat1] = STATE(5),
    [aux_sym_if_statement_repeat1] = STATE(785),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(57),
    [anon_sym_COMMA] = ACTIONS(57),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LT] = ACTIONS(69),
    [anon_sym_LT_EQ] = ACTIONS(69),
    [anon_sym_EQ_EQ] = ACTIONS(69),
    [anon_sym_TILDE_EQ] = ACTIONS(69),
    [anon_sym_GT_EQ] = ACTIONS(69),
    [anon_sym_GT] = ACTIONS(69),
    [anon_sym_AMP_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_elseif] = ACTIONS(81),
    [anon_sym_else] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(57),
    [anon_sym_CR] = ACTIONS(57),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [3] = {
    [aux_sym__block] = STATE(48),
    [sym_block] = STATE(1056),
    [sym__statement] = STATE(881),
    [sym__expression] = STATE(620),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(620),
    [sym_handle_operator] = STATE(620),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(881),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(881),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(620),
    [sym_if_statement] = STATE(881),
    [sym_for_statement] = STATE(881),
    [sym_while_statement] = STATE(881),
    [sym_switch_statement] = STATE(881),
    [sym_lambda] = STATE(620),
    [sym_global_operator] = STATE(881),
    [sym_persistent_operator] = STATE(881),
    [sym__function_definition_with_end] = STATE(892),
    [sym_class_definition] = STATE(881),
    [sym_try_statement] = STATE(881),
    [sym_boolean] = STATE(210),
    [sym__end_of_line] = STATE(8),
    [aux_sym_elseif_clause_repeat1] = STATE(8),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(91),
    [anon_sym_COMMA] = ACTIONS(91),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LT] = ACTIONS(69),
    [anon_sym_LT_EQ] = ACTIONS(69),
    [anon_sym_EQ_EQ] = ACTIONS(69),
    [anon_sym_TILDE_EQ] = ACTIONS(69),
    [anon_sym_GT_EQ] = ACTIONS(69),
    [anon_sym_GT] = ACTIONS(69),
    [anon_sym_AMP_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_elseif] = ACTIONS(93),
    [anon_sym_else] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(93),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(91),
    [anon_sym_CR] = ACTIONS(91),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [4] = {
    [aux_sym__block] = STATE(48),
    [sym_block] = STATE(1161),
    [sym__statement] = STATE(881),
    [sym__expression] = STATE(620),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(620),
    [sym_handle_operator] = STATE(620),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(881),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(881),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(620),
    [sym_if_statement] = STATE(881),
    [sym_for_statement] = STATE(881),
    [sym_while_statement] = STATE(881),
    [sym_switch_statement] = STATE(881),
    [sym_lambda] = STATE(620),
    [sym_global_operator] = STATE(881),
    [sym_persistent_operator] = STATE(881),
    [sym__function_definition_with_end] = STATE(892),
    [sym_class_definition] = STATE(881),
    [sym_try_statement] = STATE(881),
    [sym_boolean] = STATE(210),
    [sym__end_of_line] = STATE(13),
    [aux_sym_elseif_clause_repeat1] = STATE(13),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(95),
    [anon_sym_COMMA] = ACTIONS(95),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LT] = ACTIONS(69),
    [anon_sym_LT_EQ] = ACTIONS(69),
    [anon_sym_EQ_EQ] = ACTIONS(69),
    [anon_sym_TILDE_EQ] = ACTIONS(69),
    [anon_sym_GT_EQ] = ACTIONS(69),
    [anon_sym_GT] = ACTIONS(69),
    [anon_sym_AMP_AMP] = ACTIONS(71),
    [anon_sym_PIPE_PIPE] = ACTIONS(73),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(95),
    [anon_sym_CR] = ACTIONS(95),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [5] = {
    [aux_sym__block] = STATE(48),
    [sym_block] = STATE(784),
    [sym__statement] = STATE(881),
    [sym__expression] = STATE(620),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(620),
    [sym_handle_operator] = STATE(620),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(881),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(881),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(620),
    [sym_elseif_clause] = STATE(782),
    [sym_else_clause] = STATE(1239),
    [sym_if_statement] = STATE(881),
    [sym_for_statement] = STATE(881),
    [sym_while_statement] = STATE(881),
    [sym_switch_statement] = STATE(881),
    [sym_lambda] = STATE(620),
    [sym_global_operator] = STATE(881),
    [sym_persistent_operator] = STATE(881),
    [sym__function_definition_with_end] = STATE(892),
    [sym_class_definition] = STATE(881),
    [sym_try_statement] = STATE(881),
    [sym_boolean] = STATE(210),
    [sym__end_of_line] = STATE(160),
    [aux_sym_elseif_clause_repeat1] = STATE(160),
    [aux_sym_if_statement_repeat1] = STATE(782),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_elseif] = ACTIONS(81),
    [anon_sym_else] = ACTIONS(83),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(101),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [6] = {
    [aux_sym__block] = STATE(48),
    [sym_block] = STATE(1026),
    [sym__statement] = STATE(881),
    [sym__expression] = STATE(620),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(620),
    [sym_handle_operator] = STATE(620),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(881),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(881),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(620),
    [sym_if_statement] = STATE(881),
    [sym_for_statement] = STATE(881),
    [sym_while_statement] = STATE(881),
    [sym_switch_statement] = STATE(881),
    [sym_lambda] = STATE(620),
    [sym_global_operator] = STATE(881),
    [sym_persistent_operator] = STATE(881),
    [sym__function_definition_with_end] = STATE(892),
    [sym_class_definition] = STATE(881),
    [sym_catch_clause] = STATE(1199),
    [sym_try_statement] = STATE(881),
    [sym_boolean] = STATE(210),
    [sym__end_of_line] = STATE(7),
    [aux_sym_elseif_clause_repeat1] = STATE(7),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(103),
    [anon_sym_COMMA] = ACTIONS(103),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(105),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_catch] = ACTIONS(107),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(103),
    [anon_sym_CR] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [7] = {
    [aux_sym__block] = STATE(48),
    [sym_block] = STATE(1040),
    [sym__statement] = STATE(881),
    [sym__expression] = STATE(620),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(620),
    [sym_handle_operator] = STATE(620),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(881),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(881),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(620),
    [sym_if_statement] = STATE(881),
    [sym_for_statement] = STATE(881),
    [sym_while_statement] = STATE(881),
    [sym_switch_statement] = STATE(881),
    [sym_lambda] = STATE(620),
    [sym_global_operator] = STATE(881),
    [sym_persistent_operator] = STATE(881),
    [sym__function_definition_with_end] = STATE(892),
    [sym_class_definition] = STATE(881),
    [sym_catch_clause] = STATE(1245),
    [sym_try_statement] = STATE(881),
    [sym_boolean] = STATE(210),
    [sym__end_of_line] = STATE(160),
    [aux_sym_elseif_clause_repeat1] = STATE(160),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(109),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_catch] = ACTIONS(107),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [8] = {
    [aux_sym__block] = STATE(48),
    [sym_block] = STATE(1030),
    [sym__statement] = STATE(881),
    [sym__expression] = STATE(620),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(620),
    [sym_handle_operator] = STATE(620),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(881),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(881),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(620),
    [sym_if_statement] = STATE(881),
    [sym_for_statement] = STATE(881),
    [sym_while_statement] = STATE(881),
    [sym_switch_statement] = STATE(881),
    [sym_lambda] = STATE(620),
    [sym_global_operator] = STATE(881),
    [sym_persistent_operator] = STATE(881),
    [sym__function_definition_with_end] = STATE(892),
    [sym_class_definition] = STATE(881),
    [sym_try_statement] = STATE(881),
    [sym_boolean] = STATE(210),
    [sym__end_of_line] = STATE(160),
    [aux_sym_elseif_clause_repeat1] = STATE(160),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_elseif] = ACTIONS(111),
    [anon_sym_else] = ACTIONS(111),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(111),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [9] = {
    [aux_sym__block] = STATE(48),
    [sym_block] = STATE(1036),
    [sym__statement] = STATE(881),
    [sym__expression] = STATE(620),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(620),
    [sym_handle_operator] = STATE(620),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(881),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(881),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(620),
    [sym_if_statement] = STATE(881),
    [sym_for_statement] = STATE(881),
    [sym_while_statement] = STATE(881),
    [sym_switch_statement] = STATE(881),
    [sym_lambda] = STATE(620),
    [sym_global_operator] = STATE(881),
    [sym_persistent_operator] = STATE(881),
    [sym__function_definition_with_end] = STATE(892),
    [sym_class_definition] = STATE(881),
    [sym_try_statement] = STATE(881),
    [sym_boolean] = STATE(210),
    [sym__end_of_line] = STATE(160),
    [aux_sym_elseif_clause_repeat1] = STATE(160),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(113),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_case] = ACTIONS(113),
    [anon_sym_otherwise] = ACTIONS(113),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [10] = {
    [aux_sym__block] = STATE(48),
    [sym_block] = STATE(1229),
    [sym__statement] = STATE(881),
    [sym__expression] = STATE(620),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(620),
    [sym_handle_operator] = STATE(620),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(881),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(881),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(620),
    [sym_if_statement] = STATE(881),
    [sym_for_statement] = STATE(881),
    [sym_while_statement] = STATE(881),
    [sym_switch_statement] = STATE(881),
    [sym_lambda] = STATE(620),
    [sym_global_operator] = STATE(881),
    [sym_persistent_operator] = STATE(881),
    [sym__function_definition_with_end] = STATE(892),
    [sym_class_definition] = STATE(881),
    [sym_try_statement] = STATE(881),
    [sym_boolean] = STATE(210),
    [sym__end_of_line] = STATE(12),
    [aux_sym_elseif_clause_repeat1] = STATE(12),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(115),
    [anon_sym_COMMA] = ACTIONS(115),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(117),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(115),
    [anon_sym_CR] = ACTIONS(115),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [11] = {
    [aux_sym__block] = STATE(48),
    [sym_block] = STATE(1178),
    [sym__statement] = STATE(881),
    [sym__expression] = STATE(620),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(620),
    [sym_handle_operator] = STATE(620),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(881),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(881),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(620),
    [sym_if_statement] = STATE(881),
    [sym_for_statement] = STATE(881),
    [sym_while_statement] = STATE(881),
    [sym_switch_statement] = STATE(881),
    [sym_lambda] = STATE(620),
    [sym_global_operator] = STATE(881),
    [sym_persistent_operator] = STATE(881),
    [sym__function_definition_with_end] = STATE(892),
    [sym_class_definition] = STATE(881),
    [sym_try_statement] = STATE(881),
    [sym_boolean] = STATE(210),
    [sym__end_of_line] = STATE(18),
    [aux_sym_elseif_clause_repeat1] = STATE(18),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(119),
    [anon_sym_COMMA] = ACTIONS(119),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(121),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(119),
    [anon_sym_CR] = ACTIONS(119),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [12] = {
    [aux_sym__block] = STATE(48),
    [sym_block] = STATE(1160),
    [sym__statement] = STATE(881),
    [sym__expression] = STATE(620),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(620),
    [sym_handle_operator] = STATE(620),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(881),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(881),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(620),
    [sym_if_statement] = STATE(881),
    [sym_for_statement] = STATE(881),
    [sym_while_statement] = STATE(881),
    [sym_switch_statement] = STATE(881),
    [sym_lambda] = STATE(620),
    [sym_global_operator] = STATE(881),
    [sym_persistent_operator] = STATE(881),
    [sym__function_definition_with_end] = STATE(892),
    [sym_class_definition] = STATE(881),
    [sym_try_statement] = STATE(881),
    [sym_boolean] = STATE(210),
    [sym__end_of_line] = STATE(160),
    [aux_sym_elseif_clause_repeat1] = STATE(160),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(123),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [13] = {
    [aux_sym__block] = STATE(48),
    [sym_block] = STATE(1175),
    [sym__statement] = STATE(881),
    [sym__expression] = STATE(620),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(620),
    [sym_handle_operator] = STATE(620),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(881),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(881),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(620),
    [sym_if_statement] = STATE(881),
    [sym_for_statement] = STATE(881),
    [sym_while_statement] = STATE(881),
    [sym_switch_statement] = STATE(881),
    [sym_lambda] = STATE(620),
    [sym_global_operator] = STATE(881),
    [sym_persistent_operator] = STATE(881),
    [sym__function_definition_with_end] = STATE(892),
    [sym_class_definition] = STATE(881),
    [sym_try_statement] = STATE(881),
    [sym_boolean] = STATE(210),
    [sym__end_of_line] = STATE(160),
    [aux_sym_elseif_clause_repeat1] = STATE(160),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(125),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [14] = {
    [aux_sym__block] = STATE(48),
    [sym_block] = STATE(1189),
    [sym__statement] = STATE(881),
    [sym__expression] = STATE(620),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(620),
    [sym_handle_operator] = STATE(620),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(881),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(881),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(620),
    [sym_if_statement] = STATE(881),
    [sym_for_statement] = STATE(881),
    [sym_while_statement] = STATE(881),
    [sym_switch_statement] = STATE(881),
    [sym_lambda] = STATE(620),
    [sym_global_operator] = STATE(881),
    [sym_persistent_operator] = STATE(881),
    [sym__function_definition_with_end] = STATE(892),
    [sym_class_definition] = STATE(881),
    [sym_try_statement] = STATE(881),
    [sym_boolean] = STATE(210),
    [sym__end_of_line] = STATE(15),
    [aux_sym_elseif_clause_repeat1] = STATE(15),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(127),
    [anon_sym_COMMA] = ACTIONS(127),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(129),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(127),
    [anon_sym_CR] = ACTIONS(127),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [15] = {
    [aux_sym__block] = STATE(48),
    [sym_block] = STATE(1194),
    [sym__statement] = STATE(881),
    [sym__expression] = STATE(620),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(620),
    [sym_handle_operator] = STATE(620),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(881),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(881),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(620),
    [sym_if_statement] = STATE(881),
    [sym_for_statement] = STATE(881),
    [sym_while_statement] = STATE(881),
    [sym_switch_statement] = STATE(881),
    [sym_lambda] = STATE(620),
    [sym_global_operator] = STATE(881),
    [sym_persistent_operator] = STATE(881),
    [sym__function_definition_with_end] = STATE(892),
    [sym_class_definition] = STATE(881),
    [sym_try_statement] = STATE(881),
    [sym_boolean] = STATE(210),
    [sym__end_of_line] = STATE(160),
    [aux_sym_elseif_clause_repeat1] = STATE(160),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(131),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [16] = {
    [aux_sym__block] = STATE(48),
    [sym_block] = STATE(1158),
    [sym__statement] = STATE(881),
    [sym__expression] = STATE(620),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(620),
    [sym_handle_operator] = STATE(620),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(881),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(881),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(620),
    [sym_if_statement] = STATE(881),
    [sym_for_statement] = STATE(881),
    [sym_while_statement] = STATE(881),
    [sym_switch_statement] = STATE(881),
    [sym_lambda] = STATE(620),
    [sym_global_operator] = STATE(881),
    [sym_persistent_operator] = STATE(881),
    [sym__function_definition_with_end] = STATE(892),
    [sym_class_definition] = STATE(881),
    [sym_try_statement] = STATE(881),
    [sym_boolean] = STATE(210),
    [sym__end_of_line] = STATE(160),
    [aux_sym_elseif_clause_repeat1] = STATE(160),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(133),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [17] = {
    [aux_sym__block] = STATE(48),
    [sym_block] = STATE(1215),
    [sym__statement] = STATE(881),
    [sym__expression] = STATE(620),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(620),
    [sym_handle_operator] = STATE(620),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(881),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(881),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(620),
    [sym_if_statement] = STATE(881),
    [sym_for_statement] = STATE(881),
    [sym_while_statement] = STATE(881),
    [sym_switch_statement] = STATE(881),
    [sym_lambda] = STATE(620),
    [sym_global_operator] = STATE(881),
    [sym_persistent_operator] = STATE(881),
    [sym__function_definition_with_end] = STATE(892),
    [sym_class_definition] = STATE(881),
    [sym_try_statement] = STATE(881),
    [sym_boolean] = STATE(210),
    [sym__end_of_line] = STATE(160),
    [aux_sym_elseif_clause_repeat1] = STATE(160),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(135),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [18] = {
    [aux_sym__block] = STATE(48),
    [sym_block] = STATE(1201),
    [sym__statement] = STATE(881),
    [sym__expression] = STATE(620),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(620),
    [sym_handle_operator] = STATE(620),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(881),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(881),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(620),
    [sym_if_statement] = STATE(881),
    [sym_for_statement] = STATE(881),
    [sym_while_statement] = STATE(881),
    [sym_switch_statement] = STATE(881),
    [sym_lambda] = STATE(620),
    [sym_global_operator] = STATE(881),
    [sym_persistent_operator] = STATE(881),
    [sym__function_definition_with_end] = STATE(892),
    [sym_class_definition] = STATE(881),
    [sym_try_statement] = STATE(881),
    [sym_boolean] = STATE(210),
    [sym__end_of_line] = STATE(160),
    [aux_sym_elseif_clause_repeat1] = STATE(160),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(137),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [19] = {
    [aux_sym__block] = STATE(48),
    [sym_block] = STATE(1173),
    [sym__statement] = STATE(881),
    [sym__expression] = STATE(620),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(620),
    [sym_handle_operator] = STATE(620),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(881),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(881),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(620),
    [sym_if_statement] = STATE(881),
    [sym_for_statement] = STATE(881),
    [sym_while_statement] = STATE(881),
    [sym_switch_statement] = STATE(881),
    [sym_lambda] = STATE(620),
    [sym_global_operator] = STATE(881),
    [sym_persistent_operator] = STATE(881),
    [sym__function_definition_with_end] = STATE(892),
    [sym_class_definition] = STATE(881),
    [sym_try_statement] = STATE(881),
    [sym_boolean] = STATE(210),
    [sym__end_of_line] = STATE(20),
    [aux_sym_elseif_clause_repeat1] = STATE(20),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(139),
    [anon_sym_COMMA] = ACTIONS(139),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(141),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(139),
    [anon_sym_CR] = ACTIONS(139),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [20] = {
    [aux_sym__block] = STATE(48),
    [sym_block] = STATE(1153),
    [sym__statement] = STATE(881),
    [sym__expression] = STATE(620),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(620),
    [sym_handle_operator] = STATE(620),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(881),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(881),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(620),
    [sym_if_statement] = STATE(881),
    [sym_for_statement] = STATE(881),
    [sym_while_statement] = STATE(881),
    [sym_switch_statement] = STATE(881),
    [sym_lambda] = STATE(620),
    [sym_global_operator] = STATE(881),
    [sym_persistent_operator] = STATE(881),
    [sym__function_definition_with_end] = STATE(892),
    [sym_class_definition] = STATE(881),
    [sym_try_statement] = STATE(881),
    [sym_boolean] = STATE(210),
    [sym__end_of_line] = STATE(160),
    [aux_sym_elseif_clause_repeat1] = STATE(160),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(99),
    [anon_sym_LPAREN] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_QMARK] = ACTIONS(65),
    [anon_sym_AT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(77),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(143),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(89),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [anon_sym_LF] = ACTIONS(99),
    [anon_sym_CR] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [21] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(973),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(42),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(42),
    [ts_builtin_sym_end] = ACTIONS(145),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(149),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_endfunction] = ACTIONS(149),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [22] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(1008),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [ts_builtin_sym_end] = ACTIONS(155),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(157),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(159),
    [anon_sym_endfunction] = ACTIONS(157),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [23] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(898),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(30),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(30),
    [ts_builtin_sym_end] = ACTIONS(161),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(163),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_endfunction] = ACTIONS(163),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [24] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(920),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(32),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(32),
    [ts_builtin_sym_end] = ACTIONS(167),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(169),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(171),
    [anon_sym_endfunction] = ACTIONS(169),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [25] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(920),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [ts_builtin_sym_end] = ACTIONS(167),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(169),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(171),
    [anon_sym_endfunction] = ACTIONS(169),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [26] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(922),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [ts_builtin_sym_end] = ACTIONS(173),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(175),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(177),
    [anon_sym_endfunction] = ACTIONS(175),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [27] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(925),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(34),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(34),
    [ts_builtin_sym_end] = ACTIONS(145),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(179),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(153),
    [anon_sym_endfunction] = ACTIONS(179),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [28] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(946),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(36),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(36),
    [ts_builtin_sym_end] = ACTIONS(181),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(183),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(185),
    [anon_sym_endfunction] = ACTIONS(183),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [29] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(948),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(37),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(37),
    [ts_builtin_sym_end] = ACTIONS(155),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(159),
    [anon_sym_endfunction] = ACTIONS(187),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [30] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(948),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [ts_builtin_sym_end] = ACTIONS(155),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(187),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(159),
    [anon_sym_endfunction] = ACTIONS(187),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [31] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(939),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(22),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(22),
    [ts_builtin_sym_end] = ACTIONS(161),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(189),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(165),
    [anon_sym_endfunction] = ACTIONS(189),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [32] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(963),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [ts_builtin_sym_end] = ACTIONS(191),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(193),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_endfunction] = ACTIONS(193),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [33] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(979),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(39),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(39),
    [ts_builtin_sym_end] = ACTIONS(197),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(199),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(201),
    [anon_sym_endfunction] = ACTIONS(199),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [34] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(979),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [ts_builtin_sym_end] = ACTIONS(197),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(199),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(201),
    [anon_sym_endfunction] = ACTIONS(199),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [35] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(930),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(40),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(40),
    [ts_builtin_sym_end] = ACTIONS(167),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(203),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(171),
    [anon_sym_endfunction] = ACTIONS(203),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [36] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(930),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [ts_builtin_sym_end] = ACTIONS(167),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(203),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(171),
    [anon_sym_endfunction] = ACTIONS(203),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [37] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(947),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [ts_builtin_sym_end] = ACTIONS(173),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(205),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(177),
    [anon_sym_endfunction] = ACTIONS(205),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [38] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(1000),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(25),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(25),
    [ts_builtin_sym_end] = ACTIONS(181),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(207),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(185),
    [anon_sym_endfunction] = ACTIONS(207),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [39] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(942),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [ts_builtin_sym_end] = ACTIONS(209),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(211),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(213),
    [anon_sym_endfunction] = ACTIONS(211),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [40] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(911),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [ts_builtin_sym_end] = ACTIONS(191),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(215),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(195),
    [anon_sym_endfunction] = ACTIONS(215),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [41] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(913),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(43),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(43),
    [ts_builtin_sym_end] = ACTIONS(197),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(217),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(201),
    [anon_sym_endfunction] = ACTIONS(217),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [42] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(913),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [ts_builtin_sym_end] = ACTIONS(197),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(217),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(201),
    [anon_sym_endfunction] = ACTIONS(217),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [43] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(968),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [ts_builtin_sym_end] = ACTIONS(209),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(219),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(213),
    [anon_sym_endfunction] = ACTIONS(219),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [44] = {
    [aux_sym__block] = STATE(72),
    [sym_block] = STATE(1008),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(26),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(26),
    [ts_builtin_sym_end] = ACTIONS(155),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(157),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(159),
    [anon_sym_endfunction] = ACTIONS(157),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [45] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1113),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(46),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(46),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(221),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(221),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [46] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1083),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(223),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [47] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1092),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(225),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(225),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [48] = {
    [aux_sym__block] = STATE(60),
    [sym__statement] = STATE(881),
    [sym__expression] = STATE(620),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(620),
    [sym_handle_operator] = STATE(620),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(881),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(881),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(620),
    [sym_if_statement] = STATE(881),
    [sym_for_statement] = STATE(881),
    [sym_while_statement] = STATE(881),
    [sym_switch_statement] = STATE(881),
    [sym_lambda] = STATE(620),
    [sym_global_operator] = STATE(881),
    [sym_persistent_operator] = STATE(881),
    [sym__function_definition_with_end] = STATE(892),
    [sym_class_definition] = STATE(881),
    [sym_try_statement] = STATE(881),
    [sym_boolean] = STATE(210),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(79),
    [sym_continue_statement] = ACTIONS(79),
    [sym_break_statement] = ACTIONS(79),
    [anon_sym_elseif] = ACTIONS(227),
    [anon_sym_else] = ACTIONS(227),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(227),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_case] = ACTIONS(227),
    [anon_sym_otherwise] = ACTIONS(227),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_catch] = ACTIONS(227),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [49] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1147),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(50),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(50),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(229),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(229),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [50] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1096),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(231),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(231),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [51] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1102),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(55),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(55),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(233),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(233),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [52] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1102),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(233),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(233),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [53] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1115),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(235),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(235),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [54] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1147),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(229),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(229),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [55] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1107),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(237),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(237),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [56] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1109),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(52),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(52),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(239),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(239),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [57] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1114),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(54),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(54),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(241),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(241),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [58] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1087),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(243),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(243),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [59] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1083),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(53),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(53),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(223),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(223),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [60] = {
    [aux_sym__block] = STATE(60),
    [sym__statement] = STATE(881),
    [sym__expression] = STATE(620),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(620),
    [sym_handle_operator] = STATE(620),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(881),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(881),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(620),
    [sym_if_statement] = STATE(881),
    [sym_for_statement] = STATE(881),
    [sym_while_statement] = STATE(881),
    [sym_switch_statement] = STATE(881),
    [sym_lambda] = STATE(620),
    [sym_global_operator] = STATE(881),
    [sym_persistent_operator] = STATE(881),
    [sym__function_definition_with_end] = STATE(892),
    [sym_class_definition] = STATE(881),
    [sym_try_statement] = STATE(881),
    [sym_boolean] = STATE(210),
    [sym_identifier] = ACTIONS(245),
    [anon_sym_LPAREN] = ACTIONS(248),
    [anon_sym_PLUS] = ACTIONS(251),
    [anon_sym_DASH] = ACTIONS(251),
    [anon_sym_TILDE] = ACTIONS(254),
    [anon_sym_QMARK] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(260),
    [anon_sym_LBRACK] = ACTIONS(263),
    [anon_sym_LBRACE] = ACTIONS(266),
    [sym_return_statement] = ACTIONS(269),
    [sym_continue_statement] = ACTIONS(269),
    [sym_break_statement] = ACTIONS(269),
    [anon_sym_elseif] = ACTIONS(272),
    [anon_sym_else] = ACTIONS(272),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_end] = ACTIONS(272),
    [anon_sym_for] = ACTIONS(277),
    [anon_sym_parfor] = ACTIONS(280),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_case] = ACTIONS(272),
    [anon_sym_otherwise] = ACTIONS(272),
    [anon_sym_switch] = ACTIONS(286),
    [anon_sym_global] = ACTIONS(289),
    [anon_sym_persistent] = ACTIONS(292),
    [anon_sym_function] = ACTIONS(295),
    [anon_sym_classdef] = ACTIONS(298),
    [anon_sym_catch] = ACTIONS(272),
    [anon_sym_try] = ACTIONS(301),
    [sym_number] = ACTIONS(304),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(310),
    [sym__single_quote_string_start] = ACTIONS(313),
    [sym__double_quote_string_start] = ACTIONS(316),
    [sym__multioutput_variable_start] = ACTIONS(319),
  },
  [61] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1082),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(64),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(64),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(322),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(322),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [62] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1084),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(66),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(66),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(324),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(324),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [63] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1085),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(58),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(58),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(326),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(326),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [64] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1085),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(326),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(326),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [65] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1086),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(67),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(67),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(328),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(328),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [66] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1086),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(328),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(328),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [67] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1089),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(330),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(330),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [68] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1088),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(70),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(70),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(332),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(332),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [69] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1090),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(47),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(47),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(334),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(334),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [70] = {
    [aux_sym__block] = STATE(74),
    [sym_block] = STATE(1090),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym_arguments_statement] = STATE(259),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [aux_sym_function_definition_repeat1] = STATE(259),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(334),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_arguments] = ACTIONS(151),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(334),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [71] = {
    [aux_sym__block] = STATE(75),
    [sym__statement] = STATE(843),
    [sym__expression] = STATE(621),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(621),
    [sym_handle_operator] = STATE(621),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(843),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(843),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(621),
    [sym_if_statement] = STATE(843),
    [sym_for_statement] = STATE(843),
    [sym_while_statement] = STATE(843),
    [sym_switch_statement] = STATE(843),
    [sym_lambda] = STATE(621),
    [sym_global_operator] = STATE(843),
    [sym_persistent_operator] = STATE(843),
    [sym_function_definition] = STATE(964),
    [sym__function_definition_with_end] = STATE(851),
    [sym_class_definition] = STATE(843),
    [sym_try_statement] = STATE(843),
    [sym_boolean] = STATE(210),
    [aux_sym_source_file_repeat1] = STATE(964),
    [ts_builtin_sym_end] = ACTIONS(336),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(23),
    [sym_continue_statement] = ACTIONS(23),
    [sym_break_statement] = ACTIONS(23),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(39),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [72] = {
    [aux_sym__block] = STATE(73),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [ts_builtin_sym_end] = ACTIONS(338),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(227),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(340),
    [anon_sym_endfunction] = ACTIONS(227),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [73] = {
    [aux_sym__block] = STATE(73),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [ts_builtin_sym_end] = ACTIONS(343),
    [sym_identifier] = ACTIONS(245),
    [anon_sym_LPAREN] = ACTIONS(248),
    [anon_sym_PLUS] = ACTIONS(251),
    [anon_sym_DASH] = ACTIONS(251),
    [anon_sym_TILDE] = ACTIONS(254),
    [anon_sym_QMARK] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(260),
    [anon_sym_LBRACK] = ACTIONS(263),
    [anon_sym_LBRACE] = ACTIONS(266),
    [sym_return_statement] = ACTIONS(345),
    [sym_continue_statement] = ACTIONS(345),
    [sym_break_statement] = ACTIONS(345),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_end] = ACTIONS(272),
    [anon_sym_for] = ACTIONS(277),
    [anon_sym_parfor] = ACTIONS(280),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_switch] = ACTIONS(286),
    [anon_sym_global] = ACTIONS(289),
    [anon_sym_persistent] = ACTIONS(292),
    [anon_sym_function] = ACTIONS(295),
    [anon_sym_endfunction] = ACTIONS(272),
    [anon_sym_classdef] = ACTIONS(298),
    [anon_sym_try] = ACTIONS(301),
    [sym_number] = ACTIONS(304),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(310),
    [sym__single_quote_string_start] = ACTIONS(313),
    [sym__double_quote_string_start] = ACTIONS(316),
    [sym__multioutput_variable_start] = ACTIONS(319),
  },
  [74] = {
    [aux_sym__block] = STATE(73),
    [sym__statement] = STATE(849),
    [sym__expression] = STATE(625),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(625),
    [sym_handle_operator] = STATE(625),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(849),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(849),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(625),
    [sym_if_statement] = STATE(849),
    [sym_for_statement] = STATE(849),
    [sym_while_statement] = STATE(849),
    [sym_switch_statement] = STATE(849),
    [sym_lambda] = STATE(625),
    [sym_global_operator] = STATE(849),
    [sym_persistent_operator] = STATE(849),
    [sym__function_definition_with_end] = STATE(852),
    [sym_class_definition] = STATE(849),
    [sym_try_statement] = STATE(849),
    [sym_boolean] = STATE(210),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_PLUS] = ACTIONS(11),
    [anon_sym_DASH] = ACTIONS(11),
    [anon_sym_TILDE] = ACTIONS(13),
    [anon_sym_QMARK] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_LBRACE] = ACTIONS(21),
    [sym_return_statement] = ACTIONS(147),
    [sym_continue_statement] = ACTIONS(147),
    [sym_break_statement] = ACTIONS(147),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_end] = ACTIONS(227),
    [anon_sym_for] = ACTIONS(27),
    [anon_sym_parfor] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_switch] = ACTIONS(33),
    [anon_sym_global] = ACTIONS(35),
    [anon_sym_persistent] = ACTIONS(37),
    [anon_sym_function] = ACTIONS(87),
    [anon_sym_endfunction] = ACTIONS(227),
    [anon_sym_classdef] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [sym_number] = ACTIONS(45),
    [anon_sym_true] = ACTIONS(47),
    [anon_sym_false] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(49),
    [sym__single_quote_string_start] = ACTIONS(51),
    [sym__double_quote_string_start] = ACTIONS(53),
    [sym__multioutput_variable_start] = ACTIONS(55),
  },
  [75] = {
    [aux_sym__block] = STATE(75),
    [sym__statement] = STATE(843),
    [sym__expression] = STATE(621),
    [sym_parenthesis] = STATE(434),
    [sym__binary_expression] = STATE(607),
    [sym_binary_operator] = STATE(422),
    [sym_unary_operator] = STATE(379),
    [sym_indirect_access] = STATE(938),
    [sym_field_expression] = STATE(475),
    [sym_not_operator] = STATE(493),
    [sym_metaclass_operator] = STATE(621),
    [sym_handle_operator] = STATE(621),
    [sym_comparison_operator] = STATE(420),
    [sym_boolean_operator] = STATE(420),
    [sym_postfix_operator] = STATE(434),
    [sym_string] = STATE(434),
    [sym_matrix] = STATE(434),
    [sym_cell] = STATE(426),
    [sym_ignored_argument] = STATE(1176),
    [sym_assignment] = STATE(843),
    [sym_multioutput_variable] = STATE(1176),
    [sym_function_call] = STATE(208),
    [sym_command] = STATE(843),
    [sym__range_element] = STATE(1155),
    [sym_range] = STATE(621),
    [sym_if_statement] = STATE(843),
    [sym_for_statement] = STATE(843),
    [sym_while_statement] = STATE(843),
    [sym_switch_statement] = STATE(843),
    [sym_lambda] = STATE(621),
    [sym_global_operator] = STATE(843),
    [sym_persistent_operator] = STATE(843),
    [sym__function_definition_with_end] = STATE(851),
    [sym_class_definition] = STATE(843),
    [sym_try_statement] = STATE(843),
    [sym_boolean] = STATE(210),
    [ts_builtin_sym_end] = ACTIONS(343),
    [sym_identifier] = ACTIONS(245),
    [anon_sym_LPAREN] = ACTIONS(248),
    [anon_sym_PLUS] = ACTIONS(251),
    [anon_sym_DASH] = ACTIONS(251),
    [anon_sym_TILDE] = ACTIONS(254),
    [anon_sym_QMARK] = ACTIONS(257),
    [anon_sym_AT] = ACTIONS(260),
    [anon_sym_LBRACK] = ACTIONS(263),
    [anon_sym_LBRACE] = ACTIONS(266),
    [sym_return_statement] = ACTIONS(348),
    [sym_continue_statement] = ACTIONS(348),
    [sym_break_statement] = ACTIONS(348),
    [anon_sym_if] = ACTIONS(274),
    [anon_sym_for] = ACTIONS(277),
    [anon_sym_parfor] = ACTIONS(280),
    [anon_sym_while] = ACTIONS(283),
    [anon_sym_switch] = ACTIONS(286),
    [anon_sym_global] = ACTIONS(289),
    [anon_sym_persistent] = ACTIONS(292),
    [anon_sym_function] = ACTIONS(295),
    [anon_sym_classdef] = ACTIONS(298),
    [anon_sym_try] = ACTIONS(301),
    [sym_number] = ACTIONS(304),
    [anon_sym_true] = ACTIONS(307),
    [anon_sym_false] = ACTIONS(307),
    [sym_comment] = ACTIONS(3),
    [sym_line_continuation] = ACTIONS(3),
    [sym_command_name] = ACTIONS(310),
    [sym__single_quote_string_start] = ACTIONS(313),
    [sym__double_quote_string_start] = ACTIONS(316),
    [sym__multioutput_variable_start] = ACTIONS(319),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 10,
    ACTIONS(353), 1,
      anon_sym_LPAREN,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_AT,
    ACTIONS(361), 1,
      anon_sym_LBRACE,
    STATE(87), 1,
      aux_sym_field_expression_repeat1,
    STATE(95), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(363), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(351), 50,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [85] = 12,
    ACTIONS(353), 1,
      anon_sym_LPAREN,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_AT,
    ACTIONS(361), 1,
      anon_sym_LBRACE,
    ACTIONS(367), 1,
      anon_sym_COLON,
    STATE(87), 1,
      aux_sym_field_expression_repeat1,
    STATE(95), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 35,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [174] = 12,
    ACTIONS(353), 1,
      anon_sym_LPAREN,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_AT,
    ACTIONS(361), 1,
      anon_sym_LBRACE,
    STATE(87), 1,
      aux_sym_field_expression_repeat1,
    STATE(95), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(374), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(367), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(372), 28,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LBRACK,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [263] = 10,
    ACTIONS(353), 1,
      anon_sym_LPAREN,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_AT,
    ACTIONS(361), 1,
      anon_sym_LBRACE,
    STATE(87), 1,
      aux_sym_field_expression_repeat1,
    STATE(95), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(378), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(376), 50,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [348] = 12,
    ACTIONS(353), 1,
      anon_sym_LPAREN,
    ACTIONS(355), 1,
      anon_sym_DOT,
    ACTIONS(357), 1,
      anon_sym_AT,
    ACTIONS(361), 1,
      anon_sym_LBRACE,
    ACTIONS(372), 1,
      anon_sym_COLON,
    STATE(87), 1,
      aux_sym_field_expression_repeat1,
    STATE(95), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 35,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [437] = 5,
    ACTIONS(382), 1,
      anon_sym_DOT,
    STATE(83), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(384), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(380), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [511] = 5,
    ACTIONS(382), 1,
      anon_sym_DOT,
    STATE(83), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(388), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(386), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [585] = 5,
    ACTIONS(392), 1,
      anon_sym_DOT,
    STATE(83), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(395), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(390), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [659] = 5,
    ACTIONS(382), 1,
      anon_sym_DOT,
    STATE(81), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(399), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(397), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [733] = 5,
    ACTIONS(382), 1,
      anon_sym_DOT,
    STATE(82), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(403), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(401), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [807] = 7,
    ACTIONS(353), 1,
      anon_sym_LPAREN,
    ACTIONS(357), 1,
      anon_sym_AT,
    ACTIONS(361), 1,
      anon_sym_LBRACE,
    STATE(95), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(407), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(405), 53,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [885] = 5,
    ACTIONS(355), 1,
      anon_sym_DOT,
    STATE(88), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(411), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(409), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [959] = 5,
    ACTIONS(415), 1,
      anon_sym_DOT,
    STATE(88), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(418), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(413), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1033] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(422), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(420), 56,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1102] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(426), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(424), 56,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1171] = 10,
    ACTIONS(353), 1,
      anon_sym_LPAREN,
    ACTIONS(361), 1,
      anon_sym_LBRACE,
    ACTIONS(367), 1,
      anon_sym_COLON,
    ACTIONS(428), 1,
      anon_sym_AT,
    STATE(99), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 35,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1254] = 8,
    ACTIONS(353), 1,
      anon_sym_LPAREN,
    ACTIONS(361), 1,
      anon_sym_LBRACE,
    ACTIONS(428), 1,
      anon_sym_AT,
    STATE(99), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(363), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(351), 50,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1333] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(395), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(390), 56,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1402] = 10,
    ACTIONS(353), 1,
      anon_sym_LPAREN,
    ACTIONS(361), 1,
      anon_sym_LBRACE,
    ACTIONS(428), 1,
      anon_sym_AT,
    STATE(99), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(374), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(367), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(372), 28,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LBRACK,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1485] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(432), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(430), 56,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1554] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(436), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(434), 56,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1623] = 8,
    ACTIONS(353), 1,
      anon_sym_LPAREN,
    ACTIONS(361), 1,
      anon_sym_LBRACE,
    ACTIONS(428), 1,
      anon_sym_AT,
    STATE(99), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(378), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(376), 50,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1702] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(440), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(438), 56,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1771] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(444), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(442), 56,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1840] = 10,
    ACTIONS(353), 1,
      anon_sym_LPAREN,
    ACTIONS(361), 1,
      anon_sym_LBRACE,
    ACTIONS(372), 1,
      anon_sym_COLON,
    ACTIONS(428), 1,
      anon_sym_AT,
    STATE(99), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 35,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1923] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(448), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(446), 56,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [1992] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(452), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(450), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2060] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(456), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(454), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2128] = 6,
    ACTIONS(458), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 38,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2202] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 41,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2272] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 39,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2344] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(462), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(460), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2412] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(378), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(376), 53,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2482] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(378), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(376), 53,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2552] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(378), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(376), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2620] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(378), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(376), 53,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2690] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(468), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(466), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(464), 49,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2760] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(472), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(470), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2828] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(476), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(474), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2896] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(480), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(478), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [2964] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(484), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(482), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3032] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(488), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(486), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3100] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(492), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(490), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3168] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(496), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(494), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3236] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(502), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(504), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(500), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(498), 47,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3308] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(502), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(504), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(498), 53,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3378] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(502), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(504), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(498), 53,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3448] = 7,
    ACTIONS(508), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(502), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(504), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(506), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(500), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(498), 42,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3524] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(502), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(504), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(506), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(500), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(498), 43,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3598] = 4,
    ACTIONS(512), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(514), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(510), 54,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3668] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(518), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(516), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3736] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(522), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(520), 55,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3804] = 5,
    ACTIONS(529), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(531), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(526), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(524), 46,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3876] = 6,
    ACTIONS(533), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 38,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [3950] = 6,
    ACTIONS(535), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 38,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4024] = 6,
    ACTIONS(367), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 38,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4098] = 5,
    ACTIONS(367), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 40,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4170] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(540), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(466), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(538), 49,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4240] = 5,
    ACTIONS(542), 1,
      anon_sym_AMP_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(540), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(466), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(538), 48,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4312] = 6,
    ACTIONS(542), 1,
      anon_sym_AMP_AMP,
    ACTIONS(546), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(548), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(466), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(544), 47,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4386] = 6,
    ACTIONS(542), 1,
      anon_sym_AMP_AMP,
    ACTIONS(546), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(552), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(466), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(550), 47,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4460] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(363), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(351), 53,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4530] = 6,
    ACTIONS(554), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 38,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4604] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(363), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(351), 53,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4674] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(363), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(351), 53,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4744] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(374), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(367), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(372), 31,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4818] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(557), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(535), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(458), 31,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4892] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(374), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(367), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(372), 33,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [4964] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(363), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(351), 53,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5034] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(559), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(554), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(533), 31,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5108] = 6,
    ACTIONS(372), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(359), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 38,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5182] = 5,
    ACTIONS(372), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 38,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5252] = 6,
    ACTIONS(71), 1,
      anon_sym_AMP_AMP,
    ACTIONS(73), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(548), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(69), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(544), 44,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5323] = 5,
    ACTIONS(71), 1,
      anon_sym_AMP_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(540), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(69), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(538), 45,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5392] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(540), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(69), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(538), 46,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5459] = 6,
    ACTIONS(71), 1,
      anon_sym_AMP_AMP,
    ACTIONS(73), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(552), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(69), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(550), 44,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5530] = 5,
    ACTIONS(561), 1,
      anon_sym_DOT,
    STATE(156), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(388), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(386), 40,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5589] = 5,
    ACTIONS(561), 1,
      anon_sym_DOT,
    STATE(152), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(403), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(401), 40,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5648] = 5,
    ACTIONS(561), 1,
      anon_sym_DOT,
    STATE(156), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(384), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(380), 40,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5707] = 5,
    ACTIONS(561), 1,
      anon_sym_DOT,
    STATE(154), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(399), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(397), 40,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5766] = 5,
    ACTIONS(563), 1,
      anon_sym_DOT,
    STATE(156), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(395), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(390), 40,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5825] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(395), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(390), 41,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5879] = 6,
    ACTIONS(71), 1,
      anon_sym_AMP_AMP,
    ACTIONS(73), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(568), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(69), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(566), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [5936] = 30,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(574), 1,
      anon_sym_COMMA,
    ACTIONS(576), 1,
      anon_sym_LPAREN,
    ACTIONS(580), 1,
      anon_sym_TILDE,
    ACTIONS(582), 1,
      anon_sym_QMARK,
    ACTIONS(584), 1,
      anon_sym_AT,
    ACTIONS(586), 1,
      anon_sym_LBRACK,
    ACTIONS(588), 1,
      aux_sym_matrix_token1,
    ACTIONS(590), 1,
      anon_sym_LBRACE,
    ACTIONS(592), 1,
      sym_number,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    STATE(221), 1,
      sym_function_call,
    STATE(347), 1,
      sym_boolean,
    STATE(451), 1,
      sym_binary_operator,
    STATE(472), 1,
      sym_unary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(536), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(759), 1,
      sym_ignored_argument,
    STATE(921), 1,
      sym_row,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(578), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    ACTIONS(572), 3,
      anon_sym_SEMI,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    STATE(502), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(615), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [6041] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    STATE(160), 2,
      sym__end_of_line,
      aux_sym_elseif_clause_repeat1,
    ACTIONS(602), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(605), 4,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
    ACTIONS(600), 31,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_catch,
      anon_sym_try,
      sym_number,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [6095] = 27,
    ACTIONS(576), 1,
      anon_sym_LPAREN,
    ACTIONS(586), 1,
      anon_sym_LBRACK,
    ACTIONS(590), 1,
      anon_sym_LBRACE,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(607), 1,
      sym_identifier,
    ACTIONS(611), 1,
      anon_sym_TILDE,
    ACTIONS(613), 1,
      anon_sym_QMARK,
    ACTIONS(615), 1,
      anon_sym_AT,
    ACTIONS(619), 1,
      sym_number,
    STATE(207), 1,
      sym_function_call,
    STATE(352), 1,
      sym_boolean,
    STATE(464), 1,
      sym_unary_operator,
    STATE(492), 1,
      sym_not_operator,
    STATE(495), 1,
      sym_binary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(616), 1,
      sym__binary_expression,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(578), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(617), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    ACTIONS(609), 3,
      anon_sym_SEMI,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    STATE(458), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(481), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [6192] = 28,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(576), 1,
      anon_sym_LPAREN,
    ACTIONS(580), 1,
      anon_sym_TILDE,
    ACTIONS(582), 1,
      anon_sym_QMARK,
    ACTIONS(584), 1,
      anon_sym_AT,
    ACTIONS(586), 1,
      anon_sym_LBRACK,
    ACTIONS(590), 1,
      anon_sym_LBRACE,
    ACTIONS(592), 1,
      sym_number,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(623), 1,
      aux_sym_matrix_token1,
    STATE(221), 1,
      sym_function_call,
    STATE(347), 1,
      sym_boolean,
    STATE(451), 1,
      sym_binary_operator,
    STATE(472), 1,
      sym_unary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(536), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(860), 1,
      sym_ignored_argument,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(578), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    ACTIONS(621), 3,
      anon_sym_SEMI,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    STATE(502), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(627), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [6291] = 28,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(576), 1,
      anon_sym_LPAREN,
    ACTIONS(580), 1,
      anon_sym_TILDE,
    ACTIONS(582), 1,
      anon_sym_QMARK,
    ACTIONS(584), 1,
      anon_sym_AT,
    ACTIONS(586), 1,
      anon_sym_LBRACK,
    ACTIONS(590), 1,
      anon_sym_LBRACE,
    ACTIONS(592), 1,
      sym_number,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(627), 1,
      aux_sym_matrix_token1,
    STATE(221), 1,
      sym_function_call,
    STATE(347), 1,
      sym_boolean,
    STATE(451), 1,
      sym_binary_operator,
    STATE(472), 1,
      sym_unary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(536), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(860), 1,
      sym_ignored_argument,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(578), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    ACTIONS(625), 3,
      anon_sym_SEMI,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    STATE(502), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(627), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [6390] = 28,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(576), 1,
      anon_sym_LPAREN,
    ACTIONS(580), 1,
      anon_sym_TILDE,
    ACTIONS(582), 1,
      anon_sym_QMARK,
    ACTIONS(584), 1,
      anon_sym_AT,
    ACTIONS(586), 1,
      anon_sym_LBRACK,
    ACTIONS(590), 1,
      anon_sym_LBRACE,
    ACTIONS(592), 1,
      sym_number,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(631), 1,
      aux_sym_matrix_token1,
    STATE(221), 1,
      sym_function_call,
    STATE(347), 1,
      sym_boolean,
    STATE(451), 1,
      sym_binary_operator,
    STATE(472), 1,
      sym_unary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(536), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(860), 1,
      sym_ignored_argument,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(578), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    ACTIONS(629), 3,
      anon_sym_SEMI,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    STATE(502), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(627), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [6489] = 5,
    STATE(170), 1,
      aux_sym__block_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(637), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(633), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(635), 22,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_catch,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [6541] = 29,
    ACTIONS(639), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(655), 1,
      anon_sym_RBRACE,
    ACTIONS(657), 1,
      anon_sym_COLON,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(926), 1,
      sym_spread_operator,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1185), 1,
      sym_arguments,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(629), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [6641] = 29,
    ACTIONS(639), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(657), 1,
      anon_sym_COLON,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(667), 1,
      anon_sym_RBRACE,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(926), 1,
      sym_spread_operator,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1234), 1,
      sym_arguments,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(629), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [6741] = 5,
    STATE(169), 1,
      aux_sym__block_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(669), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(343), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(272), 22,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_catch,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [6793] = 5,
    STATE(170), 1,
      aux_sym__block_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(637), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(671), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(673), 22,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_catch,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [6845] = 5,
    STATE(170), 1,
      aux_sym__block_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(679), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(675), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(677), 22,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_catch,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [6897] = 29,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(657), 1,
      anon_sym_COLON,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(682), 1,
      sym_identifier,
    ACTIONS(684), 1,
      anon_sym_RPAREN,
    STATE(375), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(560), 1,
      sym_binary_operator,
    STATE(563), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(926), 1,
      sym_spread_operator,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1218), 1,
      sym_arguments,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(562), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(629), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [6997] = 29,
    ACTIONS(639), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(655), 1,
      anon_sym_RPAREN,
    ACTIONS(657), 1,
      anon_sym_COLON,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(926), 1,
      sym_spread_operator,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1183), 1,
      sym_arguments,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(629), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [7097] = 5,
    STATE(165), 1,
      aux_sym__block_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(690), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(686), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(688), 22,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_elseif,
      anon_sym_else,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_classdef,
      anon_sym_catch,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [7149] = 29,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(692), 1,
      anon_sym_COMMA,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_TILDE,
    ACTIONS(700), 1,
      anon_sym_QMARK,
    ACTIONS(702), 1,
      anon_sym_AT,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(706), 1,
      anon_sym_RBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(710), 1,
      sym_number,
    STATE(221), 1,
      sym_function_call,
    STATE(347), 1,
      sym_boolean,
    STATE(451), 1,
      sym_binary_operator,
    STATE(472), 1,
      sym_unary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(536), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(759), 1,
      sym_ignored_argument,
    STATE(958), 1,
      sym_row,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(502), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(615), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [7249] = 29,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(692), 1,
      anon_sym_COMMA,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_TILDE,
    ACTIONS(700), 1,
      anon_sym_QMARK,
    ACTIONS(702), 1,
      anon_sym_AT,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(710), 1,
      sym_number,
    ACTIONS(712), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      sym_function_call,
    STATE(347), 1,
      sym_boolean,
    STATE(451), 1,
      sym_binary_operator,
    STATE(472), 1,
      sym_unary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(536), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(759), 1,
      sym_ignored_argument,
    STATE(959), 1,
      sym_row,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(502), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(615), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [7349] = 29,
    ACTIONS(639), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(657), 1,
      anon_sym_COLON,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(684), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(926), 1,
      sym_spread_operator,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1218), 1,
      sym_arguments,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(629), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [7449] = 29,
    ACTIONS(639), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(657), 1,
      anon_sym_COLON,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(684), 1,
      anon_sym_RBRACE,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(926), 1,
      sym_spread_operator,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1223), 1,
      sym_arguments,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(629), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [7549] = 29,
    ACTIONS(639), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(657), 1,
      anon_sym_COLON,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(667), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(926), 1,
      sym_spread_operator,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1242), 1,
      sym_arguments,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(629), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [7649] = 29,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(692), 1,
      anon_sym_COMMA,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_TILDE,
    ACTIONS(700), 1,
      anon_sym_QMARK,
    ACTIONS(702), 1,
      anon_sym_AT,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(710), 1,
      sym_number,
    ACTIONS(714), 1,
      anon_sym_RBRACK,
    STATE(221), 1,
      sym_function_call,
    STATE(347), 1,
      sym_boolean,
    STATE(451), 1,
      sym_binary_operator,
    STATE(472), 1,
      sym_unary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(536), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(759), 1,
      sym_ignored_argument,
    STATE(985), 1,
      sym_indirect_access,
    STATE(989), 1,
      sym_row,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(502), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(615), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [7749] = 29,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(692), 1,
      anon_sym_COMMA,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_TILDE,
    ACTIONS(700), 1,
      anon_sym_QMARK,
    ACTIONS(702), 1,
      anon_sym_AT,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(710), 1,
      sym_number,
    ACTIONS(716), 1,
      anon_sym_RBRACK,
    STATE(221), 1,
      sym_function_call,
    STATE(347), 1,
      sym_boolean,
    STATE(451), 1,
      sym_binary_operator,
    STATE(472), 1,
      sym_unary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(536), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(759), 1,
      sym_ignored_argument,
    STATE(905), 1,
      sym_row,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(502), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(615), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [7849] = 29,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(692), 1,
      anon_sym_COMMA,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_TILDE,
    ACTIONS(700), 1,
      anon_sym_QMARK,
    ACTIONS(702), 1,
      anon_sym_AT,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(710), 1,
      sym_number,
    ACTIONS(718), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      sym_function_call,
    STATE(347), 1,
      sym_boolean,
    STATE(451), 1,
      sym_binary_operator,
    STATE(472), 1,
      sym_unary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(536), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(759), 1,
      sym_ignored_argument,
    STATE(914), 1,
      sym_row,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(502), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(615), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [7949] = 29,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(692), 1,
      anon_sym_COMMA,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_TILDE,
    ACTIONS(700), 1,
      anon_sym_QMARK,
    ACTIONS(702), 1,
      anon_sym_AT,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(710), 1,
      sym_number,
    ACTIONS(720), 1,
      anon_sym_RBRACK,
    STATE(221), 1,
      sym_function_call,
    STATE(347), 1,
      sym_boolean,
    STATE(451), 1,
      sym_binary_operator,
    STATE(472), 1,
      sym_unary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(536), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(759), 1,
      sym_ignored_argument,
    STATE(980), 1,
      sym_row,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(502), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(615), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [8049] = 29,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(692), 1,
      anon_sym_COMMA,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_TILDE,
    ACTIONS(700), 1,
      anon_sym_QMARK,
    ACTIONS(702), 1,
      anon_sym_AT,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(710), 1,
      sym_number,
    ACTIONS(722), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      sym_function_call,
    STATE(347), 1,
      sym_boolean,
    STATE(451), 1,
      sym_binary_operator,
    STATE(472), 1,
      sym_unary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(536), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(759), 1,
      sym_ignored_argument,
    STATE(981), 1,
      sym_row,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(502), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(615), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [8149] = 29,
    ACTIONS(639), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(657), 1,
      anon_sym_COLON,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(724), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(926), 1,
      sym_spread_operator,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1214), 1,
      sym_arguments,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(629), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [8249] = 29,
    ACTIONS(639), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(657), 1,
      anon_sym_COLON,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(724), 1,
      anon_sym_RBRACE,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(926), 1,
      sym_spread_operator,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1217), 1,
      sym_arguments,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(629), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [8349] = 29,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(692), 1,
      anon_sym_COMMA,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_TILDE,
    ACTIONS(700), 1,
      anon_sym_QMARK,
    ACTIONS(702), 1,
      anon_sym_AT,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(710), 1,
      sym_number,
    ACTIONS(726), 1,
      anon_sym_RBRACE,
    STATE(221), 1,
      sym_function_call,
    STATE(347), 1,
      sym_boolean,
    STATE(451), 1,
      sym_binary_operator,
    STATE(472), 1,
      sym_unary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(536), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(759), 1,
      sym_ignored_argument,
    STATE(985), 1,
      sym_indirect_access,
    STATE(990), 1,
      sym_row,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(502), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(615), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [8449] = 29,
    ACTIONS(639), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(657), 1,
      anon_sym_COLON,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(728), 1,
      anon_sym_RPAREN,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(926), 1,
      sym_spread_operator,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1167), 1,
      sym_arguments,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(629), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [8549] = 29,
    ACTIONS(639), 1,
      sym_identifier,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(657), 1,
      anon_sym_COLON,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(728), 1,
      anon_sym_RBRACE,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(926), 1,
      sym_spread_operator,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1169), 1,
      sym_arguments,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(629), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [8649] = 9,
    ACTIONS(730), 1,
      anon_sym_LPAREN,
    ACTIONS(732), 1,
      anon_sym_DOT,
    ACTIONS(734), 1,
      anon_sym_AT,
    ACTIONS(738), 1,
      anon_sym_LBRACE,
    STATE(200), 1,
      sym__args,
    STATE(334), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [8708] = 11,
    ACTIONS(372), 1,
      anon_sym_COLON,
    ACTIONS(730), 1,
      anon_sym_LPAREN,
    ACTIONS(732), 1,
      anon_sym_DOT,
    ACTIONS(734), 1,
      anon_sym_AT,
    ACTIONS(738), 1,
      anon_sym_LBRACE,
    STATE(200), 1,
      sym__args,
    STATE(334), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [8771] = 9,
    ACTIONS(730), 1,
      anon_sym_LPAREN,
    ACTIONS(732), 1,
      anon_sym_DOT,
    ACTIONS(734), 1,
      anon_sym_AT,
    ACTIONS(738), 1,
      anon_sym_LBRACE,
    STATE(200), 1,
      sym__args,
    STATE(334), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [8830] = 6,
    ACTIONS(730), 1,
      anon_sym_LPAREN,
    ACTIONS(734), 1,
      anon_sym_AT,
    ACTIONS(738), 1,
      anon_sym_LBRACE,
    STATE(200), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(405), 34,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [8883] = 11,
    ACTIONS(730), 1,
      anon_sym_LPAREN,
    ACTIONS(732), 1,
      anon_sym_DOT,
    ACTIONS(734), 1,
      anon_sym_AT,
    ACTIONS(738), 1,
      anon_sym_LBRACE,
    STATE(200), 1,
      sym__args,
    STATE(334), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(367), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(372), 8,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [8946] = 11,
    ACTIONS(367), 1,
      anon_sym_COLON,
    ACTIONS(730), 1,
      anon_sym_LPAREN,
    ACTIONS(732), 1,
      anon_sym_DOT,
    ACTIONS(734), 1,
      anon_sym_AT,
    ACTIONS(738), 1,
      anon_sym_LBRACE,
    STATE(200), 1,
      sym__args,
    STATE(334), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [9009] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(420), 37,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [9053] = 27,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(657), 1,
      anon_sym_COLON,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(740), 1,
      sym_identifier,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1019), 1,
      sym_spread_operator,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(654), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [9147] = 27,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(657), 1,
      anon_sym_COLON,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(742), 1,
      sym_identifier,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1019), 1,
      sym_spread_operator,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(654), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [9241] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(442), 37,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [9285] = 27,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(657), 1,
      anon_sym_COLON,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(744), 1,
      sym_identifier,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1019), 1,
      sym_spread_operator,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(654), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [9379] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(430), 37,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [9423] = 27,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(657), 1,
      anon_sym_COLON,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(746), 1,
      sym_identifier,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1019), 1,
      sym_spread_operator,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(654), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [9517] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(424), 37,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [9561] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(446), 37,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [9605] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(434), 37,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [9649] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(438), 37,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [9693] = 7,
    ACTIONS(730), 1,
      anon_sym_LPAREN,
    ACTIONS(738), 1,
      anon_sym_LBRACE,
    ACTIONS(748), 1,
      anon_sym_AT,
    STATE(198), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [9746] = 12,
    ACTIONS(367), 1,
      anon_sym_COLON,
    ACTIONS(750), 1,
      anon_sym_LPAREN,
    ACTIONS(752), 1,
      anon_sym_DOT,
    ACTIONS(754), 1,
      anon_sym_AT,
    ACTIONS(758), 1,
      anon_sym_LBRACE,
    STATE(354), 1,
      sym__args,
    STATE(389), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(365), 11,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [9809] = 12,
    ACTIONS(372), 1,
      anon_sym_COLON,
    ACTIONS(730), 1,
      anon_sym_LPAREN,
    ACTIONS(732), 1,
      anon_sym_DOT,
    ACTIONS(734), 1,
      anon_sym_AT,
    ACTIONS(738), 1,
      anon_sym_LBRACE,
    ACTIONS(760), 1,
      anon_sym_EQ,
    STATE(200), 1,
      sym__args,
    STATE(334), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(365), 12,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [9872] = 12,
    ACTIONS(750), 1,
      anon_sym_LPAREN,
    ACTIONS(752), 1,
      anon_sym_DOT,
    ACTIONS(754), 1,
      anon_sym_AT,
    ACTIONS(758), 1,
      anon_sym_LBRACE,
    STATE(354), 1,
      sym__args,
    STATE(389), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(374), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(372), 4,
      anon_sym_SEMI,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(367), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [9935] = 9,
    ACTIONS(372), 1,
      anon_sym_COLON,
    ACTIONS(730), 1,
      anon_sym_LPAREN,
    ACTIONS(738), 1,
      anon_sym_LBRACE,
    ACTIONS(748), 1,
      anon_sym_AT,
    STATE(198), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [9992] = 9,
    ACTIONS(367), 1,
      anon_sym_COLON,
    ACTIONS(730), 1,
      anon_sym_LPAREN,
    ACTIONS(738), 1,
      anon_sym_LBRACE,
    ACTIONS(748), 1,
      anon_sym_AT,
    STATE(198), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [10049] = 10,
    ACTIONS(750), 1,
      anon_sym_LPAREN,
    ACTIONS(752), 1,
      anon_sym_DOT,
    ACTIONS(754), 1,
      anon_sym_AT,
    ACTIONS(758), 1,
      anon_sym_LBRACE,
    STATE(354), 1,
      sym__args,
    STATE(389), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(378), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 26,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [10108] = 9,
    ACTIONS(730), 1,
      anon_sym_LPAREN,
    ACTIONS(738), 1,
      anon_sym_LBRACE,
    ACTIONS(748), 1,
      anon_sym_AT,
    STATE(198), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(367), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(372), 8,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [10165] = 7,
    ACTIONS(730), 1,
      anon_sym_LPAREN,
    ACTIONS(738), 1,
      anon_sym_LBRACE,
    ACTIONS(748), 1,
      anon_sym_AT,
    STATE(198), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [10218] = 26,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_TILDE,
    ACTIONS(700), 1,
      anon_sym_QMARK,
    ACTIONS(702), 1,
      anon_sym_AT,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(710), 1,
      sym_number,
    STATE(221), 1,
      sym_function_call,
    STATE(347), 1,
      sym_boolean,
    STATE(451), 1,
      sym_binary_operator,
    STATE(472), 1,
      sym_unary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(536), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(860), 1,
      sym_ignored_argument,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(502), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(627), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [10309] = 27,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(762), 1,
      sym_identifier,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(766), 1,
      sym_number,
    STATE(374), 1,
      sym_function_call,
    STATE(449), 1,
      sym_boolean,
    STATE(512), 1,
      sym_parenthesis,
    STATE(539), 1,
      sym_binary_operator,
    STATE(558), 1,
      sym_unary_operator,
    STATE(569), 1,
      sym_cell,
    STATE(581), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1022), 1,
      sym__enum_value,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(555), 4,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(688), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [10402] = 10,
    ACTIONS(750), 1,
      anon_sym_LPAREN,
    ACTIONS(752), 1,
      anon_sym_DOT,
    ACTIONS(754), 1,
      anon_sym_AT,
    ACTIONS(758), 1,
      anon_sym_LBRACE,
    STATE(354), 1,
      sym__args,
    STATE(389), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(363), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 26,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [10461] = 26,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(698), 1,
      anon_sym_TILDE,
    ACTIONS(700), 1,
      anon_sym_QMARK,
    ACTIONS(702), 1,
      anon_sym_AT,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(710), 1,
      sym_number,
    STATE(221), 1,
      sym_function_call,
    STATE(347), 1,
      sym_boolean,
    STATE(451), 1,
      sym_binary_operator,
    STATE(472), 1,
      sym_unary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(536), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(760), 1,
      sym_ignored_argument,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(502), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(610), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [10552] = 27,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(762), 1,
      sym_identifier,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(766), 1,
      sym_number,
    STATE(374), 1,
      sym_function_call,
    STATE(449), 1,
      sym_boolean,
    STATE(512), 1,
      sym_parenthesis,
    STATE(539), 1,
      sym_binary_operator,
    STATE(558), 1,
      sym_unary_operator,
    STATE(569), 1,
      sym_cell,
    STATE(581), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1108), 1,
      sym__enum_value,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(555), 4,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(688), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [10645] = 26,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(617), 1,
      anon_sym_EQ,
    ACTIONS(768), 1,
      sym_identifier,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(772), 1,
      anon_sym_QMARK,
    ACTIONS(774), 1,
      anon_sym_AT,
    ACTIONS(776), 1,
      sym_number,
    STATE(194), 1,
      sym_function_call,
    STATE(211), 1,
      sym_boolean,
    STATE(397), 1,
      sym_unary_operator,
    STATE(426), 1,
      sym_cell,
    STATE(430), 1,
      sym_binary_operator,
    STATE(431), 1,
      sym_not_operator,
    STATE(607), 1,
      sym__binary_expression,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1155), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(420), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(429), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(441), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [10736] = 12,
    ACTIONS(372), 1,
      anon_sym_COLON,
    ACTIONS(750), 1,
      anon_sym_LPAREN,
    ACTIONS(752), 1,
      anon_sym_DOT,
    ACTIONS(754), 1,
      anon_sym_AT,
    ACTIONS(758), 1,
      anon_sym_LBRACE,
    STATE(354), 1,
      sym__args,
    STATE(389), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(365), 11,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [10799] = 23,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(778), 1,
      sym_identifier,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(790), 1,
      sym_number,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    STATE(76), 1,
      sym_function_call,
    STATE(92), 1,
      sym_boolean,
    STATE(137), 1,
      sym_cell,
    STATE(140), 1,
      sym_unary_operator,
    STATE(144), 1,
      sym_binary_operator,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(121), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(139), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(695), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [10883] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(798), 1,
      sym_identifier,
    STATE(393), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(560), 1,
      sym_binary_operator,
    STATE(563), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(562), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(684), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [10971] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(768), 1,
      sym_identifier,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(772), 1,
      anon_sym_QMARK,
    ACTIONS(774), 1,
      anon_sym_AT,
    ACTIONS(776), 1,
      sym_number,
    STATE(194), 1,
      sym_function_call,
    STATE(211), 1,
      sym_boolean,
    STATE(397), 1,
      sym_unary_operator,
    STATE(426), 1,
      sym_cell,
    STATE(430), 1,
      sym_binary_operator,
    STATE(431), 1,
      sym_not_operator,
    STATE(607), 1,
      sym__binary_expression,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1155), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(420), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(382), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(429), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [11059] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(768), 1,
      sym_identifier,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(772), 1,
      anon_sym_QMARK,
    ACTIONS(774), 1,
      anon_sym_AT,
    ACTIONS(776), 1,
      sym_number,
    STATE(194), 1,
      sym_function_call,
    STATE(211), 1,
      sym_boolean,
    STATE(397), 1,
      sym_unary_operator,
    STATE(426), 1,
      sym_cell,
    STATE(430), 1,
      sym_binary_operator,
    STATE(431), 1,
      sym_not_operator,
    STATE(607), 1,
      sym__binary_expression,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1155), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(420), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(394), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(429), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [11147] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(768), 1,
      sym_identifier,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(772), 1,
      anon_sym_QMARK,
    ACTIONS(774), 1,
      anon_sym_AT,
    ACTIONS(776), 1,
      sym_number,
    STATE(194), 1,
      sym_function_call,
    STATE(211), 1,
      sym_boolean,
    STATE(397), 1,
      sym_unary_operator,
    STATE(426), 1,
      sym_cell,
    STATE(430), 1,
      sym_binary_operator,
    STATE(431), 1,
      sym_not_operator,
    STATE(607), 1,
      sym__binary_expression,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1155), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(420), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(402), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(429), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [11235] = 23,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(800), 1,
      sym_identifier,
    ACTIONS(802), 1,
      anon_sym_TILDE,
    ACTIONS(804), 1,
      sym_number,
    STATE(217), 1,
      sym_function_call,
    STATE(360), 1,
      sym_boolean,
    STATE(473), 1,
      sym_unary_operator,
    STATE(494), 1,
      sym_cell,
    STATE(499), 1,
      sym_binary_operator,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(496), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(470), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(693), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [11319] = 23,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(800), 1,
      sym_identifier,
    ACTIONS(802), 1,
      anon_sym_TILDE,
    ACTIONS(804), 1,
      sym_number,
    STATE(217), 1,
      sym_function_call,
    STATE(360), 1,
      sym_boolean,
    STATE(473), 1,
      sym_unary_operator,
    STATE(494), 1,
      sym_cell,
    STATE(499), 1,
      sym_binary_operator,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(498), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(470), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(693), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [11403] = 23,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(800), 1,
      sym_identifier,
    ACTIONS(802), 1,
      anon_sym_TILDE,
    ACTIONS(804), 1,
      sym_number,
    STATE(217), 1,
      sym_function_call,
    STATE(360), 1,
      sym_boolean,
    STATE(473), 1,
      sym_unary_operator,
    STATE(494), 1,
      sym_cell,
    STATE(499), 1,
      sym_binary_operator,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(452), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(470), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(693), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [11487] = 23,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(800), 1,
      sym_identifier,
    ACTIONS(802), 1,
      anon_sym_TILDE,
    ACTIONS(804), 1,
      sym_number,
    STATE(217), 1,
      sym_function_call,
    STATE(360), 1,
      sym_boolean,
    STATE(473), 1,
      sym_unary_operator,
    STATE(494), 1,
      sym_cell,
    STATE(499), 1,
      sym_binary_operator,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(454), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(470), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(693), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [11571] = 23,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(800), 1,
      sym_identifier,
    ACTIONS(802), 1,
      anon_sym_TILDE,
    ACTIONS(804), 1,
      sym_number,
    STATE(217), 1,
      sym_function_call,
    STATE(360), 1,
      sym_boolean,
    STATE(473), 1,
      sym_unary_operator,
    STATE(494), 1,
      sym_cell,
    STATE(499), 1,
      sym_binary_operator,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(455), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(470), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(693), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [11655] = 25,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(802), 1,
      anon_sym_TILDE,
    ACTIONS(806), 1,
      sym_identifier,
    ACTIONS(808), 1,
      sym_number,
    STATE(209), 1,
      sym_function_call,
    STATE(361), 1,
      sym_boolean,
    STATE(453), 1,
      sym_binary_operator,
    STATE(457), 1,
      sym__range_element,
    STATE(486), 1,
      sym_unary_operator,
    STATE(488), 1,
      sym_not_operator,
    STATE(589), 1,
      sym_cell,
    STATE(616), 1,
      sym__binary_expression,
    STATE(985), 1,
      sym_indirect_access,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(485), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(688), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [11743] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(768), 1,
      sym_identifier,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(772), 1,
      anon_sym_QMARK,
    ACTIONS(774), 1,
      anon_sym_AT,
    ACTIONS(776), 1,
      sym_number,
    STATE(194), 1,
      sym_function_call,
    STATE(211), 1,
      sym_boolean,
    STATE(397), 1,
      sym_unary_operator,
    STATE(426), 1,
      sym_cell,
    STATE(430), 1,
      sym_binary_operator,
    STATE(431), 1,
      sym_not_operator,
    STATE(607), 1,
      sym__binary_expression,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1155), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(420), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(424), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(429), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [11831] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(768), 1,
      sym_identifier,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(772), 1,
      anon_sym_QMARK,
    ACTIONS(774), 1,
      anon_sym_AT,
    ACTIONS(776), 1,
      sym_number,
    STATE(194), 1,
      sym_function_call,
    STATE(211), 1,
      sym_boolean,
    STATE(397), 1,
      sym_unary_operator,
    STATE(426), 1,
      sym_cell,
    STATE(430), 1,
      sym_binary_operator,
    STATE(431), 1,
      sym_not_operator,
    STATE(607), 1,
      sym__binary_expression,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1155), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(420), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(429), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(445), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [11919] = 25,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(802), 1,
      anon_sym_TILDE,
    ACTIONS(806), 1,
      sym_identifier,
    ACTIONS(808), 1,
      sym_number,
    STATE(209), 1,
      sym_function_call,
    STATE(361), 1,
      sym_boolean,
    STATE(453), 1,
      sym_binary_operator,
    STATE(486), 1,
      sym_unary_operator,
    STATE(488), 1,
      sym_not_operator,
    STATE(501), 1,
      sym__range_element,
    STATE(589), 1,
      sym_cell,
    STATE(616), 1,
      sym__binary_expression,
    STATE(985), 1,
      sym_indirect_access,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(485), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(688), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [12007] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(744), 1,
      sym_identifier,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(674), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [12095] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(810), 1,
      sym_identifier,
    STATE(398), 1,
      sym_boolean,
    STATE(403), 1,
      sym_function_call,
    STATE(514), 1,
      sym_cell,
    STATE(568), 1,
      sym_binary_operator,
    STATE(570), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(564), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(688), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [12183] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(772), 1,
      anon_sym_QMARK,
    ACTIONS(812), 1,
      sym_identifier,
    ACTIONS(814), 1,
      anon_sym_AT,
    STATE(190), 1,
      sym_function_call,
    STATE(210), 1,
      sym_boolean,
    STATE(379), 1,
      sym_unary_operator,
    STATE(422), 1,
      sym_binary_operator,
    STATE(426), 1,
      sym_cell,
    STATE(493), 1,
      sym_not_operator,
    STATE(607), 1,
      sym__binary_expression,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1155), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(420), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(382), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(434), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [12271] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(744), 1,
      sym_identifier,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(636), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [12359] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(772), 1,
      anon_sym_QMARK,
    ACTIONS(812), 1,
      sym_identifier,
    ACTIONS(814), 1,
      anon_sym_AT,
    STATE(190), 1,
      sym_function_call,
    STATE(210), 1,
      sym_boolean,
    STATE(379), 1,
      sym_unary_operator,
    STATE(422), 1,
      sym_binary_operator,
    STATE(426), 1,
      sym_cell,
    STATE(493), 1,
      sym_not_operator,
    STATE(607), 1,
      sym__binary_expression,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1155), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(420), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(434), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(506), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [12447] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(772), 1,
      anon_sym_QMARK,
    ACTIONS(812), 1,
      sym_identifier,
    ACTIONS(814), 1,
      anon_sym_AT,
    STATE(190), 1,
      sym_function_call,
    STATE(210), 1,
      sym_boolean,
    STATE(379), 1,
      sym_unary_operator,
    STATE(422), 1,
      sym_binary_operator,
    STATE(426), 1,
      sym_cell,
    STATE(493), 1,
      sym_not_operator,
    STATE(607), 1,
      sym__binary_expression,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1155), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(420), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(434), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(507), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [12535] = 23,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(816), 1,
      sym_identifier,
    ACTIONS(818), 1,
      sym_number,
    STATE(189), 1,
      sym_function_call,
    STATE(214), 1,
      sym_boolean,
    STATE(396), 1,
      sym_unary_operator,
    STATE(406), 1,
      sym_binary_operator,
    STATE(437), 1,
      sym_cell,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(392), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(395), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [12619] = 23,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(816), 1,
      sym_identifier,
    ACTIONS(818), 1,
      sym_number,
    STATE(189), 1,
      sym_function_call,
    STATE(214), 1,
      sym_boolean,
    STATE(396), 1,
      sym_unary_operator,
    STATE(406), 1,
      sym_binary_operator,
    STATE(437), 1,
      sym_cell,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(408), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(395), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [12703] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(820), 1,
      sym_identifier,
    ACTIONS(822), 1,
      sym_number,
    STATE(193), 1,
      sym_function_call,
    STATE(213), 1,
      sym_boolean,
    STATE(400), 1,
      sym_unary_operator,
    STATE(401), 1,
      sym_not_operator,
    STATE(409), 1,
      sym_binary_operator,
    STATE(425), 1,
      sym__range_element,
    STATE(590), 1,
      sym_cell,
    STATE(607), 1,
      sym__binary_expression,
    STATE(938), 1,
      sym_indirect_access,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(399), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(688), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [12791] = 23,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(816), 1,
      sym_identifier,
    ACTIONS(818), 1,
      sym_number,
    STATE(189), 1,
      sym_function_call,
    STATE(214), 1,
      sym_boolean,
    STATE(396), 1,
      sym_unary_operator,
    STATE(406), 1,
      sym_binary_operator,
    STATE(437), 1,
      sym_cell,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(436), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(395), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [12875] = 23,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(816), 1,
      sym_identifier,
    ACTIONS(818), 1,
      sym_number,
    STATE(189), 1,
      sym_function_call,
    STATE(214), 1,
      sym_boolean,
    STATE(396), 1,
      sym_unary_operator,
    STATE(406), 1,
      sym_binary_operator,
    STATE(437), 1,
      sym_cell,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(412), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(395), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [12959] = 23,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(816), 1,
      sym_identifier,
    ACTIONS(818), 1,
      sym_number,
    STATE(189), 1,
      sym_function_call,
    STATE(214), 1,
      sym_boolean,
    STATE(396), 1,
      sym_unary_operator,
    STATE(406), 1,
      sym_binary_operator,
    STATE(437), 1,
      sym_cell,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(386), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(395), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(689), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [13043] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(820), 1,
      sym_identifier,
    ACTIONS(822), 1,
      sym_number,
    STATE(193), 1,
      sym_function_call,
    STATE(213), 1,
      sym_boolean,
    STATE(388), 1,
      sym__range_element,
    STATE(400), 1,
      sym_unary_operator,
    STATE(401), 1,
      sym_not_operator,
    STATE(409), 1,
      sym_binary_operator,
    STATE(590), 1,
      sym_cell,
    STATE(607), 1,
      sym__binary_expression,
    STATE(938), 1,
      sym_indirect_access,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(399), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(688), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [13131] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(824), 1,
      sym_identifier,
    ACTIONS(826), 1,
      anon_sym_QMARK,
    ACTIONS(828), 1,
      anon_sym_AT,
    ACTIONS(830), 1,
      sym_number,
    STATE(357), 1,
      sym_function_call,
    STATE(405), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(537), 1,
      sym_unary_operator,
    STATE(540), 1,
      sym_not_operator,
    STATE(545), 1,
      sym_binary_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(520), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(538), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [13219] = 25,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(710), 1,
      sym_number,
    ACTIONS(802), 1,
      anon_sym_TILDE,
    ACTIONS(832), 1,
      anon_sym_QMARK,
    ACTIONS(834), 1,
      anon_sym_AT,
    STATE(221), 1,
      sym_function_call,
    STATE(347), 1,
      sym_boolean,
    STATE(451), 1,
      sym_binary_operator,
    STATE(472), 1,
      sym_unary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(536), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(468), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(502), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [13307] = 25,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(710), 1,
      sym_number,
    ACTIONS(802), 1,
      anon_sym_TILDE,
    ACTIONS(832), 1,
      anon_sym_QMARK,
    ACTIONS(834), 1,
      anon_sym_AT,
    STATE(221), 1,
      sym_function_call,
    STATE(347), 1,
      sym_boolean,
    STATE(451), 1,
      sym_binary_operator,
    STATE(472), 1,
      sym_unary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(536), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(502), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(561), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [13395] = 25,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(710), 1,
      sym_number,
    ACTIONS(802), 1,
      anon_sym_TILDE,
    ACTIONS(832), 1,
      anon_sym_QMARK,
    ACTIONS(834), 1,
      anon_sym_AT,
    STATE(221), 1,
      sym_function_call,
    STATE(347), 1,
      sym_boolean,
    STATE(451), 1,
      sym_binary_operator,
    STATE(472), 1,
      sym_unary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(536), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(502), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(559), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [13483] = 23,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(778), 1,
      sym_identifier,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(790), 1,
      sym_number,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    STATE(76), 1,
      sym_function_call,
    STATE(92), 1,
      sym_boolean,
    STATE(137), 1,
      sym_cell,
    STATE(140), 1,
      sym_unary_operator,
    STATE(144), 1,
      sym_binary_operator,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(120), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(139), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(695), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [13567] = 23,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(778), 1,
      sym_identifier,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(790), 1,
      sym_number,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    STATE(76), 1,
      sym_function_call,
    STATE(92), 1,
      sym_boolean,
    STATE(137), 1,
      sym_cell,
    STATE(140), 1,
      sym_unary_operator,
    STATE(144), 1,
      sym_binary_operator,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(122), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(139), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(695), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [13651] = 23,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(778), 1,
      sym_identifier,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(790), 1,
      sym_number,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    STATE(76), 1,
      sym_function_call,
    STATE(92), 1,
      sym_boolean,
    STATE(137), 1,
      sym_cell,
    STATE(140), 1,
      sym_unary_operator,
    STATE(144), 1,
      sym_binary_operator,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(123), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(139), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(695), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [13735] = 23,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(778), 1,
      sym_identifier,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(790), 1,
      sym_number,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    STATE(76), 1,
      sym_function_call,
    STATE(92), 1,
      sym_boolean,
    STATE(137), 1,
      sym_cell,
    STATE(140), 1,
      sym_unary_operator,
    STATE(144), 1,
      sym_binary_operator,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(124), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(139), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(695), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [13819] = 25,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    ACTIONS(836), 1,
      sym_identifier,
    ACTIONS(838), 1,
      sym_number,
    STATE(78), 1,
      sym_function_call,
    STATE(94), 1,
      sym_boolean,
    STATE(125), 1,
      sym__range_element,
    STATE(142), 1,
      sym_unary_operator,
    STATE(143), 1,
      sym_not_operator,
    STATE(145), 1,
      sym_binary_operator,
    STATE(591), 1,
      sym_cell,
    STATE(611), 1,
      sym__binary_expression,
    STATE(995), 1,
      sym_indirect_access,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(141), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(688), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [13907] = 25,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(700), 1,
      anon_sym_QMARK,
    ACTIONS(702), 1,
      anon_sym_AT,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(710), 1,
      sym_number,
    ACTIONS(802), 1,
      anon_sym_TILDE,
    STATE(221), 1,
      sym_function_call,
    STATE(347), 1,
      sym_boolean,
    STATE(451), 1,
      sym_binary_operator,
    STATE(472), 1,
      sym_unary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(536), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(502), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(556), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [13995] = 5,
    ACTIONS(844), 1,
      anon_sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    STATE(259), 2,
      sym_arguments_statement,
      aux_sym_function_definition_repeat1,
    ACTIONS(840), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(842), 18,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_endfunction,
      anon_sym_classdef,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [14043] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_QMARK,
    ACTIONS(17), 1,
      anon_sym_AT,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(812), 1,
      sym_identifier,
    STATE(190), 1,
      sym_function_call,
    STATE(210), 1,
      sym_boolean,
    STATE(379), 1,
      sym_unary_operator,
    STATE(422), 1,
      sym_binary_operator,
    STATE(426), 1,
      sym_cell,
    STATE(493), 1,
      sym_not_operator,
    STATE(607), 1,
      sym__binary_expression,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1155), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(420), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(434), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(505), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [14131] = 7,
    ACTIONS(750), 1,
      anon_sym_LPAREN,
    ACTIONS(754), 1,
      anon_sym_AT,
    ACTIONS(758), 1,
      anon_sym_LBRACE,
    STATE(354), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(407), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(405), 29,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [14183] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(847), 1,
      sym_identifier,
    ACTIONS(849), 1,
      sym_number,
    STATE(191), 1,
      sym_function_call,
    STATE(206), 1,
      sym_boolean,
    STATE(419), 1,
      sym_unary_operator,
    STATE(427), 1,
      sym_not_operator,
    STATE(428), 1,
      sym_cell,
    STATE(585), 1,
      sym_binary_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(416), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(688), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [14271] = 14,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(853), 1,
      anon_sym_DOT,
    ACTIONS(855), 1,
      anon_sym_AT,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    ACTIONS(861), 1,
      anon_sym_EQ,
    STATE(387), 1,
      sym__args,
    STATE(462), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [14337] = 25,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    ACTIONS(863), 1,
      sym_identifier,
    ACTIONS(865), 1,
      anon_sym_QMARK,
    ACTIONS(867), 1,
      anon_sym_AT,
    ACTIONS(869), 1,
      sym_number,
    STATE(80), 1,
      sym_function_call,
    STATE(100), 1,
      sym_boolean,
    STATE(104), 1,
      sym_unary_operator,
    STATE(106), 1,
      sym_cell,
    STATE(129), 1,
      sym_binary_operator,
    STATE(147), 1,
      sym_not_operator,
    STATE(611), 1,
      sym__binary_expression,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1241), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(105), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(3), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(146), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [14425] = 25,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(700), 1,
      anon_sym_QMARK,
    ACTIONS(702), 1,
      anon_sym_AT,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(710), 1,
      sym_number,
    ACTIONS(802), 1,
      anon_sym_TILDE,
    STATE(221), 1,
      sym_function_call,
    STATE(347), 1,
      sym_boolean,
    STATE(451), 1,
      sym_binary_operator,
    STATE(472), 1,
      sym_unary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(536), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(502), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(557), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [14513] = 25,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    ACTIONS(836), 1,
      sym_identifier,
    ACTIONS(838), 1,
      sym_number,
    STATE(78), 1,
      sym_function_call,
    STATE(94), 1,
      sym_boolean,
    STATE(128), 1,
      sym__range_element,
    STATE(142), 1,
      sym_unary_operator,
    STATE(143), 1,
      sym_not_operator,
    STATE(145), 1,
      sym_binary_operator,
    STATE(591), 1,
      sym_cell,
    STATE(611), 1,
      sym__binary_expression,
    STATE(995), 1,
      sym_indirect_access,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(141), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(688), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [14601] = 25,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    ACTIONS(863), 1,
      sym_identifier,
    ACTIONS(865), 1,
      anon_sym_QMARK,
    ACTIONS(867), 1,
      anon_sym_AT,
    ACTIONS(869), 1,
      sym_number,
    STATE(80), 1,
      sym_function_call,
    STATE(100), 1,
      sym_boolean,
    STATE(104), 1,
      sym_unary_operator,
    STATE(106), 1,
      sym_cell,
    STATE(129), 1,
      sym_binary_operator,
    STATE(147), 1,
      sym_not_operator,
    STATE(611), 1,
      sym__binary_expression,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1241), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(105), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(146), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(158), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [14689] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(454), 35,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [14731] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_QMARK,
    ACTIONS(17), 1,
      anon_sym_AT,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(812), 1,
      sym_identifier,
    STATE(190), 1,
      sym_function_call,
    STATE(210), 1,
      sym_boolean,
    STATE(379), 1,
      sym_unary_operator,
    STATE(422), 1,
      sym_binary_operator,
    STATE(426), 1,
      sym_cell,
    STATE(493), 1,
      sym_not_operator,
    STATE(607), 1,
      sym__binary_expression,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1155), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(420), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(434), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(613), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [14819] = 25,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    ACTIONS(863), 1,
      sym_identifier,
    ACTIONS(865), 1,
      anon_sym_QMARK,
    ACTIONS(867), 1,
      anon_sym_AT,
    ACTIONS(869), 1,
      sym_number,
    STATE(80), 1,
      sym_function_call,
    STATE(100), 1,
      sym_boolean,
    STATE(104), 1,
      sym_unary_operator,
    STATE(106), 1,
      sym_cell,
    STATE(129), 1,
      sym_binary_operator,
    STATE(147), 1,
      sym_not_operator,
    STATE(611), 1,
      sym__binary_expression,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1241), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(105), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(2), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(146), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [14907] = 25,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    ACTIONS(863), 1,
      sym_identifier,
    ACTIONS(869), 1,
      sym_number,
    ACTIONS(871), 1,
      anon_sym_QMARK,
    ACTIONS(873), 1,
      anon_sym_AT,
    STATE(80), 1,
      sym_function_call,
    STATE(100), 1,
      sym_boolean,
    STATE(104), 1,
      sym_unary_operator,
    STATE(106), 1,
      sym_cell,
    STATE(129), 1,
      sym_binary_operator,
    STATE(147), 1,
      sym_not_operator,
    STATE(611), 1,
      sym__binary_expression,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1241), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(105), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(119), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(146), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [14995] = 25,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    ACTIONS(863), 1,
      sym_identifier,
    ACTIONS(869), 1,
      sym_number,
    ACTIONS(871), 1,
      anon_sym_QMARK,
    ACTIONS(873), 1,
      anon_sym_AT,
    STATE(80), 1,
      sym_function_call,
    STATE(100), 1,
      sym_boolean,
    STATE(104), 1,
      sym_unary_operator,
    STATE(106), 1,
      sym_cell,
    STATE(129), 1,
      sym_binary_operator,
    STATE(147), 1,
      sym_not_operator,
    STATE(611), 1,
      sym__binary_expression,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1241), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(105), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(146), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(150), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [15083] = 25,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    ACTIONS(863), 1,
      sym_identifier,
    ACTIONS(869), 1,
      sym_number,
    ACTIONS(871), 1,
      anon_sym_QMARK,
    ACTIONS(873), 1,
      anon_sym_AT,
    STATE(80), 1,
      sym_function_call,
    STATE(100), 1,
      sym_boolean,
    STATE(104), 1,
      sym_unary_operator,
    STATE(106), 1,
      sym_cell,
    STATE(129), 1,
      sym_binary_operator,
    STATE(147), 1,
      sym_not_operator,
    STATE(611), 1,
      sym__binary_expression,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1241), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(105), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(146), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(149), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [15171] = 25,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    ACTIONS(863), 1,
      sym_identifier,
    ACTIONS(865), 1,
      anon_sym_QMARK,
    ACTIONS(867), 1,
      anon_sym_AT,
    ACTIONS(869), 1,
      sym_number,
    STATE(80), 1,
      sym_function_call,
    STATE(100), 1,
      sym_boolean,
    STATE(104), 1,
      sym_unary_operator,
    STATE(106), 1,
      sym_cell,
    STATE(129), 1,
      sym_binary_operator,
    STATE(147), 1,
      sym_not_operator,
    STATE(611), 1,
      sym__binary_expression,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1241), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(105), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(4), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(146), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [15259] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(744), 1,
      sym_identifier,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(634), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [15347] = 25,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    ACTIONS(863), 1,
      sym_identifier,
    ACTIONS(865), 1,
      anon_sym_QMARK,
    ACTIONS(867), 1,
      anon_sym_AT,
    ACTIONS(869), 1,
      sym_number,
    STATE(80), 1,
      sym_function_call,
    STATE(100), 1,
      sym_boolean,
    STATE(104), 1,
      sym_unary_operator,
    STATE(106), 1,
      sym_cell,
    STATE(129), 1,
      sym_binary_operator,
    STATE(147), 1,
      sym_not_operator,
    STATE(611), 1,
      sym__binary_expression,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1241), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(105), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(146), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(148), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [15435] = 14,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(853), 1,
      anon_sym_DOT,
    ACTIONS(855), 1,
      anon_sym_AT,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    ACTIONS(875), 1,
      anon_sym_EQ,
    STATE(387), 1,
      sym__args,
    STATE(462), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [15501] = 14,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(853), 1,
      anon_sym_DOT,
    ACTIONS(855), 1,
      anon_sym_AT,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    ACTIONS(877), 1,
      anon_sym_EQ,
    STATE(387), 1,
      sym__args,
    STATE(462), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [15567] = 14,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(853), 1,
      anon_sym_DOT,
    ACTIONS(855), 1,
      anon_sym_AT,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    ACTIONS(879), 1,
      anon_sym_EQ,
    STATE(387), 1,
      sym__args,
    STATE(462), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [15633] = 4,
    ACTIONS(881), 1,
      anon_sym_DOT,
    STATE(280), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(413), 33,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [15679] = 25,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    ACTIONS(863), 1,
      sym_identifier,
    ACTIONS(865), 1,
      anon_sym_QMARK,
    ACTIONS(867), 1,
      anon_sym_AT,
    ACTIONS(869), 1,
      sym_number,
    STATE(80), 1,
      sym_function_call,
    STATE(100), 1,
      sym_boolean,
    STATE(104), 1,
      sym_unary_operator,
    STATE(106), 1,
      sym_cell,
    STATE(129), 1,
      sym_binary_operator,
    STATE(147), 1,
      sym_not_operator,
    STATE(611), 1,
      sym__binary_expression,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1241), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(105), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(146), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(151), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [15767] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_QMARK,
    ACTIONS(17), 1,
      anon_sym_AT,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(812), 1,
      sym_identifier,
    STATE(190), 1,
      sym_function_call,
    STATE(210), 1,
      sym_boolean,
    STATE(379), 1,
      sym_unary_operator,
    STATE(422), 1,
      sym_binary_operator,
    STATE(426), 1,
      sym_cell,
    STATE(493), 1,
      sym_not_operator,
    STATE(607), 1,
      sym__binary_expression,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1155), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(420), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(434), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(630), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [15855] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(824), 1,
      sym_identifier,
    ACTIONS(826), 1,
      anon_sym_QMARK,
    ACTIONS(828), 1,
      anon_sym_AT,
    ACTIONS(830), 1,
      sym_number,
    STATE(357), 1,
      sym_function_call,
    STATE(405), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(537), 1,
      sym_unary_operator,
    STATE(540), 1,
      sym_not_operator,
    STATE(545), 1,
      sym_binary_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(528), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(538), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [15943] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(824), 1,
      sym_identifier,
    ACTIONS(826), 1,
      anon_sym_QMARK,
    ACTIONS(828), 1,
      anon_sym_AT,
    ACTIONS(830), 1,
      sym_number,
    STATE(357), 1,
      sym_function_call,
    STATE(405), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(537), 1,
      sym_unary_operator,
    STATE(540), 1,
      sym_not_operator,
    STATE(545), 1,
      sym_binary_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(538), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(541), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [16031] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(824), 1,
      sym_identifier,
    ACTIONS(826), 1,
      anon_sym_QMARK,
    ACTIONS(828), 1,
      anon_sym_AT,
    ACTIONS(830), 1,
      sym_number,
    STATE(357), 1,
      sym_function_call,
    STATE(405), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(537), 1,
      sym_unary_operator,
    STATE(540), 1,
      sym_not_operator,
    STATE(545), 1,
      sym_binary_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(538), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(542), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [16119] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(824), 1,
      sym_identifier,
    ACTIONS(826), 1,
      anon_sym_QMARK,
    ACTIONS(828), 1,
      anon_sym_AT,
    ACTIONS(830), 1,
      sym_number,
    STATE(357), 1,
      sym_function_call,
    STATE(405), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(537), 1,
      sym_unary_operator,
    STATE(540), 1,
      sym_not_operator,
    STATE(545), 1,
      sym_binary_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(538), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(543), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [16207] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(824), 1,
      sym_identifier,
    ACTIONS(826), 1,
      anon_sym_QMARK,
    ACTIONS(828), 1,
      anon_sym_AT,
    ACTIONS(830), 1,
      sym_number,
    STATE(357), 1,
      sym_function_call,
    STATE(405), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(537), 1,
      sym_unary_operator,
    STATE(540), 1,
      sym_not_operator,
    STATE(545), 1,
      sym_binary_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(538), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(544), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [16295] = 25,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(607), 1,
      sym_identifier,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(802), 1,
      anon_sym_TILDE,
    ACTIONS(832), 1,
      anon_sym_QMARK,
    ACTIONS(884), 1,
      anon_sym_AT,
    ACTIONS(886), 1,
      sym_number,
    STATE(207), 1,
      sym_function_call,
    STATE(352), 1,
      sym_boolean,
    STATE(464), 1,
      sym_unary_operator,
    STATE(492), 1,
      sym_not_operator,
    STATE(495), 1,
      sym_binary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(616), 1,
      sym__binary_expression,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(468), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(481), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [16383] = 25,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(607), 1,
      sym_identifier,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(802), 1,
      anon_sym_TILDE,
    ACTIONS(832), 1,
      anon_sym_QMARK,
    ACTIONS(884), 1,
      anon_sym_AT,
    ACTIONS(886), 1,
      sym_number,
    STATE(207), 1,
      sym_function_call,
    STATE(352), 1,
      sym_boolean,
    STATE(464), 1,
      sym_unary_operator,
    STATE(492), 1,
      sym_not_operator,
    STATE(495), 1,
      sym_binary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(616), 1,
      sym__binary_expression,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(481), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(500), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [16471] = 25,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(607), 1,
      sym_identifier,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(802), 1,
      anon_sym_TILDE,
    ACTIONS(832), 1,
      anon_sym_QMARK,
    ACTIONS(884), 1,
      anon_sym_AT,
    ACTIONS(886), 1,
      sym_number,
    STATE(207), 1,
      sym_function_call,
    STATE(352), 1,
      sym_boolean,
    STATE(464), 1,
      sym_unary_operator,
    STATE(492), 1,
      sym_not_operator,
    STATE(495), 1,
      sym_binary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(616), 1,
      sym__binary_expression,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(481), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(503), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [16559] = 25,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(607), 1,
      sym_identifier,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(802), 1,
      anon_sym_TILDE,
    ACTIONS(832), 1,
      anon_sym_QMARK,
    ACTIONS(884), 1,
      anon_sym_AT,
    ACTIONS(886), 1,
      sym_number,
    STATE(207), 1,
      sym_function_call,
    STATE(352), 1,
      sym_boolean,
    STATE(464), 1,
      sym_unary_operator,
    STATE(492), 1,
      sym_not_operator,
    STATE(495), 1,
      sym_binary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(616), 1,
      sym__binary_expression,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(461), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(481), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [16647] = 25,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(607), 1,
      sym_identifier,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(802), 1,
      anon_sym_TILDE,
    ACTIONS(832), 1,
      anon_sym_QMARK,
    ACTIONS(884), 1,
      anon_sym_AT,
    ACTIONS(886), 1,
      sym_number,
    STATE(207), 1,
      sym_function_call,
    STATE(352), 1,
      sym_boolean,
    STATE(464), 1,
      sym_unary_operator,
    STATE(492), 1,
      sym_not_operator,
    STATE(495), 1,
      sym_binary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(616), 1,
      sym__binary_expression,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(466), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(481), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [16735] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(744), 1,
      sym_identifier,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(633), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [16823] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(744), 1,
      sym_identifier,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(637), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [16911] = 25,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    ACTIONS(871), 1,
      anon_sym_QMARK,
    ACTIONS(888), 1,
      sym_identifier,
    ACTIONS(890), 1,
      anon_sym_AT,
    ACTIONS(892), 1,
      sym_number,
    STATE(77), 1,
      sym_function_call,
    STATE(91), 1,
      sym_boolean,
    STATE(106), 1,
      sym_cell,
    STATE(130), 1,
      sym_unary_operator,
    STATE(132), 1,
      sym_not_operator,
    STATE(138), 1,
      sym_binary_operator,
    STATE(611), 1,
      sym__binary_expression,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1241), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(105), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(119), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(131), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [16999] = 25,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    ACTIONS(871), 1,
      anon_sym_QMARK,
    ACTIONS(888), 1,
      sym_identifier,
    ACTIONS(890), 1,
      anon_sym_AT,
    ACTIONS(892), 1,
      sym_number,
    STATE(77), 1,
      sym_function_call,
    STATE(91), 1,
      sym_boolean,
    STATE(106), 1,
      sym_cell,
    STATE(130), 1,
      sym_unary_operator,
    STATE(132), 1,
      sym_not_operator,
    STATE(138), 1,
      sym_binary_operator,
    STATE(611), 1,
      sym__binary_expression,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1241), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(105), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(131), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(133), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [17087] = 25,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    ACTIONS(871), 1,
      anon_sym_QMARK,
    ACTIONS(888), 1,
      sym_identifier,
    ACTIONS(890), 1,
      anon_sym_AT,
    ACTIONS(892), 1,
      sym_number,
    STATE(77), 1,
      sym_function_call,
    STATE(91), 1,
      sym_boolean,
    STATE(106), 1,
      sym_cell,
    STATE(130), 1,
      sym_unary_operator,
    STATE(132), 1,
      sym_not_operator,
    STATE(138), 1,
      sym_binary_operator,
    STATE(611), 1,
      sym__binary_expression,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1241), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(105), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(131), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(134), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [17175] = 25,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    ACTIONS(871), 1,
      anon_sym_QMARK,
    ACTIONS(888), 1,
      sym_identifier,
    ACTIONS(890), 1,
      anon_sym_AT,
    ACTIONS(892), 1,
      sym_number,
    STATE(77), 1,
      sym_function_call,
    STATE(91), 1,
      sym_boolean,
    STATE(106), 1,
      sym_cell,
    STATE(130), 1,
      sym_unary_operator,
    STATE(132), 1,
      sym_not_operator,
    STATE(138), 1,
      sym_binary_operator,
    STATE(611), 1,
      sym__binary_expression,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1241), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(105), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(131), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(135), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [17263] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(744), 1,
      sym_identifier,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(648), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [17351] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_QMARK,
    ACTIONS(17), 1,
      anon_sym_AT,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(812), 1,
      sym_identifier,
    STATE(190), 1,
      sym_function_call,
    STATE(210), 1,
      sym_boolean,
    STATE(379), 1,
      sym_unary_operator,
    STATE(422), 1,
      sym_binary_operator,
    STATE(426), 1,
      sym_cell,
    STATE(493), 1,
      sym_not_operator,
    STATE(607), 1,
      sym__binary_expression,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1155), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(420), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(434), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(509), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [17439] = 25,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    ACTIONS(871), 1,
      anon_sym_QMARK,
    ACTIONS(888), 1,
      sym_identifier,
    ACTIONS(890), 1,
      anon_sym_AT,
    ACTIONS(892), 1,
      sym_number,
    STATE(77), 1,
      sym_function_call,
    STATE(91), 1,
      sym_boolean,
    STATE(106), 1,
      sym_cell,
    STATE(130), 1,
      sym_unary_operator,
    STATE(132), 1,
      sym_not_operator,
    STATE(138), 1,
      sym_binary_operator,
    STATE(611), 1,
      sym__binary_expression,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1241), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(105), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(131), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(136), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [17527] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(768), 1,
      sym_identifier,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(772), 1,
      anon_sym_QMARK,
    ACTIONS(774), 1,
      anon_sym_AT,
    ACTIONS(776), 1,
      sym_number,
    STATE(194), 1,
      sym_function_call,
    STATE(211), 1,
      sym_boolean,
    STATE(397), 1,
      sym_unary_operator,
    STATE(426), 1,
      sym_cell,
    STATE(430), 1,
      sym_binary_operator,
    STATE(431), 1,
      sym_not_operator,
    STATE(607), 1,
      sym__binary_expression,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1155), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(420), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(429), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(441), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [17615] = 5,
    STATE(318), 1,
      aux_sym__block_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(894), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(343), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(272), 18,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_endfunction,
      anon_sym_classdef,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [17663] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(826), 1,
      anon_sym_QMARK,
    ACTIONS(896), 1,
      sym_identifier,
    ACTIONS(898), 1,
      anon_sym_AT,
    STATE(366), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(528), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [17751] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(826), 1,
      anon_sym_QMARK,
    ACTIONS(896), 1,
      sym_identifier,
    ACTIONS(898), 1,
      anon_sym_AT,
    STATE(366), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(582), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [17839] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(826), 1,
      anon_sym_QMARK,
    ACTIONS(896), 1,
      sym_identifier,
    ACTIONS(898), 1,
      anon_sym_AT,
    STATE(366), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(587), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [17927] = 23,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(900), 1,
      sym_identifier,
    ACTIONS(902), 1,
      sym_number,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(546), 1,
      sym_cell,
    STATE(549), 1,
      sym_unary_operator,
    STATE(553), 1,
      sym_binary_operator,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(529), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(548), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(691), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [18011] = 23,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(900), 1,
      sym_identifier,
    ACTIONS(902), 1,
      sym_number,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(546), 1,
      sym_cell,
    STATE(549), 1,
      sym_unary_operator,
    STATE(553), 1,
      sym_binary_operator,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(530), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(548), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(691), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [18095] = 23,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(900), 1,
      sym_identifier,
    ACTIONS(902), 1,
      sym_number,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(546), 1,
      sym_cell,
    STATE(549), 1,
      sym_unary_operator,
    STATE(553), 1,
      sym_binary_operator,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(531), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(548), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(691), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [18179] = 23,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(900), 1,
      sym_identifier,
    ACTIONS(902), 1,
      sym_number,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(546), 1,
      sym_cell,
    STATE(549), 1,
      sym_unary_operator,
    STATE(553), 1,
      sym_binary_operator,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(532), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(548), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(691), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [18263] = 23,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(900), 1,
      sym_identifier,
    ACTIONS(902), 1,
      sym_number,
    STATE(358), 1,
      sym_function_call,
    STATE(404), 1,
      sym_boolean,
    STATE(546), 1,
      sym_cell,
    STATE(549), 1,
      sym_unary_operator,
    STATE(553), 1,
      sym_binary_operator,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(510), 4,
      sym__binary_expression,
      sym_not_operator,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(548), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(691), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [18347] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(904), 1,
      sym_identifier,
    ACTIONS(906), 1,
      sym_number,
    STATE(346), 1,
      sym_function_call,
    STATE(410), 1,
      sym_boolean,
    STATE(517), 1,
      sym_unary_operator,
    STATE(518), 1,
      sym_not_operator,
    STATE(519), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(516), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(688), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [18435] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(908), 1,
      sym_identifier,
    ACTIONS(910), 1,
      sym_number,
    STATE(359), 1,
      sym_function_call,
    STATE(407), 1,
      sym_boolean,
    STATE(511), 1,
      sym_binary_operator,
    STATE(514), 1,
      sym_cell,
    STATE(533), 1,
      sym__range_element,
    STATE(551), 1,
      sym_unary_operator,
    STATE(552), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(550), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(688), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [18523] = 5,
    STATE(322), 1,
      aux_sym__block_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(912), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(686), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(688), 18,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_endfunction,
      anon_sym_classdef,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [18571] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(914), 1,
      sym_identifier,
    STATE(398), 1,
      sym_boolean,
    STATE(433), 1,
      sym_function_call,
    STATE(514), 1,
      sym_cell,
    STATE(573), 1,
      sym_binary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(578), 1,
      sym_unary_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(572), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(688), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [18659] = 25,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    ACTIONS(871), 1,
      anon_sym_QMARK,
    ACTIONS(888), 1,
      sym_identifier,
    ACTIONS(890), 1,
      anon_sym_AT,
    ACTIONS(892), 1,
      sym_number,
    STATE(77), 1,
      sym_function_call,
    STATE(91), 1,
      sym_boolean,
    STATE(106), 1,
      sym_cell,
    STATE(130), 1,
      sym_unary_operator,
    STATE(132), 1,
      sym_not_operator,
    STATE(138), 1,
      sym_binary_operator,
    STATE(611), 1,
      sym__binary_expression,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1241), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(105), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(112), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(131), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [18747] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(896), 1,
      sym_identifier,
    STATE(366), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(584), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [18835] = 5,
    STATE(324), 1,
      aux_sym__block_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(916), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(671), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(673), 18,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_endfunction,
      anon_sym_classdef,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [18883] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(772), 1,
      anon_sym_QMARK,
    ACTIONS(812), 1,
      sym_identifier,
    ACTIONS(814), 1,
      anon_sym_AT,
    STATE(190), 1,
      sym_function_call,
    STATE(210), 1,
      sym_boolean,
    STATE(379), 1,
      sym_unary_operator,
    STATE(422), 1,
      sym_binary_operator,
    STATE(426), 1,
      sym_cell,
    STATE(493), 1,
      sym_not_operator,
    STATE(607), 1,
      sym__binary_expression,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1155), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(420), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(434), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(505), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [18971] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(896), 1,
      sym_identifier,
    STATE(366), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(682), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [19059] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(772), 1,
      anon_sym_QMARK,
    ACTIONS(812), 1,
      sym_identifier,
    ACTIONS(814), 1,
      anon_sym_AT,
    STATE(190), 1,
      sym_function_call,
    STATE(210), 1,
      sym_boolean,
    STATE(379), 1,
      sym_unary_operator,
    STATE(422), 1,
      sym_binary_operator,
    STATE(426), 1,
      sym_cell,
    STATE(493), 1,
      sym_not_operator,
    STATE(607), 1,
      sym__binary_expression,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1155), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(420), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(434), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(509), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [19147] = 5,
    STATE(324), 1,
      aux_sym__block_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(916), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(633), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(635), 18,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_endfunction,
      anon_sym_classdef,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [19195] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(896), 1,
      sym_identifier,
    STATE(366), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(588), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [19283] = 5,
    STATE(324), 1,
      aux_sym__block_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(918), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(675), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(677), 18,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_function,
      anon_sym_endfunction,
      anon_sym_classdef,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [19331] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(908), 1,
      sym_identifier,
    ACTIONS(910), 1,
      sym_number,
    STATE(359), 1,
      sym_function_call,
    STATE(407), 1,
      sym_boolean,
    STATE(511), 1,
      sym_binary_operator,
    STATE(514), 1,
      sym_cell,
    STATE(551), 1,
      sym_unary_operator,
    STATE(552), 1,
      sym_not_operator,
    STATE(554), 1,
      sym__range_element,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(550), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(688), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [19419] = 25,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(802), 1,
      anon_sym_TILDE,
    ACTIONS(921), 1,
      sym_identifier,
    ACTIONS(923), 1,
      sym_number,
    STATE(212), 1,
      sym_function_call,
    STATE(369), 1,
      sym_boolean,
    STATE(487), 1,
      sym_unary_operator,
    STATE(489), 1,
      sym_not_operator,
    STATE(490), 1,
      sym_cell,
    STATE(586), 1,
      sym_binary_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(484), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(688), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [19507] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_QMARK,
    ACTIONS(17), 1,
      anon_sym_AT,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(812), 1,
      sym_identifier,
    STATE(190), 1,
      sym_function_call,
    STATE(210), 1,
      sym_boolean,
    STATE(379), 1,
      sym_unary_operator,
    STATE(422), 1,
      sym_binary_operator,
    STATE(426), 1,
      sym_cell,
    STATE(493), 1,
      sym_not_operator,
    STATE(607), 1,
      sym__binary_expression,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1155), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(420), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(434), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(628), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [19595] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(925), 1,
      sym_identifier,
    STATE(391), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(574), 1,
      sym_binary_operator,
    STATE(575), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(576), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(688), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [19683] = 25,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(607), 1,
      sym_identifier,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(802), 1,
      anon_sym_TILDE,
    ACTIONS(832), 1,
      anon_sym_QMARK,
    ACTIONS(884), 1,
      anon_sym_AT,
    ACTIONS(886), 1,
      sym_number,
    STATE(207), 1,
      sym_function_call,
    STATE(352), 1,
      sym_boolean,
    STATE(464), 1,
      sym_unary_operator,
    STATE(492), 1,
      sym_not_operator,
    STATE(495), 1,
      sym_binary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(616), 1,
      sym__binary_expression,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(458), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
    STATE(481), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
  [19771] = 25,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    ACTIONS(927), 1,
      sym_identifier,
    ACTIONS(929), 1,
      sym_number,
    STATE(79), 1,
      sym_function_call,
    STATE(97), 1,
      sym_boolean,
    STATE(109), 1,
      sym_unary_operator,
    STATE(110), 1,
      sym_not_operator,
    STATE(111), 1,
      sym_cell,
    STATE(583), 1,
      sym_binary_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(108), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(688), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [19859] = 25,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(15), 1,
      anon_sym_QMARK,
    ACTIONS(17), 1,
      anon_sym_AT,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_LBRACE,
    ACTIONS(45), 1,
      sym_number,
    ACTIONS(51), 1,
      sym__single_quote_string_start,
    ACTIONS(53), 1,
      sym__double_quote_string_start,
    ACTIONS(770), 1,
      anon_sym_TILDE,
    ACTIONS(812), 1,
      sym_identifier,
    STATE(190), 1,
      sym_function_call,
    STATE(210), 1,
      sym_boolean,
    STATE(379), 1,
      sym_unary_operator,
    STATE(422), 1,
      sym_binary_operator,
    STATE(426), 1,
      sym_cell,
    STATE(493), 1,
      sym_not_operator,
    STATE(607), 1,
      sym__binary_expression,
    STATE(938), 1,
      sym_indirect_access,
    STATE(1155), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(11), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(47), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(420), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(434), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(594), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [19947] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(931), 1,
      sym_identifier,
    STATE(398), 1,
      sym_boolean,
    STATE(439), 1,
      sym_function_call,
    STATE(514), 1,
      sym_cell,
    STATE(565), 1,
      sym_binary_operator,
    STATE(566), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(567), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(688), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [20035] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(933), 1,
      sym_identifier,
    STATE(398), 1,
      sym_boolean,
    STATE(432), 1,
      sym_function_call,
    STATE(514), 1,
      sym_cell,
    STATE(571), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(580), 1,
      sym_binary_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(579), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(688), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [20123] = 4,
    ACTIONS(732), 1,
      anon_sym_DOT,
    STATE(280), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(409), 33,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_EQ,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [20169] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(798), 1,
      sym_identifier,
    STATE(393), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(560), 1,
      sym_binary_operator,
    STATE(563), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(562), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(680), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [20257] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(744), 1,
      sym_identifier,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(584), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [20345] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(649), 1,
      anon_sym_AT,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(744), 1,
      sym_identifier,
    STATE(348), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(588), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [20433] = 25,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(710), 1,
      sym_number,
    ACTIONS(802), 1,
      anon_sym_TILDE,
    ACTIONS(832), 1,
      anon_sym_QMARK,
    ACTIONS(834), 1,
      anon_sym_AT,
    STATE(221), 1,
      sym_function_call,
    STATE(347), 1,
      sym_boolean,
    STATE(451), 1,
      sym_binary_operator,
    STATE(472), 1,
      sym_unary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(536), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(502), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(556), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [20521] = 25,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(596), 1,
      sym__single_quote_string_start,
    ACTIONS(598), 1,
      sym__double_quote_string_start,
    ACTIONS(694), 1,
      anon_sym_LPAREN,
    ACTIONS(704), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_LBRACE,
    ACTIONS(710), 1,
      sym_number,
    ACTIONS(802), 1,
      anon_sym_TILDE,
    ACTIONS(832), 1,
      anon_sym_QMARK,
    ACTIONS(834), 1,
      anon_sym_AT,
    STATE(221), 1,
      sym_function_call,
    STATE(347), 1,
      sym_boolean,
    STATE(451), 1,
      sym_binary_operator,
    STATE(472), 1,
      sym_unary_operator,
    STATE(504), 1,
      sym_cell,
    STATE(536), 1,
      sym_not_operator,
    STATE(616), 1,
      sym__binary_expression,
    STATE(985), 1,
      sym_indirect_access,
    STATE(1154), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(594), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(696), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(474), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(502), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(557), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [20609] = 25,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    ACTIONS(863), 1,
      sym_identifier,
    ACTIONS(869), 1,
      sym_number,
    ACTIONS(871), 1,
      anon_sym_QMARK,
    ACTIONS(873), 1,
      anon_sym_AT,
    STATE(80), 1,
      sym_function_call,
    STATE(100), 1,
      sym_boolean,
    STATE(104), 1,
      sym_unary_operator,
    STATE(106), 1,
      sym_cell,
    STATE(129), 1,
      sym_binary_operator,
    STATE(147), 1,
      sym_not_operator,
    STATE(611), 1,
      sym__binary_expression,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1241), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(105), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(146), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(148), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [20697] = 25,
    ACTIONS(780), 1,
      anon_sym_LPAREN,
    ACTIONS(784), 1,
      anon_sym_TILDE,
    ACTIONS(786), 1,
      anon_sym_LBRACK,
    ACTIONS(788), 1,
      anon_sym_LBRACE,
    ACTIONS(794), 1,
      sym__single_quote_string_start,
    ACTIONS(796), 1,
      sym__double_quote_string_start,
    ACTIONS(863), 1,
      sym_identifier,
    ACTIONS(869), 1,
      sym_number,
    ACTIONS(871), 1,
      anon_sym_QMARK,
    ACTIONS(873), 1,
      anon_sym_AT,
    STATE(80), 1,
      sym_function_call,
    STATE(100), 1,
      sym_boolean,
    STATE(104), 1,
      sym_unary_operator,
    STATE(106), 1,
      sym_cell,
    STATE(129), 1,
      sym_binary_operator,
    STATE(147), 1,
      sym_not_operator,
    STATE(611), 1,
      sym__binary_expression,
    STATE(995), 1,
      sym_indirect_access,
    STATE(1241), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(782), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(792), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(105), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(146), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(151), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [20785] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(798), 1,
      sym_identifier,
    STATE(393), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(560), 1,
      sym_binary_operator,
    STATE(563), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(562), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(685), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [20873] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(826), 1,
      anon_sym_QMARK,
    ACTIONS(896), 1,
      sym_identifier,
    ACTIONS(898), 1,
      anon_sym_AT,
    STATE(366), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(584), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [20961] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(826), 1,
      anon_sym_QMARK,
    ACTIONS(896), 1,
      sym_identifier,
    ACTIONS(898), 1,
      anon_sym_AT,
    STATE(366), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(539), 1,
      sym_binary_operator,
    STATE(547), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(512), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(588), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [21049] = 25,
    ACTIONS(641), 1,
      anon_sym_LPAREN,
    ACTIONS(645), 1,
      anon_sym_TILDE,
    ACTIONS(647), 1,
      anon_sym_QMARK,
    ACTIONS(651), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      anon_sym_LBRACE,
    ACTIONS(659), 1,
      sym_number,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(764), 1,
      anon_sym_AT,
    ACTIONS(798), 1,
      sym_identifier,
    STATE(393), 1,
      sym_function_call,
    STATE(398), 1,
      sym_boolean,
    STATE(514), 1,
      sym_cell,
    STATE(560), 1,
      sym_binary_operator,
    STATE(563), 1,
      sym_unary_operator,
    STATE(577), 1,
      sym_not_operator,
    STATE(614), 1,
      sym__binary_expression,
    STATE(975), 1,
      sym_indirect_access,
    STATE(1247), 1,
      sym__range_element,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(643), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(513), 2,
      sym_comparison_operator,
      sym_boolean_operator,
    STATE(562), 5,
      sym_parenthesis,
      sym_field_expression,
      sym_postfix_operator,
      sym_string,
      sym_matrix,
    STATE(676), 5,
      sym__expression,
      sym_metaclass_operator,
      sym_handle_operator,
      sym_range,
      sym_lambda,
  [21137] = 10,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(853), 1,
      anon_sym_DOT,
    ACTIONS(855), 1,
      anon_sym_AT,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    STATE(387), 1,
      sym__args,
    STATE(462), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(378), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [21194] = 10,
    ACTIONS(372), 1,
      anon_sym_COLON,
    ACTIONS(750), 1,
      anon_sym_LPAREN,
    ACTIONS(758), 1,
      anon_sym_LBRACE,
    ACTIONS(935), 1,
      anon_sym_AT,
    STATE(362), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(365), 11,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [21251] = 13,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(853), 1,
      anon_sym_DOT,
    ACTIONS(855), 1,
      anon_sym_AT,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    STATE(387), 1,
      sym__args,
    STATE(456), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [21314] = 4,
    ACTIONS(937), 1,
      anon_sym_DOT,
    STATE(353), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(397), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [21359] = 4,
    ACTIONS(937), 1,
      anon_sym_DOT,
    STATE(355), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(401), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [21404] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(436), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(434), 32,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [21447] = 10,
    ACTIONS(367), 1,
      anon_sym_COLON,
    ACTIONS(750), 1,
      anon_sym_LPAREN,
    ACTIONS(758), 1,
      anon_sym_LBRACE,
    ACTIONS(935), 1,
      anon_sym_AT,
    STATE(362), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(365), 11,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [21504] = 4,
    ACTIONS(937), 1,
      anon_sym_DOT,
    STATE(364), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(380), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [21549] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(432), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(430), 32,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [21592] = 4,
    ACTIONS(937), 1,
      anon_sym_DOT,
    STATE(364), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(386), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [21637] = 14,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(853), 1,
      anon_sym_DOT,
    ACTIONS(855), 1,
      anon_sym_AT,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    ACTIONS(877), 1,
      anon_sym_EQ,
    STATE(387), 1,
      sym__args,
    STATE(462), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 8,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [21702] = 13,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(853), 1,
      anon_sym_DOT,
    ACTIONS(855), 1,
      anon_sym_AT,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    ACTIONS(939), 1,
      anon_sym_COLON,
    STATE(387), 1,
      sym__args,
    STATE(462), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [21765] = 10,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(853), 1,
      anon_sym_DOT,
    ACTIONS(855), 1,
      anon_sym_AT,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    STATE(387), 1,
      sym__args,
    STATE(462), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(363), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [21822] = 13,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(853), 1,
      anon_sym_DOT,
    ACTIONS(855), 1,
      anon_sym_AT,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    STATE(387), 1,
      sym__args,
    STATE(462), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(367), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(374), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(939), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [21885] = 8,
    ACTIONS(750), 1,
      anon_sym_LPAREN,
    ACTIONS(758), 1,
      anon_sym_LBRACE,
    ACTIONS(935), 1,
      anon_sym_AT,
    STATE(362), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(363), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 26,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [21938] = 10,
    ACTIONS(750), 1,
      anon_sym_LPAREN,
    ACTIONS(758), 1,
      anon_sym_LBRACE,
    ACTIONS(935), 1,
      anon_sym_AT,
    STATE(362), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(374), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(372), 4,
      anon_sym_SEMI,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(367), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [21995] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(444), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(442), 32,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [22038] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(440), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(438), 32,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [22081] = 4,
    ACTIONS(942), 1,
      anon_sym_DOT,
    STATE(364), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(390), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [22126] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(448), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(446), 32,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [22169] = 13,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(853), 1,
      anon_sym_DOT,
    ACTIONS(855), 1,
      anon_sym_AT,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    STATE(387), 1,
      sym__args,
    STATE(462), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [22232] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(426), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(424), 32,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [22275] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(422), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(420), 32,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [22318] = 8,
    ACTIONS(750), 1,
      anon_sym_LPAREN,
    ACTIONS(758), 1,
      anon_sym_LBRACE,
    ACTIONS(935), 1,
      anon_sym_AT,
    STATE(362), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(378), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 26,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [22371] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(945), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(947), 19,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_arguments,
      anon_sym_function,
      anon_sym_endfunction,
      anon_sym_classdef,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [22413] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(949), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(951), 19,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_arguments,
      anon_sym_function,
      anon_sym_endfunction,
      anon_sym_classdef,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [22455] = 7,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(855), 1,
      anon_sym_AT,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    STATE(387), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(405), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(407), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [22505] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(953), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(955), 19,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_arguments,
      anon_sym_function,
      anon_sym_endfunction,
      anon_sym_classdef,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [22547] = 14,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(853), 1,
      anon_sym_DOT,
    ACTIONS(855), 1,
      anon_sym_AT,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    STATE(387), 1,
      sym__args,
    STATE(462), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(957), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [22611] = 13,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(853), 1,
      anon_sym_DOT,
    ACTIONS(855), 1,
      anon_sym_AT,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    STATE(387), 1,
      sym__args,
    STATE(456), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 8,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [22673] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(390), 33,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [22713] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(456), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(454), 31,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [22755] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(959), 14,
      sym_command_name,
      sym__single_quote_string_start,
      sym__double_quote_string_start,
      sym__multioutput_variable_start,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_number,
    ACTIONS(961), 19,
      sym_return_statement,
      sym_continue_statement,
      sym_break_statement,
      anon_sym_if,
      anon_sym_end,
      anon_sym_for,
      anon_sym_parfor,
      anon_sym_while,
      anon_sym_switch,
      anon_sym_global,
      anon_sym_persistent,
      anon_sym_arguments,
      anon_sym_function,
      anon_sym_endfunction,
      anon_sym_classdef,
      anon_sym_try,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [22797] = 5,
    ACTIONS(458), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [22842] = 5,
    ACTIONS(963), 1,
      anon_sym_DOT,
    STATE(383), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(399), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(397), 28,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [22887] = 5,
    ACTIONS(963), 1,
      anon_sym_DOT,
    STATE(384), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(403), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(401), 28,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [22932] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(494), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [22971] = 5,
    ACTIONS(963), 1,
      anon_sym_DOT,
    STATE(385), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(384), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(380), 28,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [23016] = 5,
    ACTIONS(963), 1,
      anon_sym_DOT,
    STATE(385), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(388), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(386), 28,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [23061] = 5,
    ACTIONS(965), 1,
      anon_sym_DOT,
    STATE(385), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(395), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(390), 28,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [23106] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(972), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(968), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(970), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(498), 20,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [23151] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(430), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(432), 27,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [23192] = 3,
    ACTIONS(974), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(510), 31,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [23233] = 5,
    ACTIONS(752), 1,
      anon_sym_DOT,
    STATE(418), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(411), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(409), 28,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [23278] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(438), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(440), 27,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [23319] = 14,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(853), 1,
      anon_sym_DOT,
    ACTIONS(855), 1,
      anon_sym_AT,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    ACTIONS(976), 1,
      anon_sym_RPAREN,
    STATE(387), 1,
      sym__args,
    STATE(462), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [23382] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(972), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(970), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(498), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [23425] = 13,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(853), 1,
      anon_sym_DOT,
    ACTIONS(855), 1,
      anon_sym_AT,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    STATE(387), 1,
      sym__args,
    STATE(462), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 7,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [23486] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(978), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(538), 26,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [23527] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [23568] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [23609] = 5,
    ACTIONS(535), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [23654] = 11,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    ACTIONS(980), 1,
      anon_sym_AT,
    STATE(414), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [23711] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(367), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(372), 8,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [23756] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(458), 8,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(535), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [23801] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(367), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(372), 10,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [23844] = 4,
    ACTIONS(982), 1,
      anon_sym_AMP_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(978), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(538), 25,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [23887] = 14,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(853), 1,
      anon_sym_DOT,
    ACTIONS(855), 1,
      anon_sym_AT,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    ACTIONS(984), 1,
      anon_sym_RPAREN,
    STATE(387), 1,
      sym__args,
    STATE(462), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [23950] = 8,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    ACTIONS(980), 1,
      anon_sym_AT,
    STATE(414), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(363), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [24001] = 11,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    ACTIONS(939), 1,
      anon_sym_COLON,
    ACTIONS(980), 1,
      anon_sym_AT,
    STATE(414), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [24058] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24099] = 11,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    ACTIONS(980), 1,
      anon_sym_AT,
    STATE(414), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(367), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(374), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(939), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [24156] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(972), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(498), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24197] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(533), 8,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(554), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [24242] = 8,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    ACTIONS(980), 1,
      anon_sym_AT,
    STATE(414), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(378), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [24293] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(516), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24332] = 6,
    ACTIONS(986), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(972), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(968), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(970), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(498), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24379] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(474), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24418] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(442), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(444), 27,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [24459] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(478), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24498] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24539] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(482), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24578] = 5,
    ACTIONS(988), 1,
      anon_sym_DOT,
    STATE(418), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(418), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(413), 28,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [24623] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24664] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 18,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24705] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(486), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24744] = 5,
    ACTIONS(533), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24789] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(490), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24828] = 5,
    ACTIONS(982), 1,
      anon_sym_AMP_AMP,
    ACTIONS(991), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(978), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(544), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24873] = 4,
    ACTIONS(529), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(526), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(524), 23,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24916] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24959] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(376), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [24998] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25039] = 5,
    ACTIONS(367), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25084] = 5,
    ACTIONS(554), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25129] = 4,
    ACTIONS(367), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 17,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25172] = 14,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(853), 1,
      anon_sym_DOT,
    ACTIONS(855), 1,
      anon_sym_AT,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    ACTIONS(993), 1,
      anon_sym_RPAREN,
    STATE(387), 1,
      sym__args,
    STATE(462), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [25235] = 14,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(853), 1,
      anon_sym_DOT,
    ACTIONS(855), 1,
      anon_sym_AT,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    ACTIONS(995), 1,
      anon_sym_RPAREN,
    STATE(387), 1,
      sym__args,
    STATE(462), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [25298] = 5,
    ACTIONS(372), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25343] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(446), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(448), 27,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [25384] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(972), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(498), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25425] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 30,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25466] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(424), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(426), 27,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [25507] = 14,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(853), 1,
      anon_sym_DOT,
    ACTIONS(855), 1,
      anon_sym_AT,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    ACTIONS(997), 1,
      anon_sym_RPAREN,
    STATE(387), 1,
      sym__args,
    STATE(462), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [25570] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(460), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25609] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(978), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(464), 26,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25650] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(470), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25689] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(450), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25728] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(420), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(422), 27,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [25769] = 5,
    ACTIONS(982), 1,
      anon_sym_AMP_AMP,
    ACTIONS(991), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(978), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(550), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25814] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(434), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(436), 27,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [25855] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(520), 32,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_COLON,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [25894] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(454), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(456), 27,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [25934] = 12,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(859), 1,
      anon_sym_LBRACE,
    ACTIONS(980), 1,
      anon_sym_AT,
    STATE(414), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(957), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [25992] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(395), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(390), 29,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26032] = 6,
    ACTIONS(533), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(365), 11,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [26077] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(504), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(999), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(498), 26,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26118] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(559), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(533), 4,
      anon_sym_SEMI,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(554), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [26163] = 7,
    ACTIONS(1005), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(504), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(999), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(1001), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(1003), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(498), 15,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26210] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(504), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(999), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(1001), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(1003), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(498), 16,
      anon_sym_SEMI,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26255] = 5,
    ACTIONS(853), 1,
      anon_sym_DOT,
    STATE(463), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(409), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(411), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26298] = 4,
    ACTIONS(1007), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(514), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(510), 27,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [26339] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(468), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1009), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(464), 22,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26380] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(480), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(478), 28,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26419] = 5,
    ACTIONS(1011), 1,
      anon_sym_DOT,
    STATE(477), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(380), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(384), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26462] = 6,
    ACTIONS(1013), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1015), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(548), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1009), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(544), 20,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26507] = 5,
    ACTIONS(853), 1,
      anon_sym_DOT,
    STATE(463), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(409), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(411), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26550] = 5,
    ACTIONS(1017), 1,
      anon_sym_DOT,
    STATE(463), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(413), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(418), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26593] = 6,
    ACTIONS(535), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(365), 11,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [26638] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(488), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(486), 28,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26677] = 6,
    ACTIONS(1013), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1015), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(552), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1009), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(550), 20,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26722] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(472), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(470), 28,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26761] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(496), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(494), 28,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26800] = 5,
    ACTIONS(1011), 1,
      anon_sym_DOT,
    STATE(477), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(386), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(388), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26843] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(363), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 26,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26884] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(492), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(490), 28,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [26923] = 6,
    ACTIONS(458), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(365), 11,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [26968] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(363), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 26,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27009] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 14,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27050] = 6,
    ACTIONS(372), 1,
      anon_sym_COLON,
    ACTIONS(760), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(736), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(365), 12,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [27095] = 5,
    ACTIONS(1011), 1,
      anon_sym_DOT,
    STATE(460), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(397), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(399), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27138] = 5,
    ACTIONS(1020), 1,
      anon_sym_DOT,
    STATE(477), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(390), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(395), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27181] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(484), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(482), 28,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27220] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(518), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(516), 28,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27259] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(462), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(460), 28,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27298] = 6,
    ACTIONS(367), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(365), 11,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [27343] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(522), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(520), 28,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27382] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(476), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(474), 28,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27421] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(378), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 26,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27462] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(374), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(372), 4,
      anon_sym_SEMI,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(367), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [27507] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(557), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(458), 4,
      anon_sym_SEMI,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(535), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [27552] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(378), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 26,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27593] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(374), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(372), 6,
      anon_sym_SEMI,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(367), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [27636] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(378), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(376), 28,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27675] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(378), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 26,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27716] = 5,
    ACTIONS(1011), 1,
      anon_sym_DOT,
    STATE(469), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(401), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(403), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27759] = 5,
    ACTIONS(367), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(365), 13,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [27802] = 4,
    ACTIONS(372), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [27843] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(363), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 26,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27884] = 6,
    ACTIONS(554), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(365), 11,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [27929] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(504), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(999), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(1003), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(498), 20,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [27972] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(452), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(450), 28,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28011] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(504), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(999), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(498), 26,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28052] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(363), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 26,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28093] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(540), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1009), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(538), 22,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28134] = 5,
    ACTIONS(529), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(531), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(526), 8,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(524), 19,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [28177] = 6,
    ACTIONS(372), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(365), 11,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [28222] = 5,
    ACTIONS(1013), 1,
      anon_sym_AMP_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(540), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1009), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(538), 21,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28265] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(756), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(365), 12,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [28308] = 5,
    ACTIONS(1025), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1027), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1023), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(544), 21,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [28350] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1023), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(538), 23,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [28388] = 4,
    ACTIONS(1025), 1,
      anon_sym_AMP_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1023), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(538), 22,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [28428] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(390), 5,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(395), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28466] = 5,
    ACTIONS(1025), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1027), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1023), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(550), 21,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [28508] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1033), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(498), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1029), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(1031), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(504), 12,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28551] = 7,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(554), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(559), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(1035), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [28596] = 7,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [28641] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(370), 12,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28682] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 10,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [28725] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(460), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(462), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28762] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(378), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28801] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(378), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28840] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(376), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(378), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28877] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(376), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(378), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28916] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(464), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1038), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1040), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(468), 20,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28957] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(470), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(472), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [28994] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(450), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(452), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29031] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(474), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(476), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29068] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(478), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(480), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29105] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(482), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(484), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29142] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(486), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(488), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29179] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(490), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(492), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29216] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(494), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(496), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29253] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1033), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(498), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1031), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(504), 16,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29294] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1033), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(498), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(504), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29333] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1033), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(498), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(504), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29372] = 7,
    ACTIONS(1042), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1033), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(498), 3,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1029), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(1031), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
    ACTIONS(504), 12,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29417] = 4,
    ACTIONS(1044), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(510), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(514), 23,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
  [29456] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(516), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(518), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29493] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(520), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(522), 24,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29530] = 5,
    ACTIONS(372), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(370), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(365), 11,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(351), 14,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
  [29571] = 7,
    ACTIONS(1046), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [29616] = 7,
    ACTIONS(939), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [29661] = 7,
    ACTIONS(559), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [29706] = 6,
    ACTIONS(939), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(370), 11,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [29749] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(538), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1038), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1040), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(540), 20,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29790] = 6,
    ACTIONS(1049), 1,
      anon_sym_AMP_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(538), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1038), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1040), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(540), 19,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE_PIPE,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29833] = 7,
    ACTIONS(1049), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1051), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(544), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1038), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1040), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(548), 18,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29878] = 7,
    ACTIONS(1049), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1051), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(550), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1038), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1040), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(552), 18,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [29923] = 7,
    ACTIONS(1035), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [29968] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(363), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30007] = 7,
    ACTIONS(557), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [30052] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(363), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30091] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(363), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30130] = 7,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(367), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(374), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(939), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [30175] = 7,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(535), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(557), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(1046), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [30220] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(367), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(374), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
      anon_sym_COLON,
    ACTIONS(939), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [30263] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(351), 4,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(363), 22,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
      anon_sym_COLON,
  [30302] = 6,
    ACTIONS(1044), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(524), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(526), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1053), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(531), 17,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
      anon_sym_RBRACE,
  [30345] = 8,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(957), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [30391] = 6,
    ACTIONS(1058), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1060), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(548), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1056), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(544), 17,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [30433] = 6,
    ACTIONS(1058), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1060), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(552), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1056), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(550), 17,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [30475] = 8,
    ACTIONS(557), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(957), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [30521] = 5,
    ACTIONS(1058), 1,
      anon_sym_AMP_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(540), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1056), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(538), 18,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [30561] = 7,
    ACTIONS(559), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 8,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [30605] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(540), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1056), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
    ACTIONS(538), 19,
      anon_sym_SEMI,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [30643] = 7,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 8,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [30687] = 7,
    ACTIONS(557), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 8,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [30731] = 8,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(984), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [30776] = 8,
    ACTIONS(559), 1,
      anon_sym_COLON,
    ACTIONS(997), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [30821] = 8,
    ACTIONS(557), 1,
      anon_sym_COLON,
    ACTIONS(997), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [30866] = 8,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(997), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [30911] = 8,
    ACTIONS(559), 1,
      anon_sym_COLON,
    ACTIONS(984), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [30956] = 7,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(957), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [30999] = 8,
    ACTIONS(557), 1,
      anon_sym_COLON,
    ACTIONS(984), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31044] = 8,
    ACTIONS(557), 1,
      anon_sym_COLON,
    ACTIONS(993), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31089] = 8,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(995), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31134] = 8,
    ACTIONS(559), 1,
      anon_sym_COLON,
    ACTIONS(995), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31179] = 8,
    ACTIONS(559), 1,
      anon_sym_COLON,
    ACTIONS(976), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31224] = 8,
    ACTIONS(557), 1,
      anon_sym_COLON,
    ACTIONS(976), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31269] = 8,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(976), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31314] = 6,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(370), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31355] = 8,
    ACTIONS(557), 1,
      anon_sym_COLON,
    ACTIONS(995), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31400] = 8,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(993), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31445] = 8,
    ACTIONS(559), 1,
      anon_sym_COLON,
    ACTIONS(993), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(857), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31490] = 7,
    ACTIONS(374), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(957), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31532] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(538), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1062), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1064), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(540), 17,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
  [31570] = 7,
    ACTIONS(559), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1066), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31612] = 7,
    ACTIONS(1068), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1070), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(544), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1062), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1064), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(548), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_RBRACE,
  [31654] = 7,
    ACTIONS(559), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1072), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31696] = 7,
    ACTIONS(559), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1074), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31738] = 6,
    ACTIONS(1068), 1,
      anon_sym_AMP_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(538), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1062), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1064), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(540), 16,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
  [31778] = 7,
    ACTIONS(1068), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1070), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(550), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(1062), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1064), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
    ACTIONS(552), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
      anon_sym_RBRACE,
  [31820] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1074), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31859] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1072), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31898] = 6,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(351), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(365), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1066), 2,
      anon_sym_DOT_SQUOTE,
      anon_sym_SQUOTE,
    ACTIONS(370), 6,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
    ACTIONS(363), 12,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
  [31937] = 4,
    ACTIONS(1076), 1,
      anon_sym_DOT,
    STATE(592), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(390), 21,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACE,
      anon_sym_EQ,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [31971] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(390), 22,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACE,
      anon_sym_EQ,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [32000] = 11,
    ACTIONS(1025), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1027), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1081), 1,
      anon_sym_end,
    ACTIONS(1083), 1,
      anon_sym_case,
    ACTIONS(1085), 1,
      anon_sym_otherwise,
    STATE(1243), 1,
      sym_otherwise_clause,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    STATE(635), 2,
      sym__end_of_line,
      aux_sym_elseif_clause_repeat1,
    STATE(773), 2,
      sym_case_clause,
      aux_sym_switch_statement_repeat1,
    ACTIONS(1079), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(1023), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [32045] = 16,
    ACTIONS(1087), 1,
      sym_identifier,
    ACTIONS(1089), 1,
      anon_sym_COMMA,
    ACTIONS(1091), 1,
      anon_sym_LPAREN,
    ACTIONS(1093), 1,
      anon_sym_DOT,
    ACTIONS(1095), 1,
      anon_sym_TILDE,
    ACTIONS(1097), 1,
      anon_sym_AT,
    ACTIONS(1099), 1,
      anon_sym_RBRACK,
    ACTIONS(1101), 1,
      anon_sym_LBRACE,
    STATE(632), 1,
      sym_function_call,
    STATE(639), 1,
      sym__args,
    STATE(681), 1,
      aux_sym_field_expression_repeat1,
    STATE(951), 1,
      sym_indirect_access,
    STATE(971), 1,
      sym_boolean,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(624), 3,
      sym_field_expression,
      sym_ignored_argument,
      aux_sym_multioutput_variable_repeat1,
  [32098] = 4,
    ACTIONS(1103), 1,
      anon_sym_DOT,
    STATE(597), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(397), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [32126] = 4,
    ACTIONS(1103), 1,
      anon_sym_DOT,
    STATE(592), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(380), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [32154] = 4,
    ACTIONS(1103), 1,
      anon_sym_DOT,
    STATE(592), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(386), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [32182] = 4,
    ACTIONS(1103), 1,
      anon_sym_DOT,
    STATE(598), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(401), 15,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_end,
      anon_sym_case,
      anon_sym_otherwise,
      anon_sym_LF,
      anon_sym_CR,
  [32210] = 14,
    ACTIONS(1105), 1,
      sym_identifier,
    ACTIONS(1109), 1,
      anon_sym_LPAREN,
    ACTIONS(1111), 1,
      anon_sym_DOT,
    ACTIONS(1113), 1,
      anon_sym_AT,
    ACTIONS(1115), 1,
      anon_sym_LBRACE,
    ACTIONS(1117), 1,
      anon_sym_EQ,
    STATE(641), 1,
      aux_sym_metaclass_operator_repeat1,
    STATE(662), 1,
      sym_dimensions,
    STATE(683), 1,
      sym_property_name,
    STATE(735), 1,
      sym_validation_functions,
    STATE(840), 1,
      sym_default_value,
    STATE(1044), 1,
      sym__end_of_line,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1107), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
  [32257] = 5,
    ACTIONS(1119), 1,
      anon_sym_DOT,
    STATE(601), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(395), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(390), 11,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [32285] = 5,
    ACTIONS(1122), 1,
      anon_sym_DOT,
    STATE(601), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(388), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(386), 11,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [32313] = 5,
    ACTIONS(1124), 1,
      anon_sym_DOT,
    STATE(603), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(390), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(395), 11,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [32341] = 5,
    ACTIONS(1122), 1,
      anon_sym_DOT,
    STATE(606), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(399), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(397), 11,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [32369] = 5,
    ACTIONS(1122), 1,
      anon_sym_DOT,
    STATE(602), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(403), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(401), 11,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [32397] = 5,
    ACTIONS(1122), 1,
      anon_sym_DOT,
    STATE(601), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(384), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(380), 11,
      anon_sym_SEMI,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [32425] = 6,
    ACTIONS(1133), 1,
      anon_sym_PIPE,
    ACTIONS(1135), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1131), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(1127), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(1129), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
  [32454] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(395), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(390), 12,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [32477] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(390), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(395), 12,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [32500] = 8,
    ACTIONS(627), 1,
      aux_sym_matrix_token1,
    ACTIONS(1058), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1060), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1137), 1,
      sym__entry_delimiter,
    STATE(777), 1,
      aux_sym_row_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(625), 3,
      anon_sym_SEMI,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(1056), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [32533] = 6,
    ACTIONS(1145), 1,
      anon_sym_PIPE,
    ACTIONS(1147), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1143), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(1139), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(1141), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
  [32562] = 12,
    ACTIONS(1105), 1,
      sym_identifier,
    ACTIONS(1109), 1,
      anon_sym_LPAREN,
    ACTIONS(1113), 1,
      anon_sym_AT,
    ACTIONS(1115), 1,
      anon_sym_LBRACE,
    ACTIONS(1117), 1,
      anon_sym_EQ,
    STATE(662), 1,
      sym_dimensions,
    STATE(683), 1,
      sym_property_name,
    STATE(735), 1,
      sym_validation_functions,
    STATE(840), 1,
      sym_default_value,
    STATE(1044), 1,
      sym__end_of_line,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1107), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
  [32603] = 6,
    ACTIONS(1025), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1027), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    STATE(9), 2,
      sym__end_of_line,
      aux_sym_elseif_clause_repeat1,
    ACTIONS(1149), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(1023), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [32632] = 6,
    ACTIONS(1151), 1,
      anon_sym_PIPE,
    ACTIONS(1153), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1033), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(1029), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(1031), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
  [32661] = 8,
    ACTIONS(1058), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1060), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1157), 1,
      aux_sym_matrix_token1,
    ACTIONS(1159), 1,
      sym__entry_delimiter,
    STATE(751), 1,
      aux_sym_row_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1155), 3,
      anon_sym_SEMI,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(1056), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [32694] = 6,
    ACTIONS(1167), 1,
      anon_sym_PIPE,
    ACTIONS(1169), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1165), 2,
      anon_sym_CARET,
      anon_sym_DOT_CARET,
    ACTIONS(1161), 4,
      anon_sym_PLUS,
      anon_sym_DOT_PLUS,
      anon_sym_DASH,
      anon_sym_DOT_DASH,
    ACTIONS(1163), 6,
      anon_sym_STAR,
      anon_sym_DOT_STAR,
      anon_sym_SLASH,
      anon_sym_DOT_SLASH,
      anon_sym_BSLASH,
      anon_sym_DOT_BSLASH,
  [32723] = 5,
    ACTIONS(1171), 1,
      anon_sym_DOT,
    STATE(623), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(401), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(403), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
  [32749] = 11,
    ACTIONS(1173), 1,
      sym_identifier,
    ACTIONS(1176), 1,
      anon_sym_COMMA,
    ACTIONS(1179), 1,
      anon_sym_LPAREN,
    ACTIONS(1182), 1,
      anon_sym_TILDE,
    ACTIONS(1185), 1,
      anon_sym_RBRACK,
    STATE(632), 1,
      sym_function_call,
    STATE(951), 1,
      sym_indirect_access,
    STATE(971), 1,
      sym_boolean,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1187), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(618), 3,
      sym_field_expression,
      sym_ignored_argument,
      aux_sym_multioutput_variable_repeat1,
  [32787] = 11,
    ACTIONS(1087), 1,
      sym_identifier,
    ACTIONS(1089), 1,
      anon_sym_COMMA,
    ACTIONS(1095), 1,
      anon_sym_TILDE,
    ACTIONS(1099), 1,
      anon_sym_RBRACK,
    ACTIONS(1190), 1,
      anon_sym_LPAREN,
    STATE(632), 1,
      sym_function_call,
    STATE(951), 1,
      sym_indirect_access,
    STATE(971), 1,
      sym_boolean,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(624), 3,
      sym_field_expression,
      sym_ignored_argument,
      aux_sym_multioutput_variable_repeat1,
  [32825] = 6,
    ACTIONS(1025), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1027), 1,
      anon_sym_PIPE_PIPE,
    STATE(168), 1,
      sym__end_of_line,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1192), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(1023), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [32853] = 6,
    ACTIONS(1025), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1027), 1,
      anon_sym_PIPE_PIPE,
    STATE(168), 1,
      sym__end_of_line,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1192), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(1023), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [32881] = 5,
    ACTIONS(1171), 1,
      anon_sym_DOT,
    STATE(603), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(380), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(384), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
  [32907] = 5,
    ACTIONS(1171), 1,
      anon_sym_DOT,
    STATE(603), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(386), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(388), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
  [32933] = 11,
    ACTIONS(1087), 1,
      sym_identifier,
    ACTIONS(1095), 1,
      anon_sym_TILDE,
    ACTIONS(1190), 1,
      anon_sym_LPAREN,
    ACTIONS(1194), 1,
      anon_sym_COMMA,
    ACTIONS(1196), 1,
      anon_sym_RBRACK,
    STATE(632), 1,
      sym_function_call,
    STATE(951), 1,
      sym_indirect_access,
    STATE(971), 1,
      sym_boolean,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(618), 3,
      sym_field_expression,
      sym_ignored_argument,
      aux_sym_multioutput_variable_repeat1,
  [32971] = 6,
    ACTIONS(1025), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1027), 1,
      anon_sym_PIPE_PIPE,
    STATE(303), 1,
      sym__end_of_line,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1198), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(1023), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [32999] = 5,
    ACTIONS(1171), 1,
      anon_sym_DOT,
    STATE(622), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(397), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(399), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACE,
  [33025] = 6,
    ACTIONS(1058), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1060), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1202), 2,
      sym__entry_delimiter,
      aux_sym_matrix_token1,
    ACTIONS(1200), 3,
      anon_sym_SEMI,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
    ACTIONS(1056), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [33053] = 5,
    ACTIONS(1025), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1027), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1204), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(1023), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [33078] = 8,
    ACTIONS(1068), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1070), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1206), 1,
      anon_sym_COMMA,
    STATE(969), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1062), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1208), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    ACTIONS(1064), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33109] = 5,
    ACTIONS(1025), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1027), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1210), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
    ACTIONS(1023), 6,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
      anon_sym_GT,
  [33134] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(442), 3,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(444), 9,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_AT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [33155] = 9,
    ACTIONS(1093), 1,
      anon_sym_DOT,
    ACTIONS(1097), 1,
      anon_sym_AT,
    ACTIONS(1101), 1,
      anon_sym_LBRACE,
    ACTIONS(1216), 1,
      anon_sym_LPAREN,
    STATE(639), 1,
      sym__args,
    STATE(681), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1212), 3,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(1214), 3,
      anon_sym_COMMA,
      anon_sym_TILDE,
      anon_sym_RBRACK,
  [33188] = 8,
    ACTIONS(1068), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1070), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1218), 1,
      anon_sym_COMMA,
    STATE(956), 1,
      aux_sym_arguments_repeat2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1062), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1220), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    ACTIONS(1064), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33219] = 8,
    ACTIONS(1068), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1070), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1218), 1,
      anon_sym_COMMA,
    STATE(904), 1,
      aux_sym_arguments_repeat2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1062), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1222), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    ACTIONS(1064), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33250] = 8,
    ACTIONS(1083), 1,
      anon_sym_case,
    ACTIONS(1085), 1,
      anon_sym_otherwise,
    ACTIONS(1226), 1,
      anon_sym_end,
    STATE(1222), 1,
      sym_otherwise_clause,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    STATE(679), 2,
      sym__end_of_line,
      aux_sym_elseif_clause_repeat1,
    STATE(793), 2,
      sym_case_clause,
      aux_sym_switch_statement_repeat1,
    ACTIONS(1224), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
  [33281] = 8,
    ACTIONS(1068), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1070), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1218), 1,
      anon_sym_COMMA,
    STATE(943), 1,
      aux_sym_arguments_repeat2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1062), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1228), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    ACTIONS(1064), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33312] = 8,
    ACTIONS(1068), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1070), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1218), 1,
      anon_sym_COMMA,
    STATE(957), 1,
      aux_sym_arguments_repeat2,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1062), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1220), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    ACTIONS(1064), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33343] = 9,
    ACTIONS(1093), 1,
      anon_sym_DOT,
    ACTIONS(1097), 1,
      anon_sym_AT,
    ACTIONS(1101), 1,
      anon_sym_LBRACE,
    ACTIONS(1216), 1,
      anon_sym_LPAREN,
    STATE(639), 1,
      sym__args,
    STATE(681), 1,
      aux_sym_field_expression_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1185), 3,
      anon_sym_COMMA,
      anon_sym_TILDE,
      anon_sym_RBRACK,
    ACTIONS(1230), 3,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [33376] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(430), 3,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(432), 9,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_AT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [33397] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(446), 3,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(448), 9,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_AT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [33418] = 4,
    ACTIONS(1234), 1,
      anon_sym_DOT,
    STATE(592), 1,
      aux_sym_metaclass_operator_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1232), 10,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_AT,
      anon_sym_LBRACE,
      anon_sym_EQ,
      sym_identifier,
      anon_sym_LF,
      anon_sym_CR,
  [33441] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(424), 3,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(426), 9,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_AT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [33462] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(420), 3,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(422), 9,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_AT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [33483] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(438), 3,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(440), 9,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_AT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
  [33504] = 12,
    ACTIONS(663), 1,
      sym__single_quote_string_start,
    ACTIONS(665), 1,
      sym__double_quote_string_start,
    ACTIONS(1190), 1,
      anon_sym_LPAREN,
    ACTIONS(1236), 1,
      sym_identifier,
    ACTIONS(1238), 1,
      sym_number,
    STATE(876), 1,
      sym_function_call,
    STATE(951), 1,
      sym_indirect_access,
    STATE(971), 1,
      sym_boolean,
    STATE(1177), 1,
      sym_string,
    STATE(1179), 1,
      sym_parfor_options,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
  [33543] = 10,
    ACTIONS(55), 1,
      sym__multioutput_variable_start,
    ACTIONS(1240), 1,
      sym_identifier,
    ACTIONS(1242), 1,
      anon_sym_end,
    ACTIONS(1244), 1,
      anon_sym_function,
    STATE(772), 1,
      sym__function_definition_with_end,
    STATE(1063), 1,
      sym_function_output,
    STATE(1207), 1,
      sym_multioutput_variable,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1246), 2,
      anon_sym_get_DOT,
      anon_sym_set_DOT,
    STATE(651), 2,
      sym_function_signature,
      aux_sym_methods_repeat1,
  [33577] = 8,
    ACTIONS(1248), 1,
      anon_sym_SEMI,
    ACTIONS(1250), 1,
      anon_sym_end,
    ACTIONS(1252), 1,
      anon_sym_properties,
    ACTIONS(1254), 1,
      anon_sym_methods,
    ACTIONS(1256), 1,
      anon_sym_events,
    ACTIONS(1258), 1,
      anon_sym_enumeration,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    STATE(655), 5,
      sym_properties,
      sym_methods,
      sym_events,
      sym_enumeration,
      aux_sym_class_definition_repeat1,
  [33607] = 6,
    ACTIONS(1068), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1070), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1062), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1260), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    ACTIONS(1064), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33633] = 8,
    ACTIONS(1252), 1,
      anon_sym_properties,
    ACTIONS(1254), 1,
      anon_sym_methods,
    ACTIONS(1256), 1,
      anon_sym_events,
    ACTIONS(1258), 1,
      anon_sym_enumeration,
    ACTIONS(1262), 1,
      anon_sym_SEMI,
    ACTIONS(1264), 1,
      anon_sym_end,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    STATE(658), 5,
      sym_properties,
      sym_methods,
      sym_events,
      sym_enumeration,
      aux_sym_class_definition_repeat1,
  [33663] = 10,
    ACTIONS(55), 1,
      sym__multioutput_variable_start,
    ACTIONS(1240), 1,
      sym_identifier,
    ACTIONS(1244), 1,
      anon_sym_function,
    ACTIONS(1266), 1,
      anon_sym_end,
    STATE(772), 1,
      sym__function_definition_with_end,
    STATE(1063), 1,
      sym_function_output,
    STATE(1207), 1,
      sym_multioutput_variable,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1246), 2,
      anon_sym_get_DOT,
      anon_sym_set_DOT,
    STATE(667), 2,
      sym_function_signature,
      aux_sym_methods_repeat1,
  [33697] = 10,
    ACTIONS(55), 1,
      sym__multioutput_variable_start,
    ACTIONS(1240), 1,
      sym_identifier,
    ACTIONS(1244), 1,
      anon_sym_function,
    ACTIONS(1266), 1,
      anon_sym_end,
    STATE(772), 1,
      sym__function_definition_with_end,
    STATE(1063), 1,
      sym_function_output,
    STATE(1207), 1,
      sym_multioutput_variable,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1246), 2,
      anon_sym_get_DOT,
      anon_sym_set_DOT,
    STATE(668), 2,
      sym_function_signature,
      aux_sym_methods_repeat1,
  [33731] = 9,
    ACTIONS(1111), 1,
      anon_sym_DOT,
    ACTIONS(1115), 1,
      anon_sym_LBRACE,
    ACTIONS(1117), 1,
      anon_sym_EQ,
    STATE(641), 1,
      aux_sym_metaclass_operator_repeat1,
    STATE(706), 1,
      sym_validation_functions,
    STATE(870), 1,
      sym_default_value,
    STATE(1077), 1,
      sym__end_of_line,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1268), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
  [33763] = 8,
    ACTIONS(1250), 1,
      anon_sym_end,
    ACTIONS(1252), 1,
      anon_sym_properties,
    ACTIONS(1254), 1,
      anon_sym_methods,
    ACTIONS(1256), 1,
      anon_sym_events,
    ACTIONS(1258), 1,
      anon_sym_enumeration,
    ACTIONS(1262), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    STATE(658), 5,
      sym_properties,
      sym_methods,
      sym_events,
      sym_enumeration,
      aux_sym_class_definition_repeat1,
  [33793] = 6,
    ACTIONS(1068), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1070), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1062), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1270), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    ACTIONS(1064), 4,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_GT_EQ,
  [33819] = 8,
    ACTIONS(1252), 1,
      anon_sym_properties,
    ACTIONS(1254), 1,
      anon_sym_methods,
    ACTIONS(1256), 1,
      anon_sym_events,
    ACTIONS(1258), 1,
      anon_sym_enumeration,
    ACTIONS(1262), 1,
      anon_sym_SEMI,
    ACTIONS(1272), 1,
      anon_sym_end,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    STATE(658), 5,
      sym_properties,
      sym_methods,
      sym_events,
      sym_enumeration,
      aux_sym_class_definition_repeat1,
  [33849] = 8,
    ACTIONS(1252), 1,
      anon_sym_properties,
    ACTIONS(1254), 1,
      anon_sym_methods,
    ACTIONS(1256), 1,
      anon_sym_events,
    ACTIONS(1258), 1,
      anon_sym_enumeration,
    ACTIONS(1274), 1,
      anon_sym_SEMI,
    ACTIONS(1276), 1,
      anon_sym_end,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    STATE(653), 5,
      sym_properties,
      sym_methods,
      sym_events,
      sym_enumeration,
      aux_sym_class_definition_repeat1,
  [33879] = 10,
    ACTIONS(1095), 1,
      anon_sym_TILDE,
    ACTIONS(1190), 1,
      anon_sym_LPAREN,
    ACTIONS(1278), 1,
      sym_identifier,
    ACTIONS(1280), 1,
      anon_sym_RBRACK,
    STATE(595), 1,
      sym_function_call,
    STATE(951), 1,
      sym_indirect_access,
    STATE(971), 1,
      sym_boolean,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(619), 2,
      sym_field_expression,
      sym_ignored_argument,
  [33913] = 8,
    ACTIONS(1282), 1,
      anon_sym_SEMI,
    ACTIONS(1285), 1,
      anon_sym_end,
    ACTIONS(1287), 1,
      anon_sym_properties,
    ACTIONS(1290), 1,
      anon_sym_methods,
    ACTIONS(1293), 1,
      anon_sym_events,
    ACTIONS(1296), 1,
      anon_sym_enumeration,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    STATE(658), 5,
      sym_properties,
      sym_methods,
      sym_events,
      sym_enumeration,
      aux_sym_class_definition_repeat1,
  [33943] = 10,
    ACTIONS(1095), 1,
      anon_sym_TILDE,
    ACTIONS(1190), 1,
      anon_sym_LPAREN,
    ACTIONS(1299), 1,
      sym_identifier,
    ACTIONS(1301), 1,
      anon_sym_RBRACK,
    STATE(638), 1,
      sym_function_call,
    STATE(951), 1,
      sym_indirect_access,
    STATE(971), 1,
      sym_boolean,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(661), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(725), 2,
      sym_field_expression,
      sym_ignored_argument,
  [33977] = 7,
    ACTIONS(1097), 1,
      anon_sym_AT,
    ACTIONS(1101), 1,
      anon_sym_LBRACE,
    ACTIONS(1216), 1,
      anon_sym_LPAREN,
    STATE(639), 1,
      sym__args,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(405), 3,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(407), 4,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_TILDE,
      anon_sym_RBRACK,
  [34005] = 9,
    ACTIONS(1111), 1,
      anon_sym_DOT,
    ACTIONS(1115), 1,
      anon_sym_LBRACE,
    ACTIONS(1117), 1,
      anon_sym_EQ,
    STATE(641), 1,
      aux_sym_metaclass_operator_repeat1,
    STATE(704), 1,
      sym_validation_functions,
    STATE(847), 1,
      sym_default_value,
    STATE(1075), 1,
      sym__end_of_line,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1303), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
  [34037] = 9,
    ACTIONS(1115), 1,
      anon_sym_LBRACE,
    ACTIONS(1117), 1,
      anon_sym_EQ,
    ACTIONS(1305), 1,
      sym_identifier,
    STATE(677), 1,
      sym_property_name,
    STATE(704), 1,
      sym_validation_functions,
    STATE(847), 1,
      sym_default_value,
    STATE(1075), 1,
      sym__end_of_line,
    ACTIONS(3), 2,
      sym_comment,
      sym_line_continuation,
    ACTIONS(1303), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LF,
      anon_sym_CR,
  [34069] = 8,
    ACTIONS(1252), 1,
      anon_sym_properties,
    ACTIONS(1254), 1,
      anon_sym_methods,