/*++

Copyright (C) 2019 Calculation developers

All rights reserved.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated C++ implementation file in order to allow easy
development of Calculation library. The functions in this file need to be implemented. It needs to be generated only once.

Interface version: 1.0.0

*/

#include "calculation_abi.hpp"
#include "calculation_interfaces.hpp"
#include "calculation_interfaceexception.hpp"

#include <map>

using namespace Calculation::Impl;

CalculationResult handleCalculationException(IBase * pIBaseClass, ECalculationInterfaceException & Exception)
{
	CalculationResult errorCode = Exception.getErrorCode();

	if (pIBaseClass != nullptr)
		pIBaseClass->RegisterErrorMessage(Exception.what());

	return errorCode;
}

CalculationResult handleStdException(IBase * pIBaseClass, std::exception & Exception)
{
	CalculationResult errorCode = CALCULATION_ERROR_GENERICEXCEPTION;

	if (pIBaseClass != nullptr)
		pIBaseClass->RegisterErrorMessage(Exception.what());

	return errorCode;
}

CalculationResult handleUnhandledException(IBase * pIBaseClass)
{
	CalculationResult errorCode = CALCULATION_ERROR_GENERICEXCEPTION;

	if (pIBaseClass != nullptr)
		pIBaseClass->RegisterErrorMessage("Unhandled Exception");

	return errorCode;
}



/*************************************************************************************************************************
 Class implementation for Base
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for Calculator
**************************************************************************************************************************/
CalculationResult calculation_calculator_enlistvariable(Calculation_Calculator pCalculator, Numbers_Variable pVariable)
{
	IBase* pIBaseClass = (IBase *)pCalculator;

	try {
		Numbers::PVariable pIVariable = std::make_shared<Numbers::CVariable>(CWrapper::sPNumbersWrapper.get(), pVariable);
		CWrapper::sPNumbersWrapper->AcquireInstance(pIVariable.get());
		if (!pIVariable)
			throw ECalculationInterfaceException (CALCULATION_ERROR_INVALIDCAST);
		
		ICalculator* pICalculator = dynamic_cast<ICalculator*>(pIBaseClass);
		if (!pICalculator)
			throw ECalculationInterfaceException(CALCULATION_ERROR_INVALIDCAST);
		
		pICalculator->EnlistVariable(pIVariable);

		return CALCULATION_SUCCESS;
	}
	catch (ECalculationInterfaceException & Exception) {
		return handleCalculationException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

CalculationResult calculation_calculator_getenlistedvariable(Calculation_Calculator pCalculator, Calculation_uint32 nIndex, Numbers_Variable * pVariable)
{
	IBase* pIBaseClass = (IBase *)pCalculator;

	try {
		if (pVariable == nullptr)
			throw ECalculationInterfaceException (CALCULATION_ERROR_INVALIDPARAM);
		Numbers::PVariable pNumbersVariable;
		ICalculator* pICalculator = dynamic_cast<ICalculator*>(pIBaseClass);
		if (!pICalculator)
			throw ECalculationInterfaceException(CALCULATION_ERROR_INVALIDCAST);
		
		pNumbersVariable = pICalculator->GetEnlistedVariable(nIndex);

		CWrapper::sPNumbersWrapper->AcquireInstance(pNumbersVariable.get());
		*pVariable = pNumbersVariable->GetHandle();
		return CALCULATION_SUCCESS;
	}
	catch (ECalculationInterfaceException & Exception) {
		return handleCalculationException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

CalculationResult calculation_calculator_clearvariables(Calculation_Calculator pCalculator)
{
	IBase* pIBaseClass = (IBase *)pCalculator;

	try {
		ICalculator* pICalculator = dynamic_cast<ICalculator*>(pIBaseClass);
		if (!pICalculator)
			throw ECalculationInterfaceException(CALCULATION_ERROR_INVALIDCAST);
		
		pICalculator->ClearVariables();

		return CALCULATION_SUCCESS;
	}
	catch (ECalculationInterfaceException & Exception) {
		return handleCalculationException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

CalculationResult calculation_calculator_multiply(Calculation_Calculator pCalculator, Numbers_Variable * pInstance)
{
	IBase* pIBaseClass = (IBase *)pCalculator;

	try {
		if (pInstance == nullptr)
			throw ECalculationInterfaceException (CALCULATION_ERROR_INVALIDPARAM);
		Numbers::PVariable pNumbersInstance;
		ICalculator* pICalculator = dynamic_cast<ICalculator*>(pIBaseClass);
		if (!pICalculator)
			throw ECalculationInterfaceException(CALCULATION_ERROR_INVALIDCAST);
		
		pNumbersInstance = pICalculator->Multiply();

		CWrapper::sPNumbersWrapper->AcquireInstance(pNumbersInstance.get());
		*pInstance = pNumbersInstance->GetHandle();
		return CALCULATION_SUCCESS;
	}
	catch (ECalculationInterfaceException & Exception) {
		return handleCalculationException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

CalculationResult calculation_calculator_add(Calculation_Calculator pCalculator, Numbers_Variable * pInstance)
{
	IBase* pIBaseClass = (IBase *)pCalculator;

	try {
		if (pInstance == nullptr)
			throw ECalculationInterfaceException (CALCULATION_ERROR_INVALIDPARAM);
		Numbers::PVariable pNumbersInstance;
		ICalculator* pICalculator = dynamic_cast<ICalculator*>(pIBaseClass);
		if (!pICalculator)
			throw ECalculationInterfaceException(CALCULATION_ERROR_INVALIDCAST);
		
		pNumbersInstance = pICalculator->Add();

		CWrapper::sPNumbersWrapper->AcquireInstance(pNumbersInstance.get());
		*pInstance = pNumbersInstance->GetHandle();
		return CALCULATION_SUCCESS;
	}
	catch (ECalculationInterfaceException & Exception) {
		return handleCalculationException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}



/*************************************************************************************************************************
 Function table lookup implementation
**************************************************************************************************************************/

CalculationResult _calculation_getprocaddress_internal(const char * pProcName, void ** ppProcAddress)
{
	static bool sbProcAddressMapHasBeenInitialized = false;
	static std::map<std::string, void*> sProcAddressMap;
	if (!sbProcAddressMapHasBeenInitialized) {
		sProcAddressMap["calculation_calculator_enlistvariable"] = (void*)&calculation_calculator_enlistvariable;
		sProcAddressMap["calculation_calculator_getenlistedvariable"] = (void*)&calculation_calculator_getenlistedvariable;
		sProcAddressMap["calculation_calculator_clearvariables"] = (void*)&calculation_calculator_clearvariables;
		sProcAddressMap["calculation_calculator_multiply"] = (void*)&calculation_calculator_multiply;
		sProcAddressMap["calculation_calculator_add"] = (void*)&calculation_calculator_add;
		sProcAddressMap["calculation_createcalculator"] = (void*)&calculation_createcalculator;
		sProcAddressMap["calculation_getversion"] = (void*)&calculation_getversion;
		sProcAddressMap["calculation_getlasterror"] = (void*)&calculation_getlasterror;
		sProcAddressMap["calculation_releaseinstance"] = (void*)&calculation_releaseinstance;
		sProcAddressMap["calculation_acquireinstance"] = (void*)&calculation_acquireinstance;
		sProcAddressMap["calculation_injectcomponent"] = (void*)&calculation_injectcomponent;
		sProcAddressMap["calculation_getsymbollookupmethod"] = (void*)&calculation_getsymbollookupmethod;
		
		sbProcAddressMapHasBeenInitialized = true;
	}
	if (pProcName == nullptr)
		return CALCULATION_ERROR_INVALIDPARAM;
	if (ppProcAddress == nullptr)
		return CALCULATION_ERROR_INVALIDPARAM;
	*ppProcAddress = nullptr;
	std::string sProcName (pProcName);
	
	auto procPair = sProcAddressMap.find(sProcName);
	if (procPair == sProcAddressMap.end()) {
		return CALCULATION_ERROR_COULDNOTFINDLIBRARYEXPORT;
	}
	else {
		*ppProcAddress = procPair->second;
		return CALCULATION_SUCCESS;
	}
	
}

/*************************************************************************************************************************
 Global functions implementation
**************************************************************************************************************************/
CalculationResult calculation_createcalculator(Calculation_Calculator * pInstance)
{
	IBase* pIBaseClass = nullptr;

	try {
		if (pInstance == nullptr)
			throw ECalculationInterfaceException (CALCULATION_ERROR_INVALIDPARAM);
		IBase* pBaseInstance(nullptr);
		pBaseInstance = CWrapper::CreateCalculator();

		*pInstance = (IBase*)(pBaseInstance);
		return CALCULATION_SUCCESS;
	}
	catch (ECalculationInterfaceException & Exception) {
		return handleCalculationException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

CalculationResult calculation_getversion(Calculation_uint32 * pMajor, Calculation_uint32 * pMinor, Calculation_uint32 * pMicro)
{
	IBase* pIBaseClass = nullptr;

	try {
		if (!pMajor)
			throw ECalculationInterfaceException (CALCULATION_ERROR_INVALIDPARAM);
		if (!pMinor)
			throw ECalculationInterfaceException (CALCULATION_ERROR_INVALIDPARAM);
		if (!pMicro)
			throw ECalculationInterfaceException (CALCULATION_ERROR_INVALIDPARAM);
		CWrapper::GetVersion(*pMajor, *pMinor, *pMicro);

		return CALCULATION_SUCCESS;
	}
	catch (ECalculationInterfaceException & Exception) {
		return handleCalculationException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

CalculationResult calculation_getlasterror(Calculation_Base pInstance, const Calculation_uint32 nErrorMessageBufferSize, Calculation_uint32* pErrorMessageNeededChars, char * pErrorMessageBuffer, bool * pHasError)
{
	IBase* pIBaseClass = nullptr;

	try {
		if ( (!pErrorMessageBuffer) && !(pErrorMessageNeededChars) )
			throw ECalculationInterfaceException (CALCULATION_ERROR_INVALIDPARAM);
		if (pHasError == nullptr)
			throw ECalculationInterfaceException (CALCULATION_ERROR_INVALIDPARAM);
		IBase* pIBaseClassInstance = (IBase *)pInstance;
		IBase* pIInstance = dynamic_cast<IBase*>(pIBaseClassInstance);
		if (!pIInstance)
			throw ECalculationInterfaceException (CALCULATION_ERROR_INVALIDCAST);
		
		std::string sErrorMessage("");
		*pHasError = CWrapper::GetLastError(pIInstance, sErrorMessage);

		if (pErrorMessageNeededChars)
			*pErrorMessageNeededChars = (Calculation_uint32) (sErrorMessage.size()+1);
		if (pErrorMessageBuffer) {
			if (sErrorMessage.size() >= nErrorMessageBufferSize)
				throw ECalculationInterfaceException (CALCULATION_ERROR_BUFFERTOOSMALL);
			for (size_t iErrorMessage = 0; iErrorMessage < sErrorMessage.size(); iErrorMessage++)
				pErrorMessageBuffer[iErrorMessage] = sErrorMessage[iErrorMessage];
			pErrorMessageBuffer[sErrorMessage.size()] = 0;
		}
		return CALCULATION_SUCCESS;
	}
	catch (ECalculationInterfaceException & Exception) {
		return handleCalculationException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

CalculationResult calculation_releaseinstance(Calculation_Base pInstance)
{
	IBase* pIBaseClass = nullptr;

	try {
		IBase* pIBaseClassInstance = (IBase *)pInstance;
		IBase* pIInstance = dynamic_cast<IBase*>(pIBaseClassInstance);
		if (!pIInstance)
			throw ECalculationInterfaceException (CALCULATION_ERROR_INVALIDCAST);
		
		CWrapper::ReleaseInstance(pIInstance);

		return CALCULATION_SUCCESS;
	}
	catch (ECalculationInterfaceException & Exception) {
		return handleCalculationException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

CalculationResult calculation_acquireinstance(Calculation_Base pInstance)
{
	IBase* pIBaseClass = nullptr;

	try {
		IBase* pIBaseClassInstance = (IBase *)pInstance;
		IBase* pIInstance = dynamic_cast<IBase*>(pIBaseClassInstance);
		if (!pIInstance)
			throw ECalculationInterfaceException (CALCULATION_ERROR_INVALIDCAST);
		
		CWrapper::AcquireInstance(pIInstance);

		return CALCULATION_SUCCESS;
	}
	catch (ECalculationInterfaceException & Exception) {
		return handleCalculationException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

CalculationResult calculation_injectcomponent(const char * pNameSpace, Calculation_pvoid pSymbolAddressMethod)
{
	IBase* pIBaseClass = nullptr;

	try {
		if (pNameSpace == nullptr)
			throw ECalculationInterfaceException (CALCULATION_ERROR_INVALIDPARAM);
		std::string sNameSpace(pNameSpace);
		
		bool bNameSpaceFound = false;
		
		if (sNameSpace == "Numbers") {
			if (CWrapper::sPNumbersWrapper.get() != nullptr) {
				throw ECalculationInterfaceException(CALCULATION_ERROR_COULDNOTLOADLIBRARY);
			}
			CWrapper::sPNumbersWrapper = Numbers::CWrapper::loadLibraryFromSymbolLookupMethod(pSymbolAddressMethod);
			bNameSpaceFound = true;
		}
		
		if (!bNameSpaceFound)
			throw ECalculationInterfaceException(CALCULATION_ERROR_COULDNOTLOADLIBRARY);
		
		return CALCULATION_SUCCESS;
	}
	catch (ECalculationInterfaceException & Exception) {
		return handleCalculationException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

CalculationResult calculation_getsymbollookupmethod(Calculation_pvoid * pSymbolLookupMethod)
{
	IBase* pIBaseClass = nullptr;

	try {
		if (pSymbolLookupMethod == nullptr)
			throw ECalculationInterfaceException (CALCULATION_ERROR_INVALIDPARAM);
		*pSymbolLookupMethod = (void*)&_calculation_getprocaddress_internal;
		return CALCULATION_SUCCESS;
	}
	catch (ECalculationInterfaceException & Exception) {
		return handleCalculationException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}


