(*++

Copyright (C) 2019 Calculation developers

All rights reserved.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated Pascal exception class definition file in order to allow easy
development of Calculation library. The functions in this file need to be implemented. It needs to be generated only once.

Interface version: 1.0.0

*)

{$MODE DELPHI}
unit calculation_exception;

interface

uses
  calculation_types,
  calculation_interfaces,
  Classes,
  sysutils;

type
  ECalculationException = class(Exception)
  private
    FErrorCode: TCalculationResult;
    FCustomMessage: String;
  public
    property ErrorCode: TCalculationResult read FErrorCode;
    property CustomMessage: String read FCustomMessage;
    constructor Create(AErrorCode: TCalculationResult);
    constructor CreateCustomMessage(AErrorCode: TCalculationResult; AMessage: String);
  end;


(*************************************************************************************************************************
 Definition of exception handling functionality for Calculation
**************************************************************************************************************************)

function HandleCalculationException(ACalculationObject: TObject; E: ECalculationException): TCalculationResult;
function HandleStdException(ACalculationObject: TObject; E: Exception): TCalculationResult;
function HandleUnhandledException(ACalculationObject: TObject): TCalculationResult;


implementation

  constructor ECalculationException.Create(AErrorCode: TCalculationResult);
  var
    ADescription: String;
  begin
    FErrorCode := AErrorCode;
    case FErrorCode of
      CALCULATION_ERROR_NOTIMPLEMENTED: ADescription := 'functionality not implemented';
      CALCULATION_ERROR_INVALIDPARAM: ADescription := 'an invalid parameter was passed';
      CALCULATION_ERROR_INVALIDCAST: ADescription := 'a type cast failed';
      CALCULATION_ERROR_BUFFERTOOSMALL: ADescription := 'a provided buffer is too small';
      CALCULATION_ERROR_GENERICEXCEPTION: ADescription := 'a generic exception occurred';
      CALCULATION_ERROR_COULDNOTLOADLIBRARY: ADescription := 'the library could not be loaded';
      CALCULATION_ERROR_COULDNOTFINDLIBRARYEXPORT: ADescription := 'a required exported symbol could not be found in the library';
      CALCULATION_ERROR_INCOMPATIBLEBINARYVERSION: ADescription := 'the version of the binary interface does not match the bindings interface';
      else
        ADescription := 'unknown';
    end;

    inherited Create(Format('Calculation library Error - %s (#%d)', [ ADescription, AErrorCode ]));
  end;

  constructor ECalculationException.CreateCustomMessage(AErrorCode: TCalculationResult; AMessage: String);
  begin
    FCustomMessage := AMessage;
    FErrorCode := AErrorCode;
    inherited Create(Format('%s(%d)', [FCustomMessage, AErrorCode]));
  end;

(*************************************************************************************************************************
 Implementation of exception handling functionality for Calculation
**************************************************************************************************************************)

function HandleCalculationException(ACalculationObject: TObject; E: ECalculationException): TCalculationResult;
begin
  result := E.ErrorCode;
  if Supports(ACalculationObject, ICalculationBase) then begin
    (ACalculationObject as ICalculationBase).RegisterErrorMessage(E.CustomMessage)
  end;
end;
function HandleStdException(ACalculationObject: TObject; E: Exception): TCalculationResult;
begin
  Result := CALCULATION_ERROR_GENERICEXCEPTION;
  if Supports(ACalculationObject, ICalculationBase) then begin
    (ACalculationObject as ICalculationBase).RegisterErrorMessage(E.Message)
  end;
end;
function HandleUnhandledException(ACalculationObject: TObject): TCalculationResult;
begin
  Result := CALCULATION_ERROR_GENERICEXCEPTION;
  if Supports(ACalculationObject, ICalculationBase) then begin
    (ACalculationObject as ICalculationBase).RegisterErrorMessage('Unhandled Exception')
  end;
end;
end.
