'''++

Copyright (C) 2019 PrimeDevelopers

All rights reserved.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated Python file in order to allow an easy
 use of Prime Numbers Library

Interface version: 1.2.0

'''


import ctypes
import platform
import enum
import os

name = "libprimes"

'''Definition of domain specific exception
'''
class ELibPrimesException(Exception):
	def __init__(self, code, message = ''):
		self._code = code
		self._message = message
	
	def __str__(self):
		if self._message:
			return 'LibPrimesException ' + str(self._code) + ': '+ str(self._message)
		return 'LibPrimesException ' + str(self._code)

'''Definition of binding API version
'''
class BindingVersion(enum.IntEnum):
	MAJOR = 1
	MINOR = 2
	MICRO = 0

'''Definition Error Codes
'''
class ErrorCodes(enum.IntEnum):
	SUCCESS = 0
	NOTIMPLEMENTED = 1
	INVALIDPARAM = 2
	INVALIDCAST = 3
	BUFFERTOOSMALL = 4
	GENERICEXCEPTION = 5
	COULDNOTLOADLIBRARY = 6
	COULDNOTFINDLIBRARYEXPORT = 7
	INCOMPATIBLEBINARYVERSION = 8
	NORESULTAVAILABLE = 9
	CALCULATIONABORTED = 10

'''Definition of Function Table
'''
class FunctionTable:
	libprimes_getversion = None
	libprimes_getlasterror = None
	libprimes_acquireinstance = None
	libprimes_releaseinstance = None
	libprimes_createfactorizationcalculator = None
	libprimes_createsievecalculator = None
	libprimes_setjournal = None
	libprimes_calculator_getvalue = None
	libprimes_calculator_setvalue = None
	libprimes_calculator_calculate = None
	libprimes_calculator_setprogresscallback = None
	libprimes_factorizationcalculator_getprimefactors = None
	libprimes_sievecalculator_getprimes = None

'''Definition of Structs
'''
'''Definition of PrimeFactor
'''
class PrimeFactor(ctypes.Structure):
	_pack_ = 1
	_fields_ = [
		("Prime", ctypes.c_uint64), 
		("Multiplicity", ctypes.c_uint32)
	]

'''Definition of Function Types
'''
'''Definition of ProgressCallback
		Callback to report calculation progress and query whether it should be aborted
'''
ProgressCallback = ctypes.CFUNCTYPE(ctypes.c_void_p, ctypes.c_float, ctypes.POINTER(ctypes.c_bool))


'''Wrapper Class Implementation
'''
class Wrapper:

	def __init__(self, libraryName = None, symbolLookupMethodAddress = None):
		ending = ''
		if platform.system() == 'Windows':
			ending = 'dll'
		elif platform.system() == 'Linux':
			ending = 'so'
		elif platform.system() == 'Darwin':
			ending = 'dylib'
		else:
			raise ELibPrimesException(ErrorCodes.COULDNOTLOADLIBRARY)
		
		if (not libraryName) and (not symbolLookupMethodAddress):
			libraryName = os.path.join(os.path.dirname(os.path.realpath(__file__)),'libprimes')
		
		if libraryName is not None:
			path = libraryName + '.' + ending
			try:
				self.lib = ctypes.CDLL(path)
			except Exception as e:
				raise ELibPrimesException(ErrorCodes.COULDNOTLOADLIBRARY, str(e) + '| "'+path + '"' )
			
			self._loadFunctionTable()
		elif symbolLookupMethodAddress is not None:
				self.lib = FunctionTable()
				self._loadFunctionTableFromMethod(symbolLookupMethodAddress)
		else:
			raise ELibPrimesException(ErrorCodes.COULDNOTLOADLIBRARY, str(e))
		
		self._checkBinaryVersion()
	
	def _loadFunctionTableFromMethod(self, symbolLookupMethodAddress):
		try:
			symbolLookupMethodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p))
			symbolLookupMethod = symbolLookupMethodType(int(symbolLookupMethodAddress))
			
			methodAddress = ctypes.c_void_p()
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("libprimes_getversion")), methodAddress)
			if err != 0:
				raise ELibPrimesException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32))
			self.lib.libprimes_getversion = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("libprimes_getlasterror")), methodAddress)
			if err != 0:
				raise ELibPrimesException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p, ctypes.POINTER(ctypes.c_bool))
			self.lib.libprimes_getlasterror = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("libprimes_acquireinstance")), methodAddress)
			if err != 0:
				raise ELibPrimesException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.libprimes_acquireinstance = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("libprimes_releaseinstance")), methodAddress)
			if err != 0:
				raise ELibPrimesException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.libprimes_releaseinstance = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("libprimes_createfactorizationcalculator")), methodAddress)
			if err != 0:
				raise ELibPrimesException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.libprimes_createfactorizationcalculator = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("libprimes_createsievecalculator")), methodAddress)
			if err != 0:
				raise ELibPrimesException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.POINTER(ctypes.c_void_p))
			self.lib.libprimes_createsievecalculator = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("libprimes_setjournal")), methodAddress)
			if err != 0:
				raise ELibPrimesException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_char_p)
			self.lib.libprimes_setjournal = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("libprimes_calculator_getvalue")), methodAddress)
			if err != 0:
				raise ELibPrimesException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64))
			self.lib.libprimes_calculator_getvalue = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("libprimes_calculator_setvalue")), methodAddress)
			if err != 0:
				raise ELibPrimesException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64)
			self.lib.libprimes_calculator_setvalue = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("libprimes_calculator_calculate")), methodAddress)
			if err != 0:
				raise ELibPrimesException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p)
			self.lib.libprimes_calculator_calculate = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("libprimes_calculator_setprogresscallback")), methodAddress)
			if err != 0:
				raise ELibPrimesException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ProgressCallback)
			self.lib.libprimes_calculator_setprogresscallback = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("libprimes_factorizationcalculator_getprimefactors")), methodAddress)
			if err != 0:
				raise ELibPrimesException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(PrimeFactor))
			self.lib.libprimes_factorizationcalculator_getprimefactors = methodType(int(methodAddress.value))
			
			err = symbolLookupMethod(ctypes.c_char_p(str.encode("libprimes_sievecalculator_getprimes")), methodAddress)
			if err != 0:
				raise ELibPrimesException(ErrorCodes.COULDNOTLOADLIBRARY, str(err))
			methodType = ctypes.CFUNCTYPE(ctypes.c_int32, ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint64))
			self.lib.libprimes_sievecalculator_getprimes = methodType(int(methodAddress.value))
			
		except AttributeError as ae:
			raise ELibPrimesException(ErrorCodes.COULDNOTFINDLIBRARYEXPORT, ae.args[0])
		
	def _loadFunctionTable(self):
		try:
			self.lib.libprimes_getversion.restype = ctypes.c_int32
			self.lib.libprimes_getversion.argtypes = [ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32), ctypes.POINTER(ctypes.c_uint32)]
			
			self.lib.libprimes_getlasterror.restype = ctypes.c_int32
			self.lib.libprimes_getlasterror.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.c_char_p, ctypes.POINTER(ctypes.c_bool)]
			
			self.lib.libprimes_acquireinstance.restype = ctypes.c_int32
			self.lib.libprimes_acquireinstance.argtypes = [ctypes.c_void_p]
			
			self.lib.libprimes_releaseinstance.restype = ctypes.c_int32
			self.lib.libprimes_releaseinstance.argtypes = [ctypes.c_void_p]
			
			self.lib.libprimes_createfactorizationcalculator.restype = ctypes.c_int32
			self.lib.libprimes_createfactorizationcalculator.argtypes = [ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.libprimes_createsievecalculator.restype = ctypes.c_int32
			self.lib.libprimes_createsievecalculator.argtypes = [ctypes.POINTER(ctypes.c_void_p)]
			
			self.lib.libprimes_setjournal.restype = ctypes.c_int32
			self.lib.libprimes_setjournal.argtypes = [ctypes.c_char_p]
			
			self.lib.libprimes_calculator_getvalue.restype = ctypes.c_int32
			self.lib.libprimes_calculator_getvalue.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.c_uint64)]
			
			self.lib.libprimes_calculator_setvalue.restype = ctypes.c_int32
			self.lib.libprimes_calculator_setvalue.argtypes = [ctypes.c_void_p, ctypes.c_uint64]
			
			self.lib.libprimes_calculator_calculate.restype = ctypes.c_int32
			self.lib.libprimes_calculator_calculate.argtypes = [ctypes.c_void_p]
			
			self.lib.libprimes_calculator_setprogresscallback.restype = ctypes.c_int32
			self.lib.libprimes_calculator_setprogresscallback.argtypes = [ctypes.c_void_p, ProgressCallback]
			
			self.lib.libprimes_factorizationcalculator_getprimefactors.restype = ctypes.c_int32
			self.lib.libprimes_factorizationcalculator_getprimefactors.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(PrimeFactor)]
			
			self.lib.libprimes_sievecalculator_getprimes.restype = ctypes.c_int32
			self.lib.libprimes_sievecalculator_getprimes.argtypes = [ctypes.c_void_p, ctypes.c_uint64, ctypes.POINTER(ctypes.c_uint64), ctypes.POINTER(ctypes.c_uint64)]
			
		except AttributeError as ae:
			raise ELibPrimesException(ErrorCodes.COULDNOTFINDLIBRARYEXPORT, ae.args[0])
	
	def _checkBinaryVersion(self):
		nMajor, nMinor, _ = self.GetVersion()
		if (nMajor != BindingVersion.MAJOR) or (nMinor < BindingVersion.MINOR):
			raise ELibPrimesException(ErrorCodes.INCOMPATIBLEBINARYVERSION)
	
	def checkError(self, instance, errorCode):
		if errorCode != ErrorCodes.SUCCESS.value:
			if instance:
				if instance._wrapper != self:
					raise ELibPrimesException(ErrorCodes.INVALIDCAST, 'invalid wrapper call')
			message,_ = self.GetLastError(instance)
			raise ELibPrimesException(errorCode, message)
	
	def GetVersion(self):
		pMajor = ctypes.c_uint32()
		pMinor = ctypes.c_uint32()
		pMicro = ctypes.c_uint32()
		self.checkError(None, self.lib.libprimes_getversion(pMajor, pMinor, pMicro))
		
		return pMajor.value, pMinor.value, pMicro.value
	
	def GetLastError(self, InstanceObject):
		InstanceHandle = None
		if InstanceObject:
			InstanceHandle = InstanceObject._handle
		else:
			raise ELibPrimesException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		nErrorMessageBufferSize = ctypes.c_uint64(0)
		nErrorMessageNeededChars = ctypes.c_uint64(0)
		pErrorMessageBuffer = ctypes.c_char_p(None)
		pHasError = ctypes.c_bool()
		self.checkError(None, self.lib.libprimes_getlasterror(InstanceHandle, nErrorMessageBufferSize, nErrorMessageNeededChars, pErrorMessageBuffer, pHasError))
		nErrorMessageBufferSize = ctypes.c_uint64(nErrorMessageNeededChars.value)
		pErrorMessageBuffer = (ctypes.c_char * (nErrorMessageNeededChars.value))()
		self.checkError(None, self.lib.libprimes_getlasterror(InstanceHandle, nErrorMessageBufferSize, nErrorMessageNeededChars, pErrorMessageBuffer, pHasError))
		
		return pErrorMessageBuffer.value.decode(), pHasError.value
	
	def AcquireInstance(self, InstanceObject):
		InstanceHandle = None
		if InstanceObject:
			InstanceHandle = InstanceObject._handle
		else:
			raise ELibPrimesException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self.checkError(None, self.lib.libprimes_acquireinstance(InstanceHandle))
		
	
	def ReleaseInstance(self, InstanceObject):
		InstanceHandle = None
		if InstanceObject:
			InstanceHandle = InstanceObject._handle
		else:
			raise ELibPrimesException(ErrorCodes.INVALIDPARAM, 'Invalid return/output value')
		self.checkError(None, self.lib.libprimes_releaseinstance(InstanceHandle))
		
	
	def CreateFactorizationCalculator(self):
		InstanceHandle = ctypes.c_void_p()
		self.checkError(None, self.lib.libprimes_createfactorizationcalculator(InstanceHandle))
		if InstanceHandle:
			InstanceObject = FactorizationCalculator(InstanceHandle, self)
		else:
			raise ELibPrimesException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return InstanceObject
	
	def CreateSieveCalculator(self):
		InstanceHandle = ctypes.c_void_p()
		self.checkError(None, self.lib.libprimes_createsievecalculator(InstanceHandle))
		if InstanceHandle:
			InstanceObject = SieveCalculator(InstanceHandle, self)
		else:
			raise ELibPrimesException(ErrorCodes.INVALIDCAST, 'Invalid return/output value')
		
		return InstanceObject
	
	def SetJournal(self, FileName):
		pFileName = ctypes.c_char_p(str.encode(FileName))
		self.checkError(None, self.lib.libprimes_setjournal(pFileName))
		
	


''' Class Implementation for Base
'''
class Base:
	def __init__(self, handle, wrapper):
		if not handle or not wrapper:
			raise ELibPrimesException(ErrorCodes.INVALIDPARAM)
		self._handle = handle
		self._wrapper = wrapper
	
	def __del__(self):
		self._wrapper.ReleaseInstance(self)


''' Class Implementation for Calculator
'''
class Calculator(Base):
	def __init__(self, handle, wrapper):
		Base.__init__(self, handle, wrapper)
	def GetValue(self):
		pValue = ctypes.c_uint64()
		self._wrapper.checkError(self, self._wrapper.lib.libprimes_calculator_getvalue(self._handle, pValue))
		
		return pValue.value
	
	def SetValue(self, Value):
		nValue = ctypes.c_uint64(Value)
		self._wrapper.checkError(self, self._wrapper.lib.libprimes_calculator_setvalue(self._handle, nValue))
		
	
	def Calculate(self):
		self._wrapper.checkError(self, self._wrapper.lib.libprimes_calculator_calculate(self._handle))
		
	
	def SetProgressCallback(self, ProgressCallbackFunc):
		self._wrapper.checkError(self, self._wrapper.lib.libprimes_calculator_setprogresscallback(self._handle, ProgressCallbackFunc))
		
	


''' Class Implementation for FactorizationCalculator
'''
class FactorizationCalculator(Calculator):
	def __init__(self, handle, wrapper):
		Calculator.__init__(self, handle, wrapper)
	def GetPrimeFactors(self):
		nPrimeFactorsCount = ctypes.c_uint64(0)
		nPrimeFactorsNeededCount = ctypes.c_uint64(0)
		pPrimeFactorsBuffer = (PrimeFactor*0)()
		self._wrapper.checkError(self, self._wrapper.lib.libprimes_factorizationcalculator_getprimefactors(self._handle, nPrimeFactorsCount, nPrimeFactorsNeededCount, pPrimeFactorsBuffer))
		nPrimeFactorsCount = ctypes.c_uint64(nPrimeFactorsNeededCount.value)
		pPrimeFactorsBuffer = (PrimeFactor * nPrimeFactorsNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.libprimes_factorizationcalculator_getprimefactors(self._handle, nPrimeFactorsCount, nPrimeFactorsNeededCount, pPrimeFactorsBuffer))
		
		return [pPrimeFactorsBuffer[i] for i in range(nPrimeFactorsNeededCount.value)]
	


''' Class Implementation for SieveCalculator
'''
class SieveCalculator(Calculator):
	def __init__(self, handle, wrapper):
		Calculator.__init__(self, handle, wrapper)
	def GetPrimes(self):
		nPrimesCount = ctypes.c_uint64(0)
		nPrimesNeededCount = ctypes.c_uint64(0)
		pPrimesBuffer = (ctypes.c_uint64*0)()
		self._wrapper.checkError(self, self._wrapper.lib.libprimes_sievecalculator_getprimes(self._handle, nPrimesCount, nPrimesNeededCount, pPrimesBuffer))
		nPrimesCount = ctypes.c_uint64(nPrimesNeededCount.value)
		pPrimesBuffer = (ctypes.c_uint64 * nPrimesNeededCount.value)()
		self._wrapper.checkError(self, self._wrapper.lib.libprimes_sievecalculator_getprimes(self._handle, nPrimesCount, nPrimesNeededCount, pPrimesBuffer))
		
		return [pPrimesBuffer[i] for i in range(nPrimesNeededCount.value)]
	
		
