
#include "Symbols.hh"


const std::map<std::string, std::string> cadabra::symbols::greekmap {
	{"\\alpha",   "α" },
	{"\\beta",    "β" },  // beta seems to be reserved
	{"\\gamma",   "γ" }, // gamma seems to be reserved
	{"\\delta",   "δ" },
	{"\\epsilon", "ε" },
	{"\\zeta",    "ζ" },
	{"\\eta",     "η" },
	{"\\theta",   "θ" },
	{"\\iota",    "ι" },
	{"\\kappa",   "κ" },
	{"\\lambda",  "λ" }, // lambda is reserved
	{"\\mu",      "μ" },
	{"\\nu",      "ν" },
	{"\\xi",      "ξ" },
	{"\\omicron", "ο" },
	{"\\pi",      "π" },
	{"\\rho",     "ρ" },
	{"\\sigma",   "σ" },
	{"\\tau",     "τ" },
	{"\\upsilon", "υ" },
	{"\\phi",     "φ" },
	{"\\varphi",  "ϕ" },
	{"\\chi",     "χ" },
	{"\\psi",     "ψ" },
	{"\\omega",   "ω" },

	{"\\Alpha",   "Α" },
	{"\\Beta",    "Β" },
	{"\\Gamma",   "Γ" },
	{"\\Delta",   "Δ" },
	{"\\Epsilon", "Ε" },
	{"\\Zeta",    "Ζ" },
	{"\\Eta",     "Η" },
	{"\\Theta",   "ϴ" },
	{"\\Iota",    "Ι" },
	{"\\Kappa",   "Κ" },
	{"\\Lambda",  "Λ" },
	{"\\Mu",      "Μ" },
	{"\\Nu",      "Ν" },
	{"\\Xi",      "Ξ" },
	{"\\Omicron", "Ο" },
	{"\\Pi",      "Π" },
	{"\\Rho",     "Ρ" },
	{"\\Sigma",   "Σ" },
	{"\\Tau",     "Τ" },
	{"\\Upsilon", "Υ" },
	{"\\Phi",     "Φ" },
	{"\\Chi",     "Χ" },
	{"\\Psi",     "Ψ" },
	{"\\Omega",   "Ω" },
	};
