/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.editor;

import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.TextMateAutoClosingPair;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateElementType;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;

public final class TextMateEditorUtils {
    @Nullable
    public static TextMateScope getCurrentScopeSelector(@NotNull EditorEx editor) {
        TextMateLanguageDescriptor languageDescriptor;
        VirtualFile file;
        TextMateScope result;
        if (editor == null) {
            TextMateEditorUtils.$$$reportNull$$$0(0);
        }
        if ((result = TextMateEditorUtils.getCurrentScopeFromEditor(editor)) == null && (file = editor.getVirtualFile()) != null && (languageDescriptor = TextMateService.getInstance().getLanguageDescriptorByFileName(file.getName())) != null) {
            return new TextMateScope(languageDescriptor.getScopeName(), null);
        }
        return result;
    }

    @Nullable
    private static TextMateScope getCurrentScopeFromEditor(@NotNull EditorEx editor) {
        if (editor == null) {
            TextMateEditorUtils.$$$reportNull$$$0(1);
        }
        EditorHighlighter highlighter = editor.getHighlighter();
        SelectionModel selection = editor.getSelectionModel();
        int offset = selection.hasSelection() ? selection.getSelectionStart() : editor.getCaretModel().getOffset();
        HighlighterIterator iterator = highlighter.createIterator(offset);
        TextMateScope result = null;
        if (offset != 0 || !iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            result = tokenType instanceof TextMateElementType ? ((TextMateElementType)tokenType).getScope() : null;
        }
        return result;
    }

    @Nullable
    public static TextMateBracePair findRightHighlightingPair(int leftBraceStartOffset, @NotNull CharSequence fileText, @Nullable TextMateScope currentScope) {
        if (fileText == null) {
            TextMateEditorUtils.$$$reportNull$$$0(2);
        }
        if (!TextMateService.getInstance().getPreferenceRegistry().isPossibleLeftHighlightingBrace(fileText.charAt(leftBraceStartOffset))) {
            return null;
        }
        Set<TextMateBracePair> pairs = TextMateEditorUtils.getAllPairsForMatcher(currentScope);
        for (TextMateBracePair pair : pairs) {
            int endOffset = leftBraceStartOffset + pair.getLeft().length();
            if (endOffset >= fileText.length() || !StringUtil.equals((CharSequence)pair.getLeft(), (CharSequence)fileText.subSequence(leftBraceStartOffset, endOffset))) continue;
            return pair;
        }
        return null;
    }

    @Nullable
    public static TextMateBracePair findLeftHighlightingPair(int rightBraceEndOffset, @NotNull CharSequence fileText, @Nullable TextMateScope currentSelector) {
        if (fileText == null) {
            TextMateEditorUtils.$$$reportNull$$$0(3);
        }
        if (!TextMateService.getInstance().getPreferenceRegistry().isPossibleRightHighlightingBrace(fileText.charAt(rightBraceEndOffset - 1))) {
            return null;
        }
        Set<TextMateBracePair> pairs = TextMateEditorUtils.getAllPairsForMatcher(currentSelector);
        for (TextMateBracePair pair : pairs) {
            int startOffset = rightBraceEndOffset - pair.getRight().length();
            if (startOffset < 0 || !StringUtil.equals((CharSequence)pair.getRight(), (CharSequence)fileText.subSequence(startOffset, rightBraceEndOffset))) continue;
            return pair;
        }
        return null;
    }

    private static Set<TextMateBracePair> getAllPairsForMatcher(@Nullable TextMateScope selector) {
        if (selector == null) {
            return Constants.Companion.getDEFAULT_HIGHLIGHTING_BRACE_PAIRS();
        }
        HashSet<TextMateBracePair> result = new HashSet<TextMateBracePair>();
        List<Preferences> preferencesForSelector = TextMateService.getInstance().getPreferenceRegistry().getPreferences(selector);
        for (Preferences preferences : preferencesForSelector) {
            Set<TextMateBracePair> highlightingPairs = preferences.getHighlightingPairs();
            if (highlightingPairs == null) continue;
            if (highlightingPairs.isEmpty()) {
                return Collections.emptySet();
            }
            result.addAll(highlightingPairs);
        }
        return result;
    }

    public static Set<TextMateAutoClosingPair> getSmartTypingPairs(@Nullable TextMateScope currentScope) {
        if (currentScope == null) {
            return Constants.Companion.getDEFAULT_SMART_TYPING_BRACE_PAIRS();
        }
        List<Preferences> preferencesForSelector = TextMateService.getInstance().getPreferenceRegistry().getPreferences(currentScope);
        HashSet<TextMateAutoClosingPair> result = new HashSet<TextMateAutoClosingPair>();
        for (Preferences preferences : preferencesForSelector) {
            @Nullable Set<TextMateAutoClosingPair> smartTypingPairs = preferences.getSmartTypingPairs();
            if (smartTypingPairs == null) continue;
            if (smartTypingPairs.isEmpty()) {
                return Collections.emptySet();
            }
            result.addAll(smartTypingPairs);
        }
        return result;
    }

    private TextMateEditorUtils() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/textmate/editor/TextMateEditorUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentScopeSelector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentScopeFromEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findRightHighlightingPair";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findLeftHighlightingPair";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

