/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.remote;

import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.GrazieDynamic;
import com.intellij.grazie.GraziePlugin;
import com.intellij.grazie.ide.ui.components.dsl.SwingKTKt;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.remote.GrazieRemote;
import com.intellij.grazie.remote.OfflineLanguageBundleSelectionDialog;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u001c\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\"\u0010\u0011\u001a\u00020\u000b2\u0018\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u00140\u0013H\u0002J(\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u00140\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0002J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J(\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u00140\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/grazie/remote/LangDownloader;", "", "<init>", "()V", "download", "", "lang", "Lcom/intellij/grazie/jlanguage/Lang;", "project", "Lcom/intellij/openapi/project/Project;", "downloadAsync", "", "languages", "", "runDownload", "Ljava/nio/file/Path;", "language", "performGrazieUpdate", "bundles", "", "Lkotlin/Pair;", "performDownload", "promptToSelectLanguageBundleManually", "doDownload", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nLangDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LangDownloader.kt\ncom/intellij/grazie/remote/LangDownloader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n774#2:128\n865#2,2:129\n1869#2:132\n1870#2:134\n1563#2:135\n1634#2,3:136\n774#2:139\n865#2,2:140\n1563#2:142\n1634#2,3:143\n1869#2,2:146\n1869#2:148\n1563#2:149\n1634#2,3:150\n1870#2:153\n1869#2,2:154\n1563#2:156\n1634#2,3:157\n24#3:131\n1#4:133\n*S KotlinDebug\n*F\n+ 1 LangDownloader.kt\ncom/intellij/grazie/remote/LangDownloader\n*L\n36#1:128\n36#1:129,2\n72#1:132\n72#1:134\n77#1:135\n77#1:136,3\n90#1:139\n90#1:140,2\n91#1:142\n91#1:143,3\n93#1:146,2\n110#1:148\n116#1:149\n116#1:150,3\n110#1:153\n122#1:154,2\n123#1:156\n123#1:157,3\n66#1:131\n*E\n"})
public final class LangDownloader {
    @NotNull
    public static final LangDownloader INSTANCE = new LangDownloader();

    private LangDownloader() {
    }

    public final boolean download(@NotNull Lang lang, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        if (GrazieRemote.INSTANCE.isAvailableLocally(lang)) {
            return true;
        }
        Path path = this.runDownload(lang, project);
        if (path == null) {
            return false;
        }
        Path path2 = path;
        this.performGrazieUpdate(CollectionsKt.listOf((Object)TuplesKt.to((Object)((Object)lang), (Object)path2)));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void downloadAsync(@NotNull Collection<? extends Lang> languages2, @NotNull Project project) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(languages2, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable iterable = languages2;
        boolean $i$f$filter = false;
        PerformInBackgroundOption performInBackgroundOption = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Lang it = (Lang)((Object)element$iv$iv);
            boolean bl = false;
            if (!(!GrazieRemote.INSTANCE.isAvailableLocally(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List notAvailableLocallyLanguages = (List)destination$iv$iv;
        if (notAvailableLocallyLanguages.isEmpty()) {
            return;
        }
        String string = SwingKTKt.msg("grazie.settings.proofreading.languages.download", new String[0]);
        performInBackgroundOption = Task.Backgroundable.ALWAYS_BACKGROUND;
        Task.Backgroundable task2 = new Task.Backgroundable(project, languages2, string, performInBackgroundOption){
            final /* synthetic */ Collection<Lang> $languages;
            {
                this.$languages = $languages;
                super($project, $super_call_param$1, true, $super_call_param$2);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                LangDownloader.access$performGrazieUpdate(LangDownloader.INSTANCE, LangDownloader.access$performDownload(LangDownloader.INSTANCE, this.$languages));
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new BackgroundableProcessIndicator(task2));
    }

    private final Path runDownload(Lang language, Project project) {
        try {
            Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> LangDownloader.runDownload$lambda$1(language), SwingKTKt.msg("grazie.settings.proofreading.languages.download", new String[0]), false, project);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runProcessWithProgressSynchronously(...)");
            return (Path)((kotlin.Pair)CollectionsKt.single((List)((List)object))).getSecond();
        }
        catch (Throwable exception) {
            LangDownloader $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(LangDownloader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn(exception);
            return this.promptToSelectLanguageBundleManually(project, language);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void performGrazieUpdate(List<? extends kotlin.Pair<? extends Lang, ? extends Path>> bundles) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        kotlin.Pair pair;
        Iterable $this$forEach$iv = bundles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path path;
            pair = (kotlin.Pair)element$iv;
            boolean bl = false;
            Lang lang = (Lang)((Object)pair.component1());
            if (GrazieRemote.INSTANCE.isValidBundleForLanguage(lang, path = (Path)pair.component2())) continue;
            boolean $i$a$-check-LangDownloader$performGrazieUpdate$1$22 = false;
            String $i$a$-check-LangDownloader$performGrazieUpdate$1$22 = "Language bundle checksum became invalid right before loading it: " + lang;
            throw new IllegalStateException($i$a$-check-LangDownloader$performGrazieUpdate$1$22.toString());
        }
        Iterable iterable = bundles;
        UrlClassLoader.Builder builder = UrlClassLoader.build().parent(GraziePlugin.INSTANCE.getClassLoader());
        boolean $i$f$map = false;
        pair = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            kotlin.Pair pair2 = (kotlin.Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Path)it.getSecond());
        }
        UrlClassLoader urlClassLoader = builder.files((List)destination$iv$iv).get();
        Intrinsics.checkNotNullExpressionValue((Object)urlClassLoader, (String)"get(...)");
        UrlClassLoader classLoader = urlClassLoader;
        GrazieDynamic.INSTANCE.addDynClassLoader((ClassLoader)classLoader);
        GrazieConfig.Companion.update((Function1<? super GrazieConfig.State, GrazieConfig.State>)((Function1)LangDownloader::performGrazieUpdate$lambda$5));
        GrazieConfig.Companion.stateChanged(GrazieConfig.Companion.get(), GrazieConfig.Companion.get());
    }

    /*
     * WARNING - void declaration
     */
    private final List<kotlin.Pair<Lang, Path>> performDownload(Collection<? extends Lang> languages2) throws IllegalStateException {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        kotlin.Pair it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List<kotlin.Pair<Lang, Path>> bundles = this.doDownload(languages2);
        Iterable iterable = bundles;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (kotlin.Pair)element$iv$iv;
            boolean bl = false;
            if (!(!GrazieRemote.INSTANCE.isValidBundleForLanguage((Lang)((Object)it.getFirst()), (Path)it.getSecond()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (kotlin.Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Path)it.getSecond());
        }
        List invalidBundles = (List)destination$iv$iv;
        if (!((Collection)invalidBundles).isEmpty()) {
            Iterable $this$forEach$iv = bundles;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                kotlin.Pair it2 = (kotlin.Pair)element$iv;
                boolean bl = false;
                NioFiles.deleteRecursively((Path)((Path)it2.getSecond()));
            }
            throw new IllegalStateException("Failed to verify integrity of downloaded language bundle for languages " + invalidBundles + ".");
        }
        return bundles;
    }

    private final Path promptToSelectLanguageBundleManually(Project project, Lang language) {
        Path path = OfflineLanguageBundleSelectionDialog.Companion.show(project, language);
        if (path == null) {
            return null;
        }
        Path selectedFile = path;
        Path targetPath = GrazieDynamic.INSTANCE.getDynamicFolder().resolve(language.getRemote().getFileName());
        Path path2 = selectedFile;
        Intrinsics.checkNotNull((Object)targetPath);
        Path path3 = targetPath;
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        CopyOption[] copyOptionArray2 = copyOptionArray;
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, path3, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"copy(...)");
        return targetPath;
    }

    /*
     * WARNING - void declaration
     */
    private final List<kotlin.Pair<Lang, Path>> doDownload(Collection<? extends Lang> languages2) {
        DownloadableFileService downloaderService = DownloadableFileService.getInstance();
        List paths = new ArrayList();
        try {
            Iterable $this$forEach$iv = languages2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv2;
                DownloadableFileDescription descriptor;
                Lang lang = (Lang)((Object)element$iv);
                boolean bl = false;
                Path folder = GrazieDynamic.INSTANCE.getDynamicFolder();
                Intrinsics.checkNotNullExpressionValue((Object)downloaderService.createFileDescription(lang.getRemote().getUrl(), lang.getRemote().getFileName()), (String)"createFileDescription(...)");
                List list = downloaderService.createDownloader(CollectionsKt.listOf((Object)descriptor), SwingKTKt.msg("grazie.settings.proofreading.languages.download", new String[0])).download(folder.toFile());
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"download(...)");
                Iterable iterable = list;
                boolean $i$f$map = false;
                void var14_26 = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(((File)it.first).toPath());
                }
                Path path = (Path)CollectionsKt.first((List)((List)destination$iv$iv));
                paths.add(TuplesKt.to((Object)((Object)lang), (Object)path));
            }
        }
        catch (Throwable e) {
            void $this$mapTo$iv$iv;
            Iterable $this$forEach$iv = paths;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                kotlin.Pair it = (kotlin.Pair)element$iv;
                boolean bl = false;
                NioFiles.deleteRecursively((Path)((Path)it.getSecond()));
            }
            Iterable $this$map$iv = languages2;
            boolean $i$f$map = false;
            Iterable element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Lang $this$map$iv2 = (Lang)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getDisplayName());
            }
            Throwable throwable = e;
            String string = "Failed to download language bundle for languages " + (List)destination$iv$iv;
            throw new IllegalStateException(string, throwable);
        }
        return paths;
    }

    private static final List runDownload$lambda$1(Lang $language) {
        return INSTANCE.performDownload(CollectionsKt.listOf((Object)((Object)$language)));
    }

    private static final GrazieConfig.State performGrazieUpdate$lambda$5(GrazieConfig.State it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return GrazieConfig.State.copy$default(it, null, null, null, false, null, null, null, null, null, null, 1023, null);
    }

    public static final /* synthetic */ void access$performGrazieUpdate(LangDownloader $this, List bundles) {
        $this.performGrazieUpdate(bundles);
    }

    public static final /* synthetic */ List access$performDownload(LangDownloader $this, Collection languages2) {
        return $this.performDownload(languages2);
    }
}

