/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionProposalBase;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionRequest;
import org.jkiss.dbeaver.model.sql.parser.SQLWordPartDetector;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.text.TextUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.SuggestionInformationControlCreator;
import org.jkiss.utils.CommonUtils;

public class SQLCompletionProposal
extends SQLCompletionProposalBase
implements ICompletionProposal,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension4,
ICompletionProposalExtension5,
ICompletionProposalExtension6 {
    private static final Log log = Log.getLog(SQLCompletionProposal.class);
    private final String replacementLast;
    private boolean isNeverAddSpaceAfter = false;

    public SQLCompletionProposal(SQLCompletionRequest request, String displayString, String replacementString, int cursorPosition, @Nullable DBPImage image, DBPKeywordType proposalType, String description, DBPNamedObject object, Map<String, Object> params) {
        super(request, displayString, replacementString, cursorPosition, image, proposalType, description, object, params);
        int divPos = this.replacementFull.lastIndexOf(request.getContext().getSyntaxManager().getStructSeparator());
        this.replacementLast = divPos == -1 ? null : this.replacementFull.substring(divPos + 1);
        Object paramAlias = params.get("no-space");
        if (paramAlias != null && ((Boolean)paramAlias).booleanValue()) {
            this.isNeverAddSpaceAfter = true;
        }
    }

    public void apply(IDocument document) {
        try {
            Object replaceOn = this.replacementString;
            String extraString = this.getExtraString();
            if (extraString != null) {
                replaceOn = (String)replaceOn + extraString;
            }
            if (this.replacementAfter != null) {
                replaceOn = (String)replaceOn + this.replacementAfter;
            }
            if (!this.isNeverAddSpaceAfter && this.getDataSource() != null && this.getDataSource().getContainer().getPreferenceStore().getBoolean("SQLEditor.ContentAssistant.insert.space.after.proposal")) {
                boolean hasClosingParenthesis = false;
                int replacementSum = this.replacementOffset + this.replacementLength;
                int docLen = document.getLength();
                if (replacementSum < docLen) {
                    char nextChar = document.getChar(replacementSum);
                    boolean bl = hasClosingParenthesis = nextChar == ')' || nextChar == '}' || nextChar == ']' || nextChar == '\'' || nextChar == '\"';
                }
                if (!(this.getObject() instanceof DBSObjectContainer) && !hasClosingParenthesis) {
                    boolean insertTrailingSpace;
                    if (docLen <= replacementSum + 2) {
                        insertTrailingSpace = true;
                    } else {
                        char ch = document.getChar(replacementSum);
                        boolean bl = insertTrailingSpace = !Character.isWhitespace(ch) || ch == '\r' || ch == '\n';
                    }
                    if (insertTrailingSpace) {
                        replaceOn = (String)replaceOn + " ";
                        ++this.cursorPosition;
                    }
                }
            }
            document.replace(this.replacementOffset, this.replacementLength, (String)replaceOn);
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
        }
    }

    public Point getSelection(IDocument document) {
        int newOffset = this.replacementOffset + this.cursorPosition + (this.replacementAfter == null ? 0 : this.replacementAfter.length());
        if (newOffset > document.getLength()) {
            newOffset = document.getLength();
        }
        return new Point(newOffset, 0);
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        return this.getAdditionalInfo((DBRProgressMonitor)new DefaultProgressMonitor(monitor));
    }

    public String getAdditionalProposalInfo() {
        return CommonUtils.toString((Object)this.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor()));
    }

    public Image getImage() {
        DBPImage objectImage = this.getObjectImage();
        return objectImage == null ? null : DBeaverIcons.getImage((DBPImage)objectImage);
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        this.apply(viewer.getDocument());
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (event == null) {
            return false;
        }
        this.getRequest().getActivityTracker().implicitlyTriggered();
        SQLSyntaxManager syntaxManager = this.getRequest().getContext().getSyntaxManager();
        DBPDataSource dataSource = this.getRequest().getContext().getDataSource();
        SQLWordPartDetector wordDetector = new SQLWordPartDetector(document, syntaxManager, offset);
        String wordPart = wordDetector.getWordPart();
        int divPos = wordPart.lastIndexOf(syntaxManager.getStructSeparator());
        if (divPos != -1) {
            if (divPos == wordPart.length() - 1) {
                if (this.replacementString.equals(wordPart.substring(0, divPos))) {
                    UIUtils.asyncExec(() -> {
                        ITextViewer textViewer;
                        IEditorPart activeEditor = UIUtils.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                        if (activeEditor != null && (textViewer = (ITextViewer)activeEditor.getAdapter(ITextViewer.class)) != null) {
                            textViewer.getTextOperationTarget().doOperation(13);
                        }
                    });
                }
                return false;
            }
            wordPart = wordPart.substring(divPos + 1);
        }
        String wordLower = wordPart.toLowerCase(Locale.ENGLISH);
        if (!CommonUtils.isEmpty((String)wordPart)) {
            boolean matched;
            boolean matchContains;
            boolean bl = matchContains = dataSource != null && dataSource.getContainer().getPreferenceStore().getBoolean("SQLEditor.ContentAssistant.matching.fuzzy");
            if (this.getObject() == null || !matchContains) {
                matched = (matchContains ? this.replacementFull.contains(wordLower) : this.replacementFull.startsWith(wordLower)) && (CommonUtils.isEmpty((String)event.getText()) || this.replacementFull.contains(event.getText().toLowerCase(Locale.ENGLISH))) || this.replacementLast != null && this.replacementLast.startsWith(wordLower);
            } else {
                int score = TextUtils.fuzzyScore((CharSequence)this.replacementFull, (CharSequence)wordLower);
                boolean bl2 = matched = score > 0 && (CommonUtils.isEmpty((String)event.getText()) || TextUtils.fuzzyScore((CharSequence)this.replacementFull, (CharSequence)event.getText()) > 0) || this.replacementLast != null && TextUtils.fuzzyScore((CharSequence)this.replacementLast, (CharSequence)wordLower) > 0;
                if (matched) {
                    this.setProposalScore(score);
                }
            }
            if (matched) {
                this.setPosition(wordDetector);
                return true;
            }
        } else if (divPos != -1 && this.getObject() != null) {
            return true;
        }
        return false;
    }

    public boolean isAutoInsertable() {
        return true;
    }

    public StyledString getStyledDisplayString() {
        if (this.getProposalType() == DBPKeywordType.LITERAL) {
            StyledString styledString = new StyledString();
            styledString.append(this.getDisplayString(), StyledString.createColorRegistryStyler((String)"org.jkiss.dbeaver.sql.editor.color.string.foreground", null));
            return styledString;
        }
        if (this.getProposalType() == DBPKeywordType.KEYWORD) {
            return new StyledString(this.getDisplayString(), StyledString.createColorRegistryStyler((String)"org.jkiss.dbeaver.sql.editor.color.keyword.foreground", null));
        }
        if (this.getProposalType() == DBPKeywordType.FUNCTION) {
            return new StyledString(this.getDisplayString(), StyledString.createColorRegistryStyler((String)"org.jkiss.dbeaver.sql.editor.color.function.foreground", null));
        }
        return new StyledString(this.getDisplayString());
    }

    public IInformationControlCreator getInformationControlCreator() {
        if (this.hasStructObject() && this.getRequest().getActivityTracker().isAdditionalInfoExpected()) {
            return SuggestionInformationControlCreator.INSTANCE;
        }
        return null;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.getReplacementString();
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.getReplacementOffset();
    }
}

