package models

import "github.com/anchore/grype/grype/vulnerability"

type VulnerabilityMetadata struct {
	ID          string   `json:"id"`
	DataSource  string   `json:"dataSource"`
	Namespace   string   `json:"namespace,omitempty"`
	Severity    string   `json:"severity,omitempty"`
	URLs        []string `json:"urls"`
	Description string   `json:"description,omitempty"`
	Cvss        []Cvss   `json:"cvss"`
}

func NewVulnerabilityMetadata(id, namespace string, metadata *vulnerability.Metadata) VulnerabilityMetadata {
	if metadata == nil {
		return VulnerabilityMetadata{
			ID:        id,
			Namespace: namespace,
		}
	}

	urls := metadata.URLs
	if urls == nil {
		urls = make([]string, 0)
	}

	return VulnerabilityMetadata{
		ID:          id,
		DataSource:  metadata.DataSource,
		Namespace:   metadata.Namespace,
		Severity:    metadata.Severity,
		URLs:        urls,
		Description: metadata.Description,
		Cvss:        NewCVSS(metadata),
	}
}
